/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGRect;

public class SVGSVGElementBridge
extends SVGGElementBridge
implements SVGSVGContext {
    public String getLocalName() {
        return "svg";
    }

    public Bridge getInstance() {
        return new SVGSVGElementBridge();
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CanvasGraphicsNode();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Rectangle2D rectangle2D;
        Object object;
        AffineTransform affineTransform;
        String string;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CanvasGraphicsNode canvasGraphicsNode = (CanvasGraphicsNode)this.instantiateGraphicsNode();
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        boolean bl = sVGDocument.getRootElement() == element;
        float f = 0.0f;
        float f2 = 0.0f;
        if (!bl) {
            string = element.getAttributeNS(null, "x");
            if (string.length() != 0) {
                f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
            }
            if ((string = element.getAttributeNS(null, "y")).length() != 0) {
                f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
            }
        }
        if ((string = element.getAttributeNS(null, "width")).length() == 0) {
            string = "100%";
        }
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            string = "100%";
        }
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        canvasGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        AffineTransform affineTransform2 = ViewBox.getPreserveAspectRatioTransform(element, f3, f4);
        float f5 = f3;
        float f6 = f4;
        try {
            affineTransform = affineTransform2.createInverse();
            f5 = (float)((double)f3 * affineTransform.getScaleX());
            f6 = (float)((double)f4 * affineTransform.getScaleY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        affineTransform = AffineTransform.getTranslateInstance(f, f2);
        if (!bl) {
            canvasGraphicsNode.setPositionTransform(affineTransform);
        } else if (sVGDocument == bridgeContext.getDocument()) {
            bridgeContext.setDocumentSize(new Dimension((int)(f3 + 0.5f), (int)(f4 + 0.5f)));
        }
        canvasGraphicsNode.setViewingTransform(affineTransform2);
        Shape shape = null;
        if (CSSUtilities.convertOverflow(element)) {
            object = CSSUtilities.convertClip(element);
            shape = object == null ? new Rectangle2D.Float(f, f2, f3, f4) : new Rectangle2D.Float(f + object[3], f2 + object[0], f3 - object[1] - object[3], f4 - object[2] - object[0]);
        }
        if (shape != null) {
            try {
                object = new AffineTransform(affineTransform);
                object.concatenate(affineTransform2);
                object = object.createInverse();
                shape = object.createTransformedShape(shape);
                rectangle2D = canvasGraphicsNode.getGraphicsNodeRable(true);
                canvasGraphicsNode.setClip((ClipRable)new ClipRable8Bit((Filter)rectangle2D, shape));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        object = null;
        if ((object = (Object)CSSUtilities.convertColorRendering(element, (RenderingHints)object)) != null) {
            canvasGraphicsNode.setRenderingHints((RenderingHints)object);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            canvasGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        bridgeContext.openViewport(element, new SVGSVGElementViewport(f5, f6));
        return canvasGraphicsNode;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        bridgeContext.closeViewport(element);
    }

    public void dispose() {
        this.ctx.removeViewport(this.e);
        super.dispose();
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        CompositeGraphicsNode compositeGraphicsNode;
        String string = mutationEvent.getAttrName();
        boolean bl = false;
        if (string.equals("width") || string.equals("height")) {
            bl = true;
        } else if (string.equals("x") || string.equals("y")) {
            boolean bl2;
            compositeGraphicsNode = (SVGDocument)this.e.getOwnerDocument();
            boolean bl3 = bl2 = compositeGraphicsNode.getRootElement() == this.e;
            if (!bl2) {
                float f = 0.0f;
                float f2 = 0.0f;
                UnitProcessor.Context context = UnitProcessor.createContext(this.ctx, this.e);
                String string2 = this.e.getAttributeNS(null, "x");
                if (string2.length() != 0) {
                    f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, "x", context);
                }
                if ((string2 = this.e.getAttributeNS(null, "y")).length() != 0) {
                    f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "y", context);
                }
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
                CanvasGraphicsNode canvasGraphicsNode = (CanvasGraphicsNode)this.node;
                canvasGraphicsNode.setPositionTransform(affineTransform);
            }
        } else if (string.equals("viewBox") || string.equals("preserveAspectRatio")) {
            String string3;
            compositeGraphicsNode = (SVGDocument)this.e.getOwnerDocument();
            boolean bl4 = compositeGraphicsNode.getRootElement() == this.e;
            UnitProcessor.Context context = UnitProcessor.createContext(this.ctx, this.e);
            float f = 0.0f;
            float f3 = 0.0f;
            if (!bl4) {
                string3 = this.e.getAttributeNS(null, "x");
                if (string3.length() != 0) {
                    f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string3, "x", context);
                }
                if ((string3 = this.e.getAttributeNS(null, "y")).length() != 0) {
                    f3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string3, "y", context);
                }
            }
            if ((string3 = this.e.getAttributeNS(null, "width")).length() == 0) {
                string3 = "100%";
            }
            float f4 = UnitProcessor.svgHorizontalLengthToUserSpace(string3, "width", context);
            string3 = this.e.getAttributeNS(null, "height");
            if (string3.length() == 0) {
                string3 = "100%";
            }
            float f5 = UnitProcessor.svgVerticalLengthToUserSpace(string3, "height", context);
            CanvasGraphicsNode canvasGraphicsNode = (CanvasGraphicsNode)this.node;
            AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform(this.e, f4, f5);
            AffineTransform affineTransform2 = canvasGraphicsNode.getViewingTransform();
            if (affineTransform.getScaleX() != affineTransform2.getScaleX() || affineTransform.getScaleY() != affineTransform2.getScaleY() || affineTransform.getShearX() != affineTransform2.getShearX() || affineTransform.getShearY() != affineTransform2.getShearY()) {
                bl = true;
            } else {
                Object object;
                canvasGraphicsNode.setViewingTransform(affineTransform);
                Shape shape = null;
                if (CSSUtilities.convertOverflow(this.e)) {
                    object = CSSUtilities.convertClip(this.e);
                    shape = object == null ? new Rectangle2D.Float(f, f3, f4, f5) : new Rectangle2D.Float(f + object[3], f3 + object[0], f4 - object[1] - object[3], f5 - object[2] - object[0]);
                }
                if (shape != null) {
                    try {
                        object = canvasGraphicsNode.getPositionTransform();
                        object = object == null ? (Object)new AffineTransform() : (Object)new AffineTransform((AffineTransform)object);
                        object.concatenate(affineTransform);
                        object = object.createInverse();
                        shape = object.createTransformedShape(shape);
                        Filter filter = canvasGraphicsNode.getGraphicsNodeRable(true);
                        canvasGraphicsNode.setClip((ClipRable)new ClipRable8Bit(filter, shape));
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                }
            }
        }
        if (bl) {
            compositeGraphicsNode = this.node.getParent();
            compositeGraphicsNode.remove((Object)this.node);
            this.disposeTree(this.e);
            this.handleElementAdded(compositeGraphicsNode, this.e.getParentNode(), this.e);
        }
    }

    public List getIntersectionList(SVGRect sVGRect, Element element) {
        Node node;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Rectangle2D.Float float_ = new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        GraphicsNode graphicsNode = this.ctx.getGraphicsNode(this.e);
        if (graphicsNode == null) {
            return arrayList;
        }
        Rectangle2D rectangle2D = graphicsNode.getSensitiveBounds();
        if (rectangle2D == null) {
            return arrayList;
        }
        if (!float_.intersects(rectangle2D)) {
            return arrayList;
        }
        Element element2 = this.e;
        AffineTransform affineTransform = graphicsNode.getGlobalTransform();
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        for (node = element2.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        if (node == null) {
            return arrayList;
        }
        Element element3 = (Element)node;
        Set set = null;
        if (element != null && (set = this.getAncestors(element, element2)) == null) {
            element = null;
        }
        while (element3 != null) {
            String string = element3.getNamespaceURI();
            String string2 = element3.getLocalName();
            boolean bl = "http://www.w3.org/2000/svg".equals(string) && ("g".equals(string2) || "svg".equals(string2) || "a".equals(string2));
            GraphicsNode graphicsNode2 = this.ctx.getGraphicsNode(element3);
            if (graphicsNode2 == null) {
                if (set != null && set.contains(element3)) break;
                element3 = this.getNext(element3, element2, element);
                continue;
            }
            AffineTransform affineTransform2 = graphicsNode2.getGlobalTransform();
            Rectangle2D rectangle2D2 = graphicsNode2.getSensitiveBounds();
            affineTransform2.preConcatenate(affineTransform);
            if (rectangle2D2 != null) {
                rectangle2D2 = affineTransform2.createTransformedShape(rectangle2D2).getBounds2D();
            }
            if (rectangle2D2 == null || !float_.intersects(rectangle2D2)) {
                if (set != null && set.contains(element3)) break;
                element3 = this.getNext(element3, element2, element);
                continue;
            }
            if (bl) {
                for (node = element3.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
                }
                if (node != null) {
                    element3 = (Element)node;
                    continue;
                }
            } else {
                Object object;
                ShapeNode shapeNode;
                if (element3 == element) break;
                if ("http://www.w3.org/2000/svg".equals(string) && "use".equals(string2) && float_.contains(rectangle2D2)) {
                    arrayList.add(element3);
                }
                if (graphicsNode2 instanceof ShapeNode) {
                    shapeNode = (ShapeNode)graphicsNode2;
                    object = shapeNode.getSensitiveArea();
                    if (object != null && (object = affineTransform2.createTransformedShape((Shape)object)).intersects(float_)) {
                        arrayList.add(element3);
                    }
                } else if (graphicsNode2 instanceof TextNode) {
                    shapeNode = (SVGOMElement)element3;
                    object = (SVGTextElementBridge)shapeNode.getSVGContext();
                    Set set2 = ((SVGTextElementBridge)object).getTextIntersectionSet(affineTransform2, float_);
                    if (set != null && set.contains(element3)) {
                        this.filterChildren(element3, element, set2, arrayList);
                    } else {
                        arrayList.addAll(set2);
                    }
                } else {
                    arrayList.add(element3);
                }
            }
            element3 = this.getNext(element3, element2, element);
        }
        return arrayList;
    }

    public List getEnclosureList(SVGRect sVGRect, Element element) {
        Node node;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Rectangle2D.Float float_ = new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        GraphicsNode graphicsNode = this.ctx.getGraphicsNode(this.e);
        if (graphicsNode == null) {
            return arrayList;
        }
        Rectangle2D rectangle2D = graphicsNode.getSensitiveBounds();
        if (rectangle2D == null) {
            return arrayList;
        }
        if (!float_.intersects(rectangle2D)) {
            return arrayList;
        }
        Element element2 = this.e;
        AffineTransform affineTransform = graphicsNode.getGlobalTransform();
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        for (node = element2.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        if (node == null) {
            return arrayList;
        }
        Element element3 = (Element)node;
        Set set = null;
        if (element != null && (set = this.getAncestors(element, element2)) == null) {
            element = null;
        }
        while (element3 != null) {
            String string = element3.getNamespaceURI();
            String string2 = element3.getLocalName();
            boolean bl = "http://www.w3.org/2000/svg".equals(string) && ("g".equals(string2) || "svg".equals(string2) || "a".equals(string2));
            GraphicsNode graphicsNode2 = this.ctx.getGraphicsNode(element3);
            if (graphicsNode2 == null) {
                if (set != null && set.contains(element3)) break;
                element3 = this.getNext(element3, element2, element);
                continue;
            }
            AffineTransform affineTransform2 = graphicsNode2.getGlobalTransform();
            Rectangle2D rectangle2D2 = graphicsNode2.getSensitiveBounds();
            affineTransform2.preConcatenate(affineTransform);
            if (rectangle2D2 != null) {
                rectangle2D2 = affineTransform2.createTransformedShape(rectangle2D2).getBounds2D();
            }
            if (rectangle2D2 == null || !float_.intersects(rectangle2D2)) {
                if (set != null && set.contains(element3)) break;
                element3 = this.getNext(element3, element2, element);
                continue;
            }
            if (bl) {
                for (node = element3.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
                }
                if (node != null) {
                    element3 = (Element)node;
                    continue;
                }
            } else {
                if (element3 == element) break;
                if ("http://www.w3.org/2000/svg".equals(string) && "use".equals(string2)) {
                    if (float_.contains(rectangle2D2)) {
                        arrayList.add(element3);
                    }
                } else if (graphicsNode2 instanceof TextNode) {
                    SVGOMElement sVGOMElement = (SVGOMElement)element3;
                    SVGTextElementBridge sVGTextElementBridge = (SVGTextElementBridge)sVGOMElement.getSVGContext();
                    Set set2 = sVGTextElementBridge.getTextEnclosureSet(affineTransform2, float_);
                    if (set != null && set.contains(element3)) {
                        this.filterChildren(element3, element, set2, arrayList);
                    } else {
                        arrayList.addAll(set2);
                    }
                } else if (float_.contains(rectangle2D2)) {
                    arrayList.add(element3);
                }
            }
            element3 = this.getNext(element3, element2, element);
        }
        return arrayList;
    }

    public boolean checkIntersection(Element element, SVGRect sVGRect) {
        GraphicsNode graphicsNode = this.ctx.getGraphicsNode(this.e);
        if (graphicsNode == null) {
            return false;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        AffineTransform affineTransform = graphicsNode.getGlobalTransform();
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        SVGContext sVGContext = null;
        if (element instanceof SVGOMElement && ((sVGContext = ((SVGOMElement)element).getSVGContext()) instanceof SVGTextElementBridge || sVGContext instanceof SVGTextElementBridge.AbstractTextChildSVGContext)) {
            return SVGTextElementBridge.getTextIntersection(this.ctx, element, affineTransform, float_, true);
        }
        Rectangle2D rectangle2D = null;
        GraphicsNode graphicsNode2 = this.ctx.getGraphicsNode(element);
        if (graphicsNode2 != null) {
            rectangle2D = graphicsNode2.getSensitiveBounds();
        }
        if (rectangle2D == null) {
            return false;
        }
        AffineTransform affineTransform2 = graphicsNode2.getGlobalTransform();
        affineTransform2.preConcatenate(affineTransform);
        rectangle2D = affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
        if (!float_.intersects(rectangle2D)) {
            return false;
        }
        if (!(graphicsNode2 instanceof ShapeNode)) {
            return true;
        }
        ShapeNode shapeNode = (ShapeNode)graphicsNode2;
        Shape shape = shapeNode.getSensitiveArea();
        if (shape == null) {
            return false;
        }
        return (shape = affineTransform2.createTransformedShape(shape)).intersects(float_);
    }

    public boolean checkEnclosure(Element element, SVGRect sVGRect) {
        Object object;
        GraphicsNode graphicsNode = this.ctx.getGraphicsNode(element);
        Rectangle2D rectangle2D = null;
        SVGContext sVGContext = null;
        if (element instanceof SVGOMElement) {
            sVGContext = ((SVGOMElement)element).getSVGContext();
            if (sVGContext instanceof SVGTextElementBridge || sVGContext instanceof SVGTextElementBridge.AbstractTextChildSVGContext) {
                rectangle2D = SVGTextElementBridge.getTextBounds(this.ctx, element, true);
                for (object = (Element)element.getParentNode(); object != null && graphicsNode == null; object = (Element)object.getParentNode()) {
                    graphicsNode = this.ctx.getGraphicsNode((Element)object);
                }
            } else if (graphicsNode != null) {
                rectangle2D = graphicsNode.getSensitiveBounds();
            }
        } else if (graphicsNode != null) {
            rectangle2D = graphicsNode.getSensitiveBounds();
        }
        if (rectangle2D == null) {
            return false;
        }
        object = this.ctx.getGraphicsNode(this.e);
        if (object == null) {
            return false;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        AffineTransform affineTransform = object.getGlobalTransform();
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        AffineTransform affineTransform2 = graphicsNode.getGlobalTransform();
        affineTransform2.preConcatenate(affineTransform);
        rectangle2D = affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
        return float_.contains(rectangle2D);
    }

    public boolean filterChildren(Element element, Element element2, Set set, List list) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !this.filterChildren((Element)node, element2, set, list)) continue;
            return true;
        }
        if (element == element2) {
            return true;
        }
        if (set.contains(element)) {
            list.add(element);
        }
        return false;
    }

    protected Set getAncestors(Element element, Element element2) {
        HashSet<Element> hashSet = new HashSet<Element>();
        Element element3 = element;
        do {
            hashSet.add(element3);
        } while ((element3 = (Element)element3.getParentNode()) != null && element3 != element2);
        if (element3 == null) {
            return null;
        }
        return hashSet;
    }

    protected Element getNext(Element element, Element element2, Element element3) {
        Node node;
        for (node = element.getNextSibling(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        while (node == null) {
            if ((element = (Element)element.getParentNode()) == element3 || element == element2) {
                node = null;
                break;
            }
            for (node = element.getNextSibling(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
            }
        }
        return (Element)node;
    }

    public void deselectAll() {
        this.ctx.getUserAgent().deselectAll();
    }

    public static class SVGSVGElementViewport
    implements Viewport {
        private float width;
        private float height;

        public SVGSVGElementViewport(float f, float f2) {
            this.width = f;
            this.height = f2;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

