.\"
.\" "$Id: lpc.man 12854 2015-08-28 14:08:00Z msweet $"
.\"
.\" lpc man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lpc 8 "CUPS" "11 June 2014" "Apple Inc."
.SH NAME
lpc \- line printer control program
.SH SYNOPSIS
.B lpc
[
.I command
[
.I parameter(s)
] ]
.SH DESCRIPTION
\fBlpc\fR provides limited control over printer and class queues provided by CUPS. It can also be used to query the state of queues.
.LP
If no command is specified on the command-line, \fBlpc\fR displays a prompt and accepts commands from the standard input.
.SS COMMANDS
The \fBlpc\fR program accepts a subset of commands accepted by the Berkeley \fBlpc\fR program of the same name:
.TP 5
.B exit
Exits the command interpreter.
.TP 5
\fBhelp \fR[\fIcommand\fR]
.TP 5
\fB? \fR[\fIcommand\fR]
Displays a short help message.
.TP 5
.B quit
Exits the command interpreter.
.TP 5
\fBstatus \fR[\fIqueue\fR]
Displays the status of one or more printer or class queues.
.SH NOTES
Since \fBlpc\fR is geared towards the Berkeley printing system, it is impossible to use \fBlpc\fR to configure printer or class queues provided by CUPS.
To configure printer or class queues you must use the
.BR lpadmin (8)
command or another CUPS-compatible client with that functionality.
.SH SEE ALSO
.BR cancel (1),
.BR cupsaccept (8),
.BR cupsenable (8),
.BR lp (1),
.BR lpadmin (8),
.BR lpr (1),
.BR lprm (1),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2015 by Apple Inc.
.\"
.\" End of "$Id: lpc.man 12854 2015-08-28 14:08:00Z msweet $".
.\"
