#
# Find OSS include header for Unix platforms.
# used by FQTerm to detect the availability of OSS.

IF(UNIX)
  IF(CMAKE_SYSTEM_NAME MATCHES "Linux")
	SET(OSS_HDR_NAME "linux/soundcard.h")
  ELSE(CMAKE_SYSTEM_NAME MATCHES "Linux")
	IF(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")
	  SET(OSS_HDR_NAME "sys/soundcard.h")
	ELSE(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")
	  IF(CMAKE_SYSTEM_NAME MATCHES "OpenBSD")
	    SET(OSS_HDR_NAME "soundcard.h")
	  ELSE(CMAKE_SYSTEM_NAME MATCHES "OpenBSD")
	    SET(OSS_HDR_NAME "machine/soundcard.h")
	  ENDIF(CMAKE_SYSTEM_NAME MATCHES "OpenBSD")
	ENDIF(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")
  ENDIF(CMAKE_SYSTEM_NAME MATCHES "Linux")
ENDIF(UNIX)

FIND_PATH(OSS_INCLUDE_DIR "${OSS_HDR_NAME}"
  "/usr/include" "/usr/local/include"
)

IF(OSS_INCLUDE_DIR)
  SET(OSS_FOUND TRUE)
ELSE(OSS_INCLUDE_DIR)
  SET(OSS_FOUND)
ENDIF(OSS_INCLUDE_DIR)

IF(OSS_FOUND)
  MESSAGE(STATUS "Found OSS Audio")
ELSE(OSS_FOUND)
  IF(OSS_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "FAILED to found Audio - REQUIRED")
  ELSE(OSS_FIND_REQUIRED)
    MESSAGE(STATUS "Audio Disabled")
  ENDIF(OSS_FIND_REQUIRED)
ENDIF(OSS_FOUND)

MARK_AS_ADVANCED (
  OSS_FOUND
  OSS_INCLUDE_DIR
)
