#include "message_header.h"

namespace ADNS {

	MessageHeader::MessageHeader()
	{
		id = 0;
		args_upper = 0;
		args_lower = 0;

	}

	MessageHeader::MessageHeader(array<Byte>^ msghead)
	{
		id = IPAddress::NetworkToHostOrder((short int) BitConverter::ToUInt16(msghead,0));
		args_upper = msghead[2];
		args_lower = msghead[3];
		return;
	}

	Void MessageHeader::SetQuery(bool b)
	{
		if (b)
			args_upper = args_upper | 0x80;
		else
			args_upper = args_upper & 0x7F;

		return;
	}

	bool MessageHeader::GetQuery()
	{
		if (args_upper & 0x80)
			return true;

		return false;
	}

	Void  MessageHeader::SetOpcode(PKT_OPCODE oc)
	{
		args_upper = args_upper & 0x87;
		args_upper = args_upper | ((Byte) oc << 3);
		return;
	}
	
	Byte  MessageHeader::GetOpcode()
	{
		return (args_upper & 0x78) >> 3;
	}

	Void MessageHeader::SetAuthAnswer(bool b)
	{
		if (b)
			args_upper = args_upper | 0x04;
		else
			args_upper = args_upper & 0xFb;

		return;
	}
	
	bool MessageHeader::GetAuthAnswer()
	{
		if (args_upper & 0x04)
			return true;

		return false;
	}

	Void MessageHeader::SetTruncation(bool b)
	{
		if (b)
			args_upper = args_upper | 0x02;
		else
			args_upper = args_upper & 0xFd;

		return;
	}
	
	bool MessageHeader::GetTruncation()
	{
		if (args_upper & 0x02)
			return true;
		
		return false;
	}

	Void MessageHeader::SetRecursionDesired(bool b)
	{
		if (b)
			args_upper = args_upper | 0x01;
		else
			args_upper = args_upper & 0xFE;

		return;
	}
	
	bool MessageHeader::GetRecursionDesired()
	{
		if (args_upper & 0x01)
			return true;

		return false;
	}

	Void MessageHeader::SetRecursionAvailable(bool b)
	{
		if (b)
			args_lower = args_lower | 0x80;
		else
			args_lower = args_lower & 0x7F;
		return;
	}

	bool MessageHeader::GetRecursionAvailable()
	{
		if (args_lower & 0x80)
			return true;
		
		return false;
	}

	Void MessageHeader::SetRCode(PKT_RCODE rc)
	{

		args_lower = args_lower & 0xF0;
		args_lower = args_lower | (Byte) rc;

		return;
	}

	Byte MessageHeader::GetRcode()
	{
		return args_lower & 0x0F;
	}

	array<Byte>^ MessageHeader::ToWire()
	{
		array<Byte>^ output = gcnew array<Byte>(4);

		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) id))->CopyTo(output,0);
		output[2] = args_upper;
		output[3] = args_lower;

		return output;
	}

	UInt16 MessageHeader::GetId()
	{
		return id;
	}

	Void MessageHeader::SetId(UInt16 newid)
	{
		id = newid;
	}


		
}