/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi;

import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.Instrumentor;
import alt.jiapi.Runtime;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.Loader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class InstrumentationContext {
    private static Category log = Runtime.getLogCategory(InstrumentationContext.class);
    private List descriptors = new ArrayList();
    private Loader loader = new Loader();

    public void addInstrumentationDescriptor(InstrumentationDescriptor id) {
        this.descriptors.add(id);
    }

    public Loader getLoader() {
        return this.loader;
    }

    public List getDescriptors() {
        return this.descriptors;
    }

    public void instrument(JiapiClass clazz) {
        ArrayList list = new ArrayList();
        for (InstrumentationDescriptor id : this.getDescriptors()) {
            if (!id.match(clazz.getName())) continue;
            list.addAll(id.getInstrumentors());
        }
        if (!list.isEmpty()) {
            Iterator i = list.iterator();
            long l1 = System.currentTimeMillis();
            while (i.hasNext()) {
                Instrumentor instrumentor = (Instrumentor)i.next();
                instrumentor.instrument(clazz);
            }
            long l2 = System.currentTimeMillis();
            log.debug((Object)("It took " + (l2 - l1) + " ms to instrument " + clazz));
        } else {
            log.debug((Object)("No inclusion rules match " + clazz.getName()));
        }
    }
}

