/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef IMPHEADER_H_INCLUDED
#define IMPHEADER_H_INCLUDED

#include <boost/shared_ptr.hpp>

#include "IMPTypes.h"

class WPXInputStream;

namespace libebook
{

class IMPHeader
{
public:
  explicit IMPHeader(WPXInputStream *input);

  static boost::shared_ptr<IMPHeader> create(WPXInputStream *input);

  unsigned getVersion() const;
  IMPColorMode getColorMode() const;
  unsigned getFileCount() const;
  bool getCompressed() const;
  bool getEncrypted() const;
  const IMPMetadata &getMetadata() const;

  unsigned getTOCOffset() const;

private:
  void readHeader(WPXInputStream *input);
  void readBookProperties(WPXInputStream *input);

private:
  unsigned m_version;
  IMPColorMode m_colorMode;
  unsigned m_files;
  unsigned m_dirNameLength;
  unsigned m_remainingBytes;
  bool m_compressed;
  bool m_encrypted;
  IMPMetadata m_metadata;
};

}

#endif // IMPHEADER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
