//
// This file is part of the LibreOffice project.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
//
#include <stdio.h>
#include <TargetConditionals.h>
#define LOK_USE_UNSTABLE_API
#include <LibreOfficeKit/LibreOfficeKitInit.h>

#include <osl/process.h>

//#include <unicode/udata.h>
//#include <unicode/ucnv.h>

// generated by solenv/bin/native-code.py:
#include "native-code.h"


// Force reference to libreofficekit_hook
extern __attribute__((used)) void *libreofficekit_hook(const char *);
static __attribute__((used)) void *(*foop)(const char *) = libreofficekit_hook;

// pointers to our instance
static LibreOfficeKit* kit;
static LibreOfficeKitDocument* document;


// Tile variables
static int tileSizeX, tileSizeY, tileMaxY, documentParts;
static double twipsPerXtile, twipsPerYtile;



// Bridge functions to LibreOfficeKit
int BridgeLOkit_Init(const char *path)
{
    char bufUserPath[200];
    strcpy(bufUserPath, path);
    strcpy(bufUserPath + strlen(path), "/user");

    // Initialize LibreOfficeKit
    if (!kit) {
        kit = lok_init_2(path, bufUserPath);
        if (!kit)
            return 1;
    }
    return 0;
}



int BridgeLOkit_Sizing(const int countXtiles, const int countYtiles,
                       const int pixelsXtile, const int pixelsYtile)
{
    long docWidth, docHeight;

    (void)countXtiles;
    (void)countYtiles;

    // Remember for later
    tileSizeX = pixelsXtile;
    tileSizeY = pixelsYtile;

    // Calculate twips to pixels in X,Y direction
    document->pClass->getDocumentSize(document, &docWidth, &docHeight);
    twipsPerXtile = docWidth / countXtiles;
    double ratio = (double)docHeight / (double)docWidth + 0.05;
    int x0 = (int)((ratio - (int)ratio) * 10.0);
    int x1 = x0 * countXtiles / 10;
    int x2 = (int)ratio;
    tileMaxY = x1 + x2;
    twipsPerYtile = docHeight / tileMaxY;
    documentParts = document->pClass->getParts(document);
    return 0;
}



int BridgeLOkit_open(const char *path)
{
    document = kit->pClass->documentLoad(kit, path);
    document->pClass->initializeForRendering(document, "");
    return 0;
}



int BridgeLOkit_ClientCommand(const char *input)
{
    (void)input;
    return 0;
}



int BridgeLOkit_Hipernate()
{
    //FIXME
    // check if document needs to be saved, to avoid data loss
    // terminate all threads (basically terminate LOkit)
    return 0;
}



int BridgeLOkit_LeaveHipernate()
{
    //FIXME
    // restart LOkit
    // reload document (it may have been changed by other programs, especially if iCloud
    return 0;
}

