/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.2
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.1

Rectangle {
    width: 600
    height: 400

    TabView {
        anchors.fill: parent
        Tab {
            title: "Height"
            Row {
                height: parent.height
                anchors.horizontalCenter: parent.horizontalCenter
                Button { text: "One" ; height: parent.height; style: ButtonStyle{}}
                Slider { height: parent.height ; style: SliderStyle{}}
                ComboBox { height: parent.height ; style: ComboBoxStyle{}}
            }
        }
        Tab {
            title: "Width"
            Column {
                width: parent.width
                anchors.verticalCenter: parent.verticalCenter
                Button { text: "One" ; width: parent.width; style: ButtonStyle{}}
                Slider { width: parent.width ; style: SliderStyle{}}
                ComboBox {width: parent.width ; style: ComboBoxStyle{}}
            }
        }
        Tab {
            title: "Both"
            Row {
                anchors.fill: parent
                Button { text: "One" ; width: parent.width/3 ; height: parent.height; style: ButtonStyle{}}
                Slider { width: parent.width/3 ; height: parent.height ; style: SliderStyle{}}
                ComboBox {width: parent.width/3 ; height: parent.height ; style: ComboBoxStyle{}}
            }
        }
    }
}
