/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import org.broadinstitute.sting.utils.nanoScheduler.EOFMarkedValue;

class MapResult<MapType>
extends EOFMarkedValue<MapType>
implements Comparable<MapResult<MapType>> {
    final int jobID;

    MapResult(MapType datum, int jobID) {
        super(datum);
        this.jobID = jobID;
        if (jobID < 0) {
            throw new IllegalArgumentException("JobID must be >= 0");
        }
    }

    MapResult(int jobID) {
        this.jobID = jobID;
        if (jobID < 0) {
            throw new IllegalArgumentException("JobID must be >= 0");
        }
    }

    MapResult() {
        this.jobID = Integer.MAX_VALUE;
    }

    public int getJobID() {
        return this.jobID;
    }

    @Override
    public int compareTo(MapResult<MapType> o) {
        return Integer.valueOf(this.jobID).compareTo(o.getJobID());
    }

    public String toString() {
        return "[MapResult id=" + this.jobID + "]";
    }
}

