/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifUserCommentChunk
extends Chunk {
    private static final String asciiDes = "ASCII";
    private static final String jisDes = "JIS";
    private static final String unicodeDes = "UNICODE";

    public ExifUserCommentChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        if (this.bytesLeft < 8L) {
            repInfo.setMessage((Message)new ErrorMessage("Exif User Comment Chunk is too short"));
            repInfo.setWellFormed(false);
            return false;
        }
        byte[] byArray = new byte[8];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
        String string = new String(byArray).trim();
        this.bytesLeft -= 8L;
        String string2 = null;
        if (asciiDes.equals(string)) {
            string2 = "US-ASCII";
        } else if (jisDes.equals(string)) {
            string2 = "EUC_JP";
        } else if (unicodeDes.equals(string)) {
            string2 = "UTF-16";
        }
        byArray = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
        String string3 = null;
        try {
            if (string2 != null) {
                string3 = new String(byArray, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = new String(byArray);
        }
        ExifInfo exifInfo = waveModule.getExifInfo();
        waveModule.getExifInfo().setUserComment(string3);
        return true;
    }
}

