#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Fabien Givors <captnfab@debian-facile.org>
set -o errexit

###
# Heroine's Quest: The Herald of Ragnarok
###

script_version=20240228.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='heroines-quest-the-herald-of-ragnarok'
GAME_NAME='Heroine’s Quest: The Herald of Ragnarok'

ARCHIVE_BASE_GOG_EN_0_NAME='heroine_s_quest_the_herald_of_ragnarok_1_2_9_2_68339.sh'
ARCHIVE_BASE_GOG_EN_0_MD5='a9cfa6ca34e28fa4b06d7d6fc565421d'
ARCHIVE_BASE_GOG_EN_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_EN_0_SIZE='500000'
ARCHIVE_BASE_GOG_EN_0_VERSION='1.2.9.2-gog68339'
ARCHIVE_BASE_GOG_EN_0_URL='https://www.gog.com/fr/game/heroines_quest_the_herald_of_ragnarok'

CONTENT_DOC_DATA_PATH='data/noarch/game'
CONTENT_DOC_DATA_FILES='
*.pdf'
CONTENT_DOC0_DATA_PATH='data/noarch/game/data'
CONTENT_DOC0_DATA_FILES='
licenses'

CONTENT_PATH_DEFAULT='data/noarch/game/data'
CONTENT_GAME_BIN64_FILES='
ags64'
CONTENT_GAME_BIN32_FILES='
ags32'

CONTENT_GAME_DATA_FILES='
../goggame-*
acsetup.cfg
*.tra
*.vox
*.ags'

APP_MAIN_EXE_BIN64='ags64'
APP_MAIN_EXE_BIN32='ags32'
APP_MAIN_ICON='../../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN64_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libogg.so.0
libSDL2-2.0.so.0
libtheora.so.0
libvorbisfile.so.3
libvorbis.so.0'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN64'
launchers_write
set_current_package 'PKG_BIN32'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
