#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Swapper
# send your bug reports to contact@dotslashplay.it
###

script_version=20230825.1

GAME_ID='the-swapper'
GAME_NAME='The Swapper'

ARCHIVE_BASE_0='the-swapper-linux-1.24_1409159048.sh'
ARCHIVE_BASE_0_MD5='4f9627d245388edc320f61fae7cbd29f'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='980000'
ARCHIVE_BASE_0_VERSION='1.24-humble140404'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/the-swapper'

CONTENT_PATH_DEFAULT='data/noarch'
CONTENT_GAME_MAIN_FILES='
data
mono
TheSwapper.exe
TheSwapper.exe.config
BugReporter.exe
mainSettings.ini
config.xml
AdvanceMath.dll
Antlr3.Runtime.dll
C5.dll
FarseerPhysics331.dll
HackFlipcodeDecomposer.dll
ImageManipulation.dll
Jint.dll
Lidgren.Network.dll
MiniTK.dll
MiniTK.dll.config
MonoGame.Framework.dll
Newtonsoft.Json.dll
OptimusSwitcher.dll
Poly2Tri.dll
SDL2#.dll
SDL2#.dll.config
SteamManagedWrapper.dll
Steamworks.NET.dll
TargaImage.dll
TrueEngine.dll
TrueEngine.dll.config'
CONTENT_DOC_MAIN_FILES='
Licences
README*'

APP_MAIN_TYPE='mono'
APP_MAIN_EXE='TheSwapper.exe'
APP_MAIN_ICON='TheSwapper.exe'

PKG_MAIN_DEPS='mono'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
Mono.Posix.dll
Mono.Security.dll
OpenTK.dll
OpenTK.Compatibility.dll
OpenTK.GLControl.dll
System.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Numerics.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Xml.dll
System.Xml.Linq.dll'

# Delete unwanted Dropbox metadata files

SCRIPT_DEPS="$SCRIPT_DEPS find"

# Include shipped libraries that can not be replaced by system ones

CONTENT_LIBS_LIBS32_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_LIBS32_FILES='
libfmodex.so'
CONTENT_LIBS_LIBS64_PATH="${CONTENT_PATH_DEFAULT}/lib64"
CONTENT_LIBS_LIBS64_FILES='
libfmodex.so'

PACKAGES_LIST='PKG_MAIN PKG_LIBS32 PKG_LIBS64'

PKG_LIBS_ID="${GAME_ID}-libs"
PKG_LIBS32_ID="$PKG_LIBS_ID"
PKG_LIBS64_ID="$PKG_LIBS_ID"
PKG_LIBS32_ARCH='32'
PKG_LIBS64_ARCH='64'
PKG_LIBS_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libm.so.6
libpthread.so.0
libstdc++.so.6'
PKG_LIBS32_DEPENDENCIES_LIBRARIES="$PKG_LIBS_DEPENDENCIES_LIBRARIES"
PKG_LIBS64_DEPENDENCIES_LIBRARIES="$PKG_LIBS_DEPENDENCIES_LIBRARIES"

PKG_MAIN_DEPS="$PKG_MAIN_DEPS $PKG_LIBS_ID"

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Delete unwanted Dropbox metadata files
	find . \
		-name '*:com.dropbox.attributes:$DATA' \
		-delete
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
