/*
 * lock-free-queue.h: Lock free queue.
 *
 * (C) Copyright 2011 Novell, Inc
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#ifndef __MONO_LOCKFREEQUEUE_H__
#define __MONO_LOCKFREEQUEUE_H__

#include <glib.h>

//#define QUEUE_DEBUG	1

typedef struct _MonoLockFreeQueueNode MonoLockFreeQueueNode;

struct _MonoLockFreeQueueNode {
	MonoLockFreeQueueNode *next;
#ifdef QUEUE_DEBUG
	gint32 in_queue;
#endif
};

typedef struct {
	MonoLockFreeQueueNode node;
	gint32 in_use;
} MonoLockFreeQueueDummy;

#define MONO_LOCK_FREE_QUEUE_NUM_DUMMIES	2

typedef struct {
	volatile MonoLockFreeQueueNode *head;
	volatile MonoLockFreeQueueNode *tail;
	MonoLockFreeQueueDummy dummies [MONO_LOCK_FREE_QUEUE_NUM_DUMMIES];
	gint32 has_dummy;
} MonoLockFreeQueue;

void mono_lock_free_queue_init (MonoLockFreeQueue *q) MONO_INTERNAL;

void mono_lock_free_queue_node_init (MonoLockFreeQueueNode *node, gboolean to_be_freed) MONO_INTERNAL;
void mono_lock_free_queue_node_free (MonoLockFreeQueueNode *node) MONO_INTERNAL;

void mono_lock_free_queue_enqueue (MonoLockFreeQueue *q, MonoLockFreeQueueNode *node) MONO_INTERNAL;

MonoLockFreeQueueNode* mono_lock_free_queue_dequeue (MonoLockFreeQueue *q) MONO_INTERNAL;

#endif
