!{\src2tex{textfont=tt}}
!!****f* ABINIT/wrtout
!! NAME
!! wrtout
!!
!! FUNCTION
!! Organizes the sequential or parallel version of the write intrinsic
!! Also allows to treat correctly the write operations for
!! Unix (+DOS) and MacOS.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  unit=unit number for writing
!!  mode_paral='COLL' if all procs are calling the routine with the same message
!!           to be written once only
!!          or 'PERS' if the procs are calling the routine with different mesgs
!!           each to be written, or if one proc is calling the routine
!!
!! OUTPUT
!!  (only writing)
!!
!! SIDE EFFECTS
!!  message=(character(len=500)) message to be written
!!
!! PARENTS
!!      abi_etsf_electrons_put,abi_etsf_geo_put,abi_etsf_init,abinit,acfd_dyson
!!      acfd_intexact,afterscfloop,anaddb,anascr,append_cml,append_cml2,asria9
!!      asrif9,berryphase,berryphase_new,besjm,bfactor,bigbx9,bldgrp,blok8
!!      bonds_lgth_angles,bound,brdmin,canat9,ccfft,ccgradvnl,ccgradvnl_ylm
!!      cchi0,cchi0q0,cgwf,cgwf3,cgwf_htor,chkdilatmx,chkdpr,chkexi,chkgrp
!!      chki8,chkilwf,chkin9,chkinp,chkint,chkneu,chknm8,chkorthsy,chkpawovlp
!!      chkph3,chkprimit,chkr8,chkrp9,chneu9,cigfft,clnup1,clnup2,clsopn
!!      cmevxclda,cmpar8,completeperts,constrf,contract_dp_ge_val
!!      contract_int_ge_val,contract_int_le_val,contract_int_list,cppm1par
!!      cppm2par,cppm3par,cppm4par,crho,csigme,ctocprj,cvxclda,d3output,ddkten
!!      delocint,density,der_int,diel9,dielmt,dielmt2,dieltcel,diisrelax
!!      distrb2,dos_hdr_write,dotprod_vn,dotprodm_vn,driver,drivergw,drivexc
!!      dsksta,dyfnl3,dyson_sc,eig1fixed,elast9,electrooptic,elphon,elpolariz
!!      eltxccore,energy,ewald,ewald3,ewald4,ewald9,fconv,fermi,fftpac,fftw
!!      fftwfn,filterpot,findk,findmin,findnq,findq,findshells,fixsym,forstr
!!      forstrnps,fourdp,fourwf,fresid,ftgam,ftgkk,ftiaf9,fxphas,gensymshub
!!      gensymshub4,gensymspgr,get_all_gkq,get_fs_kpts,get_full_kgrid
!!      get_g_tiny,get_gkk_qpt_tr,get_tetra,getattribute,getcprj,getcut
!!      getdim_nloc,getfreqsus,getghc,getgsc,getkgrid,getlambda,getmpw,getnel
!!      getng,getsc,getshell,getspinrot,gstate,gtblk9,gtdyn9,handle_err_netcdf
!!      hartre,hartre1,hartrestr,hdr_check,hdr_init,hdr_io,hdr_io_etsf
!!      hdr_io_netcdf,hermit,hessinit,identk,identq,importcml,inarray,incomprs
!!      ingeo,ingeobld,ini_wf_etsf,init8,initang,initberry,initberry3
!!      initmpi_gs,initmpi_respfn,initmv,initro,initwf,inkpts,inprep8,instr9
!!      instrng,insy3,int2char,int2char4,intagm,integrate_gamma
!!      integrate_gamma_tr,inupper,invars0,invars1,invars1m,invars2,invars2m
!!      invars9,invcb,inwffil,inwffil3,ioarr,ioddb8,iofn1,iofn2,iosig,irrzg
!!      isfile,klocal,kpgio,kpgsph,kpgstr,kxc_alda,kxc_eok,ladielmt,lattice
!!      lavnl,leave_new,leave_test,lifetime_bn,lifetime_rpa,linemin,listkk
!!      lobpcgIIwf,lobpcgccIIwf,lobpcgccwf,lobpcgwf,loop3dte,loper3,lwf
!!      matcginv,mati3inv,matrginv,matrixelmt_g,mean_fftr,meanvalue_g,memana
!!      memerr,memkss,memorf,memory,metcon,metric,metstr,mka2f,mka2fQgrid
!!      mka2f_tr,mkcor3,mkcore,mkdenpos,mkeuler,mkffnl,mkfilename,mkfskgrid
!!      mkifc9,mkkpg,mklocl,mklocl_realspace,mklocl_recipspace,mklocl_wavelets
!!      mknesting,mkph_linwid,mkqptequiv,mkrho,mkrho3,mkvxc3,mkvxcstr3,moddiel
!!      moldyn,move,mrgddb,mrggkk,mrgscr,mv_3dte,nanal9,nderiv_gen,newfermie1
!!      newkpt,newocc,newrho,newsp,newvtr,newvtr3,nhatgrid,nmsq_gam
!!      nmsq_gam_sumfs,nmsq_pure_gkk,nonlinear,nonlop,nonlop_htor,nonlop_pl
!!      nonlop_ylm,normsq_gkq,nselt3,nstdy3,nstwf3,occeig,operat,opernl2
!!      opernl3,opernl4b,optics_paw,out1dm,outelph,outkss,outqmc,outscfcv
!!      outvars,outwant,outwf,overlap_g,pareigocc,pawcorloc,pawdenpot,pawdij
!!      pawgrhoij,pawinit,pawmknhat,pawmkrhoij,pawprt,pawpuinit,pawpupot
!!      pawuenergy,pawxc,pawxcdenm,pawxcm,ph1d3d,phfrq3,piezo9,pl_deriv
!!      plm_coeff,plm_d2theta,plm_dphi,plm_dtheta,polcart,prcref,prcref_PMA
!!      prctfvw1,prctfvw2,precon,print_ij,printbxsf,printxsf,projbd,prt_cml
!!      prt_cml2,prteigrs,prtene,prtene3,prtocc,prtph3,prtrhomxmn,prtspgroup
!!      prttagm,prtxf,prtxvf,psddb8,psolver_hartree,psp1cc,psp1in,psp1nl,psp2in
!!      psp2lo,psp3in,psp3nl,psp4cc,psp5in,psp5nl,psp6in,psp7in,psp7nl,psp8cc
!!      psp8in,psp9in,pspatm,pspini,pstate,psxml2ab,q0dy3,ramansus,randac
!!      rchkgsheader,rdddb9,rdkss,rdnpw,rdqps,rdscr,read_gkk,readeig,relaxpol
!!      respfn,rhofermi3,rhohxc,rhohxc_coll,rsiaf9,rwwan,rwwf,scalewf_nonlop
!!      scfcge,scfcv,scfcv3,scfeig,scfopt,scprqt,screening,setmesh,setshells
!!      setup1,setup2,setup_hamilt,setup_little_group,sg_ctrig,sg_fft,sg_fftpad
!!      sg_fftpx,sg_fftrisc,sg_fftx,sg_ffty,sg_fftz,sg_fourwf,sigma,smallprim
!!      smatrix,smpbz,sphere,sphereboundary,sphericaldens,status,stress
!!      subdiago,subdiago_htor,surot,suscep,suscep_dyn,suscep_kxc_dyn
!!      suscep_stat,suskmm,suskmm_dyn,suskmm_kxc_dyn,sym_gkk,symanal,symatm
!!      symbrav,symdet,symdij,symdm9,symfind,symg,symkchk,symkpt,symmultsg
!!      symph3,symq3,symrelrot,symrhg,symrhoij,symspgr,tddft,testkgrid,testlda
!!      testscr,tetrahedron,thm9,timab,timana,time_accu,timein,transgrid,uderiv
!!      vlocalstr,vtorho,vtorho3,vtorhotf,vtowfk,vtowfk3,vtowfk_htor,wannier
!!      wfconv,wffclose,wffile,wffopen,wffreadnpwrec,wfkfermi3,wfsinp,wght9
!!      wrqps,wrscr,wrtloctens,wvl_init_type_proj,wvl_init_type_wfs,wvl_mkrho
!!      wvl_rwwf,wvl_setboxgeometry,wvl_vtorho,wvl_wfsinp,xcacfd,xcden,xchcth
!!      xchelu,xcpbe,xcpot,xcpzca,xcspol,xctetr,xcwign,xcxalp,xfpack,xredxcart
!!      ylmc,ylmcd
!!
!! CHILDREN
!!      mpi_comm_rank
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wrtout(unit,message,mode_paral)

 use defs_basis 
 implicit none

#if defined MPI  || defined MPI_FFT
           include 'mpif.h'
#endif
!Arguments ------------------------------------
 integer,intent(in) :: unit
 character(len=4),intent(in) :: mode_paral
 character(len=500),intent(inout) :: message

!Local variables-------------------------------
 integer,save :: iexit=0,ncomment=0,nwarning=0
 integer :: rtnpos,lenmessage
 real(dp) :: tsec(2)
 character(len=7) :: tag
 character(len=500) :: messtmp,string
 logical :: test_mpi
!no_abirules
#if defined MPI || defined MPI_FFT
          !Variables introduced for MPI version
           integer, save :: master=0
           integer :: ierr,me
           character(len=12) :: form,strfmt
#endif

!******************************************************************
!BEGIN EXECUTABLE SECTION

!Be careful with the coding  of the parallel case ...
 test_mpi=.false.
#if defined MPI || defined MPI_FFT
           test_mpi=.true.
          !Determine who I am
           call MPI_COMM_RANK(MPI_COMM_WORLD,me,ierr)
           if(mode_paral=='COLL') then
            if(me==master) then
#endif

 if(message/=' ') then
  messtmp=message
  lenmessage=len(message)
! Here, split the message, according to the char(10)
! characters (carriage return). This technique is
! portable accross different OS.
  rtnpos=index(messtmp,ch10)
  do while(rtnpos/=0)
   string=messtmp(1:rtnpos-1)
   write(unit, '(a)' ) trim(string)
   messtmp=messtmp(rtnpos+1:lenmessage)
   lenmessage=lenmessage-rtnpos
   rtnpos=index(messtmp,ch10)
  end do
  write(unit, '(a)' ) trim(messtmp)
 else
  write(unit,*)
 end if

 if( index(trim(message),'BUG') /= 0 )then
  write(unit, '(a)' ) '  Action : contact ABINIT group.'
  write(unit,*)
 end if

 if( index(trim(message),'BUG') /= 0   .or. &
&    index(trim(message),'Calculation completed') /= 0 )then
  if(nwarning<10000 .and. ncomment<1000)then
   write(unit, '(a,i5,a,i4,a)' ) &
&    '.Delivered',nwarning,' WARNINGs and',ncomment,' COMMENTs to log file.'
  else
   write(unit, '(a,i6,a,i6,a)' ) &
&    '.Delivered',nwarning,' WARNINGs and',ncomment,' COMMENTs to log file.'
  end if
  if(iexit/=0)then
   write(unit, '(a)' ) ' Note : exit requested by the user.'
  end if
 end if

 if( index(trim(message),'Exit') /= 0 )then
  iexit=1
 end if

!Count the number of warnings and comments. Only take into
!account unit 6, in order not to duplicate these numbers.
 if( index(trim(message),'WARNING') /= 0 .and. unit==6 )then
   nwarning=nwarning+1
 end if
 if( index(trim(message),'COMMENT') /= 0 .and. unit==6 )then
   ncomment=ncomment+1
 end if

#if defined MPI || defined MPI_FFT
             end if
           elseif(mode_paral=='PERS') then
             if(me<10) then
               write(tag,'("-P-000",i1)') me
             elseif(me<100) then
               write(tag,'("-P-00",i2)') me
             elseif(me<1000) then
               write(tag,'("-P-0",i3)') me
             elseif(me<10000) then
               write(tag,'("-P-",i4)') me
             else
               tag=' ######'
             end if
             rtnpos=index(message,ch10)
#endif
!            It is not possible to use CPP, due to the // signs
             if(test_mpi)then
              do while(rtnpos/=0)
               string=tag//' '//message(1:rtnpos-1)
               write(unit, '(a)' ) trim(string)
               message=message(rtnpos+1:len(message))
               rtnpos=index(message,ch10)
              end do
              string=tag//' '//message
             end if
#if defined MPI || defined MPI_FFT
             write(unit, '(a)' ) trim(string)
           elseif(mode_paral=='INIT') then
             master=unit
           end if
#endif

end subroutine wrtout
!!***
