/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef balance_H
#define balance_H

#include "../V/Vlibmath.h"

#ifdef balance_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * <pre>
 *   ----------------  z = 0 in body coordinates
 *      ^
 *      |       r{m,n}.z        (constant)
 *      v
 *      o       gear attachment point
 *      ^
 *      |       c{m,n}.z        strut extension  (0 - c{m,n}Max)
 *      v
 *      ^
 *      |       G{m,n}          strut + tire length  (constant)
 *      v
 *   ----------------  ground
 * </pre>
 */
struct balance_data {
	double  weight; /* weight for this test */
	VPoint  rm;     /* rest main gear ground contact point (input),
			   rest main gear attachment point (output) */
	VPoint  rn;     /* rest nose gear ground contact point (input),
			   rest nose gear attachment point (output) */
	double  cm, cn; /* rest extension values of each strut */
	double  cmMax, cnMax;   /* maximum extension values of each strut */
	double  Gm, Gn; /* strut + tire lengths */
	double  Km, Kn; /* string constants (output) */
	double  Gpz;    /* the old "grounding point" Z value */
	};

EXTERN void balance (struct balance_data *s);

#undef EXTERN
#endif
