/* jshint ignore:start */
module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 19);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(9);

/*global toString:true*/

// utils is a library of generic helper functions non-specific to axios

var toString = Object.prototype.toString;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray(val) {
  return toString.call(val) === '[object Array]';
}

/**
 * Determine if a value is a Node Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Node Buffer, otherwise false
 */
function isBuffer(val) {
  return ((typeof Buffer !== 'undefined') && (Buffer.isBuffer) && (Buffer.isBuffer(val)));
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
function isArrayBuffer(val) {
  return toString.call(val) === '[object ArrayBuffer]';
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(val) {
  return (typeof FormData !== 'undefined') && (val instanceof FormData);
}

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {
    result = ArrayBuffer.isView(val);
  } else {
    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a Date
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
function isDate(val) {
  return toString.call(val) === '[object Date]';
}

/**
 * Determine if a value is a File
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
function isFile(val) {
  return toString.call(val) === '[object File]';
}

/**
 * Determine if a value is a Blob
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
function isBlob(val) {
  return toString.call(val) === '[object Blob]';
}

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
function isURLSearchParams(val) {
  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
}

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.replace(/^\s*/, '').replace(/\s*$/, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && navigator.product === 'ReactNative') {
    return false;
  }
  return (
    typeof window !== 'undefined' &&
    typeof document !== 'undefined'
  );
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object' && !isArray(obj)) {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }

  if (isArray(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = merge(result[key], val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

module.exports = {
  isArray: isArray,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  extend: extend,
  trim: trim
};


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var instance;
var levels = {
    config: 3,
    fine: 2,
    finer: 1,
    finest: 0,
    info: 4,
    severe: 6,
    warning: 5,
};
var colors = {
    fine: "grey", finer: "grey", finest: "grey",
    info: "green", severe: "red", warning: "yellow",
};
function getInstance(options) {
    try {
        instance = __webpack_require__(22).getInstance(options);
    }
    catch (err) {
        if (instance && !options) {
            return instance;
        }
        var winston = __webpack_require__(23);
        var loggerConfig = {
            transports: [],
            levels: levels,
            colors: colors,
        };
        if ((options || {}).consoleLogLevel !== "none") {
            loggerConfig.transports[0] =
                new (winston.transports.Console)({
                    colorize: true,
                    handleExceptions: true,
                    humanReadableUnhandledException: true,
                    json: false,
                    level: (options || {}).consoleLogLevel,
                    timestamp: function () { return (new Date()).toUTCString(); },
                });
        }
        if ((options || {}).fileLogLevel !== "none") {
            loggerConfig.transports[1] =
                new (winston.transports.File)({
                    colorize: false,
                    filename: (options || {}).fileLogPath || "local-restnoded.log",
                    handleExceptions: true,
                    humanReadableUnhandledException: true,
                    json: false,
                    level: (options || {}).fileLogLevel,
                    maxFiles: (options || {}).maxFiles || 20,
                    maxSize: (options || {}).maxFileSize || 1000000,
                    tailable: true,
                    timestamp: function () { return (new Date()).toUTCString(); },
                });
        }
        instance = new winston.Logger(loggerConfig);
    }
    return instance;
}
exports.getInstance = getInstance;
var f5Logger = {
    getInstance: getInstance,
};
exports.default = f5Logger;
//# sourceMappingURL=index.js.map

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
// module name for logging
exports.moduleName = "@iapp::renderer";
var Renderer_1 = __webpack_require__(30);
var RequestHandler_1 = __webpack_require__(3);
exports.request = new RequestHandler_1.default();
exports.default = Renderer_1.default;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = __webpack_require__(1);
var logger = logger_1.default.getInstance();
var axios_1 = __webpack_require__(33);
var index_1 = __webpack_require__(2);
var requestInterceptors_1 = __webpack_require__(63);
exports._h = "[" + index_1.moduleName + "::handler]";
var _baseURL = "http://localhost:8100/mgmt";
var _auth = { username: "admin", password: "" };
var DEFAULT_TIMEOUT = 5 * 1000; // msec
var IcrRequestHandler = (function () {
    function IcrRequestHandler(options) {
        if (options === void 0) { options = {}; }
        var _this = this;
        this.debug = !!options.debug;
        var _a = options.auth || _auth, username = _a.username, _b = _a.password, password = _b === void 0 ? "" : _b;
        var baseURL = options.baseURL || _baseURL;
        this.options = { timeout: DEFAULT_TIMEOUT, auth: { username: username, password: password }, baseURL: baseURL };
        this.handler = axios_1.default.create(this.options);
        //
        // Request Interceptors
        //
        this.handler.interceptors.request.use(function (config) {
            config.__sentAt__ = Date.now();
            config.__debug__ = _this.debug;
            if (!config.transId) {
                return config;
            }
            // Insert coordinate-id header for POST, PUT, PATCH, DELETE request/
            var method = (config.method || "").toLocaleLowerCase();
            if (["post", "put", "patch", "delete"].indexOf(method) > -1) {
                if (Object.prototype.hasOwnProperty.call(config, "transId") &&
                    !/\/tm\/transaction/.test(config.url || "")) {
                    config.headers["X-F5-REST-Coordination-Id"] = config.transId;
                }
            }
            return config;
        });
        this.handler.interceptors.request.use(requestInterceptors_1.loggerOnRequest);
        this.handler.interceptors.response.use(requestInterceptors_1.loggerOnResponse, requestInterceptors_1.loggerOnError);
        var _loop_1 = function (verb) {
            this_1[verb] = function (apiPath, data, config) {
                if (config === void 0) { config = { transId: undefined }; }
                return _this.handler[verb](apiPath, data, config);
            };
        };
        var this_1 = this;
        //
        // Request Methods Wrapper
        //
        for (var _i = 0, _c = ["post", "patch", "put"]; _i < _c.length; _i++) {
            var verb = _c[_i];
            _loop_1(verb);
        }
        var _loop_2 = function (verb) {
            this_2[verb] = function (apiPath, config) {
                if (config === void 0) { config = { transId: undefined }; }
                return _this.handler[verb](apiPath, config);
            };
        };
        var this_2 = this;
        for (var _d = 0, _e = ["get", "head", "delete"]; _d < _e.length; _d++) {
            var verb = _e[_d];
            _loop_2(verb);
        }
    }
    Object.defineProperty(IcrRequestHandler.prototype, "timeout", {
        get: function () {
            return this.handler.defaults.timeout || DEFAULT_TIMEOUT;
        },
        set: function (value) {
            this.handler.defaults.timeout = value;
        },
        enumerable: true,
        configurable: true
    });
    IcrRequestHandler.prototype.createTransaction = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _f, res, transId, err_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _f = exports._h + "(createTransaction)";
                        logger.info(_f, "Creating a transaction");
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.post("/tm/transaction", {})];
                    case 2:
                        res = _a.sent();
                        transId = res.data.transId;
                        logger.info(_f, "Successfully created a transaction (transId=" + transId + ")");
                        return [2 /*return*/, transId];
                    case 3:
                        err_1 = _a.sent();
                        logger.severe(_f, "Failed to create transaction", "Reason=\"" + err_1.message + "\"");
                        throw (err_1);
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    IcrRequestHandler.prototype.commitTransaction = function (transId) {
        return __awaiter(this, void 0, void 0, function () {
            var _f, msg, error, res, err_2, cmds, data_1, data, err_3, message, data;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _f = exports._h + "(commitTransaction)(transId:" + transId + ")";
                        logger.info(_f + " Committing transaction");
                        if (!transId || typeof transId !== "number") {
                            msg = "Invalid transaction id is passed (type=" + typeof transId + ")";
                            logger.severe(_f + "(transId:" + transId + " " + msg + ")");
                            throw (new TypeError(msg));
                        }
                        error = new Error();
                        error.message = "";
                        error.name = "";
                        error.config = {};
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.get("/tm/transaction/" + transId + "/commands")];
                    case 2:
                        res = _a.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        err_2 = _a.sent();
                        error.config = err_2.config;
                        error.code = err_2.code;
                        error.data = err_2.response ? err_2.response.data : void 0;
                        // logger.finest(`${_f}(transId=${transId}) code="${error.code}", message="${error.data.message}"`);
                        error.message = (err_2.code === "404") ?
                            "Failed to find transaction in the system. Aborting" :
                            "Unknown Error Occurred while finding transaction to commit.";
                        throw error;
                    case 4:
                        _a.trys.push([4, 8, , 9]);
                        cmds = res.data;
                        if (!!cmds.items) return [3 /*break*/, 6];
                        logger.info(_f + " No command in the transaction. Cancelling");
                        return [4 /*yield*/, this.cancelTransaction(transId)];
                    case 5:
                        _a.sent();
                        data_1 = {
                            state: "COMPLETED",
                            transId: transId,
                            kind: "tm:transactionstate",
                        };
                        return [2 /*return*/, data_1];
                    case 6:
                        logger.info(_f + " Found transaction with " + (cmds.items || []).length + " commands. Committing.");
                        if (this.debug) {
                            logger.finest(_f + " Commands to commit:", JSON.stringify(cmds, null, "  "));
                        }
                        return [4 /*yield*/, this.patch("/tm/transaction/" + transId, { state: "VALIDATING" }, { transId: transId })];
                    case 7:
                        res = _a.sent();
                        data = res.data;
                        if (data.state !== "COMPLETED" ||
                            data.transId != transId ||
                            data.failureReason !== "") {
                            error.message = "Transaction did not seem to complete properly." +
                                ("(code=" + res.status + ", state=" + data.state + ", reason=\"" + data.failureReason + ")\"");
                            error.code = res.status.toString();
                            error.data = res.data;
                            throw error;
                        }
                        logger.info(_f + " Successfully committed transaction. (t=" + data.executionTime + ")");
                        return [2 /*return*/, data];
                    case 8:
                        err_3 = _a.sent();
                        message = err_3.message;
                        data = err_3.response ? err_3.response.data : err_3.data;
                        logger.severe(_f + " Transaction failed. (message=" + message + ")");
                        throw data;
                    case 9: return [2 /*return*/];
                }
            });
        });
    };
    IcrRequestHandler.prototype.cancelTransaction = function (transId) {
        return __awaiter(this, void 0, void 0, function () {
            var _f, msg, res, err_4;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _f = exports._h + "(cancelTransaction)(transId:" + (transId ? transId : "none") + ")";
                        logger.info(_f + " Cancelling transaction");
                        if (!transId || typeof transId !== "number") {
                            msg = "Invalid transaction id is passed (transId=" + transId + ", type=" + typeof transId + ")";
                            logger.severe(_f + " " + msg + ")");
                            throw new TypeError(msg);
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.delete("/tm/transaction/" + transId)];
                    case 2:
                        res = _a.sent();
                        logger.info(_f + " Successfully canceled the transaction. (status=" + res.status + ")");
                        return [2 /*return*/, res.data];
                    case 3:
                        err_4 = _a.sent();
                        logger.severe(_f + " Failed to cancel the transaction. (message=" + err_4.message + ")");
                        throw err_4;
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    return IcrRequestHandler;
}());
exports.IcrRequestHandler = IcrRequestHandler;
exports.default = IcrRequestHandler;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[argsTag] = cloneableTags[arrayTag] =
cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
cloneableTags[boolTag] = cloneableTags[dateTag] =
cloneableTags[float32Tag] = cloneableTags[float64Tag] =
cloneableTags[int8Tag] = cloneableTags[int16Tag] =
cloneableTags[int32Tag] = cloneableTags[mapTag] =
cloneableTags[numberTag] = cloneableTags[objectTag] =
cloneableTags[regexpTag] = cloneableTags[setTag] =
cloneableTags[stringTag] = cloneableTags[symbolTag] =
cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = cloneableTags[funcTag] =
cloneableTags[weakMapTag] = false;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/**
 * Adds the key-value `pair` to `map`.
 *
 * @private
 * @param {Object} map The map to modify.
 * @param {Array} pair The key-value pair to add.
 * @returns {Object} Returns `map`.
 */
function addMapEntry(map, pair) {
  // Don't return `map.set` because it's not chainable in IE 11.
  map.set(pair[0], pair[1]);
  return map;
}

/**
 * Adds `value` to `set`.
 *
 * @private
 * @param {Object} set The set to modify.
 * @param {*} value The value to add.
 * @returns {Object} Returns `set`.
 */
function addSetEntry(set, value) {
  // Don't return `set.add` because it's not chainable in IE 11.
  set.add(value);
  return set;
}

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array ? array.length : 0;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1,
      length = array ? array.length : 0;

  if (initAccum && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Checks if `value` is a host object in IE < 9.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
 */
function isHostObject(value) {
  // Many host objects are `Object` objects that can coerce to strings
  // despite having improperly defined `toString` methods.
  var result = false;
  if (value != null && typeof value.toString != 'function') {
    try {
      result = !!(value + '');
    } catch (e) {}
  }
  return result;
}

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype,
    funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    Symbol = root.Symbol,
    Uint8Array = root.Uint8Array,
    getPrototype = overArg(Object.getPrototypeOf, Object),
    objectCreate = Object.create,
    propertyIsEnumerable = objectProto.propertyIsEnumerable,
    splice = arrayProto.splice;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols,
    nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
    nativeKeys = overArg(Object.keys, Object);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView'),
    Map = getNative(root, 'Map'),
    Promise = getNative(root, 'Promise'),
    Set = getNative(root, 'Set'),
    WeakMap = getNative(root, 'WeakMap'),
    nativeCreate = getNative(Object, 'create');

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  return this.has(key) && delete this.__data__[key];
}

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
}

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
}

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  return getMapData(this, key)['delete'](key);
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  getMapData(this, key).set(key, value);
  return this;
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  this.__data__ = new ListCache(entries);
}

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  return this.__data__['delete'](key);
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var cache = this.__data__;
  if (cache instanceof ListCache) {
    var pairs = cache.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      return this;
    }
    cache = this.__data__ = new MapCache(pairs);
  }
  cache.set(key, value);
  return this;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
  // Safari 9 makes `arguments.length` enumerable in strict mode.
  var result = (isArray(value) || isArguments(value))
    ? baseTimes(value.length, String)
    : [];

  var length = result.length,
      skipIndexes = !!length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    object[key] = value;
  }
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/**
 * The base implementation of `_.assign` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssign(object, source) {
  return object && copyObject(source, keys(source), object);
}

/**
 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
 * traversed objects.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @param {boolean} [isFull] Specify a clone including symbols.
 * @param {Function} [customizer] The function to customize cloning.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The parent object of `value`.
 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, isDeep, isFull, customizer, key, object, stack) {
  var result;
  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!isObject(value)) {
    return value;
  }
  var isArr = isArray(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return copyArray(value, result);
    }
  } else {
    var tag = getTag(value),
        isFunc = tag == funcTag || tag == genTag;

    if (isBuffer(value)) {
      return cloneBuffer(value, isDeep);
    }
    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
      if (isHostObject(value)) {
        return object ? value : {};
      }
      result = initCloneObject(isFunc ? {} : value);
      if (!isDeep) {
        return copySymbols(value, baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = initCloneByTag(value, tag, baseClone, isDeep);
    }
  }
  // Check for circular references and return its corresponding clone.
  stack || (stack = new Stack);
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);

  if (!isArr) {
    var props = isFull ? getAllKeys(value) : keys(value);
  }
  arrayEach(props || value, function(subValue, key) {
    if (props) {
      key = subValue;
      subValue = value[key];
    }
    // Recursively populate clone (susceptible to call stack limits).
    assignValue(result, key, baseClone(subValue, isDeep, isFull, customizer, key, value, stack));
  });
  return result;
}

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} prototype The object to inherit from.
 * @returns {Object} Returns the new object.
 */
function baseCreate(proto) {
  return isObject(proto) ? objectCreate(proto) : {};
}

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

/**
 * The base implementation of `getTag`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  return objectToString.call(value);
}

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var result = new buffer.constructor(buffer.length);
  buffer.copy(result);
  return result;
}

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

/**
 * Creates a clone of `dataView`.
 *
 * @private
 * @param {Object} dataView The data view to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned data view.
 */
function cloneDataView(dataView, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}

/**
 * Creates a clone of `map`.
 *
 * @private
 * @param {Object} map The map to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned map.
 */
function cloneMap(map, isDeep, cloneFunc) {
  var array = isDeep ? cloneFunc(mapToArray(map), true) : mapToArray(map);
  return arrayReduce(array, addMapEntry, new map.constructor);
}

/**
 * Creates a clone of `regexp`.
 *
 * @private
 * @param {Object} regexp The regexp to clone.
 * @returns {Object} Returns the cloned regexp.
 */
function cloneRegExp(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}

/**
 * Creates a clone of `set`.
 *
 * @private
 * @param {Object} set The set to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned set.
 */
function cloneSet(set, isDeep, cloneFunc) {
  var array = isDeep ? cloneFunc(setToArray(set), true) : setToArray(set);
  return arrayReduce(array, addSetEntry, new set.constructor);
}

/**
 * Creates a clone of the `symbol` object.
 *
 * @private
 * @param {Object} symbol The symbol object to clone.
 * @returns {Object} Returns the cloned symbol object.
 */
function cloneSymbol(symbol) {
  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    assignValue(object, key, newValue === undefined ? source[key] : newValue);
  }
  return object;
}

/**
 * Copies own symbol properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbols(source, object) {
  return copyObject(source, getSymbols(source), object);
}

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/**
 * Creates an array of the own enumerable symbol properties of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = nativeGetSymbols ? overArg(nativeGetSymbols, Object) : stubArray;

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11,
// for data views in Edge < 14, and promises in Node.js.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = objectToString.call(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : undefined;

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

/**
 * Initializes an array clone.
 *
 * @private
 * @param {Array} array The array to clone.
 * @returns {Array} Returns the initialized clone.
 */
function initCloneArray(array) {
  var length = array.length,
      result = array.constructor(length);

  // Add properties assigned by `RegExp#exec`.
  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

/**
 * Initializes an object clone based on its `toStringTag`.
 *
 * **Note:** This function only supports cloning values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to clone.
 * @param {string} tag The `toStringTag` of the object to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneByTag(object, tag, cloneFunc, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case arrayBufferTag:
      return cloneArrayBuffer(object);

    case boolTag:
    case dateTag:
      return new Ctor(+object);

    case dataViewTag:
      return cloneDataView(object, isDeep);

    case float32Tag: case float64Tag:
    case int8Tag: case int16Tag: case int32Tag:
    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
      return cloneTypedArray(object, isDeep);

    case mapTag:
      return cloneMap(object, isDeep, cloneFunc);

    case numberTag:
    case stringTag:
      return new Ctor(object);

    case regexpTag:
      return cloneRegExp(object);

    case setTag:
      return cloneSet(object, isDeep, cloneFunc);

    case symbolTag:
      return cloneSymbol(object);
  }
}

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to process.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * This method is like `_.clone` except that it recursively clones `value`.
 *
 * @static
 * @memberOf _
 * @since 1.0.0
 * @category Lang
 * @param {*} value The value to recursively clone.
 * @returns {*} Returns the deep cloned value.
 * @see _.clone
 * @example
 *
 * var objects = [{ 'a': 1 }, { 'b': 2 }];
 *
 * var deep = _.cloneDeep(objects);
 * console.log(deep[0] === objects[0]);
 * // => false
 */
function cloneDeep(value) {
  return baseClone(value, true, true);
}

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
function isArguments(value) {
  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
}

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 8-9 which returns 'object' for typed array and other constructors.
  var tag = isObject(value) ? objectToString.call(value) : '';
  return tag == funcTag || tag == genTag;
}

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = cloneDeep;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(25)(module)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var HTTP_METHODS = ['GET', 'POST', 'PUT', 'PATCH', 'DELETE'];

/**
 * @typedef {Object} URI
 * @property {String|Null} protocol - http
 * @property {String|Null} slashes
 * @property {String|Null} auth
 * @property {String|Null} host
 * @property {String|Null} port
 * @property {String|Null} hostname
 * @property {String|Null} hash
 * @property {String|Null} search - ?q=123
 * @property {Object|Null} query - { q: 123 }
 * @property {String|Null} pathname - /shared/iapp/lwc/config/message
 * @property {String|Null} path - /shared/iapp/lwc/config/message?q=123
 * @property {String|Null} href - /shared/iapp/lwc/config/message?q=123
 */

/**
 * @typedef {Object} RestOperation
 * @property {String} method
 * @property {URI} uri
 * @property {Object} body
 * @property {String} statusCode
 * @property {Object} contentType
 * @property {String} referer
 * @property {String} id
 * @property {Function} complete
 * @property {Function} fail
 */

/**
 * Validates if it is a valid restOperation object.
 * @param {RestOperation} restOperation
 * @return {boolean}
 */
exports.isValidRestOperation = function (restOperation) {
  var validProps = ['uri', 'method', 'body'];
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = validProps[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var prop = _step.value;

      if (!{}.hasOwnProperty.call(restOperation, prop)) return false;
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  if (!restOperation.uri.pathname) return false;
  if (!restOperation.method || HTTP_METHODS.indexOf(restOperation.method.toUpperCase()) === -1) return false;
  return true;
};

/***/ }),
/* 6 */
/***/ (function(module, exports) {

module.exports = require("url");

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);
var normalizeHeaderName = __webpack_require__(36);

var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};

function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}

function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = __webpack_require__(37);
  } else if (typeof process !== 'undefined') {
    // For node use HTTP adapter
    adapter = __webpack_require__(42);
  }
  return adapter;
}

var defaults = {
  adapter: getDefaultAdapter(),

  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Content-Type');
    if (utils.isFormData(data) ||
      utils.isArrayBuffer(data) ||
      utils.isBuffer(data) ||
      utils.isStream(data) ||
      utils.isFile(data) ||
      utils.isBlob(data)
    ) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    if (utils.isObject(data)) {
      setContentTypeIfUnset(headers, 'application/json;charset=utf-8');
      return JSON.stringify(data);
    }
    return data;
  }],

  transformResponse: [function transformResponse(data) {
    /*eslint no-param-reassign:0*/
    if (typeof data === 'string') {
      try {
        data = JSON.parse(data);
      } catch (e) { /* Ignore */ }
    }
    return data;
  }],

  timeout: 0,

  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',

  maxContentLength: -1,

  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  }
};

defaults.headers = {
  common: {
    'Accept': 'application/json, text/plain, */*'
  }
};

utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});

module.exports = defaults;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var enhanceError = __webpack_require__(11);

/**
 * Create an Error with the specified message, config, error code, and response.
 *
 * @param {string} message The error message.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 @ @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
module.exports = function createError(message, config, code, response) {
  var error = new Error(message);
  return enhanceError(error, config, code, response);
};


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var createError = __webpack_require__(8);

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
module.exports = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  // Note: status is not exposed by XDomainRequest
  if (!response.status || !validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(createError(
      'Request failed with status code ' + response.status,
      response.config,
      null,
      response
    ));
  }
};


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Update an Error with the specified config, error code, and response.
 *
 * @param {Error} error The error to update.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 @ @param {Object} [response] The response.
 * @returns {Error} The error.
 */
module.exports = function enhanceError(error, config, code, response) {
  error.config = config;
  if (code) {
    error.code = code;
  }
  error.response = response;
  return error;
};


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

function encode(val) {
  return encodeURIComponent(val).
    replace(/%40/gi, '@').
    replace(/%3A/gi, ':').
    replace(/%24/g, '$').
    replace(/%2C/gi, ',').
    replace(/%20/g, '+').
    replace(/%5B/gi, '[').
    replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
module.exports = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }

  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];

    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }

      if (utils.isArray(val)) {
        key = key + '[]';
      }

      if (!utils.isArray(val)) {
        val = [val];
      }

      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });

    serializedParams = parts.join('&');
  }

  if (serializedParams) {
    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }

  return url;
};


/***/ }),
/* 13 */
/***/ (function(module, exports) {

module.exports = require("http");

/***/ }),
/* 14 */
/***/ (function(module, exports) {

module.exports = require("https");

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var url = __webpack_require__(6);
var assert = __webpack_require__(43);
var http = __webpack_require__(13);
var https = __webpack_require__(14);
var Writable = __webpack_require__(44).Writable;
var debug = __webpack_require__(45)('follow-redirects');

var nativeProtocols = {'http:': http, 'https:': https};
var schemes = {};
var exports = module.exports = {
	maxRedirects: 21
};
// RFC7231§4.2.1: Of the request methods defined by this specification,
// the GET, HEAD, OPTIONS, and TRACE methods are defined to be safe.
var safeMethods = {GET: true, HEAD: true, OPTIONS: true, TRACE: true};

// Create handlers that pass events from native requests
var eventHandlers = Object.create(null);
['abort', 'aborted', 'error', 'socket'].forEach(function (event) {
	eventHandlers[event] = function (arg) {
		this._redirectable.emit(event, arg);
	};
});

// An HTTP(S) request that can be redirected
function RedirectableRequest(options, responseCallback) {
	// Initialize the request
	Writable.call(this);
	this._options = options;
	this._redirectCount = 0;
	this._bufferedWrites = [];

	// Attach a callback if passed
	if (responseCallback) {
		this.on('response', responseCallback);
	}

	// React to responses of native requests
	var self = this;
	this._onNativeResponse = function (response) {
		self._processResponse(response);
	};

	// Complete the URL object when necessary
	if (!options.pathname && options.path) {
		var searchPos = options.path.indexOf('?');
		if (searchPos < 0) {
			options.pathname = options.path;
		} else {
			options.pathname = options.path.substring(0, searchPos);
			options.search = options.path.substring(searchPos);
		}
	}

	// Perform the first request
	this._performRequest();
}
RedirectableRequest.prototype = Object.create(Writable.prototype);

// Executes the next native request (initial or redirect)
RedirectableRequest.prototype._performRequest = function () {
	// If specified, use the agent corresponding to the protocol
	// (HTTP and HTTPS use different types of agents)
	var protocol = this._options.protocol;
	if (this._options.agents) {
		this._options.agent = this._options.agents[schemes[protocol]];
	}

	// Create the native request
	var nativeProtocol = nativeProtocols[protocol];
	var request = this._currentRequest =
				nativeProtocol.request(this._options, this._onNativeResponse);
	this._currentUrl = url.format(this._options);

	// Set up event handlers
	request._redirectable = this;
	for (var event in eventHandlers) {
		/* istanbul ignore else */
		if (event) {
			request.on(event, eventHandlers[event]);
		}
	}

	// End a redirected request
	// (The first request must be ended explicitly with RedirectableRequest#end)
	if (this._isRedirect) {
		// If the request doesn't have en entity, end directly.
		var bufferedWrites = this._bufferedWrites;
		if (bufferedWrites.length === 0) {
			request.end();
		// Otherwise, write the request entity and end afterwards.
		} else {
			var i = 0;
			(function writeNext() {
				if (i < bufferedWrites.length) {
					var bufferedWrite = bufferedWrites[i++];
					request.write(bufferedWrite.data, bufferedWrite.encoding, writeNext);
				} else {
					request.end();
				}
			})();
		}
	}
};

// Processes a response from the current native request
RedirectableRequest.prototype._processResponse = function (response) {
	// RFC7231§6.4: The 3xx (Redirection) class of status code indicates
	// that further action needs to be taken by the user agent in order to
	// fulfill the request. If a Location header field is provided,
	// the user agent MAY automatically redirect its request to the URI
	// referenced by the Location field value,
	// even if the specific status code is not understood.
	var location = response.headers.location;
	if (location && this._options.followRedirects !== false &&
			response.statusCode >= 300 && response.statusCode < 400) {
		// RFC7231§6.4: A client SHOULD detect and intervene
		// in cyclical redirections (i.e., "infinite" redirection loops).
		if (++this._redirectCount > this._options.maxRedirects) {
			return this.emit('error', new Error('Max redirects exceeded.'));
		}

		// RFC7231§6.4: Automatic redirection needs to done with
		// care for methods not known to be safe […],
		// since the user might not wish to redirect an unsafe request.
		// RFC7231§6.4.7: The 307 (Temporary Redirect) status code indicates
		// that the target resource resides temporarily under a different URI
		// and the user agent MUST NOT change the request method
		// if it performs an automatic redirection to that URI.
		var header;
		var headers = this._options.headers;
		if (response.statusCode !== 307 && !(this._options.method in safeMethods)) {
			this._options.method = 'GET';
			// Drop a possible entity and headers related to it
			this._bufferedWrites = [];
			for (header in headers) {
				if (/^content-/i.test(header)) {
					delete headers[header];
				}
			}
		}

		// Drop the Host header, as the redirect might lead to a different host
		if (!this._isRedirect) {
			for (header in headers) {
				if (/^host$/i.test(header)) {
					delete headers[header];
				}
			}
		}

		// Perform the redirected request
		var redirectUrl = url.resolve(this._currentUrl, location);
		debug('redirecting to', redirectUrl);
		Object.assign(this._options, url.parse(redirectUrl));
		this._isRedirect = true;
		this._performRequest();
	} else {
		// The response is not a redirect; return it as-is
		response.responseUrl = this._currentUrl;
		this.emit('response', response);

		// Clean up
		delete this._options;
		delete this._bufferedWrites;
	}
};

// Aborts the current native request
RedirectableRequest.prototype.abort = function () {
	this._currentRequest.abort();
};

// Flushes the headers of the current native request
RedirectableRequest.prototype.flushHeaders = function () {
	this._currentRequest.flushHeaders();
};

// Sets the noDelay option of the current native request
RedirectableRequest.prototype.setNoDelay = function (noDelay) {
	this._currentRequest.setNoDelay(noDelay);
};

// Sets the socketKeepAlive option of the current native request
RedirectableRequest.prototype.setSocketKeepAlive = function (enable, initialDelay) {
	this._currentRequest.setSocketKeepAlive(enable, initialDelay);
};

// Sets the timeout option of the current native request
RedirectableRequest.prototype.setTimeout = function (timeout, callback) {
	this._currentRequest.setTimeout(timeout, callback);
};

// Writes buffered data to the current native request
RedirectableRequest.prototype.write = function (data, encoding, callback) {
	this._currentRequest.write(data, encoding, callback);
	this._bufferedWrites.push({data: data, encoding: encoding});
};

// Ends the current native request
RedirectableRequest.prototype.end = function (data, encoding, callback) {
	this._currentRequest.end(data, encoding, callback);
	if (data) {
		this._bufferedWrites.push({data: data, encoding: encoding});
	}
};

// Export a redirecting wrapper for each native protocol
Object.keys(nativeProtocols).forEach(function (protocol) {
	var scheme = schemes[protocol] = protocol.substr(0, protocol.length - 1);
	var nativeProtocol = nativeProtocols[protocol];
	var wrappedProtocol = exports[scheme] = Object.create(nativeProtocol);

	// Executes an HTTP request, following redirects
	wrappedProtocol.request = function (options, callback) {
		if (typeof options === 'string') {
			options = url.parse(options);
			options.maxRedirects = exports.maxRedirects;
		} else {
			options = Object.assign({
				maxRedirects: exports.maxRedirects,
				protocol: protocol
			}, options);
		}
		assert.equal(options.protocol, protocol, 'protocol mismatch');
		debug('options', options);

		return new RedirectableRequest(options, callback);
	};

	// Executes a GET request, following redirects
	wrappedProtocol.get = function (options, callback) {
		var request = wrappedProtocol.request(options, callback);
		request.end();
		return request;
	};
});


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {


/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 *
 * Expose `debug()` as the module.
 */

exports = module.exports = createDebug.debug = createDebug['default'] = createDebug;
exports.coerce = coerce;
exports.disable = disable;
exports.enable = enable;
exports.enabled = enabled;
exports.humanize = __webpack_require__(47);

/**
 * The currently active debug mode names, and names to skip.
 */

exports.names = [];
exports.skips = [];

/**
 * Map of special "%n" handling functions, for the debug "format" argument.
 *
 * Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
 */

exports.formatters = {};

/**
 * Previous log timestamp.
 */

var prevTime;

/**
 * Select a color.
 * @param {String} namespace
 * @return {Number}
 * @api private
 */

function selectColor(namespace) {
  var hash = 0, i;

  for (i in namespace) {
    hash  = ((hash << 5) - hash) + namespace.charCodeAt(i);
    hash |= 0; // Convert to 32bit integer
  }

  return exports.colors[Math.abs(hash) % exports.colors.length];
}

/**
 * Create a debugger with the given `namespace`.
 *
 * @param {String} namespace
 * @return {Function}
 * @api public
 */

function createDebug(namespace) {

  function debug() {
    // disabled?
    if (!debug.enabled) return;

    var self = debug;

    // set `diff` timestamp
    var curr = +new Date();
    var ms = curr - (prevTime || curr);
    self.diff = ms;
    self.prev = prevTime;
    self.curr = curr;
    prevTime = curr;

    // turn the `arguments` into a proper Array
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }

    args[0] = exports.coerce(args[0]);

    if ('string' !== typeof args[0]) {
      // anything else let's inspect with %O
      args.unshift('%O');
    }

    // apply any `formatters` transformations
    var index = 0;
    args[0] = args[0].replace(/%([a-zA-Z%])/g, function(match, format) {
      // if we encounter an escaped % then don't increase the array index
      if (match === '%%') return match;
      index++;
      var formatter = exports.formatters[format];
      if ('function' === typeof formatter) {
        var val = args[index];
        match = formatter.call(self, val);

        // now we need to remove `args[index]` since it's inlined in the `format`
        args.splice(index, 1);
        index--;
      }
      return match;
    });

    // apply env-specific formatting (colors, etc.)
    exports.formatArgs.call(self, args);

    var logFn = debug.log || exports.log || console.log.bind(console);
    logFn.apply(self, args);
  }

  debug.namespace = namespace;
  debug.enabled = exports.enabled(namespace);
  debug.useColors = exports.useColors();
  debug.color = selectColor(namespace);

  // env-specific initialization logic for debug instances
  if ('function' === typeof exports.init) {
    exports.init(debug);
  }

  return debug;
}

/**
 * Enables a debug mode by namespaces. This can include modes
 * separated by a colon and wildcards.
 *
 * @param {String} namespaces
 * @api public
 */

function enable(namespaces) {
  exports.save(namespaces);

  exports.names = [];
  exports.skips = [];

  var split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
  var len = split.length;

  for (var i = 0; i < len; i++) {
    if (!split[i]) continue; // ignore empty strings
    namespaces = split[i].replace(/\*/g, '.*?');
    if (namespaces[0] === '-') {
      exports.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
    } else {
      exports.names.push(new RegExp('^' + namespaces + '$'));
    }
  }
}

/**
 * Disable debug output.
 *
 * @api public
 */

function disable() {
  exports.enable('');
}

/**
 * Returns true if the given mode name is enabled, false otherwise.
 *
 * @param {String} name
 * @return {Boolean}
 * @api public
 */

function enabled(name) {
  var i, len;
  for (i = 0, len = exports.skips.length; i < len; i++) {
    if (exports.skips[i].test(name)) {
      return false;
    }
  }
  for (i = 0, len = exports.names.length; i < len; i++) {
    if (exports.names[i].test(name)) {
      return true;
    }
  }
  return false;
}

/**
 * Coerce `val`.
 *
 * @param {Mixed} val
 * @return {Mixed}
 * @api private
 */

function coerce(val) {
  if (val instanceof Error) return val.stack || val.message;
  return val;
}


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * A `Cancel` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function Cancel(message) {
  this.message = message;
}

Cancel.prototype.toString = function toString() {
  return 'Cancel' + (this.message ? ': ' + this.message : '');
};

Cancel.prototype.__CANCEL__ = true;

module.exports = Cancel;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = undefined && undefined.__generator || function (thisArg, body) {
    var _ = { label: 0, sent: function sent() {
            if (t[0] & 1) throw t[1];return t[1];
        }, trys: [], ops: [] },
        f,
        y,
        t,
        g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
        return this;
    }), g;
    function verb(n) {
        return function (v) {
            return step([n, v]);
        };
    }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) {
            try {
                if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [0, t.value];
                switch (op[0]) {
                    case 0:case 1:
                        t = op;break;
                    case 4:
                        _.label++;return { value: op[1], done: false };
                    case 5:
                        _.label++;y = op[1];op = [0];continue;
                    case 7:
                        op = _.ops.pop();_.trys.pop();continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                            _ = 0;continue;
                        }
                        if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                            _.label = op[1];break;
                        }
                        if (op[0] === 6 && _.label < t[1]) {
                            _.label = t[1];t = op;break;
                        }
                        if (t && _.label < t[2]) {
                            _.label = t[2];_.ops.push(op);break;
                        }
                        if (t[2]) _.ops.pop();
                        _.trys.pop();continue;
                }
                op = body.call(thisArg, _);
            } catch (e) {
                op = [6, e];y = 0;
            } finally {
                f = t = 0;
            }
        }if (op[0] & 5) throw op[1];return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var controller_1 = __webpack_require__(20);
var logger_1 = __webpack_require__(1);
var renderer_1 = __webpack_require__(2);
var _h = "[ApiHandler]";
var logger = logger_1.default.getInstance();
var ApiHandler = function () {
    function ApiHandler() {
        var _this = this;
        this.handleOnPost = function (req, res) {
            return __awaiter(_this, void 0, void 0, function () {
                var _a, name, destination, mask, renderer, err_1;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = req.body, name = _a.name, destination = _a.destination, mask = _a.mask;
                            _b.label = 1;
                        case 1:
                            _b.trys.push([1, 3,, 4]);
                            renderer = new renderer_1.default();
                            renderer.add({
                                kind: "tm:ltm:virtual:virtualstate",
                                name: name,
                                description: "Created by MyAPI",
                                destination: destination,
                                source: "0.0.0.0/0",
                                mask: mask,
                                pool: name + "-pool"
                            });
                            renderer.add({
                                kind: "tm:ltm:pool:poolstate",
                                name: name + "-pool",
                                description: "Created by MyAPI"
                            });
                            return [4 /*yield*/, renderer.dispatch()];
                        case 2:
                            _b.sent();
                            this.deployed = renderer.selfLinks;
                            res.send({ deployed: this.deployed });
                            return [3 /*break*/, 4];
                        case 3:
                            err_1 = _b.sent();
                            logger.severe(_h + " Failed with error " + err_1.message);
                            logger.severe(_h, err_1.stack);
                            res.status(500).send({ error: err_1.message, stack: err_1.stack });
                            return [3 /*break*/, 4];
                        case 4:
                            return [2 /*return*/];
                    }
                });
            });
        };
        this.handleOnDelete = function (req, res) {
            return __awaiter(_this, void 0, void 0, function () {
                var renderer, err_2;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            _a.trys.push([0, 4,, 5]);
                            renderer = new renderer_1.default();
                            if (!!this.deployed) return [3 /*break*/, 1];
                            res.status(404).send({ error: "Config not found" });
                            return [3 /*break*/, 3];
                        case 1:
                            return [4 /*yield*/, renderer.dispatch([], this.deployed)];
                        case 2:
                            _a.sent();
                            res.send({});
                            _a.label = 3;
                        case 3:
                            return [3 /*break*/, 5];
                        case 4:
                            err_2 = _a.sent();
                            logger.severe(_h + " Failed with error " + err_2.message);
                            logger.severe(_h, err_2.stack);
                            res.status(500).send({ error: err_2.message, stack: err_2.stack });
                            return [3 /*break*/, 5];
                        case 5:
                            return [2 /*return*/];
                    }
                });
            });
        };
        this.WORKER_URI_PATH = "/shared/iapp/my-app/APIHandler";
        this.isPublic = true;
        this.isPassThrough = true;
        this.iapp = new controller_1.Controller(this);
        this.iapp.onGet("/", function (req, res) {
            res.send({ status: "OK!" });
        });
        this.iapp.onGet("/:name/pool/:poolName", function (req, res) {
            var _a = req.params,
                name = _a.name,
                poolName = _a.poolName;
            res.send({ status: "OK", name: name, poolName: poolName });
        });
        this.iapp.onPost("/", this.handleOnPost);
        this.iapp.onDelete("/", this.handleOnDelete);
    }
    ApiHandler.prototype.onStart = function (success, error) {
        try {
            logger.info(_h, "#");
            logger.info(_h, "### ApiHandler STARTED ###");
            logger.info(_h, "#");
            success();
        } catch (err) {
            logger.severe(_h, err.message);
            logger.severe(_h, "#");
            logger.severe(_h, "### ApiHandler FAILED ###");
            logger.severe(_h, "#");
            error();
        }
    };
    return ApiHandler;
}();
module.exports = ApiHandler;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var Controller = __webpack_require__(21);

// import Controller from './RestOperationHandler';

Controller.moduleName = '@iapp::controller';

module.exports = { Controller: Controller };

exports.default = { Controller: Controller };

exports.default = { Controller: Controller };

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var logger = __webpack_require__(1).getInstance(); // eslint-disable-line

var Request = __webpack_require__(24);
var Response = __webpack_require__(26);
var Handler = __webpack_require__(27);

var moduleName = '@iapp::controller';

var _h = '[' + moduleName + ']';

var isValidRestOperation = __webpack_require__(5).isValidRestOperation;

var HTTP_METHODS = {
  get: 'GET',
  post: 'POST',
  put: 'PUT',
  patch: 'PATCH',
  delete: 'DELETE'
};

var VERBS = {
  get: 'GET',
  post: 'POST',
  put: 'PUT',
  patch: 'PATCH',
  delete: 'DELETE',
  onGet: 'GET',
  onPost: 'POST',
  onPut: 'PUT',
  onPatch: 'PATCH',
  onDelete: 'DELETE',
  onRequest: 'ONREQUEST',
  onResponse: 'ONRESPONSE'
};

/**
 * A constructor creates a restOperationHandler application. Typically,
 * you can use it with following syntax
 *
 *  const iapp = new RestOperationHandler({WORKER_PATH});
 *
 * @class
 */

var RestOperationHandler = function () {
  function RestOperationHandler(worker, options) {
    var _this = this;

    _classCallCheck(this, RestOperationHandler);

    options = (typeof options === 'undefined' ? 'undefined' : _typeof(options)) === 'object' || {};
    this._baseUrl = worker.WORKER_URI_PATH || '';
    this.handlers = [];
    this._preRequestHandlers = [];
    this._postRequestHandlers = [];

    logger.info(_h + ' Controller instantiated on ' + this.baseUrl);
    // Registering shorthand methods for adding handlers (iapp.get(path, handler))
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      var _loop = function _loop() {
        var verb = _step.value;

        if (!_this[verb]) {
          _this[verb] = function (path, handler) {
            return _this._addHandler(VERBS[verb], path, handler);
          };
        }
      };

      for (var _iterator = Object.keys(VERBS)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        _loop();
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    if (worker && options.createHook !== false) {
      var hooks = ['onGet', 'onPost', 'onPut', 'onPatch', 'onDelete'];
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = hooks[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var h = _step2.value;
          worker[h] = function (restOperation) {
            return _this.handle(restOperation);
          };
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }

  _createClass(RestOperationHandler, [{
    key: 'all',
    value: function all(path, handler) {
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = Object.keys(HTTP_METHODS)[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var method = _step3.value;

          this[method](path, handler);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }

    /**
     * Add handler to pre-request handler stack. Note that syntax is different
     * from Express.js.
     *
     *  iapp.use(handler) => Will run iapp.onRequest('/*', handler)
     *  iapp.use('path', handler) => will run iapp.all(path, handler)
     *  iapp.use('path', method, handler) => will run as iapp.<method>(path, handler)
     *
     * @param {String|Function} [path] - or Handler
     * @param {String|Function} [method] - or Handler
     * @param {Function} handler
     * @returns {*}
     */

  }, {
    key: 'use',
    value: function use(path, method, handler) {
      if (typeof path === 'function') {
        handler = path;
        path = '/*';
        return this._addHandler(VERBS.onRequest, path, handler);
      }

      if (typeof method === 'function' || method.constructor.name === 'RestOperationHandler') {
        handler = method;
        return this.all(path, handler);
      }

      return this._addHandler(path, method, handler);
    }

    /**
     * Handles restOperation and walk through the handler stack
     * @param {RestOperation} restOperation
     * @param {RestOperationRequest} [req]
     * @param {RestOperationResponse} [res]
     * @returns {*}
     */

  }, {
    key: 'handle',
    value: function handle(restOperation, req, res) {
      var _this2 = this;

      var errMsg = void 0;
      if (!restOperation) errMsg = _h + '(handle) No restOperation is passed';
      if (!errMsg && !isValidRestOperation(restOperation)) {
        errMsg = _h + '(handle) Invalid restOperation is passed';
      }
      if (errMsg) {
        logger.severe(errMsg, restOperation);
        restOperation.statusCode = 500;
        restOperation.body = { error: errMsg };
        return this._handleOnResponse(restOperation);
      }

      var method = restOperation.method,
          path = restOperation.uri.path;

      return new Promise(function (resolve) {
        logger.info(_h + '(handle) ' + method + ' - ' + path + ': Start dispatching user request');
        req = req || new Request(restOperation);
        res = res || new Response(restOperation, _this2._handleOnResponse);
        return resolve();
      }).then(function () {
        return _this2._handleOnRequest(req, res);
      }).then(function () {
        var _iteratorNormalCompletion4 = true;
        var _didIteratorError4 = false;
        var _iteratorError4 = undefined;

        try {
          for (var _iterator4 = _this2.handlers[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
            var handler = _step4.value;

            if (handler.shouldDispatch(req, method, _this2.baseUrl)) {
              return handler.dispatch(req, res);
            }
          }
        } catch (err) {
          _didIteratorError4 = true;
          _iteratorError4 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion4 && _iterator4.return) {
              _iterator4.return();
            }
          } finally {
            if (_didIteratorError4) {
              throw _iteratorError4;
            }
          }
        }

        logger.info(_h + '(handle) ' + method + ' - ' + path + ': No handler matched. Handling post request');
        restOperation.statusCode = 404;
        return _this2._handleOnResponse(restOperation);
      }).catch(function (err) {
        var code = 500;
        var stack = err.stack;
        if (err.response) {
          code = err.response.status;
          stack = err.response.data;
        }

        var message = (err || {}).message || JSON.stringify(err);
        logger.severe(_h + '(handle) Error while processing. Responding ' + code + ' error:', message);
        restOperation.statusCode = code;
        restOperation.body = { code: '' + code, message: message, stack: stack };
        return _this2._handleOnResponse(restOperation);
      });
    }

    /**
     * @param {RestOperationRequest} req
     * @param {RestOperationResponse} res
     * @private
     */

  }, {
    key: '_handleOnRequest',
    value: function _handleOnRequest(req, res) {
      var _this3 = this;

      var idx = 0;

      // Do Something before send response;
      var method = req.method,
          path = req.uri.path;
      // const { method, body, uri: { path } } = req;

      logger.finest(_h + '(onRequest) Handling Request: ' + method + ' - ' + path + ' ');

      var next = function next(err) {
        while (idx < _this3._preRequestHandlers.length) {
          var task = _this3._preRequestHandlers[idx++].dispatch(req, res, next);
          if (typeof (task || {}).then === 'function') {
            return task.then(function () {
              return next();
            });
          }
        }
        return err;
      };
      return new next(); // eslint-disable-line new-cap
    }

    /**
     * A callback functions that response instance will call when send()
     * method is called from handler. This will provide a hook to invoke
     * some logic such that logging and response validation before
     * responding to clients.
     * @param {RestOperation} restOperation - Passed by response
     * @private
     */

  }, {
    key: '_handleOnResponse',
    value: function _handleOnResponse(restOperation) {
      var _this4 = this;

      // Do Something before send response;
      // const { method, statusCode, body, uri: { path } } = restOperation;

      // logger.finest(`${_h}(onResponse) ${method} - ${path} Sending Response: ` +
      //             `Status: ${statusCode}, Body: ${JSON.stringify(body, null, '  ')}`);

      return new Promise(function (resolve) {
        restOperation.complete();
        return resolve(_this4);
      });
    }

    /**
     * Add requestHandler to the handler stack.
     * @param {String} method - 'GET', 'POST', 'PUT', 'PATCH', 'DELETE'
     * @param {String} path - Path to match. Must start with /.
     * @param {RestOperationHandler~handler} handler
     * @private
     */

  }, {
    key: '_addHandler',
    value: function _addHandler(method, path, handler) {
      var methods = Object.keys(VERBS).map(function (i) {
        return i.toUpperCase();
      });
      if (!method || methods.indexOf(method.toUpperCase()) === -1) {
        logger.severe(_h + '(addHandler) Unsupported method type passed. Method: ' + method);
        logger.severe(_h + '(addHandler) Methods must be: [' + methods + ']');
        throw new TypeError('Method type must be a valid HTTP verb');
      }

      if (typeof path !== 'string') {
        if (method !== VERBS.onRequest || method !== VERBS.onResponse) {
          throw new TypeError('Path must be string');
        }
      }

      if (!path.match(/^\//)) {
        throw new TypeError('Path must be starting with /');
      }

      if (typeof handler !== 'function' && handler.constructor.name !== 'RestOperationHandler') {
        throw new TypeError('Handler must be a function or instance of RestOperationHandler');
      }

      var _handler = new Handler(method.toUpperCase(), this.baseUrl + path, handler);

      switch (method) {
        case VERBS.onRequest:
          {
            this._preRequestHandlers.push(_handler);break;
          }
        case VERBS.onResponse:
          {
            this._postRequestHandlers.push(_handler);break;
          }
        default:
          {
            this.handlers.push(_handler);
          }
      }

      logger.info(_h + '(addHandler) on' + method + ' : ' + path + ' for ' + ('"' + ((handler || {}).name || 'handler') + '"'));

      return this;
    }
  }, {
    key: 'baseUrl',
    set: function set(value) {
      this._baseUrl = value;
    },
    get: function get() {
      if (this.worker && !this._baseUrl) {
        this._baseUrl = this.worker.WORKER_URI_PATH;
      }
      return this._baseUrl;
    }
  }]);

  return RestOperationHandler;
}();

module.exports = RestOperationHandler;
exports.default = RestOperationHandler;

/**
 * @callback RestOperationHandler~handler
 * @param {RestOperation} restOperation
 * @param {Function} next
 */

/***/ }),
/* 22 */
/***/ (function(module, exports) {

module.exports = require("f5-logger");

/***/ }),
/* 23 */
/***/ (function(module, exports) {

module.exports = require("winston");

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var cloneDeep = __webpack_require__(4);
var logger = __webpack_require__(1).getInstance(); // eslint-disable-line
var isValidRestOperation = __webpack_require__(5).isValidRestOperation;

var moduleName = '@iapp::controller';

var _h = '[' + moduleName + '::request]';

/**
 * @typedef {Object} RestOperationRequest
 * @property {String|Null} id
 * @property {URI} uri
 * @property {Object} params - Params in path (/test/:id/:post => [{name: 'id': prefix:'/', ...}])
 * @property {String|Null} method
 * @property {*} body
 */

/**
 * @class
 * @param {RestOperation} restOperation
 * @param {Object} params
 * @returns {RestOperationRequest}
 */

var Request = function Request(restOperation, params) {
  _classCallCheck(this, Request);

  if (!isValidRestOperation(restOperation)) {
    var msg = _h + ' Invalid restOperation is passed';
    logger.severe(msg);
    throw new TypeError(msg);
  }
  if ((typeof params === 'undefined' ? 'undefined' : _typeof(params)) !== 'object') params = { unknown: params };
  this._restOperation = restOperation;
  this.uri = cloneDeep(restOperation.uri);
  this.params = cloneDeep(params);
  this.method = restOperation.method;
  this.body = cloneDeep(restOperation.body);
  this.id = restOperation.id;
};

module.exports = Request;

/***/ }),
/* 25 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var logger = __webpack_require__(1).getInstance(); // eslint-disable-line
var isValidRestOperation = __webpack_require__(5).isValidRestOperation;

var moduleName = '@iapp::controller';

var _h = '[' + moduleName + '::response]';

var STATUS_CODE = {
  ok: 200,
  accepted: 202,
  forbidden: 403,
  notFound: 404,
  conflict: 409,
  error: 500,
  notImplemented: 501,
  unavailable: 403
};

/**
 * @typedef {Object} RestOperationResponse
 * @property {*} referer - Referer in restOperation. You can overwrite
 * @property {*} contentType - ContentType in restOperation. You can overwrite
 * @property {*} responseBody - Reference to response body
 * @property {Function} body - Setter for response body.
 * @property {Function} status - Set status
 * @property {Function} send - Set body and send
 * @property {Function} accept - Shorthand to res.status(202).send(body);
 * @property {Function} error - Shorthand to res.status(500).send(body)
 * @property {Function} end - Shorthand to res.send(body)
 * @property {*} body
 */

var Response = function () {
  function Response(restOperation, callback) {
    _classCallCheck(this, Response);

    if (!isValidRestOperation(restOperation)) {
      var msg = _h + ' Invalid restOperation is passed';
      logger.severe(msg);
      throw new TypeError(msg);
    }
    this._restOperation = restOperation;
    this.callback = callback;
    this.statusCode = this._restOperation.statusCode || STATUS_CODE.ok;
    this.contentType = this._restOperation.contentType;
    this.referer = this._restOperation.uri.href;
    this.responseBody = {};
  }

  _createClass(Response, [{
    key: 'accept',
    value: function accept(body) {
      return this.status(STATUS_CODE.accepted).send(body);
    }
  }, {
    key: 'error',
    value: function error(body) {
      return this.status(STATUS_CODE.error).send(body);
    }
  }, {
    key: 'end',
    value: function end() {
      this.send(this.responseBody || {});
    }
  }, {
    key: 'send',
    value: function send(body) {
      this.sent = true;
      if (body) this.responseBody = body;
      this._restOperation.body = this.responseBody;
      this._restOperation.statusCode = this.statusCode;
      this._restOperation.referer = this.referer;
      return this.callback(this._restOperation);
    }
  }, {
    key: 'status',
    value: function status(_status) {
      this.statusCode = _status;
      return this;
    }
  }, {
    key: 'body',
    value: function body(_body) {
      this.responseBody = _body;
      return this;
    }
  }]);

  return Response;
}();

module.exports = Response;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var logger = __webpack_require__(1).getInstance(); // eslint-disable-line
var pathToRegexp = __webpack_require__(28);
var url = __webpack_require__(6);

var moduleName = '@iapp::controller';

var _h = '[' + moduleName + '::handler]';

var isValidHandler = function isValidHandler(handler) {
  return handler && (typeof handler === 'function' || handler.constructor.name === 'RestOperationHandler');
};

/**
 * Constructor to wrap handler passed by user. It adds methods incorporate
 * with RestOperationHandler.
 * @class
 * @param {String} path
 * @param {Handler~handlerCallback} handler
 * @property {String} path
 * @property {String} method
 * @property {Function} handler
 */

var Handler = function () {
  function Handler(method, path, handler) {
    _classCallCheck(this, Handler);

    this.path = path.trim();
    this.method = method;
    this.keys = [];
    this.params = {};
    this.re = pathToRegexp(this.path, this.keys);
    if (this.path) this.re.exec(this.path);
    if (isValidHandler(handler)) this.handler = handler;
  }

  _createClass(Handler, [{
    key: 'shouldDispatch',
    value: function shouldDispatch(req, method, baseUrl) {
      var pathname = req.uri.pathname;
      if (method.toUpperCase() !== this.method.toUpperCase()) return false;
      if (this.handler.constructor.name === 'RestOperationHandler') {
        if (baseUrl) {
          var _path = pathname.replace(baseUrl, '');
          if (_path === '' || _path === '/') return false;
        }
        return pathname === this.path || this.path.startsWith(pathname) || !!this.re.exec(pathname);
      }
      return pathname === this.path || !!this.re.exec(pathname);
    }

    /**
     * Dispatch and hand context over to a handler function.
     * @param {RestOperationRequest} req
     * @param {RestOperationResponse} res
     * @param {Function} next - callBack for RestOperationHandler
     * @returns {Handler~handlerCallback}
     */

  }, {
    key: 'dispatch',
    value: function dispatch(req, res, next) {
      var _f = _h + '(dispatch)';
      if (!this.handler) throw new Error('Handler is not registered');
      req.params = this._pathToParams(req.uri.pathname);
      logger.info(_f + ' Dispatching <' + (this.handler.name || 'anonymousHandler') + '>: ' + ('method:[' + req.method + '] path: [' + req.uri.pathname + '] ') + ('params: ' + JSON.stringify(this.params)));
      // Try to remove parents' base path before delegating down to sub modules.
      // ToDo: Shall be simplified (Shun)
      if (this.handler.constructor.name === 'RestOperationHandler') {
        logger.info(_f + ' Delegating request to another handler name=' + (this.handler.name || 'anonymous'));
        var pathToRemove = this.path.replace(/\/\*$/, '');
        var newPath = req.uri.path.replace(pathToRemove, '');
        req.uri = url.parse(newPath.startsWith('/') ? newPath : '/' + newPath, true);
        return this.handler.handle(req._restOperation, req, res);
      }
      var task = this.handler(req, res, next);
      if (typeof (task || {}).then === 'function') {
        return typeof next === 'function' ? task.then(function () {
          return next();
        }) : task;
      }
      return undefined;
    }

    /**
     * Extract params from URI body. If you have path string of /:id/:post,
     * then it will return an object with parameter names as keys.
     * @param path
     * @returns {Object}
     * @private
     */

  }, {
    key: '_pathToParams',
    value: function _pathToParams(path) {
      this.params = {};
      var params = this.re.exec(path);
      if (!params) return this.params;
      var pathname = params.shift();
      for (var i = 0; i < params.length; i++) {
        this.params[this.keys[i].name] = params[i];
      }
      if (params.length) {
        logger.finest(_h + '(pathToParams) Params found in URI body: ' + (pathname + ' => ' + this.path + ', params: ' + JSON.stringify(params, null, '  ')));
      }
      return this.params;
    }
  }]);

  return Handler;
}();

module.exports = Handler;

/**
 * @callback Handler~handlerCallback
 * @param {Object} req
 * @param {Object} res
 * @returns {Promise}
 */

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

var isarray = __webpack_require__(29)

/**
 * Expose `pathToRegexp`.
 */
module.exports = pathToRegexp
module.exports.parse = parse
module.exports.compile = compile
module.exports.tokensToFunction = tokensToFunction
module.exports.tokensToRegExp = tokensToRegExp

/**
 * The main path matching regexp utility.
 *
 * @type {RegExp}
 */
var PATH_REGEXP = new RegExp([
  // Match escaped characters that would otherwise appear in future matches.
  // This allows the user to escape special characters that won't transform.
  '(\\\\.)',
  // Match Express-style parameters and un-named parameters with a prefix
  // and optional suffixes. Matches appear as:
  //
  // "/:test(\\d+)?" => ["/", "test", "\d+", undefined, "?", undefined]
  // "/route(\\d+)"  => [undefined, undefined, undefined, "\d+", undefined, undefined]
  // "/*"            => ["/", undefined, undefined, undefined, undefined, "*"]
  '([\\/.])?(?:(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?|(\\*))'
].join('|'), 'g')

/**
 * Parse a string for the raw tokens.
 *
 * @param  {string}  str
 * @param  {Object=} options
 * @return {!Array}
 */
function parse (str, options) {
  var tokens = []
  var key = 0
  var index = 0
  var path = ''
  var defaultDelimiter = options && options.delimiter || '/'
  var res

  while ((res = PATH_REGEXP.exec(str)) != null) {
    var m = res[0]
    var escaped = res[1]
    var offset = res.index
    path += str.slice(index, offset)
    index = offset + m.length

    // Ignore already escaped sequences.
    if (escaped) {
      path += escaped[1]
      continue
    }

    var next = str[index]
    var prefix = res[2]
    var name = res[3]
    var capture = res[4]
    var group = res[5]
    var modifier = res[6]
    var asterisk = res[7]

    // Push the current path onto the tokens.
    if (path) {
      tokens.push(path)
      path = ''
    }

    var partial = prefix != null && next != null && next !== prefix
    var repeat = modifier === '+' || modifier === '*'
    var optional = modifier === '?' || modifier === '*'
    var delimiter = res[2] || defaultDelimiter
    var pattern = capture || group

    tokens.push({
      name: name || key++,
      prefix: prefix || '',
      delimiter: delimiter,
      optional: optional,
      repeat: repeat,
      partial: partial,
      asterisk: !!asterisk,
      pattern: pattern ? escapeGroup(pattern) : (asterisk ? '.*' : '[^' + escapeString(delimiter) + ']+?')
    })
  }

  // Match any characters still remaining.
  if (index < str.length) {
    path += str.substr(index)
  }

  // If the path exists, push it onto the end.
  if (path) {
    tokens.push(path)
  }

  return tokens
}

/**
 * Compile a string to a template function for the path.
 *
 * @param  {string}             str
 * @param  {Object=}            options
 * @return {!function(Object=, Object=)}
 */
function compile (str, options) {
  return tokensToFunction(parse(str, options))
}

/**
 * Prettier encoding of URI path segments.
 *
 * @param  {string}
 * @return {string}
 */
function encodeURIComponentPretty (str) {
  return encodeURI(str).replace(/[\/?#]/g, function (c) {
    return '%' + c.charCodeAt(0).toString(16).toUpperCase()
  })
}

/**
 * Encode the asterisk parameter. Similar to `pretty`, but allows slashes.
 *
 * @param  {string}
 * @return {string}
 */
function encodeAsterisk (str) {
  return encodeURI(str).replace(/[?#]/g, function (c) {
    return '%' + c.charCodeAt(0).toString(16).toUpperCase()
  })
}

/**
 * Expose a method for transforming tokens into the path function.
 */
function tokensToFunction (tokens) {
  // Compile all the tokens into regexps.
  var matches = new Array(tokens.length)

  // Compile all the patterns before compilation.
  for (var i = 0; i < tokens.length; i++) {
    if (typeof tokens[i] === 'object') {
      matches[i] = new RegExp('^(?:' + tokens[i].pattern + ')$')
    }
  }

  return function (obj, opts) {
    var path = ''
    var data = obj || {}
    var options = opts || {}
    var encode = options.pretty ? encodeURIComponentPretty : encodeURIComponent

    for (var i = 0; i < tokens.length; i++) {
      var token = tokens[i]

      if (typeof token === 'string') {
        path += token

        continue
      }

      var value = data[token.name]
      var segment

      if (value == null) {
        if (token.optional) {
          // Prepend partial segment prefixes.
          if (token.partial) {
            path += token.prefix
          }

          continue
        } else {
          throw new TypeError('Expected "' + token.name + '" to be defined')
        }
      }

      if (isarray(value)) {
        if (!token.repeat) {
          throw new TypeError('Expected "' + token.name + '" to not repeat, but received `' + JSON.stringify(value) + '`')
        }

        if (value.length === 0) {
          if (token.optional) {
            continue
          } else {
            throw new TypeError('Expected "' + token.name + '" to not be empty')
          }
        }

        for (var j = 0; j < value.length; j++) {
          segment = encode(value[j])

          if (!matches[i].test(segment)) {
            throw new TypeError('Expected all "' + token.name + '" to match "' + token.pattern + '", but received `' + JSON.stringify(segment) + '`')
          }

          path += (j === 0 ? token.prefix : token.delimiter) + segment
        }

        continue
      }

      segment = token.asterisk ? encodeAsterisk(value) : encode(value)

      if (!matches[i].test(segment)) {
        throw new TypeError('Expected "' + token.name + '" to match "' + token.pattern + '", but received "' + segment + '"')
      }

      path += token.prefix + segment
    }

    return path
  }
}

/**
 * Escape a regular expression string.
 *
 * @param  {string} str
 * @return {string}
 */
function escapeString (str) {
  return str.replace(/([.+*?=^!:${}()[\]|\/\\])/g, '\\$1')
}

/**
 * Escape the capturing group by escaping special characters and meaning.
 *
 * @param  {string} group
 * @return {string}
 */
function escapeGroup (group) {
  return group.replace(/([=!:$\/()])/g, '\\$1')
}

/**
 * Attach the keys as a property of the regexp.
 *
 * @param  {!RegExp} re
 * @param  {Array}   keys
 * @return {!RegExp}
 */
function attachKeys (re, keys) {
  re.keys = keys
  return re
}

/**
 * Get the flags for a regexp from the options.
 *
 * @param  {Object} options
 * @return {string}
 */
function flags (options) {
  return options.sensitive ? '' : 'i'
}

/**
 * Pull out keys from a regexp.
 *
 * @param  {!RegExp} path
 * @param  {!Array}  keys
 * @return {!RegExp}
 */
function regexpToRegexp (path, keys) {
  // Use a negative lookahead to match only capturing groups.
  var groups = path.source.match(/\((?!\?)/g)

  if (groups) {
    for (var i = 0; i < groups.length; i++) {
      keys.push({
        name: i,
        prefix: null,
        delimiter: null,
        optional: false,
        repeat: false,
        partial: false,
        asterisk: false,
        pattern: null
      })
    }
  }

  return attachKeys(path, keys)
}

/**
 * Transform an array into a regexp.
 *
 * @param  {!Array}  path
 * @param  {Array}   keys
 * @param  {!Object} options
 * @return {!RegExp}
 */
function arrayToRegexp (path, keys, options) {
  var parts = []

  for (var i = 0; i < path.length; i++) {
    parts.push(pathToRegexp(path[i], keys, options).source)
  }

  var regexp = new RegExp('(?:' + parts.join('|') + ')', flags(options))

  return attachKeys(regexp, keys)
}

/**
 * Create a path regexp from string input.
 *
 * @param  {string}  path
 * @param  {!Array}  keys
 * @param  {!Object} options
 * @return {!RegExp}
 */
function stringToRegexp (path, keys, options) {
  return tokensToRegExp(parse(path, options), keys, options)
}

/**
 * Expose a function for taking tokens and returning a RegExp.
 *
 * @param  {!Array}          tokens
 * @param  {(Array|Object)=} keys
 * @param  {Object=}         options
 * @return {!RegExp}
 */
function tokensToRegExp (tokens, keys, options) {
  if (!isarray(keys)) {
    options = /** @type {!Object} */ (keys || options)
    keys = []
  }

  options = options || {}

  var strict = options.strict
  var end = options.end !== false
  var route = ''

  // Iterate over the tokens and create our regexp string.
  for (var i = 0; i < tokens.length; i++) {
    var token = tokens[i]

    if (typeof token === 'string') {
      route += escapeString(token)
    } else {
      var prefix = escapeString(token.prefix)
      var capture = '(?:' + token.pattern + ')'

      keys.push(token)

      if (token.repeat) {
        capture += '(?:' + prefix + capture + ')*'
      }

      if (token.optional) {
        if (!token.partial) {
          capture = '(?:' + prefix + '(' + capture + '))?'
        } else {
          capture = prefix + '(' + capture + ')?'
        }
      } else {
        capture = prefix + '(' + capture + ')'
      }

      route += capture
    }
  }

  var delimiter = escapeString(options.delimiter || '/')
  var endsWithDelimiter = route.slice(-delimiter.length) === delimiter

  // In non-strict mode we allow a slash at the end of match. If the path to
  // match already ends with a slash, we remove it for consistency. The slash
  // is valid at the end of a path match, not in the middle. This is important
  // in non-ending mode, where "/test/" shouldn't match "/test//route".
  if (!strict) {
    route = (endsWithDelimiter ? route.slice(0, -delimiter.length) : route) + '(?:' + delimiter + '(?=$))?'
  }

  if (end) {
    route += '$'
  } else {
    // In non-ending mode, we need the capturing groups to match as much as
    // possible by using a positive lookahead to the end or next path segment.
    route += strict && endsWithDelimiter ? '' : '(?=' + delimiter + '|$)'
  }

  return attachKeys(new RegExp('^' + route, flags(options)), keys)
}

/**
 * Normalize the given path string, returning a regular expression.
 *
 * An empty array can be passed in for the keys, which will hold the
 * placeholder key descriptions. For example, using `/user/:id`, `keys` will
 * contain `[{ name: 'id', delimiter: '/', optional: false, repeat: false }]`.
 *
 * @param  {(string|RegExp|Array)} path
 * @param  {(Array|Object)=}       keys
 * @param  {Object=}               options
 * @return {!RegExp}
 */
function pathToRegexp (path, keys, options) {
  if (!isarray(keys)) {
    options = /** @type {!Object} */ (keys || options)
    keys = []
  }

  options = options || {}

  if (path instanceof RegExp) {
    return regexpToRegexp(path, /** @type {!Array} */ (keys))
  }

  if (isarray(path)) {
    return arrayToRegexp(/** @type {!Array} */ (path), /** @type {!Array} */ (keys), options)
  }

  return stringToRegexp(/** @type {string} */ (path), /** @type {!Array} */ (keys), options)
}


/***/ }),
/* 29 */
/***/ (function(module, exports) {

module.exports = Array.isArray || function (arr) {
  return Object.prototype.toString.call(arr) == '[object Array]';
};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = __webpack_require__(1);
var index_1 = __webpack_require__(2);
var Instruction_1 = __webpack_require__(31);
var RequestHandler_1 = __webpack_require__(3);
var logger = logger_1.default.getInstance();
var _h = "[" + index_1.moduleName + "::renderer]";
var Renderer = (function () {
    function Renderer(configState, existingConfigHint, options) {
        if (configState === void 0) { configState = []; }
        if (existingConfigHint === void 0) { existingConfigHint = []; }
        if (options === void 0) { options = {}; }
        if (!configState) {
            configState = [];
        }
        else if (!Array.isArray(configState)) {
            configState = [configState];
        }
        this.desiredConfigState = [];
        for (var _i = 0, configState_1 = configState; _i < configState_1.length; _i++) {
            var c = configState_1[_i];
            if (typeof c === "string") {
                this.desiredConfigState.push(new Instruction_1.default(c));
            }
            else {
                this.desiredConfigState.push(c);
            }
        }
        if (typeof existingConfigHint === "object" &&
            !Array.isArray(existingConfigHint)) {
            options = existingConfigHint;
            existingConfigHint = [];
        }
        else if (!existingConfigHint ||
            typeof existingConfigHint === "string") {
            existingConfigHint = [existingConfigHint].filter(function (i) { return i; });
        }
        this.existingConfigHint = existingConfigHint;
        this._options = options;
        if (options.requestHandler &&
            options.requestHandler.constructor.name === "IcrRequestHandler") {
            this.requestHandler = options.requestHandler;
        }
        else {
            this.requestHandler = new RequestHandler_1.default({
                debug: this.debug,
            });
        }
        this.icrClient = this.requestHandler;
    }
    Renderer.create = function (options) {
        return new Renderer(void 0, void 0, options);
    };
    // public static createInstruction(type: "present"|"absent", props: BaseIcrObject|SelfLink): Instruction {
    //     //
    // }
    /**
     * A method to fetch config object from the system
     * @param selfLink - full selfLink string starts with http://localhost/
     */
    Renderer.fetch = function (selfLink) {
        return new Instruction_1.default(selfLink).fetch();
    };
    Renderer.fetchAll = function (selfLinks) {
        return new Renderer(selfLinks).fetchAll();
    };
    Renderer.dispatch = function (configState, existingConfigHint, options) {
        if (existingConfigHint === void 0) { existingConfigHint = []; }
        if (options === void 0) { options = {}; }
        return new Renderer(configState, existingConfigHint, options).dispatch();
    };
    Object.defineProperty(Renderer.prototype, "selfLinks", {
        get: function () {
            return (this.deployed || [])
                .map(function (i) { return (i || {}).selfLink; })
                .filter(function (i) { return i; });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Renderer.prototype, "debug", {
        get: function () { return !!this._options.debug; },
        set: function (value) {
            if (!this._options) {
                this._options = {};
            }
            this._options.debug = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Renderer.prototype, "updateMethod", {
        get: function () {
            return this._options.updateMethod;
        },
        set: function (value) {
            if (!this._options) {
                this._options = {};
            }
            this._options.updateMethod = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Renderer.prototype, "instructionSet", {
        get: function () {
            var d = this.desiredConfigState || [];
            var h = this.existingConfigHint || [];
            return this.composeInstructionSet(d, h, false);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * If selfLink is passed, assumes intent is to stat
     */
    Renderer.prototype.add = function (instruction, options) {
        if ((typeof instruction === "object" || typeof instruction === "string") &&
            instruction.constructor.name !== "Instruction") {
            options = options ? __assign({}, options) : { debug: this.debug };
            if (!options.requestHandler) {
                options.requestHandler = this.requestHandler;
            }
            if (this.updateMethod && options) {
                options.updateMethod = this.updateMethod;
            }
            instruction = new Instruction_1.default(instruction, options);
        }
        this.desiredConfigState.push(instruction);
        return instruction;
    };
    Renderer.prototype.remove = function (instruction) {
        var dCS = this.desiredConfigState.filter(function (i) { return i !== instruction; });
        var found = dCS.length !== this.desiredConfigState.length;
        this.desiredConfigState = dCS;
        return found;
    };
    Renderer.prototype.empty = function () {
        this.desiredConfigState = [];
        this.existingConfigHint = [];
        return this;
    };
    Renderer.prototype.fetchAll = function () {
        return __awaiter(this, void 0, void 0, function () {
            var results, _i, _a, instruction, res;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        results = [];
                        _i = 0, _a = this.desiredConfigState;
                        _b.label = 1;
                    case 1:
                        if (!(_i < _a.length)) return [3 /*break*/, 4];
                        instruction = _a[_i];
                        return [4 /*yield*/, instruction.fetch()];
                    case 2:
                        res = _b.sent();
                        results.push(res.data);
                        _b.label = 3;
                    case 3:
                        _i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/, results];
                }
            });
        });
    };
    Renderer.prototype.dispatch = function (desiredConfigState, existingConfigHint) {
        if (desiredConfigState === void 0) { desiredConfigState = this.desiredConfigState; }
        if (existingConfigHint === void 0) { existingConfigHint = this.existingConfigHint; }
        return __awaiter(this, void 0, void 0, function () {
            var results, set, instructionSet, transId, err_1, _f, _i, instructionSet_1, instruction, _a, err_2, _b, msg, _c, instructionSet_2, instruction;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        logger.info(_h + "(dispatch) Dispatching configuration operations.", "desiredConfigState=" + desiredConfigState.length, "existingConfigHint=" + existingConfigHint.length);
                        this.desiredConfigState = desiredConfigState;
                        this.existingConfigHint = existingConfigHint;
                        results = [];
                        set = this.composeInstructionSet();
                        instructionSet = set.delete.concat(set.stat, set.add, set.modify);
                        if (!existingConfigHint.length && !desiredConfigState.length) {
                            return [2 /*return*/, this];
                        }
                        if (!instructionSet.length) {
                            return [2 /*return*/, this];
                        }
                        transId = 0;
                        _d.label = 1;
                    case 1:
                        _d.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.requestHandler.createTransaction()];
                    case 2:
                        transId = _d.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        err_1 = _d.sent();
                        logger.severe(_h + "(dispatch) Failed to create transaction. Aborting.", "Reason=\"" + err_1.message + "\"");
                        throw (err_1);
                    case 4:
                        _f = _h + "(dispatch)(transId=" + transId + ")";
                        logger.info(_f + " Transaction created. Dispatching instructions", "C=" + set.add.length + ", U=" + set.modify.length + " D=" + set.delete.length);
                        logger.info(_f + " Sending instruction to the transaction.");
                        this.requested = [];
                        this.deployed = [];
                        _d.label = 5;
                    case 5:
                        _d.trys.push([5, 11, , 13]);
                        _i = 0, instructionSet_1 = instructionSet;
                        _d.label = 6;
                    case 6:
                        if (!(_i < instructionSet_1.length)) return [3 /*break*/, 9];
                        instruction = instructionSet_1[_i];
                        return [4 /*yield*/, instruction.dispatch(transId)];
                    case 7:
                        _d.sent();
                        if (!instruction.response) {
                            return [3 /*break*/, 8];
                        }
                        this.requested.push(__assign({}, instruction.response.data));
                        _d.label = 8;
                    case 8:
                        _i++;
                        return [3 /*break*/, 6];
                    case 9:
                        logger.info(_f + " Committing transaction");
                        // Non 200 response will be resulted in throwing exception but error state
                        // shall still be captured.
                        _a = this;
                        return [4 /*yield*/, this.requestHandler.commitTransaction(transId)];
                    case 10:
                        // Non 200 response will be resulted in throwing exception but error state
                        // shall still be captured.
                        _a.transactionResult = _d.sent();
                        return [3 /*break*/, 13];
                    case 11:
                        err_2 = _d.sent();
                        logger.severe(_f + " Dispatch failed. Reverting the transaction.", "desiredConfigState=" + desiredConfigState.length, "existingConfigHint=" + existingConfigHint.length);
                        _b = this;
                        return [4 /*yield*/, this.requestHandler.cancelTransaction(transId)];
                    case 12:
                        _b.transactionResult = _d.sent();
                        msg = "Transaction canceled. Dispatch is failed with error (error=" + ((err_2 || {}).message || err_2) + ")";
                        logger.severe(_f + " " + msg);
                        err_2.message = msg;
                        throw (err_2);
                    case 13:
                        logger.info(_f + " Checking deployed configuration.");
                        _c = 0, instructionSet_2 = instructionSet;
                        _d.label = 14;
                    case 14:
                        if (!(_c < instructionSet_2.length)) return [3 /*break*/, 17];
                        instruction = instructionSet_2[_c];
                        return [4 /*yield*/, instruction.fetch()];
                    case 15:
                        _d.sent();
                        if (!instruction.deployed) {
                            return [3 /*break*/, 16];
                        }
                        this.deployed.push(__assign({}, instruction.deployed));
                        _d.label = 16;
                    case 16:
                        _c++;
                        return [3 /*break*/, 14];
                    case 17:
                        logger.info(_f + " Done!");
                        return [2 /*return*/, this];
                }
            });
        });
    };
    Renderer.prototype.composeInstructionSet = function (desiredConfigState, existingConfigHint, emitLog) {
        if (desiredConfigState === void 0) { desiredConfigState = this.desiredConfigState; }
        if (existingConfigHint === void 0) { existingConfigHint = this.existingConfigHint; }
        if (emitLog === void 0) { emitLog = true; }
        var _f = _h + "(composeInstructionSet)";
        var set = { add: [], modify: [], delete: [], stat: [] };
        if (this.debug && emitLog) {
            logger.finest(_f + " Generating configuration instructions from:", JSON.stringify(desiredConfigState, null, "  "), JSON.stringify(existingConfigHint, null, "  "));
        }
        var selfLinks = desiredConfigState.map(function (i) { return i.selfLink; });
        for (var _i = 0, existingConfigHint_1 = existingConfigHint; _i < existingConfigHint_1.length; _i++) {
            var hint = existingConfigHint_1[_i];
            if (selfLinks.indexOf(hint) !== -1) {
                continue;
            }
            var i = new Instruction_1.default(hint, { intent: "absent", requestHandler: this.requestHandler });
            if (emitLog) {
                logger.finest(_f + " Added a remove operation", "I=" + i.intent + ", P=" + i.fullPath + ",", "sNF=" + (i.skipDeleteIfNotFound ? "y" : "n"));
            }
            set.delete.push(i);
        }
        for (var _a = 0, desiredConfigState_1 = desiredConfigState; _a < desiredConfigState_1.length; _a++) {
            var i = desiredConfigState_1[_a];
            var c = "create";
            if (i.intent === "stat") {
                set.stat.push(i);
            }
            else if (i.intent === "absent") {
                set.delete.push(i);
            }
            else if (existingConfigHint.indexOf(i.selfLink) === -1) {
                set.add.push(i);
            }
            else {
                c = "modify";
                set.modify.push(i);
            }
            var prop = this.debug ?
                JSON.stringify(i.props).substr(0, 128) + "...}..." :
                "" + JSON.stringify(i.props, null, "  ");
            if (emitLog) {
                logger.finest(_f + " Added a " + c + " operation to the set.", "I=" + i.intent + ", P=" + i.fullPath + ", U=" + i.updateMethod + " D=" + prop);
            }
        }
        return set;
    };
    return Renderer;
}());
exports.Renderer = Renderer;
exports.default = Renderer;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = __webpack_require__(1);
var events_1 = __webpack_require__(32);
var cloneDeep = __webpack_require__(4);
var index_1 = __webpack_require__(2);
var RequestHandler_1 = __webpack_require__(3);
var SelfLinkFactory_1 = __webpack_require__(64);
var logger = logger_1.default.getInstance();
var _h = "[" + index_1.moduleName + "::instruction]";
exports.METHOD = {
    create: "post",
    destroy: "delete",
    fetch: "get",
    merge: "patch",
    modify: "patch",
    update: "put",
};
var defaultOptions = {
    debug: false,
    intent: "present",
    updateMethod: "put",
    skipDeleteIfNotFound: true,
};
var Instruction = (function () {
    function Instruction(instruction, options) {
        if (options === void 0) { options = defaultOptions; }
        this.debug = !!options.debug;
        this._deployed = void 0;
        this._present = void 0;
        this._fetched = false;
        this._basePath = options.basePath;
        this.error = void 0;
        this.intent = options.intent || "present";
        this.updateMethod = options.updateMethod || "put";
        this.skipDeleteIfNotFound =
            typeof options.skipDeleteIfNotFound === "boolean" ? options.skipDeleteIfNotFound : true;
        if (typeof instruction !== "string" && typeof instruction !== "object") {
            var msg = "Instruction must be string or object. (type=" + typeof instruction + ")";
            logger.severe(_h + "(constructor)", msg);
            throw new TypeError(msg);
        }
        else if (typeof instruction === "string") {
            if (SelfLinkFactory_1.default.isValidSelfLink(instruction)) {
                this._selfLink = SelfLinkFactory_1.default.fromSelfLink(instruction);
                var _a = this._selfLink, kind = _a.kind, name = _a.name;
                this._props = { selfLink: instruction, kind: kind, name: name };
                if (!options || !options.intent) {
                    this.intent = "stat";
                }
            }
            else {
                var msg = "Instruction must be a valid SelfLInk. (value=" + instruction + ")";
                logger.severe(_h + "(constructor)", msg);
                throw new TypeError(msg);
            }
        }
        else if (typeof instruction === "object") {
            if (SelfLinkFactory_1.default.isValidProps(instruction)) {
                this._props = instruction;
                this._selfLink = (instruction.selfLink) ?
                    this._selfLink = SelfLinkFactory_1.default.fromSelfLink(instruction.selfLink) :
                    this._selfLink = new SelfLinkFactory_1.default(instruction, options.basePath);
            }
        }
        if (options.requestHandler && options.requestHandler.constructor.name === "IcrRequestHandler") {
            this.requestHandler = options.requestHandler;
        }
        else {
            this.requestHandler = new RequestHandler_1.default();
        }
        if (options.event && options.event.constructor.name === "EventEmitter") {
            this.event = options.event;
        }
        else {
            this.event = new events_1.EventEmitter();
        }
    }
    Object.defineProperty(Instruction.prototype, "basePath", {
        get: function () { return this._selfLink.basePath; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "fullPath", {
        get: function () { return this._selfLink.fullPath; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "selfLink", {
        get: function () { return this._selfLink.selfLink; },
        set: function (selfLink) {
            this._selfLink = SelfLinkFactory_1.default.fromSelfLink(selfLink);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "present", {
        get: function () { return this._present; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "fetched", {
        get: function () { return this._fetched; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "generation", {
        get: function () { return (this.deployed || {}).generation; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "deployed", {
        get: function () { return this._deployed; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Instruction.prototype, "props", {
        get: function () { return this._props; },
        set: function (newProps) {
            if (SelfLinkFactory_1.default.isValidProps(newProps, this._basePath, true)) {
                this._props = newProps;
                this._selfLink = new SelfLinkFactory_1.default(newProps);
            }
            else {
                var msg = _h + "(setProps) Error. Invalid Prop is passed.";
                logger.severe(msg);
                if (this.debug) {
                    logger.finest(_h + "(setProps) Original Props=", JSON.stringify(newProps, null, "  "));
                }
                throw new TypeError(msg);
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @description
     * Try to stat target object by sending GET request.
     */
    Instruction.prototype.fetch = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _f, res, props, err_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _f = _h + "(fetch)";
                        logger.info(_f + " Fetching object from uri=" + this.fullPath);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.requestHandler.get(this.fullPath)];
                    case 2:
                        res = _a.sent();
                        props = res.data;
                        this.response = res;
                        this._present = true;
                        this._fetched = true;
                        this.error = void 0;
                        this._deployed = props;
                        logger.info(_f + " Object found. (uri=" + this.fullPath + ",", "present=" + !!this.present + ", fetched=" + !!this._fetched + ",", "generation=" + (typeof this.generation === "number" ? this.generation : "none") + ")");
                        this.event.emit("statComplete", this);
                        return [2 /*return*/, res];
                    case 3:
                        err_1 = _a.sent();
                        if (((err_1 || {}).response || {}).status === 404) {
                            this._present = false;
                            this._fetched = true;
                            this.error = void 0;
                            this.response = err_1.response;
                            this._deployed = ((err_1 || {}).response || {}).data;
                            logger.info(_f + " Object not found. (uri=" + this.fullPath + ",", "present=" + !!this._present + ", fetched=" + !!this._fetched + ",", "generation=" + (typeof this.generation === "number" ? this.generation : "none") + ")");
                            this.event.emit("statComplete", this);
                            return [2 /*return*/, (this.response ? this.response : err_1)];
                        }
                        else {
                            this._present = false;
                            this._fetched = true;
                            this.error = err_1;
                            logger.severe(_f + " Fetch failed with error. (uri=" + this.fullPath + ",", "present=" + !!this._present + ", fetched=" + !!this._fetched + ",", "generation=" + (typeof this.generation === "number" ? this.generation : "none"), "message=" + err_1.message + ")");
                            this.event.emit("statFailure", err_1);
                            throw err_1;
                        }
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * @description
     * Dispatches instruction. If you are using transaction. You have to manually commit
     * transaction.
     */
    Instruction.prototype.dispatch = function (transId, options) {
        if (options === void 0) { options = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var intent, updateMethod, skipDeleteIfNotFound, _f, err_2, debug, config, method, apiPath, props, msg, msg, res, _a, err_3;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        intent = options.intent || this.intent || "present";
                        updateMethod = options.updateMethod || this.updateMethod;
                        skipDeleteIfNotFound = (typeof options.skipDeleteIfNotFound === "boolean") ?
                            options.skipDeleteIfNotFound : this.skipDeleteIfNotFound;
                        _f = _h + "(dispatch)(transId=" + (transId ? transId : "none") + ",i=" + intent + "," +
                            ("u=" + updateMethod + ",sDNF=" + (skipDeleteIfNotFound ? "y" : "n") + ")");
                        if (!(intent === "stat")) return [3 /*break*/, 2];
                        logger.info(_f + " Fetch target object (uri=" + this.fullPath + ")");
                        return [4 /*yield*/, this.fetch()];
                    case 1:
                        _b.sent();
                        return [2 /*return*/, this];
                    case 2:
                        if (!(!this.fetched && !this.error)) return [3 /*break*/, 6];
                        logger.info(_f + " Fetch target object before determine request methods. (uri=" + this.fullPath + ")");
                        _b.label = 3;
                    case 3:
                        _b.trys.push([3, 5, , 6]);
                        return [4 /*yield*/, this.fetch()];
                    case 4:
                        _b.sent();
                        return [3 /*break*/, 6];
                    case 5:
                        err_2 = _b.sent();
                        logger.severe(_f + " Failed to stat object. (error=" + err_2.message + ")");
                        throw err_2;
                    case 6:
                        debug = (typeof options.debug === "boolean") ? options.debug : this.debug;
                        config = { transId: transId, debug: debug };
                        method = intent === "absent" ? "delete" : "post";
                        apiPath = this.basePath;
                        props = this.props;
                        try {
                            if (intent === "present") {
                                if (this.present) {
                                    if (method === "never") {
                                        logger.info(_f + " Target object already exists. Skipping.");
                                        return [2 /*return*/, this];
                                    }
                                    method = updateMethod.toLocaleLowerCase();
                                    apiPath = this.fullPath;
                                    if (method === "patch") {
                                        props = this._deployed || {};
                                        Object.assign(props, this.props);
                                    }
                                }
                            }
                            else if (intent === "absent") {
                                if (this.fetched && !this._present && skipDeleteIfNotFound) {
                                    // If target object that is to be deleted is not found resolve immediately.
                                    logger.info(_f + " Skipping delete operation as the target object is not found. (uri=" + this.fullPath + ")");
                                    return [2 /*return*/, this];
                                }
                                apiPath = this.fullPath;
                            }
                            else {
                                msg = "Operation failed. Unknown Intent. (intent=" + intent + ")";
                                logger.warning(_f + " " + msg);
                                throw new Error(msg);
                            }
                            logger.info(_f + " Sending request <" + method.toUpperCase() + "> uri=" + apiPath);
                            if (config.debug) {
                                logger.finest(_f + " Request body=" + JSON.stringify(props, null, "  "));
                            }
                            if (!apiPath) {
                                msg = "Invalid request API path (v=\"" + apiPath + "\") aborting...";
                                logger.warning(_f + " " + msg);
                                throw new TypeError(msg);
                            }
                        }
                        catch (err) {
                            logger.severe(_h + " Failed to dispatch request. (error=" + err.message + ")");
                            throw err;
                        }
                        _b.label = 7;
                    case 7:
                        _b.trys.push([7, 12, , 13]);
                        if (!(method === "delete")) return [3 /*break*/, 9];
                        return [4 /*yield*/, this.requestHandler.delete(apiPath, config)];
                    case 8:
                        _a = _b.sent();
                        return [3 /*break*/, 11];
                    case 9: return [4 /*yield*/, this.requestHandler[method](apiPath, cloneDeep(props), config)];
                    case 10:
                        _a = _b.sent();
                        _b.label = 11;
                    case 11:
                        res = _a;
                        this.response = res;
                        this.error = void 0;
                        this.event.emit("dispatch", this);
                        return [2 /*return*/, this];
                    case 12:
                        err_3 = _b.sent();
                        // XXX: retry logic comes here
                        this.response = err_3.response;
                        this.error = err_3;
                        this.event.emit("dispatchFailed", this);
                        return [2 /*return*/, Promise.reject(this)];
                    case 13: return [2 /*return*/];
                }
            });
        });
    };
    Instruction.prototype.toAbsent = function (transId, options) {
        if (options === void 0) { options = {}; }
        options.intent = "absent";
        return this.dispatch(transId, options);
    };
    Instruction.prototype.toPresent = function (transId, options) {
        if (options === void 0) { options = {}; }
        options.intent = "present";
        return this.dispatch(transId, options);
    };
    Instruction.prototype.subscribe = function () {
        logger.warning(_h + "(subscribe) Not implemented");
    };
    Instruction.prototype.unsubscribe = function () {
        logger.warning(_h + "(subscribe) Not implemented");
    };
    return Instruction;
}());
exports.Instruction = Instruction;
exports.default = Instruction;


/***/ }),
/* 32 */
/***/ (function(module, exports) {

module.exports = require("events");

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(34);

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);
var bind = __webpack_require__(9);
var Axios = __webpack_require__(35);
var defaults = __webpack_require__(7);

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind(Axios.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  return instance;
}

// Create the default instance to be exported
var axios = createInstance(defaults);

// Expose Axios class to allow class inheritance
axios.Axios = Axios;

// Factory for creating new instances
axios.create = function create(instanceConfig) {
  return createInstance(utils.merge(defaults, instanceConfig));
};

// Expose Cancel & CancelToken
axios.Cancel = __webpack_require__(18);
axios.CancelToken = __webpack_require__(61);
axios.isCancel = __webpack_require__(17);

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = __webpack_require__(62);

module.exports = axios;

// Allow use of default import syntax in TypeScript
module.exports.default = axios;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var defaults = __webpack_require__(7);
var utils = __webpack_require__(0);
var InterceptorManager = __webpack_require__(56);
var dispatchRequest = __webpack_require__(57);
var isAbsoluteURL = __webpack_require__(59);
var combineURLs = __webpack_require__(60);

/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof config === 'string') {
    config = utils.merge({
      url: arguments[0]
    }, arguments[1]);
  }

  config = utils.merge(defaults, this.defaults, { method: 'get' }, config);

  // Support baseURL config
  if (config.baseURL && !isAbsoluteURL(config.url)) {
    config.url = combineURLs(config.baseURL, config.url);
  }

  // Hook up interceptors middleware
  var chain = [dispatchRequest, undefined];
  var promise = Promise.resolve(config);

  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    chain.unshift(interceptor.fulfilled, interceptor.rejected);
  });

  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    chain.push(interceptor.fulfilled, interceptor.rejected);
  });

  while (chain.length) {
    promise = promise.then(chain.shift(), chain.shift());
  }

  return promise;
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url
    }));
  };
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, data, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url,
      data: data
    }));
  };
});

module.exports = Axios;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

module.exports = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);
var settle = __webpack_require__(10);
var buildURL = __webpack_require__(12);
var parseHeaders = __webpack_require__(38);
var isURLSameOrigin = __webpack_require__(39);
var createError = __webpack_require__(8);
var btoa = (typeof window !== 'undefined' && window.btoa && window.btoa.bind(window)) || __webpack_require__(40);

module.exports = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;

    if (utils.isFormData(requestData)) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();
    var loadEvent = 'onreadystatechange';
    var xDomain = false;

    // For IE 8/9 CORS support
    // Only supports POST and GET calls and doesn't returns the response headers.
    // DON'T do this for testing b/c XMLHttpRequest is mocked, not XDomainRequest.
    if ("production" !== 'test' &&
        typeof window !== 'undefined' &&
        window.XDomainRequest && !('withCredentials' in request) &&
        !isURLSameOrigin(config.url)) {
      request = new window.XDomainRequest();
      loadEvent = 'onload';
      xDomain = true;
      request.onprogress = function handleProgress() {};
      request.ontimeout = function handleTimeout() {};
    }

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password || '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }

    request.open(config.method.toUpperCase(), buildURL(config.url, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;

    // Listen for ready state
    request[loadEvent] = function handleLoad() {
      if (!request || (request.readyState !== 4 && !xDomain)) {
        return;
      }

      // The request errored out and we didn't get a response, this will be
      // handled by onerror instead
      // With one exception: request that using file: protocol, most browsers
      // will return status as 0 even though it's a successful request
      if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
        return;
      }

      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;
      var response = {
        data: responseData,
        // IE sends 1223 instead of 204 (https://github.com/mzabriskie/axios/issues/201)
        status: request.status === 1223 ? 204 : request.status,
        statusText: request.status === 1223 ? 'No Content' : request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };

      settle(resolve, reject, response);

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(createError('Network Error', config));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      reject(createError('timeout of ' + config.timeout + 'ms exceeded', config, 'ECONNABORTED'));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      var cookies = __webpack_require__(41);

      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(config.url)) && config.xsrfCookieName ?
          cookies.read(config.xsrfCookieName) :
          undefined;

      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (config.withCredentials) {
      request.withCredentials = true;
    }

    // Add responseType to request if needed
    if (config.responseType) {
      try {
        request.responseType = config.responseType;
      } catch (e) {
        // Expected DOMException thrown by browsers not compatible XMLHttpRequest Level 2.
        // But, this can be suppressed for 'json' type as it can be parsed by default 'transformResponse' function.
        if (config.responseType !== 'json') {
          throw e;
        }
      }
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (!request) {
          return;
        }

        request.abort();
        reject(cancel);
        // Clean up request
        request = null;
      });
    }

    if (requestData === undefined) {
      requestData = null;
    }

    // Send the request
    request.send(requestData);
  });
};


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
module.exports = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;

  if (!headers) { return parsed; }

  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));

    if (key) {
      parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
    }
  });

  return parsed;
};


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
  (function standardBrowserEnv() {
    var msie = /(msie|trident)/i.test(navigator.userAgent);
    var urlParsingNode = document.createElement('a');
    var originURL;

    /**
    * Parse a URL to discover it's components
    *
    * @param {String} url The URL to be parsed
    * @returns {Object}
    */
    function resolveURL(url) {
      var href = url;

      if (msie) {
        // IE needs attribute set twice to normalize properties
        urlParsingNode.setAttribute('href', href);
        href = urlParsingNode.href;
      }

      urlParsingNode.setAttribute('href', href);

      // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
      return {
        href: urlParsingNode.href,
        protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
        host: urlParsingNode.host,
        search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
        hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
        hostname: urlParsingNode.hostname,
        port: urlParsingNode.port,
        pathname: (urlParsingNode.pathname.charAt(0) === '/') ?
                  urlParsingNode.pathname :
                  '/' + urlParsingNode.pathname
      };
    }

    originURL = resolveURL(window.location.href);

    /**
    * Determine if a URL shares the same origin as the current location
    *
    * @param {String} requestURL The URL to test
    * @returns {boolean} True if URL shares the same origin, otherwise false
    */
    return function isURLSameOrigin(requestURL) {
      var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;
      return (parsed.protocol === originURL.protocol &&
            parsed.host === originURL.host);
    };
  })() :

  // Non standard browser envs (web workers, react-native) lack needed support.
  (function nonStandardBrowserEnv() {
    return function isURLSameOrigin() {
      return true;
    };
  })()
);


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// btoa polyfill for IE<10 courtesy https://github.com/davidchambers/Base64.js

var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

function E() {
  this.message = 'String contains an invalid character';
}
E.prototype = new Error;
E.prototype.code = 5;
E.prototype.name = 'InvalidCharacterError';

function btoa(input) {
  var str = String(input);
  var output = '';
  for (
    // initialize result and counter
    var block, charCode, idx = 0, map = chars;
    // if the next str index does not exist:
    //   change the mapping table to "="
    //   check if d has no fractional digits
    str.charAt(idx | 0) || (map = '=', idx % 1);
    // "8 - idx % 1 * 8" generates the sequence 2, 4, 6, 8
    output += map.charAt(63 & block >> 8 - idx % 1 * 8)
  ) {
    charCode = str.charCodeAt(idx += 3 / 4);
    if (charCode > 0xFF) {
      throw new E();
    }
    block = block << 8 | charCode;
  }
  return output;
}

module.exports = btoa;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs support document.cookie
  (function standardBrowserEnv() {
    return {
      write: function write(name, value, expires, path, domain, secure) {
        var cookie = [];
        cookie.push(name + '=' + encodeURIComponent(value));

        if (utils.isNumber(expires)) {
          cookie.push('expires=' + new Date(expires).toGMTString());
        }

        if (utils.isString(path)) {
          cookie.push('path=' + path);
        }

        if (utils.isString(domain)) {
          cookie.push('domain=' + domain);
        }

        if (secure === true) {
          cookie.push('secure');
        }

        document.cookie = cookie.join('; ');
      },

      read: function read(name) {
        var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
        return (match ? decodeURIComponent(match[3]) : null);
      },

      remove: function remove(name) {
        this.write(name, '', Date.now() - 86400000);
      }
    };
  })() :

  // Non standard browser env (web workers, react-native) lack needed support.
  (function nonStandardBrowserEnv() {
    return {
      write: function write() {},
      read: function read() { return null; },
      remove: function remove() {}
    };
  })()
);


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);
var settle = __webpack_require__(10);
var buildURL = __webpack_require__(12);
var http = __webpack_require__(13);
var https = __webpack_require__(14);
var httpFollow = __webpack_require__(15).http;
var httpsFollow = __webpack_require__(15).https;
var url = __webpack_require__(6);
var zlib = __webpack_require__(53);
var pkg = __webpack_require__(54);
var Buffer = __webpack_require__(55).Buffer;
var createError = __webpack_require__(8);
var enhanceError = __webpack_require__(11);

/*eslint consistent-return:0*/
module.exports = function httpAdapter(config) {
  return new Promise(function dispatchHttpRequest(resolve, reject) {
    var data = config.data;
    var headers = config.headers;
    var timer;
    var aborted = false;

    // Set User-Agent (required by some servers)
    // Only set header if it hasn't been set in config
    // See https://github.com/mzabriskie/axios/issues/69
    if (!headers['User-Agent'] && !headers['user-agent']) {
      headers['User-Agent'] = 'axios/' + pkg.version;
    }

    if (data && !utils.isStream(data)) {
      if (utils.isBuffer(data)) {
        // Nothing to do...
      } else if (utils.isArrayBuffer(data)) {
        data = new Buffer(new Uint8Array(data));
      } else if (utils.isString(data)) {
        data = new Buffer(data, 'utf-8');
      } else {
        return reject(createError(
          'Data after transformation must be a string, an ArrayBuffer, a Buffer, or a Stream',
          config
        ));
      }

      // Add Content-Length header if data exists
      headers['Content-Length'] = data.length;
    }

    // HTTP basic authentication
    var auth = undefined;
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password || '';
      auth = username + ':' + password;
    }

    // Parse url
    var parsed = url.parse(config.url);
    var protocol = parsed.protocol || 'http:';

    if (!auth && parsed.auth) {
      var urlAuth = parsed.auth.split(':');
      var urlUsername = urlAuth[0] || '';
      var urlPassword = urlAuth[1] || '';
      auth = urlUsername + ':' + urlPassword;
    }

    if (auth) {
      delete headers.Authorization;
    }

    var isHttps = protocol === 'https:';
    var agent = isHttps ? config.httpsAgent : config.httpAgent;

    var options = {
      hostname: parsed.hostname,
      port: parsed.port,
      path: buildURL(parsed.path, config.params, config.paramsSerializer).replace(/^\?/, ''),
      method: config.method,
      headers: headers,
      agent: agent,
      auth: auth
    };

    var proxy = config.proxy;
    if (!proxy) {
      var proxyEnv = protocol.slice(0, -1) + '_proxy';
      var proxyUrl = Object({"NODE_ENV":"production"})[proxyEnv] || Object({"NODE_ENV":"production"})[proxyEnv.toUpperCase()];
      if (proxyUrl) {
        var parsedProxyUrl = url.parse(proxyUrl);
        proxy = {
          host: parsedProxyUrl.hostname,
          port: parsedProxyUrl.port
        };

        if (parsedProxyUrl.auth) {
          var proxyUrlAuth = parsedProxyUrl.auth.split(':');
          proxy.auth = {
            username: proxyUrlAuth[0],
            password: proxyUrlAuth[1]
          };
        }
      }
    }

    if (proxy) {
      options.hostname = proxy.host;
      options.host = proxy.host;
      options.headers.host = parsed.hostname + (parsed.port ? ':' + parsed.port : '');
      options.port = proxy.port;
      options.path = protocol + '//' + parsed.hostname + (parsed.port ? ':' + parsed.port : '') + options.path;

      // Basic proxy authorization
      if (proxy.auth) {
        var base64 = new Buffer(proxy.auth.username + ':' + proxy.auth.password, 'utf8').toString('base64');
        options.headers['Proxy-Authorization'] = 'Basic ' + base64;
      }
    }

    var transport;
    if (config.maxRedirects === 0) {
      transport = isHttps ? https : http;
    } else {
      if (config.maxRedirects) {
        options.maxRedirects = config.maxRedirects;
      }
      transport = isHttps ? httpsFollow : httpFollow;
    }

    // Create the request
    var req = transport.request(options, function handleResponse(res) {
      if (aborted) return;

      // Response has been received so kill timer that handles request timeout
      clearTimeout(timer);
      timer = null;

      // uncompress the response body transparently if required
      var stream = res;
      switch (res.headers['content-encoding']) {
      /*eslint default-case:0*/
      case 'gzip':
      case 'compress':
      case 'deflate':
        // add the unzipper to the body stream processing pipeline
        stream = stream.pipe(zlib.createUnzip());

        // remove the content-encoding in order to not confuse downstream operations
        delete res.headers['content-encoding'];
        break;
      }

      // return the last request in case of redirects
      var lastRequest = res.req || req;

      var response = {
        status: res.statusCode,
        statusText: res.statusMessage,
        headers: res.headers,
        config: config,
        request: lastRequest
      };

      if (config.responseType === 'stream') {
        response.data = stream;
        settle(resolve, reject, response);
      } else {
        var responseBuffer = [];
        stream.on('data', function handleStreamData(chunk) {
          responseBuffer.push(chunk);

          // make sure the content length is not over the maxContentLength if specified
          if (config.maxContentLength > -1 && Buffer.concat(responseBuffer).length > config.maxContentLength) {
            reject(createError('maxContentLength size of ' + config.maxContentLength + ' exceeded', config));
          }
        });

        stream.on('error', function handleStreamError(err) {
          if (aborted) return;
          reject(enhanceError(err, config));
        });

        stream.on('end', function handleStreamEnd() {
          var responseData = Buffer.concat(responseBuffer);
          if (config.responseType !== 'arraybuffer') {
            responseData = responseData.toString('utf8');
          }

          response.data = responseData;
          settle(resolve, reject, response);
        });
      }
    });

    // Handle errors
    req.on('error', function handleRequestError(err) {
      if (aborted) return;
      reject(enhanceError(err, config));
    });

    // Handle request timeout
    if (config.timeout && !timer) {
      timer = setTimeout(function handleRequestTimeout() {
        req.abort();
        reject(createError('timeout of ' + config.timeout + 'ms exceeded', config, 'ECONNABORTED'));
        aborted = true;
      }, config.timeout);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (aborted) {
          return;
        }

        req.abort();
        reject(cancel);
        aborted = true;
      });
    }

    // Send the request
    if (utils.isStream(data)) {
      data.pipe(req);
    } else {
      req.end(data);
    }
  });
};


/***/ }),
/* 43 */
/***/ (function(module, exports) {

module.exports = require("assert");

/***/ }),
/* 44 */
/***/ (function(module, exports) {

module.exports = require("stream");

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

/**
 * Detect Electron renderer process, which is node, but we should
 * treat as a browser.
 */

if (typeof process !== 'undefined' && process.type === 'renderer') {
  module.exports = __webpack_require__(46);
} else {
  module.exports = __webpack_require__(48);
}


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

/**
 * This is the web browser implementation of `debug()`.
 *
 * Expose `debug()` as the module.
 */

exports = module.exports = __webpack_require__(16);
exports.log = log;
exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;
exports.storage = 'undefined' != typeof chrome
               && 'undefined' != typeof chrome.storage
                  ? chrome.storage.local
                  : localstorage();

/**
 * Colors.
 */

exports.colors = [
  'lightseagreen',
  'forestgreen',
  'goldenrod',
  'dodgerblue',
  'darkorchid',
  'crimson'
];

/**
 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
 * and the Firebug extension (any Firefox version) are known
 * to support "%c" CSS customizations.
 *
 * TODO: add a `localStorage` variable to explicitly enable/disable colors
 */

function useColors() {
  // NB: In an Electron preload script, document will be defined but not fully
  // initialized. Since we know we're in Chrome, we'll just detect this case
  // explicitly
  if (typeof window !== 'undefined' && window.process && window.process.type === 'renderer') {
    return true;
  }

  // is webkit? http://stackoverflow.com/a/16459606/376773
  // document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
  return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
    // is firebug? http://stackoverflow.com/a/398120/376773
    (typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
    // is firefox >= v31?
    // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
    (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
    // double check webkit in userAgent just in case we are in a worker
    (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
}

/**
 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
 */

exports.formatters.j = function(v) {
  try {
    return JSON.stringify(v);
  } catch (err) {
    return '[UnexpectedJSONParseError]: ' + err.message;
  }
};


/**
 * Colorize log arguments if enabled.
 *
 * @api public
 */

function formatArgs(args) {
  var useColors = this.useColors;

  args[0] = (useColors ? '%c' : '')
    + this.namespace
    + (useColors ? ' %c' : ' ')
    + args[0]
    + (useColors ? '%c ' : ' ')
    + '+' + exports.humanize(this.diff);

  if (!useColors) return;

  var c = 'color: ' + this.color;
  args.splice(1, 0, c, 'color: inherit')

  // the final "%c" is somewhat tricky, because there could be other
  // arguments passed either before or after the %c, so we need to
  // figure out the correct index to insert the CSS into
  var index = 0;
  var lastC = 0;
  args[0].replace(/%[a-zA-Z%]/g, function(match) {
    if ('%%' === match) return;
    index++;
    if ('%c' === match) {
      // we only are interested in the *last* %c
      // (the user may have provided their own)
      lastC = index;
    }
  });

  args.splice(lastC, 0, c);
}

/**
 * Invokes `console.log()` when available.
 * No-op when `console.log` is not a "function".
 *
 * @api public
 */

function log() {
  // this hackery is required for IE8/9, where
  // the `console.log` function doesn't have 'apply'
  return 'object' === typeof console
    && console.log
    && Function.prototype.apply.call(console.log, console, arguments);
}

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */

function save(namespaces) {
  try {
    if (null == namespaces) {
      exports.storage.removeItem('debug');
    } else {
      exports.storage.debug = namespaces;
    }
  } catch(e) {}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */

function load() {
  var r;
  try {
    r = exports.storage.debug;
  } catch(e) {}

  // If debug isn't set in LS, and we're in Electron, try to load $DEBUG
  if (!r && typeof process !== 'undefined' && 'env' in process) {
    r = Object({"NODE_ENV":"production"}).DEBUG;
  }

  return r;
}

/**
 * Enable namespaces listed in `localStorage.debug` initially.
 */

exports.enable(load());

/**
 * Localstorage attempts to return the localstorage.
 *
 * This is necessary because safari throws
 * when a user disables cookies/localstorage
 * and you attempt to access it.
 *
 * @return {LocalStorage}
 * @api private
 */

function localstorage() {
  try {
    return window.localStorage;
  } catch (e) {}
}


/***/ }),
/* 47 */
/***/ (function(module, exports) {

/**
 * Helpers.
 */

var s = 1000;
var m = s * 60;
var h = m * 60;
var d = h * 24;
var y = d * 365.25;

/**
 * Parse or format the given `val`.
 *
 * Options:
 *
 *  - `long` verbose formatting [false]
 *
 * @param {String|Number} val
 * @param {Object} [options]
 * @throws {Error} throw an error if val is not a non-empty string or a number
 * @return {String|Number}
 * @api public
 */

module.exports = function(val, options) {
  options = options || {};
  var type = typeof val;
  if (type === 'string' && val.length > 0) {
    return parse(val);
  } else if (type === 'number' && isNaN(val) === false) {
    return options.long ? fmtLong(val) : fmtShort(val);
  }
  throw new Error(
    'val is not a non-empty string or a valid number. val=' +
      JSON.stringify(val)
  );
};

/**
 * Parse the given `str` and return milliseconds.
 *
 * @param {String} str
 * @return {Number}
 * @api private
 */

function parse(str) {
  str = String(str);
  if (str.length > 100) {
    return;
  }
  var match = /^((?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|years?|yrs?|y)?$/i.exec(
    str
  );
  if (!match) {
    return;
  }
  var n = parseFloat(match[1]);
  var type = (match[2] || 'ms').toLowerCase();
  switch (type) {
    case 'years':
    case 'year':
    case 'yrs':
    case 'yr':
    case 'y':
      return n * y;
    case 'days':
    case 'day':
    case 'd':
      return n * d;
    case 'hours':
    case 'hour':
    case 'hrs':
    case 'hr':
    case 'h':
      return n * h;
    case 'minutes':
    case 'minute':
    case 'mins':
    case 'min':
    case 'm':
      return n * m;
    case 'seconds':
    case 'second':
    case 'secs':
    case 'sec':
    case 's':
      return n * s;
    case 'milliseconds':
    case 'millisecond':
    case 'msecs':
    case 'msec':
    case 'ms':
      return n;
    default:
      return undefined;
  }
}

/**
 * Short format for `ms`.
 *
 * @param {Number} ms
 * @return {String}
 * @api private
 */

function fmtShort(ms) {
  if (ms >= d) {
    return Math.round(ms / d) + 'd';
  }
  if (ms >= h) {
    return Math.round(ms / h) + 'h';
  }
  if (ms >= m) {
    return Math.round(ms / m) + 'm';
  }
  if (ms >= s) {
    return Math.round(ms / s) + 's';
  }
  return ms + 'ms';
}

/**
 * Long format for `ms`.
 *
 * @param {Number} ms
 * @return {String}
 * @api private
 */

function fmtLong(ms) {
  return plural(ms, d, 'day') ||
    plural(ms, h, 'hour') ||
    plural(ms, m, 'minute') ||
    plural(ms, s, 'second') ||
    ms + ' ms';
}

/**
 * Pluralization helper.
 */

function plural(ms, n, name) {
  if (ms < n) {
    return;
  }
  if (ms < n * 1.5) {
    return Math.floor(ms / n) + ' ' + name;
  }
  return Math.ceil(ms / n) + ' ' + name + 's';
}


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

/**
 * Module dependencies.
 */

var tty = __webpack_require__(49);
var util = __webpack_require__(50);

/**
 * This is the Node.js implementation of `debug()`.
 *
 * Expose `debug()` as the module.
 */

exports = module.exports = __webpack_require__(16);
exports.init = init;
exports.log = log;
exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;

/**
 * Colors.
 */

exports.colors = [6, 2, 3, 4, 5, 1];

/**
 * Build up the default `inspectOpts` object from the environment variables.
 *
 *   $ DEBUG_COLORS=no DEBUG_DEPTH=10 DEBUG_SHOW_HIDDEN=enabled node script.js
 */

exports.inspectOpts = Object.keys(Object({"NODE_ENV":"production"})).filter(function (key) {
  return /^debug_/i.test(key);
}).reduce(function (obj, key) {
  // camel-case
  var prop = key
    .substring(6)
    .toLowerCase()
    .replace(/_([a-z])/g, function (_, k) { return k.toUpperCase() });

  // coerce string value into JS value
  var val = Object({"NODE_ENV":"production"})[key];
  if (/^(yes|on|true|enabled)$/i.test(val)) val = true;
  else if (/^(no|off|false|disabled)$/i.test(val)) val = false;
  else if (val === 'null') val = null;
  else val = Number(val);

  obj[prop] = val;
  return obj;
}, {});

/**
 * The file descriptor to write the `debug()` calls to.
 * Set the `DEBUG_FD` env variable to override with another value. i.e.:
 *
 *   $ DEBUG_FD=3 node script.js 3>debug.log
 */

var fd = parseInt(Object({"NODE_ENV":"production"}).DEBUG_FD, 10) || 2;

if (1 !== fd && 2 !== fd) {
  util.deprecate(function(){}, 'except for stderr(2) and stdout(1), any other usage of DEBUG_FD is deprecated. Override debug.log if you want to use a different log function (https://git.io/debug_fd)')()
}

var stream = 1 === fd ? process.stdout :
             2 === fd ? process.stderr :
             createWritableStdioStream(fd);

/**
 * Is stdout a TTY? Colored output is enabled when `true`.
 */

function useColors() {
  return 'colors' in exports.inspectOpts
    ? Boolean(exports.inspectOpts.colors)
    : tty.isatty(fd);
}

/**
 * Map %o to `util.inspect()`, all on a single line.
 */

exports.formatters.o = function(v) {
  this.inspectOpts.colors = this.useColors;
  return util.inspect(v, this.inspectOpts)
    .replace(/\s*\n\s*/g, ' ');
};

/**
 * Map %o to `util.inspect()`, allowing multiple lines if needed.
 */

exports.formatters.O = function(v) {
  this.inspectOpts.colors = this.useColors;
  return util.inspect(v, this.inspectOpts);
};

/**
 * Adds ANSI color escape codes if enabled.
 *
 * @api public
 */

function formatArgs(args) {
  var name = this.namespace;
  var useColors = this.useColors;

  if (useColors) {
    var c = this.color;
    var prefix = '  \u001b[3' + c + ';1m' + name + ' ' + '\u001b[0m';

    args[0] = prefix + args[0].split('\n').join('\n' + prefix);
    args.push('\u001b[3' + c + 'm+' + exports.humanize(this.diff) + '\u001b[0m');
  } else {
    args[0] = new Date().toUTCString()
      + ' ' + name + ' ' + args[0];
  }
}

/**
 * Invokes `util.format()` with the specified arguments and writes to `stream`.
 */

function log() {
  return stream.write(util.format.apply(util, arguments) + '\n');
}

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */

function save(namespaces) {
  if (null == namespaces) {
    // If you set a process.env field to null or undefined, it gets cast to the
    // string 'null' or 'undefined'. Just delete instead.
    delete Object({"NODE_ENV":"production"}).DEBUG;
  } else {
    Object({"NODE_ENV":"production"}).DEBUG = namespaces;
  }
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */

function load() {
  return Object({"NODE_ENV":"production"}).DEBUG;
}

/**
 * Copied from `node/src/node.js`.
 *
 * XXX: It's lame that node doesn't expose this API out-of-the-box. It also
 * relies on the undocumented `tty_wrap.guessHandleType()` which is also lame.
 */

function createWritableStdioStream (fd) {
  var stream;
  var tty_wrap = process.binding('tty_wrap');

  // Note stream._type is used for test-module-load-list.js

  switch (tty_wrap.guessHandleType(fd)) {
    case 'TTY':
      stream = new tty.WriteStream(fd);
      stream._type = 'tty';

      // Hack to have stream not keep the event loop alive.
      // See https://github.com/joyent/node/issues/1726
      if (stream._handle && stream._handle.unref) {
        stream._handle.unref();
      }
      break;

    case 'FILE':
      var fs = __webpack_require__(51);
      stream = new fs.SyncWriteStream(fd, { autoClose: false });
      stream._type = 'fs';
      break;

    case 'PIPE':
    case 'TCP':
      var net = __webpack_require__(52);
      stream = new net.Socket({
        fd: fd,
        readable: false,
        writable: true
      });

      // FIXME Should probably have an option in net.Socket to create a
      // stream from an existing fd which is writable only. But for now
      // we'll just add this hack and set the `readable` member to false.
      // Test: ./node test/fixtures/echo.js < /etc/passwd
      stream.readable = false;
      stream.read = null;
      stream._type = 'pipe';

      // FIXME Hack to have stream not keep the event loop alive.
      // See https://github.com/joyent/node/issues/1726
      if (stream._handle && stream._handle.unref) {
        stream._handle.unref();
      }
      break;

    default:
      // Probably an error on in uv_guess_handle()
      throw new Error('Implement me. Unknown stream file type!');
  }

  // For supporting legacy API we put the FD here.
  stream.fd = fd;

  stream._isStdio = true;

  return stream;
}

/**
 * Init logic for `debug` instances.
 *
 * Create a new `inspectOpts` object in case `useColors` is set
 * differently for a particular `debug` instance.
 */

function init (debug) {
  debug.inspectOpts = {};

  var keys = Object.keys(exports.inspectOpts);
  for (var i = 0; i < keys.length; i++) {
    debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
  }
}

/**
 * Enable namespaces listed in `process.env.DEBUG` initially.
 */

exports.enable(load());


/***/ }),
/* 49 */
/***/ (function(module, exports) {

module.exports = require("tty");

/***/ }),
/* 50 */
/***/ (function(module, exports) {

module.exports = require("util");

/***/ }),
/* 51 */
/***/ (function(module, exports) {

module.exports = require("fs");

/***/ }),
/* 52 */
/***/ (function(module, exports) {

module.exports = require("net");

/***/ }),
/* 53 */
/***/ (function(module, exports) {

module.exports = require("zlib");

/***/ }),
/* 54 */
/***/ (function(module, exports) {

module.exports = {"_from":"axios@0.16.1","_id":"axios@0.16.1","_inBundle":false,"_integrity":"sha1-wLbSZgCEI4S49QnlcRHw0t+CI8o=","_location":"/@iapp-express/renderer/axios","_phantomChildren":{},"_requested":{"type":"version","registry":true,"raw":"axios@0.16.1","name":"axios","escapedName":"axios","rawSpec":"0.16.1","saveSpec":null,"fetchSpec":"0.16.1"},"_requiredBy":["/@iapp-express/renderer"],"_resolved":"https://registry.npmjs.org/axios/-/axios-0.16.1.tgz","_shasum":"c0b6d26600842384b8f509e57111f0d2df8223ca","_spec":"axios@0.16.1","_where":"/Users/takahashi/Desktop/MyApp/node_modules/@iapp-express/renderer","author":{"name":"Matt Zabriskie"},"browser":{"./lib/adapters/http.js":"./lib/adapters/xhr.js"},"bugs":{"url":"https://github.com/mzabriskie/axios/issues"},"bundleDependencies":false,"dependencies":{"follow-redirects":"^1.2.3"},"deprecated":false,"description":"Promise based HTTP client for the browser and node.js","devDependencies":{"coveralls":"^2.11.9","es6-promise":"^4.0.5","grunt":"^1.0.1","grunt-banner":"^0.6.0","grunt-cli":"^1.2.0","grunt-contrib-clean":"^1.0.0","grunt-contrib-nodeunit":"^1.0.0","grunt-contrib-watch":"^1.0.0","grunt-eslint":"^19.0.0","grunt-karma":"^2.0.0","grunt-ts":"^6.0.0-beta.3","grunt-webpack":"^1.0.18","istanbul-instrumenter-loader":"^1.0.0","jasmine-core":"^2.4.1","karma":"^1.3.0","karma-chrome-launcher":"^2.0.0","karma-coverage":"^1.0.0","karma-firefox-launcher":"^1.0.0","karma-jasmine":"^1.0.2","karma-jasmine-ajax":"^0.1.13","karma-opera-launcher":"^1.0.0","karma-phantomjs-launcher":"^1.0.0","karma-safari-launcher":"^1.0.0","karma-sauce-launcher":"^1.1.0","karma-sinon":"^1.0.5","karma-sourcemap-loader":"^0.3.7","karma-webpack":"^1.7.0","load-grunt-tasks":"^3.5.2","minimist":"^1.2.0","phantomjs-prebuilt":"^2.1.7","sinon":"^1.17.4","typescript":"^2.0.3","url-search-params":"^0.6.1","webpack":"^1.13.1","webpack-dev-server":"^1.14.1"},"homepage":"https://github.com/mzabriskie/axios","keywords":["xhr","http","ajax","promise","node"],"license":"MIT","main":"index.js","name":"axios","repository":{"type":"git","url":"git+https://github.com/mzabriskie/axios.git"},"scripts":{"build":"NODE_ENV=production grunt build","coveralls":"cat coverage/lcov.info | ./node_modules/coveralls/bin/coveralls.js","examples":"node ./examples/server.js","postversion":"git push && git push --tags","preversion":"npm test","start":"node ./sandbox/server.js","test":"grunt test","version":"npm run build && grunt version && git add -A dist && git add CHANGELOG.md bower.json package.json"},"typings":"./index.d.ts","version":"0.16.1"}

/***/ }),
/* 55 */
/***/ (function(module, exports) {

module.exports = require("buffer");

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};

module.exports = InterceptorManager;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);
var transformData = __webpack_require__(58);
var isCancel = __webpack_require__(17);
var defaults = __webpack_require__(7);

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
module.exports = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData(
    config.data,
    config.headers,
    config.transformRequest
  );

  // Flatten headers
  config.headers = utils.merge(
    config.headers.common || {},
    config.headers[config.method] || {},
    config.headers || {}
  );

  utils.forEach(
    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],
    function cleanHeaderConfig(method) {
      delete config.headers[method];
    }
  );

  var adapter = config.adapter || defaults.adapter;

  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData(
      response.data,
      response.headers,
      config.transformResponse
    );

    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData(
          reason.response.data,
          reason.response.headers,
          config.transformResponse
        );
      }
    }

    return Promise.reject(reason);
  });
};


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(0);

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
module.exports = function transformData(data, headers, fns) {
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn(data, headers);
  });

  return data;
};


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
module.exports = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
module.exports = function combineURLs(baseURL, relativeURL) {
  return relativeURL
    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')
    : baseURL;
};


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Cancel = __webpack_require__(18);

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }

  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });

  var token = this;
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }

    token.reason = new Cancel(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};

module.exports = CancelToken;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
module.exports = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = __webpack_require__(1);
var logger = logger_1.default.getInstance();
var RequestHandler_1 = __webpack_require__(3);
function loggerOnRequest(config) {
    var _a = config.method, method = _a === void 0 ? "" : _a, baseURL = config.baseURL, auth = config.auth, data = config.data, transId = config.transId, __debug__ = config.__debug__;
    var url = config.url;
    var username = auth ? auth.username : "unknown";
    if (baseURL && url) {
        url = url.replace(baseURL, "");
    }
    var _f = RequestHandler_1._h + "(req)(t=" + (transId || "none") + ",u=" + username + ")";
    if (__debug__) {
        logger.info(_f + " -> <" + method.toUpperCase() + "> uri=" + url + " request=", JSON.stringify(data, null, "  "));
    }
    else {
        logger.info(_f + " -> <" + method.toUpperCase() + "> uri=" + url);
    }
    return config;
}
exports.loggerOnRequest = loggerOnRequest;
function loggerOnResponse(response) {
    var config = response.config, status = response.status, data = response.data;
    var _a = config, _b = _a.method, method = _b === void 0 ? "" : _b, auth = _a.auth, baseURL = _a.baseURL, transId = _a.transId, __sentAt__ = _a.__sentAt__, __debug__ = _a.__debug__;
    var url = config.url;
    var username = auth ? auth.username : "unknown";
    if (baseURL && url) {
        url = url.replace(baseURL, "");
    }
    var elapsedTime = __sentAt__ ? Date.now() - __sentAt__ : -1;
    response.config.__elapsed__ = elapsedTime;
    var _f = RequestHandler_1._h + "(res)(t=" + (transId || "none") + ",u=" + username + ")";
    if (__debug__) {
        logger.info(_f + " <- <" + method.toUpperCase() + "> uri=" + url, "(status=" + status + ", elapsed=" + elapsedTime + "ms) response=", JSON.stringify(data, null, "  "));
    }
    else {
        logger.info(_f + " <- <" + method.toUpperCase() + "> uri=" + url, "(status=" + status + ", elapsed=" + elapsedTime + "ms)");
    }
    return response;
}
exports.loggerOnResponse = loggerOnResponse;
/**
 * Axios error interceptor for logging. It logs as much information as possible.
 */
function loggerOnError(error) {
    if (typeof error !== "object") {
        logger.severe(RequestHandler_1._h + "(err) Request failed with unknown error (error=" + error + ")");
        return Promise.reject(error);
    }
    var _a = error.config, _b = _a.method, method = _b === void 0 ? "" : _b, baseURL = _a.baseURL, auth = _a.auth, transId = _a.transId, __sentAt__ = _a.__sentAt__, __debug__ = _a.__debug__;
    var url = error.config.url;
    var username = auth ? auth.username : "unknown";
    if (baseURL && url) {
        url = url.replace(baseURL, "");
    }
    var status = error.response ? error.response.status : -1;
    var data = error.response ? error.response.data : {};
    var elapsedTime = __sentAt__ ? Date.now() - __sentAt__ : -1;
    error.config.__elapsed__ = elapsedTime;
    var level = status === 404 ? "info" : "severe";
    var _f = RequestHandler_1._h + "(onError)(t=" + (transId || "none") + ",u=" + username + ") <- <" + method.toUpperCase() + ">";
    var message = (data || {}).message ||
        (error || {}).message ||
        "Unknown response error: error=" + error;
    if (data && Object.prototype.hasOwnProperty.call(data, "errorStack")) {
        logger[level](_f, JSON.stringify(data.errorStack, null, "  "));
    }
    if (__debug__) {
        logger[level](_f + " uri=" + url, "(debug=true, status=" + status + ", message=" + message + ", elapsed=" + elapsedTime + "ms) response=", JSON.stringify(data, null, "  "));
    }
    else {
        logger[level](_f + " uri=" + url, "(status=" + status + ", message=" + message + ", elapsed=" + elapsedTime + "ms)");
    }
    return Promise.reject(error);
}
exports.loggerOnError = loggerOnError;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = __webpack_require__(1);
var cloneDeep = __webpack_require__(4);
var querystring = __webpack_require__(65);
var index_1 = __webpack_require__(2);
var pathDictionary_1 = __webpack_require__(66);
var logger = logger_1.default.getInstance();
var _h = "[" + index_1.moduleName + "::factory]";
// Matches https://localhost/mgmt/tm/ltm/virtual/~Common~a?ver=13.0.0
var REGEXP_ITEM = /.*((\/tm\/|\/shared\/)[\w\-\/]+\/~[\w\-]+~[\w\-\.]+)(\?.*)?$/;
// Matches https://localhost/mgmt/tm/net/fdb/~Common~a/records/ff:ff:ff:ff:ff:ff?ver=13.0.0
var REGEXP_SUB_ITEM = /.*((\/tm\/|\/shared\/)[\w\-\/]+\/~[\w\-]+~[\w\-]+(\/[\w\-\.\:]+)+)(\?.*)?$/;
// https://localhost/mgmt/shared/iapp/blocks/014337e9-f8b4-3cab-988b-e97f4a005cbb
var REGEXP_BLOCK = /.*\/shared\/iapp\/blocks\/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(\?.*)?$/;
var REGEXP_SHARED_DG = /.*\/shared\/resolver\/device-groups\/([\w-]+)?(\?.*)?$/;
function throwIfNonStringInput(input, _f) {
    if (_f === void 0) { _f = _h; }
    if (typeof input !== "string") {
        var msg = _f + " Error non string input. (type=" + typeof input + ", value=" + input + ")";
        logger.severe(msg);
        throw new TypeError(msg);
    }
}
/**
 * A class that provide heuristic to compute API request path from various inputs
 * including: selflink string, iControl-Rest prop object with { name, kind }.
 * - basePath: An API end-point to a module level (ex: /tm/ltm/virtual)
 * - fullPath: An API end-point to a resource level (ex: /tm/ltm/virtual/<name>)
 * - selfLink: An original selfLink string in iControl-Rest response
 */
var SelfLinkFactory = (function () {
    //
    // Instance Methods
    //
    function SelfLinkFactory(props, basePath, options) {
        if (options === void 0) { options = {
            throwError: true,
        }; }
        if (!SelfLinkFactory.isValidProps(props, basePath, true)) {
            var msg = _h + "(constructor) Failed to instantiate. Invalid prop object.";
            logger.severe(msg);
            if (options.throwError) {
                throw new TypeError(msg);
            }
        }
        this._props = cloneDeep(props);
        this._basePath = basePath ||
            SelfLinkFactory.kindToBasePath(props.kind || "") ||
            SelfLinkFactory.selfLinkToBasePath(props.selfLink || "");
        this._version = options.version;
    }
    /**
     * Create an instance from selfLink string. Valid selfLink shall fulfill either:
     * - https://localhost/mgmt/tm/<apiPath>/~<Partition>~<name>?ver=13.0.0
     * - https://localhost/mgmt/shared/<apiPath>/<name>
     * Note that if selfLink is under /shared/ branch, it assumes last node as a name.
     * @static
     * @param {String} selfLink
     * @returns {PropFactory}
     */
    SelfLinkFactory.fromSelfLink = function (selfLink, options) {
        var name = SelfLinkFactory.getName(selfLink);
        var partition = SelfLinkFactory.getPartition(selfLink) || "Common";
        var basePath = (options || {}).basePath || SelfLinkFactory.selfLinkToBasePath(selfLink);
        var kind = SelfLinkFactory.basePathToKind(basePath);
        return new SelfLinkFactory({ name: name, partition: partition, selfLink: selfLink, kind: kind }, basePath);
    };
    /**
     * A method that naively assumes that kind string with omitting
     *  the last part represents API base path.
     * example:
     * - tm:ltm:pool:poolcollectionstate => /tm/ltm/pool
     * - tm:ltm:pool => /tm/ltm/pool
     * - tm:ltm:pool:poolstate => /tm/ltm/pool
     * @static
     * @param {String} input
     * @returns {String}
     */
    SelfLinkFactory.kindToBasePath = function (input) {
        var _f = _h + "(kindToBasePath)";
        throwIfNonStringInput(input, _f);
        var paths = input.split(":");
        if (!/^\w+:([\w-]+:)+[\w-]+state$/.test(input) || paths.length <= 1 || paths[0] !== "tm") {
            logger.warning(_f + " Invalid input format is passed. Returning empty string. (value=" + input + ")");
            return "";
        }
        paths.pop(); // Remove last item that contains *state part.
        return "/" + paths.join("/");
    };
    /**
     * A method that naively assumes that path string with adding
     *  "state" to the last part represents kind string.
     * example:
     * - /tm/ltm/pool => tm:ltm:pool:poolstate
     * @static
     * @param {String} input
     * @returns {String}
     */
    SelfLinkFactory.basePathToKind = function (input) {
        var _f = _h + "(basePathToKind)";
        throwIfNonStringInput(input, _f);
        var kind = input.split("/")
            .filter(function (i) { return i !== ""; })
            .filter(function (i) { return !/~[\w\-]+~/.test(i); });
        kind.push(kind[kind.length - 1] + "state");
        return kind.join(":");
    };
    /**
     * Take selfLink, and extract and return basePath string
     *  - https://localhost/mgmt/tm/ltm/virtual/~Common~a?ver=13.0.0
     *    => /tm/ltm/virtual
     *  - https://localhost/mgmt/tm/net/fdb/~Common~tunnel1/records/ff:ff:ff:ff:ff:ff
     *    => /tm/net/fdb/~Common~tunnel1/records/ff:ff:ff:ff:ff:ff
     * @param {String} selfLink
     * @return {String}
     */
    SelfLinkFactory.selfLinkToBasePath = function (selfLink) {
        var _f = _h + "(selfLinkToBasePath)";
        throwIfNonStringInput(selfLink, _f);
        if (!SelfLinkFactory.isValidSelfLink(selfLink)) {
            return "";
        }
        var output = "";
        // Assume that /a/~Common~b -> b becomes name nad partition.
        if (REGEXP_ITEM.test(selfLink)) {
            output = (selfLink.match(REGEXP_ITEM) || [])[1] || "";
            var arr = output.split("/").filter(function (i) { return i !== ""; });
            if (arr.length) {
                arr.pop();
            }
            output = "/" + arr.join("/");
            return output;
        }
        // Assume that /a/~Common~b/c/d -> d becomes name nad no partition.
        if (REGEXP_SUB_ITEM.test(selfLink)) {
            output = (selfLink.match(REGEXP_SUB_ITEM) || [])[1] || "";
            var arr = output.split("/").filter(function (i) { return i !== ""; });
            if (arr.length) {
                arr.pop();
            }
            output = "/" + arr.join("/");
            return output;
        }
        // For irregular input 1. Block
        if (REGEXP_BLOCK.test(selfLink)) {
            var arr = selfLink
                .replace("https://localhost/mgmt", "")
                .split("/~")[0]
                .split("/")
                .filter(function (i) { return i !== ""; });
            if (arr[0] === "shared" && arr[2] === "blocks") {
                arr.pop();
                output = "/" + arr.join("/");
            }
        }
        // For irregular input 2. Device-Group
        if (REGEXP_SHARED_DG.test(selfLink)) {
            var arr = selfLink
                .replace("https://localhost/mgmt", "")
                .split("/~")[0]
                .split("/")
                .filter(function (i) { return i !== ""; });
            if (arr[0] === "shared" && arr[2] === "resolver") {
                arr.pop();
                output = "/" + arr.join("/");
            }
        }
        return output ? output : pathDictionary_1.getBasePath(selfLink);
    };
    /**
     * Expect input of actual selfLink string returned from the target BIG-IP.
     * @param {String} selfLink
     * @returns {boolean}
     */
    SelfLinkFactory.isValidSelfLink = function (selfLink, emitLog) {
        if (emitLog === void 0) { emitLog = true; }
        var _f = _h + "(isValidSelfLink)";
        throwIfNonStringInput(selfLink, _f);
        if (!selfLink.startsWith("https://localhost/mgmt")) {
            if (emitLog && selfLink) {
                logger.warning(_f + " SelfLink string must start with https://localhost/mgmt. (value=" + selfLink + ")");
            }
            return false;
        }
        var valid = (REGEXP_ITEM.test(selfLink) ||
            REGEXP_SUB_ITEM.test(selfLink) ||
            REGEXP_BLOCK.test(selfLink) ||
            REGEXP_SHARED_DG.test(selfLink));
        if (emitLog && !valid) {
            logger.warning(_f + " Invalid selfLink string. (value=" + selfLink + ")");
        }
        return valid;
    };
    /**
     * Validate iControl-Rest config object that has sufficient props to convert into
     * selfLinkLike object.
     * @param {Object} props
     * @param {String} basePath=''
     * @returns {boolean}
     */
    SelfLinkFactory.isValidProps = function (props, basePath, emitLog) {
        if (basePath === void 0) { basePath = ""; }
        if (emitLog === void 0) { emitLog = false; }
        var _f = _h + "(isValidProps)";
        var _props = props;
        if (typeof props === "string") {
            try {
                _props = JSON.parse(props);
            }
            catch (err) {
                if (emitLog) {
                    logger.warning(_f + " Failed to convert string into object.");
                }
                return false;
            }
        }
        if (typeof _props !== "object") {
            if (emitLog) {
                logger.warning(_f + " Invalid Prop: Non-object value (type=" + typeof _props + ")");
            }
            return false;
        }
        var kind = _props.kind, name = _props.name, tmName = _props.tmName, fullPath = _props.fullPath, _a = _props.selfLink, selfLink = _a === void 0 ? "" : _a;
        if (selfLink && !SelfLinkFactory.isValidSelfLink(selfLink)) {
            if (emitLog) {
                logger.warning(_f + " Invalid Prop: Invalid selfLink string", "(type=" + typeof selfLink + ", value=" + selfLink + ")");
            }
            return false;
        }
        if (!basePath && !selfLink) {
            if (!kind || !SelfLinkFactory.kindToBasePath(kind)) {
                if (emitLog) {
                    logger.warning(_f + " Invalid Prop: Invalid kind string.", "(type=" + typeof kind + ", value=" + kind + ")");
                }
                return false;
            }
        }
        if (!fullPath && !selfLink) {
            if ((!name && !tmName)) {
                if (emitLog) {
                    logger.warning(_f + " Invalid Prop: No name/tmName property.", "(type=" + typeof name + ", value=" + name + ")");
                }
                return false;
            }
        }
        return true;
    };
    SelfLinkFactory.getName = function (selfLink) {
        var _input = selfLink.split("?")[0];
        if (!SelfLinkFactory.isValidSelfLink(_input)) {
            return "";
        }
        if (REGEXP_SUB_ITEM.test(_input)) {
            var arry = _input.split("/");
            return arry[arry.length - 1];
        }
        if (REGEXP_ITEM.test(_input)) {
            var arry = _input.split("~");
            return arry[arry.length - 1];
        }
        var name = pathDictionary_1.getName(selfLink);
        if (name) {
            return name;
        }
        var arr = _input.split("/");
        return arr[arr.length - 1];
    };
    SelfLinkFactory.getQuery = function (_input) {
        if (!SelfLinkFactory.isValidSelfLink(_input)) {
            return {};
        }
        return querystring.parse((_input.match(/[\w\/]+\?(.*)/) || [])[1] || "");
    };
    SelfLinkFactory.getPartition = function (selfLink) {
        if (!SelfLinkFactory.isValidSelfLink(selfLink)) {
            return "";
        }
        return (selfLink.match(/~(\w+)~/) || [])[1] || "";
    };
    Object.defineProperty(SelfLinkFactory.prototype, "name", {
        get: function () {
            return this._props.name || SelfLinkFactory.getName(this._props.selfLink || "");
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelfLinkFactory.prototype, "partition", {
        get: function () {
            return this._props.partition || this._props.tmPartition ||
                SelfLinkFactory.getPartition(this._props.selfLink || "") || "Common";
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelfLinkFactory.prototype, "version", {
        get: function () {
            return this._version || SelfLinkFactory.getQuery(this._props.selfLink || "").ver;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelfLinkFactory.prototype, "basePath", {
        get: function () {
            return this._basePath;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelfLinkFactory.prototype, "fullPath", {
        get: function () {
            if (REGEXP_SUB_ITEM.test(this.basePath || "")) {
                return this.basePath + "/" + this.name;
            }
            return this.partition ?
                this.basePath + "/~" + this.partition + "~" + this.name :
                this.basePath + "/" + this.name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelfLinkFactory.prototype, "selfLink", {
        get: function () {
            return this.version ?
                "https://localhost/mgmt" + this.fullPath + "?ver=" + this.version :
                "https://localhost/mgmt" + this.fullPath;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelfLinkFactory.prototype, "kind", {
        get: function () {
            return this.basePath ?
                SelfLinkFactory.basePathToKind(this.basePath) : this._props.kind;
        },
        enumerable: true,
        configurable: true
    });
    return SelfLinkFactory;
}());
exports.SelfLinkFactory = SelfLinkFactory;
exports.default = SelfLinkFactory;


/***/ }),
/* 65 */
/***/ (function(module, exports) {

module.exports = require("querystring");

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = __webpack_require__(1);
var logger = logger_1.default.getInstance();
var nameRegexp = /([\w-]+)/;
exports.dictionary = {
    "/shared/resolver/device-groups": nameRegexp,
};
var keys = Object.keys(exports.dictionary);
exports.getName = function (selfLink) {
    selfLink = selfLink
        .replace("https://localhost/mgmt", "")
        .split("/~")[0]
        .split("?")[0];
    selfLink = selfLink.startsWith("/") ? selfLink : "/" + selfLink;
    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
        var basePath = keys_1[_i];
        if (selfLink.startsWith(basePath)) {
            var name = selfLink.replace(basePath, "");
            name = (name.match(exports.dictionary[basePath]) || [])[1] || "";
            return name;
        }
    }
    return "";
};
exports.getBasePath = function (selfLink) {
    selfLink = selfLink
        .replace("https://localhost/mgmt", "")
        .split("/~")[0]
        .split("?")[0];
    selfLink = selfLink.startsWith("/") ? selfLink : "/" + selfLink;
    for (var _i = 0, keys_2 = keys; _i < keys_2.length; _i++) {
        var basePath = keys_2[_i];
        if (selfLink.startsWith(basePath)) {
            return basePath;
        }
    }
    return "";
};
exports.default = exports.dictionary;


/***/ })
/******/ ]);