OCaml transition scripts
========================

Introduction
------------

The goal is to build a new universe with a new version of OCaml.

Warning: as chroots are involved, some parts of these scripts require
sudo privileges. If you are uncomfortable with that, use a virtual
machine.

Dependencies
------------

    apt install sudo pbuilder devscripts ben

Guide
-----

To start a new transition, run:

    /full/path/to/bin/create-transition.sh $VERSION $BASEPATH

where:

 * `$VERSION` is the new version of OCaml
 * `$BASEPATH` is the path to a directory dedicated to transitions.

A subdirectory `ocaml-$VERSION` will be created in it, and everything
will be done from this new directory which we will call `$BASE` in the
following. A convenience symbolic link `usr` to `/full/path/to` will
be made. A pbuilder chroot will be created in
`build/ocaml-$VERSION.tgz`. The APT repository of the new universe
will be progressively built in `pool`. The pbuilder chroot is set up
to use (and prefer) it.

Source packages are taken from unstable by default. To override that,
put the source package in the `override` directory. Before a package
is built, a new changelog entry is added and `+o1` is appended to the
version.

To initialize (or update) ben's working directory:

    ( cd ben && rm -f ben.cache && ben download -c ../usr/ben/download.ben )

To update the Release file of the new universe:

    touch pool/stamp && make -C pool -f ../usr/lib/Makefile.pool

To sign the Release file before exposing the repository to the world:

    gpg --clearsign < pool/Release > pool/InRelease

Note that this is not necessary for the chroot, it trusts the pool
unconditionally which is fine as packages are generated locally.

To update the chroot:

    sudo usr/bin/update-chroot.sh

To rebuild a specific package in the new universe:

    sudo usr/bin/rebuild.sh $PACKAGE

This will build the package in the chroot, and put the resulting
.changes and related files in the `build` directory. Il will also save
a log to `build/$PACKAGE.log`. To promote these files to the pool:

    dcmd mv -i build/*.changes build/*.log pool

To do a round of compilation of all possible packages:

    ( cd ben && sudo ben rebuild ../usr/ben/rebuild.ben -o ../missing.txt )

This may be very long! and can be interrupted cleanly by creating a
file `build/stop`. An option `-j N` can be given to `ben rebuild` to
allow parallelization with at most `N` simultaneous builds. You might
want to restrict parallelization of the builds themselves with
`OMP_THREAD_LIMIT=1` and/or `parallel=1` in `DEB_BUILD_OPTIONS`.

Additionally, if `BEN_REBUILD_TIMELIMIT` is set, its value will be
used to limit the time taken by a build (the `timelimit` package is
then needed).

For example:

    ( cd ben && sudo env BEN_REBUILD_TIMELIMIT=600 DEB_BUILD_OPTIONS=parallel=1 ben rebuild -j $(nproc) ../usr/ben/rebuild.ben -o ../missing.txt )

Eventually, `missing.txt` will contain the list of failing packages and
their failing dependencies, in Makefile syntax.
