/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl_Pixmap.H>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <util.hpp>

#include <multiline_label_prop.hpp>
#include <paragraph_text_prop.hpp>



extern Fl_Pixmap img_incr_interline_mlabel;
extern Fl_Pixmap img_decr_interline_mlabel;




void paragraph_text_set_l_layout(Fl_Widget* w, void* d){
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  prop->_str->layout_lines(PARAGRAPH_TEXT_ALIGN_LEFT_TEXT_LAYOUT);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}

void paragraph_text_set_c_layout(Fl_Widget* w, void* d){
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  prop->_str->layout_lines(PARAGRAPH_TEXT_ALIGN_CENTER_TEXT_LAYOUT);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}

void paragraph_text_set_r_layout(Fl_Widget* w, void* d){
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  prop->_str->layout_lines(PARAGRAPH_TEXT_ALIGN_RIGHT_TEXT_LAYOUT);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}

void paragraph_text_prop_color_cb(Fl_Widget* w, void* d){
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  if(pushd){
    prop->_str->cr(r);
    prop->_str->cg(g);
    prop->_str->cb(b);
  }
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}

void paragraph_text_prop_ok_cb(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  Fl_Choice* dimensioni=dynamic_cast<Fl_Choice*>(prop->child(2));
  Fl_Choice* i_font=dynamic_cast<Fl_Choice*>(prop->child(1));
  int font_ch=i_font->value(); 
  
  prop->_str->font(font_ch);
  prop->_str->dim(strtol(dimensioni->mvalue()->text,NULL,0));
  prop->_str->update_highligted_text();
  prop->_str->de_highlight();
  prop->_str->can_highlight(true);
  //prop->_str->treat_as_a_whole(true);
  
  ed->redraw();
}

void paragraph_text_prop_canc_cb(Fl_Widget* w, void* d){
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  //prop->_str->treat_as_a_whole(true);
  prop->_str->de_highlight();
  prop->_str->can_highlight(false);
  prop->hide();
}


void paragraph_text_increase_interline(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  int old=prop->_str->interline_space();

  prop->_str->interline_space(old+2);
  ed->redraw();
}

void paragraph_text_decrease_interline(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  int old=prop->_str->interline_space();

  if(old>0){
    prop->_str->interline_space(old-1);
  }
  ed->redraw();
  
}

void paragraph_text_set_current_font_dimension(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  Fl_Choice* dimensioni=dynamic_cast<Fl_Choice*>(prop->child(2));
  prop->_str->dim(strtol(dimensioni->mvalue()->text,NULL,0));
  ed->redraw();
}


void paragraph_text_set_current_font(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  paragraph_text_prop* prop=dynamic_cast<paragraph_text_prop*>(w->parent());
  Fl_Choice* i_font=dynamic_cast<Fl_Choice*>(prop->child(1));
  int font_ch=i_font->value(); 
  prop->_str->font(font_ch);
  ed->redraw();
}

paragraph_text_prop::paragraph_text_prop(paragraph_text* et)
  :Fl_Double_Window(339,144,_("Text properties")),
   _str(et)
{
  et->can_highlight(true);
  initialize_GUI();
  dialog_position(this);
}


paragraph_text_prop::paragraph_text_prop(etichetta* et)
  :Fl_Double_Window(339,144,_("Text properties"))

{

  paragraph_text* m_lb=dynamic_cast<paragraph_text*>(et);
  et->can_highlight(true);

  if(m_lb!=0){
    _str=m_lb;
  }else{
    _str=0;
  }

  initialize_GUI();
  dialog_position(this);
}


void paragraph_text_prop::initialize_GUI(){
  if(_str!=0){

    { 
      Fl_Box* o = new Fl_Box(5, 5, 330, 100); //0
      o->box(FL_ENGRAVED_BOX);
      add(o);
    }
   
    { 
      Fl_Choice* o = new Fl_Choice(90, 15, 145, 20, _("Font:")); //1
      o->down_box(FL_BORDER_BOX);
      o->copy(paragraph_text_prop::_str_font_face);
      o->callback(paragraph_text_set_current_font);
      add(o);
    }
   
   
    { 
      Fl_Choice* o = new Fl_Choice(90, 40, 60, 20, _("Dimension:"));//2
      o->down_box(FL_BORDER_BOX);
      o->copy(paragraph_text_prop::_font_dim_str);
      o->value(8);
      o->callback(paragraph_text_set_current_font_dimension);
      add(o);
    }
   
    Fl_Button* text= new Fl_Button(LARG_BUTTON_DEFAULT, 65, 
                                   LARG_BUTTON_DEFAULT, 
                                   LARG_BUTTON_DEFAULT);//3
    text->type(FL_RADIO_BUTTON);
    text->image(image_lb_normal_str_atom);
    add(text);


    Fl_Button* sup=  new Fl_Button(LARG_BUTTON_DEFAULT*2, 65, 
                                   LARG_BUTTON_DEFAULT, 
                                   LARG_BUTTON_DEFAULT);//4
    sup->type(FL_RADIO_BUTTON);
    sup->image(image_lb_supers);
    add(sup);

    Fl_Button* sub=  new Fl_Button(LARG_BUTTON_DEFAULT*3, 65, 
                                   LARG_BUTTON_DEFAULT, 
                                   LARG_BUTTON_DEFAULT);//5
    sub->type(FL_RADIO_BUTTON);
    sub->image(image_lb_subs);
    add(sub);

    Fl_Button* color=new Fl_Button(LARG_BUTTON_DEFAULT*4, 65, 
                                   LARG_BUTTON_DEFAULT, 
                                   LARG_BUTTON_DEFAULT);//6
    color->image(image_lb_select_font_color);
    color->callback(paragraph_text_prop_color_cb);
    add(color);



    Fl_Button* incr_interline=new Fl_Button(LARG_BUTTON_DEFAULT*5, 65, 
                                            LARG_BUTTON_DEFAULT, 
                                            LARG_BUTTON_DEFAULT);//7


    incr_interline->image(img_incr_interline_mlabel);
    incr_interline->callback(paragraph_text_increase_interline);
    add(incr_interline);

    Fl_Button* decr_interline=new Fl_Button(LARG_BUTTON_DEFAULT*6, 65, 
                                            LARG_BUTTON_DEFAULT, 
                                            LARG_BUTTON_DEFAULT);//8
    decr_interline->image(img_decr_interline_mlabel);
    decr_interline->callback(paragraph_text_decrease_interline);
    add(decr_interline);
    /*
    Fl_Toggle_Button* treat_as_a_whole=new Fl_Toggle_Button(LARG_BUTTON_DEFAULT*7, 65, 
                                                            LARG_BUTTON_DEFAULT, 
                                                            LARG_BUTTON_DEFAULT);//9
    treat_as_a_whole->image(img_group_ungroup_mlabel);
    treat_as_a_whole->callback(paragraph_text_threat_as_a_whole_cb);
    add(treat_as_a_whole);

    */
    Fl_Button* l_align=new Fl_Button(LARG_BUTTON_DEFAULT*8, 65, 
                                                            LARG_BUTTON_DEFAULT, 
                                                            LARG_BUTTON_DEFAULT);//10
    l_align->label("L");
    l_align->callback(paragraph_text_set_l_layout);
    add(l_align);

    Fl_Button* c_align=new Fl_Button(LARG_BUTTON_DEFAULT*9, 65, 
                                                            LARG_BUTTON_DEFAULT, 
                                                            LARG_BUTTON_DEFAULT);//11
    c_align->label("C");
    c_align->callback(paragraph_text_set_c_layout);
    add(c_align);

    Fl_Button* r_align=new Fl_Button(LARG_BUTTON_DEFAULT*10, 65, 
                                                            LARG_BUTTON_DEFAULT, 
                                                            LARG_BUTTON_DEFAULT);//12
    r_align->label("R");
    r_align->callback(paragraph_text_set_r_layout);
    add(r_align);


    Fl_Button* ok= new Fl_Return_Button(w()/2-LARG_BUTTON_DEFAULT*3, 109, 
                                        LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Apply"));//13
    ok->callback(paragraph_text_prop_ok_cb);
    add(ok);


    Fl_Button* ann=new Fl_Button(w()/2, 109, LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Done"));//14
    ann->callback(paragraph_text_prop_canc_cb);
    add(ann);


    end();
  
    set_non_modal();
    _str->draw_cursor(true);
  }
}

paragraph_text_prop::~paragraph_text_prop(){

}

int paragraph_text_prop::handle(int e){
  if(_str!=0){
    editor* ed=dynamic_cast<editor*>(MainWindow);
    Fl_Double_Window::handle(e);

    Fl_Button* apic=dynamic_cast<Fl_Button*>(child(4));
    Fl_Button* pedic=dynamic_cast<Fl_Button*>(child(5));

    switch(e){
    case FL_KEYDOWN:
      {

        string car;

        if(Fl::event_state(FL_SHIFT)){
          car=toupper(Fl::event_text()[0]);
        }else{
          car=Fl::event_text()[0];
        }
       
        if(Fl::event_key(FL_Delete)){ //cancellare il successivo
          _str->delete_char_curr_pos(false);
        }else if(car=="\b"){//cancellare il precedente
          _str->delete_char_curr_pos(true);
        }else if(isprint(car[0])){
          if(apic->value()){
            _str->insert_string_in_curr_pos(car,ET_APICE);
          }else if(pedic->value()){
            _str->insert_string_in_curr_pos(car,ET_PEDICE);
          }else{
            _str->insert_string_in_curr_pos(car,ET_STR);
          }
        }else if(Fl::event_key()==FL_Left){
          if(Fl::event_state(FL_SHIFT)){
            _str->invert_highlight_child_and_shift_cursor(false);
          }else{
            int currtype=0;
            _str->cursor_one_step_back(currtype);
            update_widget_cursor();
          }
        }else if(Fl::event_key()==FL_Right){
          if(Fl::event_state(FL_SHIFT)){
            _str->invert_highlight_child_and_shift_cursor(true);
          }else{
            int currtype=0;
            _str->cursor_one_step_fwd(currtype);
            update_widget_cursor();
          }
        }else if(Fl::event_key()==FL_Up){
          int ctype=0;
          _str->cursor_one_step_up(ctype);
        }else if(Fl::event_key()==FL_Down){
          int ctype=0;
          _str->cursor_one_step_down(ctype);
        }else if(Fl::event_key()==FL_Enter){
         
          multifont_label* l=0;
          multifont_label* r=0;
          etichetta* p_l=l;
          etichetta* p_r=r;
          _str->break_and_split_normal_str(&p_l , &p_r);
        }else if(Fl::event_key()==FL_End){
          //_str->highlight_child(false);
          //_str->dim_child(80);
          //_str->font_child(8);
          int ctype=0;
          if(Fl::event_state(FL_SHIFT)){
            _str->highlight_current_line();
            _str->go_to_end_of_line();
            _str->cursor_one_step_fwd(ctype);
          }else if(Fl::event_state(FL_CTRL)){
            _str->go_to_end_of_label();
          }else{
            _str->go_to_end_of_line();
          }
        }else if(Fl::event_key()==FL_Home){
          int ctype=0;
          if(Fl::event_state(FL_SHIFT)){
            _str->dehighlight_current_line();
            _str->go_to_start_of_line();
            _str->cursor_one_step_back(ctype);
            _str->pointer_to_currline_transl(-1);
          }else if(Fl::event_state(FL_CTRL)){
            _str->go_to_start_of_label();
          }else{
            _str->go_to_start_of_line();
          }
        }else if(Fl::event_key()==FL_Insert){

          //_str->highlight_child(true);
      
        }

        ed->redraw();
        return 1;
      
      }
    default:
      return 0; 
  
    }
    
  }else{
    return 0;
  }
}


void paragraph_text_prop::update_widget_cursor(){
  int cr_f=0;
  int cg_f=0;
  int cb_f=0;
  int dim_f=0;
  int font_f=0;
  _str->query_child(&cr_f, &cg_f, &cb_f,
                    &font_f, &dim_f,
                    NULL,NULL);
  
  Fl_Choice* dim_w=dynamic_cast<Fl_Choice*>(child(2));
  Fl_Choice* font_w=dynamic_cast<Fl_Choice*>(child(1));
  Fl_Menu_Item min_s=paragraph_text_prop::_font_dim_str[0];
  int min_i=strtod(min_s.text,NULL);
  dim_w->value(dim_f - min_i);
  font_w->value(font_f);
}

void paragraph_text_prop::highlight_text(){
  _str->increase_highlighted();
}

void paragraph_text_prop::de_highlight_text(){
  _str->decrease_highlighted();
}

const int paragraph_text_prop::_button_mouse_highlight=FL_LEFT_MOUSE;

const Fl_Menu_Item paragraph_text_prop::_str_font_face[] = {
    {"helvetica", 0, 0, 0,},
    {"helvetica bold", 0, 0, 0,},
    {"helvetica italic", 0, 0, 0,},
    {"helvetica bold italic", 0, 0, 0,},
    
    {"courier", 0, 0, 0,},
    {"courier bold", 0, 0, 0,},
    {"courier italic", 0, 0, 0,},
    {"courier bold italic", 0, 0, 0,},
    
    {"times", 0, 0, 0,},
    {"times bold", 0, 0, 0,},
    {"times italic", 0, 0, 0,},
    {"times bold italic", 0, 0, 0,},
    
    {"symbol", 0, 0, 0,},
    
    {"screen", 0, 0, 0,},
    {"screen bold", 0, 0, 0,},
    
    {"zapf dingbats", 0, 0, 0,},
    
    {0}
  };


const Fl_Menu_Item paragraph_text_prop::_font_dim_str[]={
    {"5", 0, 0, 0,},
    {"6", 0, 0, 0,},
    {"7", 0, 0, 0,},
    {"8", 0, 0, 0,},
    {"9", 0, 0, 0,},
    {"10", 0, 0, 0,},
    {"11", 0, 0, 0,},
    {"12", 0, 0, 0,},
    {"13", 0, 0, 0,},
    {"14", 0, 0, 0,},
    {"15", 0, 0, 0,},
    {"16", 0, 0, 0,},
    {"17", 0, 0, 0,},
    {"18", 0, 0, 0,},
    {"19", 0, 0, 0,},
    {"20", 0, 0, 0,},
    {"21", 0, 0, 0,},
    {"22", 0, 0, 0,},
    {"23", 0, 0, 0,},
    {"24", 0, 0, 0,},
    {"25", 0, 0, 0,},
    {"26", 0, 0, 0,},
    {"27", 0, 0, 0,},
    {"28", 0, 0, 0,},
    {"29", 0, 0, 0,},
    {"30", 0, 0, 0,},
    {"31", 0, 0, 0,},
    {"32", 0, 0, 0,},
    {"33", 0, 0, 0,},
    {"34", 0, 0, 0,},
    {"35", 0, 0, 0,},
    {"36", 0, 0, 0,},
    {"37", 0, 0, 0,},
    {"38", 0, 0, 0,},
    {"39", 0, 0, 0,},
    {"40", 0, 0, 0,},
    {"41", 0, 0, 0,},
    {"42", 0, 0, 0,},
    {"43", 0, 0, 0,},
    {"44", 0, 0, 0,},
    {"45", 0, 0, 0,},
    {"46", 0, 0, 0,},
    {"47", 0, 0, 0,},
    {"48", 0, 0, 0,},
    {"49", 0, 0, 0,},
    {0}
  };




 
