//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Data/ID.h
//! @brief     Defines shared enums
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2023
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_DATA_ID_H
#define BORNAGAIN_GUI_SUPPORT_DATA_ID_H

namespace GUI::ID {

//! The possible states of a projection type.
enum ProjectionType { Horizontal, Vertical, Invalid };

//! Which distributions should be available in the selector
enum class Distributions { All, Symmetric };

//! Enumerates views of the main window
enum ViewId { Projects, Instrument, Sample, Import, Simulation, Job };

} // namespace GUI::ID

#endif // BORNAGAIN_GUI_SUPPORT_DATA_ID_H
