#!/usr/bin/env python
#
# Copyright (c) 2008 Patryk Zawadzki <pzawadzki@gnome.org>
# Based on an idea and Ruby script by Jakub Steiner
#
# Licensed under LGPL v3+ (http://www.gnu.org/copyleft/lesser.html)
#
#Renders the one-canvas source SVG into individual bitmaps. Run without parameters to get all the svgs in ./source_svg rendered. Pass a specific name to get just that one SVG rendered.#!/usr/bin/env python

from xml.dom.minidom import parse
from xml.dom.minidom import Node
import os
import sys

INKSCAPE = 'inkscape'
SRC = os.path.join(os.getcwd(), 'source_svg')
OUTPUT = os.path.join(os.getcwd(), '')
RENDERED = os.path.join(os.getcwd(), 'source_svg', 'rendered')

def renderIt(template):
	print 'Rendering %s...' % template
	doc = parse(template)
	groups = doc.getElementsByTagName('g')
	layers = [g for g in groups if g.getAttribute("inkscape:groupmode") == 'layer']
	icons = []
	platemap = {}
	# split layers and plates
	for l in layers:
		lname = l.getAttribute('inkscape:label')
		print '\tProcessing Layer: %s' % lname
		if '/' in lname:
			if lname[:6] == 'plate:':
				# one plate per icon
				platemap[lname[6:]] = l
				print '\t\tSetting plate "%s"' % lname[6:]
			else:
				icons.append(lname)
				print '\t\tSetting icon "%s"' % lname
		elif lname == 'plate':
			# one plate to rule them all
			if platemap.has_key('-'):
				print '\t\tDANGER! DANGER! Will Robinson! Multiple master plates!'
			platemap['-'] = l
			print '\t\tSetting master plate'
	for name in icons:
		# for each icon
		if platemap.has_key(name):
			# find a suitable plate
			plate = platemap[name]
		else:
			# or fall back to the generic plate
			plate = platemap['-']
		basedir = os.path.split(name)[0]
		sizes = plate.getElementsByTagName('rect')
		for s in sizes:
			rectid = s.getAttribute('id')
			width = s.getAttribute('width')
			height = s.getAttribute('height')
			if s.getAttribute('inkscape:label') == 'scalable':
				dirname = u'scalable/%s' % basedir
			else:
				dirname = u'%sx%s/%s' % (width, height, basedir)
			dirname = OUTPUT + os.sep + dirname
			if not os.path.exists(dirname):
				os.makedirs(dirname)
			if s.getAttribute('inkscape:label') == 'scalable':
				fname = u'scalable/%s.svg' % name
			else:
				fname = u'%sx%s/%s.png' % (width, height, name)
			fname = OUTPUT + os.sep + fname

			if s.getAttribute('inkscape:label') == 'scalable':
				print '\tWriting size scalable'
				# make a copy to work with
				cmd = u'cp -f "%s" "%s"' % (template, fname)
				os.system(cmd)

				# Reposition the canvas for the scalable area
				print '\t\tResizing canvas (' + rectid + ')'
				cmd = u'%s --select=%s --verb=FitCanvasToSelection --verb=EditDelete --verb=FileSave --verb=FileClose "%s"' % (INKSCAPE, rectid, fname)
				os.system(cmd)

				# Remove all groups and unlink clones
				# print '\t\tRemoving groups and clones'
				# cmd = u'%s --verb="EditSelectAll" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="SelectionUnGroup" --verb="EditUnlinkClone" --verb=FileSave --verb=FileClose %s' % (INKSCAPE, fname)
				# os.system(cmd)

				# Get the list of objects -- and their bounding box
				print '\t\tCalculating Bounding Boxes'
				cmd = u'%s --query-all "%s"' % (INKSCAPE, fname)
				stdout = os.popen(cmd)
				deletables = []
				for id in stdout:
					delete = False

					boundingbox = id.split(',')
					boundingbox[4] = boundingbox[4][:-1] # newline removal

					id_x = float(boundingbox[1])
					id_y = float(boundingbox[2])

					id_width = float(boundingbox[3])
					id_height = float(boundingbox[4])

					if id_x < 0.0 and id_x + id_width < 0.0:
						delete = True
					if id_x > float(width):
						delete = True
					if id_y < 0.0 and id_y + id_height < 0.0:
						delete = True
					if id_y > float(height):
						delete = True

					if delete:
						deletables.append(boundingbox[0])
						# print "Marking for delete: " + boundingbox[0] + " x: " + str(id_x) + " y: " + str(id_y) + "   " + str(id_width) + "x" + str(id_height)

				print '\t\tDeleting nodes outside canvas  ' + width + 'x' + height
				newdoc = parse(fname)
				stack = [newdoc.documentElement]
				while stack:
					node = stack.pop()
					stack.extend(node.childNodes)
					if node.nodeType is Node.ELEMENT_NODE and node.getAttribute('id') in deletables and not node.tagName == 'g':
						node.parentNode.removeChild(node)

				fileout = open(fname, "w")
				newdoc.writexml(fileout)
				fileout.close()

				# Removing extra defs
				print '\t\tVacuuming defs'
				cmd = u'%s --vacuum-defs "%s"' % (INKSCAPE, fname)
				os.system(cmd)
						
			else:
				print '\tWriting size %sx%s (%s)' % (width, height, s.getAttribute('inkscape:label'))
				cmd = u'mkdir -p %s' % (os.sep.join(fname.split(os.sep)[0:-1]))
				# print '\t\tMaking directory: %s' % (cmd)
				os.popen(cmd)
				cmd = u'%s -i "%s" -e "%s" "%s"' % (INKSCAPE, rectid, fname, template)
				# print '\t\tBuilding image: %s' % (cmd)
				os.popen(cmd)
	#build out a render of the whole thing
	renderedfile = RENDERED + os.sep + '.'.join(template.split(os.sep)[-1].split('.')[0:-1]) + '.png'
	print '\tRendering full file (%s)' % (renderedfile)
	cmd = u'%s -e "%s" "%s"' % (INKSCAPE, renderedfile, template)
	os.popen(cmd)

if __name__ == '__main__':
	cmd = u'mkdir -p %s' % (OUTPUT)
	os.popen(cmd)

	cmd = u'mkdir -p %s' % (RENDERED)
	os.popen(cmd)

	args = sys.argv[1:]
	if args:
		for a in args:
			renderIt(a)
	else:
		for root, dirs, files in os.walk(SRC):
			for f in files:
				if os.path.splitext(f)[1] == '.svg':
					renderIt(os.path.join(root, f))
