#!/usr/local/gnu/bin/perl

#
# Layout of trajectory events:
#
# N:
# x1 y1 t1
# x2 y2 t2
# ...
#

$xhi = 0.002;
$ylo = 0.03;
$yhi = 0.04;

print STDERR "Searching for trajectories in [(0,$ylo),($xhi,$yhi)] ...\n";

sub numerically { $a <=> $b; }

%SUM = ();

$N = 0;

TRAJ;

while (<>)
{
    if (/^[0-9]+:$/)
    {
        substr($_,-2) = "";
        
        $N = $_;
    }
    else
    {
        ($a,$b,$c) = split(' ', $_);

        if ($a <= $xhi && $ylo <= $b && $b <= $yhi)
        {
            $SUM{$N}++;
        }
    }
}

foreach $key (sort numerically keys %SUM)
{
    print $key, "\n";
}
