/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::sepCheckNeg__option_t::type& Options::operator[](
    options::sepCheckNeg__option_t) const
{
  return d_holder->sepCheckNeg;
}
template <> bool Options::wasSetByUser(options::sepCheckNeg__option_t) const
{
  return d_holder->sepCheckNeg__setByUser__;
}
template <> const options::sepChildRefine__option_t::type& Options::operator[](
    options::sepChildRefine__option_t) const
{
  return d_holder->sepChildRefine;
}
template <> bool Options::wasSetByUser(options::sepChildRefine__option_t) const
{
  return d_holder->sepChildRefine__setByUser__;
}
template <> const options::sepDisequalC__option_t::type& Options::operator[](
    options::sepDisequalC__option_t) const
{
  return d_holder->sepDisequalC;
}
template <> bool Options::wasSetByUser(options::sepDisequalC__option_t) const
{
  return d_holder->sepDisequalC__setByUser__;
}
template <> const options::sepExp__option_t::type& Options::operator[](
    options::sepExp__option_t) const
{
  return d_holder->sepExp;
}
template <> bool Options::wasSetByUser(options::sepExp__option_t) const
{
  return d_holder->sepExp__setByUser__;
}
template <> const options::sepMinimalRefine__option_t::type& Options::operator[](
    options::sepMinimalRefine__option_t) const
{
  return d_holder->sepMinimalRefine;
}
template <> bool Options::wasSetByUser(options::sepMinimalRefine__option_t) const
{
  return d_holder->sepMinimalRefine__setByUser__;
}
template <> const options::sepPreSkolemEmp__option_t::type& Options::operator[](
    options::sepPreSkolemEmp__option_t) const
{
  return d_holder->sepPreSkolemEmp;
}
template <> bool Options::wasSetByUser(options::sepPreSkolemEmp__option_t) const
{
  return d_holder->sepPreSkolemEmp__setByUser__;
}


namespace options {

struct sepCheckNeg__option_t sepCheckNeg;
struct sepChildRefine__option_t sepChildRefine;
struct sepDisequalC__option_t sepDisequalC;
struct sepExp__option_t sepExp;
struct sepMinimalRefine__option_t sepMinimalRefine;
struct sepPreSkolemEmp__option_t sepPreSkolemEmp;


}  // namespace options
}  // namespace CVC4
