/* Copyright (C) 2007  db4objects Inc.  http://www.db4o.com */

package enhancement.model;

import java.util.*;

import tacustom.*;

@Db4oPersistent

public class MaintenanceQueue<Item> {

	public MaintenanceQueue<Item> _next;
	
	private Item _value;

	public MaintenanceQueue(Item value) {
		_value = value;
	}

	public static MaintenanceQueue<Integer> newList(int depth) {
		if (depth == 0) {
			return null;
		}
		MaintenanceQueue<Integer> head = new MaintenanceQueue<Integer>(depth);
		head._next = newList(depth - 1);
		return head;
	}

	/**
	 * Overrides this method to assert that <code>other</code> is only
	 * activated with depth 1.
	 */
	@SuppressWarnings("unchecked")
	public boolean equals(Object other) {
		return ((MaintenanceQueue<Item>) other)._next == null;
	}

	public boolean hasNext() {
		return _next != null;
	}

	public MaintenanceQueue<Item> next() {
		return _next;
	}

	public int size() {
		if(_next == null) {
			return 1;
		}
		return _next.size() + 1;
	}
	
	public Item get(int idx) {
		if(idx == 0) {
			return value();
		}
		return _next.get(idx - 1);
	}

	public Item value() {
		return _value;
	}
	
	public void add(Item item) {
		if(_next != null) {
			_next.add(item);
		}
		else {
			_next = new MaintenanceQueue<Item>(item);
		}
	}
	
	public Iterator<Item> iterator() {
		return new LinkedListIterator<Item>(this);
	}
	
	public String toString() {
		return "LinkedList: " + _value;
	}
	
	public static <Item> MaintenanceQueue<Item> add(MaintenanceQueue<Item> list, Item item) {
		if(list == null) {
			return new MaintenanceQueue<Item>(item);
		}
		list.add(item);
		return list;
	}

	private final static class LinkedListIterator<Item> implements Iterator<Item> {
		private MaintenanceQueue<Item> _current;
		
		public LinkedListIterator(MaintenanceQueue<Item> list) {
			_current = list;
		}

		public boolean hasNext() {
			return _current != null;
		}

		public Item next() {
			Item item = _current.value();
			_current  = _current.next();
			return item;
		}

		public void remove() {
			throw new UnsupportedOperationException();
		}
	}

	public static <Item> Iterator<Item> iterator(MaintenanceQueue<Item> list) {
		return (list == null ? new LinkedListIterator<Item>(null) : list.iterator());
	}

}
