" Vim syntax file
" Language: DDTP files - common definitions
" Maintainer: Lorenzo Cappelletti <lorenzo.cappelletti@email.it>
" Last Change: Tue,  5 Aug 2003 19:46:14 +0200
"
" This is a hack of the ddts and ddtc syntax files from DDTP - the Debian
" Description Translation Project.
"
" Original work based on the script of Fabio Bonelli <fabiobonelli@libero.it>,
" Emanuele Aina <emanuele.aina@tiscali.it>, and Nicolas Bertolissio
" <nico.bertol@free.fr>.
"
" Contributions:
"   Matteo Cortese <mfc@bronto.sauro.it>
"   Cristian Rigamonti <cri@linux.it>

" This script checks the ddts_nofolding variable to disable the folding
" method based on the syntax regions.

" To deal with complex DDTP's file syntaxes and to achieve a high
" customization, the scripts are deeply modular.  Since there are two types
" of syntax, one from the server and one from the client, there are also
" two entry files, which in turn include other files.
"
"   ddtpSrv.vim
"     \
"      \-- ddtpSrvXx.vim ------\
"       \                       \
"        \-- ddtpCom.vim      ddtpComXx.vim
"       /                       /
"      /-- ddtpCliXx.vim ------/
"     /
"   ddtpCli.vim
"
" ddtp(Cli|Srv).vim  : entry points for server and client syntax, respectively.
" ddtpCom.vim        : shared definitions for ddtp(Cli|Srv).vim.
" ddtp(Cli|Srv)Xx.vim: Xx language specific highlighting (ddtp(Cli|Srv)Xx_XX.vim
"                      is also possibile).
" ddtpComXx.vim      : shared definitions for ddtp(Cli|Srv)??.vim
"
" Hence, you can customize the highlighting for your language by:
" - creating three new files named ddtp(Cli|Srv|Com)Xx.vim or
"   ddtp(Cli|Srv|Com)Xx_XX.vim;
" - copying the "Generic translation" block ddtp(Cli|Srv|Com)Xx from
"   ddtp(Cli|Srv|Com).vim files;
" - substituting "Xx" for your 2-letter langauge id;
" - defining customized syntax match rules (see other langauges as an example);
" - using/modifing ddtpCom.vim if you want to share your syntax rules with
"   other languages.


" For version 5.x: clear all syntax items
" For version 6.x: quit when a syntax file was already loaded
if version < 600
   syntax clear
elseif exists("b:current_syntax")
   finish
endif


" We use some color definition of diff.vim
source $VIMRUNTIME/syntax/diff.vim

" Case-sensitive
syntax	case	match


" Pseudo-header
syntax match  ddtpComHeaderArg	/: .*$/		contained contains=ddtpComEmail

" Email
syntax match  ddtpComEmail	/[-<\.+_a-zA-Z0-9]\+@[-\.a-zA-Z0-9>]\+/	contained contains=ddtpComEmailSym
syntax match  ddtpComEmailSym	/[<@>]/					contained

" Synopsis
syntax match  ddtpComSynpKey
	\ /^Description\(-\l\l\(_\u\u\)\?\)\?: /
	\ nextgroup=ddtpComErrLongSynp
	\ contained

" Todo
syntax match  ddtpComTodo	/<trans>/	contained

" Splitting dot
syntax match  ddtpComDot
	\ /^ \.$/
	\ contained


" Generic Errors
syntax cluster  ddtpComErrSynp  contains=ddtpComErrWSpaceTab,ddtpComErrWSpaceMultiWord,
	\ddtpComErrWSpaceTrailing,ddtpComErrLongSynp
syntax cluster  ddtpComErrPara  contains=ddtpComErrDescDot,ddtpComErrWSpaceTab,ddtpComErrWSpaceMultiWord,
	\ddtpComErrWSpaceLeading,ddtpComErrWSpaceTrailing,ddtpComErrLongDesc

syntax match  ddtpComErrSynpTrailingDot	/\.\s*$/		contained  " Trailing dot in synopsis

syntax match  ddtpComErrDescDot		/^ \.\zs.\+/		contained  " Garbage after desc dot

syntax match  ddtpComErrWSpaceTab	/\t/			contained  " Tabs not allowed
syntax match  ddtpComErrWSpaceLeading	/^[^ #>+]/		contained  " No leading whitespaces
syntax match  ddtpComErrWSpaceTrailing	/ \+$/			contained  " Trailing whitespaces
syntax match  ddtpComErrWSpaceMultiWord	/\(\>\|[,;:]\) \zs \+/	contained  " Multiple whitespaces between words
syntax match  ddtpComErrWSpaceMultiWord	/[.!?]  \zs \+/		contained
syntax match  ddtpComErrWSpaceMultiSent	/[^ ] \zs \+/		contained  " Multiple whitesapces between sentences
syntax match  ddtpComErrWSpacePunct	/ \+[:,;?!]/		contained  " No whitespaces before punctuations

syntax match  ddtpComErrLongSynp	/.*/ms=s+80		contained
syntax match  ddtpComErrLongDesc	/^[ #].*/ms=s+80	contained



" Highlighting
highlight ddtpComEmail 		ctermfg=DarkBlue
				\ guifg=DarkBlue
highlight ddtpComEmailSym	ctermfg=DarkMagenta
				\ guifg=DarkMagenta
highlight ddtpComCommPerm	ctermfg=Grey		ctermbg=DarkBlue
				\ guifg=Grey		  guibg=DarkBlue

highlight def link ddtpComHeaderKey		Identifier
highlight def link ddtpComHeaderArg		NonText
highlight def link ddtpComSynpKey		Keyword
highlight def link ddtpComTodo			Todo
highlight def link ddtpComDot			Type
highlight def link ddtpComCommServ		Comment
highlight def link ddtpComErr			Error
highlight def link ddtpComErrLongDesc		ddtpComErr
highlight def link ddtpComErrLongSynp		ddtpComErr
highlight def link ddtpComErrDescDot		ddtpComErr
highlight def link ddtpComErrSynpTrailingDot	ddtpComErr
highlight def link ddtpComErrWSpaceTab		ddtpComErr
highlight def link ddtpComErrWSpaceLeading	ddtpComErr
highlight def link ddtpComErrWSpaceTrailing	ddtpComErr
highlight def link ddtpComErrWSpaceMultiSent	ddtpComErr
highlight def link ddtpComErrWSpaceMultiWord	ddtpComErr
highlight def link ddtpComErrWSpacePunct	ddtpComErr
