# Authors:
#     Endi S. Dewata <edewata@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2014 Red Hat, Inc.
# All rights reserved.
#

from __future__ import absolute_import
import os
import sys
import subprocess

import pki.server.upgrade


class AddedRESTEasyClient(pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super(AddedRESTEasyClient, self).__init__()
        self.message = 'Added RESTEasy client'

    def upgrade_instance(self, instance):

        # Tomcat common library
        common_lib = os.path.join(instance.base_dir, 'common', 'lib')

        # RESTEasy library
        resteasy_lib = subprocess.check_output(
            '. /usr/share/pki/etc/pki.conf && . /etc/pki/pki.conf && echo $RESTEASY_LIB',
            shell=True)
        resteasy_lib = resteasy_lib.decode(sys.getfilesystemencoding())
        # workaround for pylint error E1103
        resteasy_lib = resteasy_lib.strip()

        # create new links
        source = os.path.join(resteasy_lib, 'resteasy-client.jar')
        link = os.path.join(common_lib, 'resteasy-client.jar')
        self.create_link(instance, source, link)

    def create_link(self, instance, source, link):

        self.backup(link)
        os.symlink(source, link)
        os.lchown(link, instance.uid, instance.gid)
