/* XXX, check includes */
#include <stdio.h>
#include <signal.h>
#include <pcap.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define SIZE_ETHERNET 14 /* ethernet headers are always exactly 14 bytes [1] */
#define ETHER_ADDR_LEN 6 /* Ethernet addresses are 6 bytes */

struct ethhdr { /* Ethernet header */
	u_char	ether_dhost[ETHER_ADDR_LEN];	/* destination host address */
	u_char	ether_shost[ETHER_ADDR_LEN];	/* source host address */
	u_short ether_type;			/* IP? ARP? RARP? etc */
};

/* from tcpdump sll.h */

#define SIZE_SLL	16		/* total header length */
#define SLL_ADDRLEN	8		/* length of address field */

struct sll_header {
	u_gint16	sll_pkttype;	/* packet type */
	u_gint16	sll_hatype;	/* link-layer address type */
	u_gint16	sll_halen;	/* link-layer address length */
	u_gint8	sll_addr[SLL_ADDRLEN];	/* link-layer address */
	u_gint16	sll_protocol;	/* protocol */
};

struct iphdr { /* IP header */
//	  u_char  ip_vhl;		  /* version << 4 | header length >> 2 */
	unsigned int ip_hl:4;		    /* header length */
	unsigned int ip_v:4;		    /* version */
	
	u_char	ip_tos;			/* type of service */
	u_short ip_len;			/* total length */
	u_short ip_id;			/* identification */
	u_short ip_off;			/* fragment offset field */
	#define IP_RF 0x8000		/* reserved fragment flag */
	#define IP_DF 0x4000		/* dont fragment flag */
	#define IP_MF 0x2000		/* more fragments flag */
	#define IP_OFFMASK 0x1fff	/* mask for fragmenting bits */
	u_char	ip_ttl;			/* time to live */
	u_char	ip_p;			/* protocol */
	u_short ip_sum;			/* checksum */
	struct	in_addr ip_src,ip_dst;	/* source and dest address */
};

typedef u_int tcp_seq;

struct tcphdr { /* TCP header */
	u_short th_sport;		/* source port */
	u_short th_dport;		/* destination port */
	tcp_seq th_seq;			/* sequence number */
	tcp_seq th_ack;			/* acknowledgement number */
	u_char	th_offx2;		/* data offset, rsvd */
#define TH_OFF(th)	(((th)->th_offx2 & 0xf0) >> 4)
	u_char	th_flags;
	u_short th_win;			/* window */
	u_short th_sum;			/* checksum */
	u_short th_urp;			/* urgent pointer */
};

#define TH_FIN	0x01
#define TH_SYN	0x02
#define TH_RST	0x04
#define TH_PUSH 0x08
#define TH_ACK	0x10
#define TH_URG	0x20
#define TH_ECE	0x40
#define TH_CWR	0x80

#define TH_FLAGS	(TH_FIN|TH_SYN|TH_RST|TH_ACK|TH_URG|TH_ECE|TH_CWR)

struct udphdr {	/* UDP header */
	u_short th_sport;		/* source port */
	u_short th_dport;		/* destination port */
	u_short th_len;			/* length */
	u_short th_sum;			/* checksum */
};

struct icmphdr { /* ICMP header */
	u_char icmp_type;
	u_char icmp_code;
	u_short icmp_cksum;
};

#define	ETHERTYPE_IP		0x0800		/* IP */
#define	ETHERTYPE_ARP		0x0806		/* Address resolution */

