/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

inline Foam::pointConstraint::pointConstraint()
:
    Tuple2<label, vector>(0, vector::zero)
{}


inline Foam::pointConstraint::pointConstraint(Istream& is)
:
    Tuple2<label, vector>(is)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::pointConstraint::applyConstraint(const vector& cd)
{
    if (first() == 0)
    {
        first() = 1;
        second() = cd;
    }
    else if (first() == 1)
    {
        vector planeNormal = cd ^ second();
        scalar magPlaneNormal = mag(planeNormal);

        if (magPlaneNormal > 1e-3)
        {
            first() = 2;
            second() = planeNormal/magPlaneNormal;
        }
    }
    else if (first() == 2)
    {
        if (mag(cd & second()) > 1e-3)
        {
            first() = 3;
            second() = vector::zero;
        }
    }
}


Foam::tensor Foam::pointConstraint::constraintTransformation() const
{
    if (first() == 0)
    {
        return I;
    }
    else if (first() == 1)
    {
        return I - sqr(second());
    }
    else if (first() == 2)
    {
        return sqr(second());
    }
    else
    {
        return tensor::zero;
    }
}


// ************************ vim: set sw=4 sts=4 et: ************************ //
