/* -----------------------------------------------------------------------------
 *
 * Giada - Your Hardcore Loopmachine
 *
 * -----------------------------------------------------------------------------
 *
 * Copyright (C) 2010-2021 Giovanni A. Zuliani | Monocasual
 *
 * This file is part of Giada - Your Hardcore Loopmachine.
 *
 * Giada - Your Hardcore Loopmachine is free software: you can
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * -------------------------------------------------------------------------- */

#include "graphics.h"

const char* giada_logo_xpm[] = {
    "245 86 12 1",
    " 	c #191919",
    ".	c #303030",
    "+	c #404040",
    "@	c #454545",
    "#	c #5A5A5A",
    "$	c #686868",
    "%	c #818181",
    "&	c #9C9C9C",
    "*	c #B8B8B8",
    "=	c #CDCDCD",
    "-	c #DDDDDD",
    ";	c #FEFEFE",
    "                                   ...+++@@@@++...                                                                                                                                                                                                   ",
    "                               .+@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                               ",
    "                            .+@@@@@@@@@@@@@@@@@@@@@@@@@@+.                                                                                                                                                                                           ",
    "                         .+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                         ",
    "                       .+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                       ",
    "                      @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                     ",
    "                    +@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                   ",
    "                  .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+                                                                                                                                                                                  ",
    "                 .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                ",
    "                @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                               ",
    "               @@@@@@@@@@@@@@@@@@++$*--;;;;;;;;-=&@+@@@@@@@@@@@@@@@@@@+                                                                                                                                                                              ",
    "             .@@@@@@@@@@@@@@@@+#&=;;;;;;;;;;;;;;;;;-*%++@@@@@@@@@@@@@@@+                                                                                                                                                                             ",
    "            .@@@@@@@@@@@@@@@@$=;;;;;;;;;;;;;;;;;;;;;;;;&#+@@@@@@@@@@@@@@@                                                                                                                                                                            ",
    "           .@@@@@@@@@@@@@@@$;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*@@@@@@@@@@@@@@@@                                                                                                                                                                           ",
    "           @@@@@@@@@@@@@@#-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*+@@@@@@@@@@@@@+                                                                                                                                                                          ",
    "          @@@@@@@@@@@@@+*;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;$+@@@@@@@@@@@@+                                                                                                                                                                         ",
    "         @@@@@@@@@@@@@#-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;&@@@@@@@@@@@@@.                                                                                                                                                                        ",
    "        .@@@@@@@@@@@@$;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-+@@@@@@@@@@@@                                                                                                                                                                        ",
    "       .@@@@@@@@@@@+%;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-@@@@@@@@@@@@@                                                                                                                                                                       ",
    "       @@@@@@@@@@@+&;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;#@@@@@@@@@@@.                                                                                                                                                                      ",
    "      +@@@@@@@@@@@%;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;@@@@@@@@@@@@                                                                                                                                                                      ",
    "      @@@@@@@@@@@$;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-+@@@@@@@@@@+                                                                                                                                                                     ",
    "     @@@@@@@@@@@#;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;=@@@@@@@@@@@.                                                                                                                                                                    ",
    "    .@@@@@@@@@@+-;;;;;;;;;;;;;;;;;;;;;=*&%%%%&*-;;;;;;;;;;;;;;;;;;;;;%+@@@@@@@@@@                                                                                                                                                                    ",
    "    +@@@@@@@@@@*;;;;;;;;;;;;;;;;;;;-%++@@@@@@@++@*-;;;;;;;;;;;;;;;;;;;#@@@@@@@@@@.                                                                                                                                                                   ",
    "   .@@@@@@@@@@#;;;;;;;;;;;;;;;;;;=@@@@@@@@@@@@@@@@@$;;;;;;;;;;;;;;;;;;=+@@@@@@@@@@                                                                                                                                                                   ",
    "   +@@@@@@@@@@-;;;;;;;;;;;;;;;;-$+@@@@@@@@@@@@@@@@@@@&;;;;;;;;;;;;;;;;;%@@@@@@@@@@.                        %*------=*%.              $%%%%%%%                $%%%%%%%%.               #%%%%%%%%%%%%%%$@                         %%%%%%%%%            ",
    "   @@@@@@@@@@%;;;;;;;;;;;;;;;;*@@@@@@@@@@@@@@@@@@@@@@+$;;;;;;;;;;;;;;;;-+@@@@@@@@@+                     #=;;;;;;;;;;;;;=$           .;;;;;;;;&              &;;;;;;;;;;               ;;;;;;;;;;;;;;;;;;-&#                    -;;;;;;;;;=           ",
    "  .@@@@@@@@@@;;;;;;;;;;;;;;;;*+@@@@@@@@@@@@@@@@@@@@@@@@@;;;;;;;;;;;;;;;;%@@@@@@@@@@                   .=;;;;;;;;;;;;;;;;;;#         +;;;;;;;;*              ;;;;;;;;;;;&             .;;;;;;;;;;;;;;;;;;;;;;@                 .;;;;;;;;;;;.          ",
    "  +@@@@@@@@@%;;;;;;;;;;;;;;;*@@@@@@@@@@@@@@@@@@@@@@@@@@@@;;;;;;;;;;;;;;;;@@@@@@@@@@.                 @;;;;;;;;;;;;;;;;;;;;;*        +;;;;;;;;*             +;;;;;;;;;;;;             .;;;;;;;;;;;;;;;;;;;;;;;*                &;;;;;;;;;;;*          ",
    "  @@@@@@@@@+-;;;;;;;;;;;;;;*+@@@@@@@@@@@@@@@@@@@@@@@@@@@@#;;;;;;;;;;;;;;;$@@@@@@@@@+                @;;;;;;;;;;;;;;;;;;;;;;;=       +;;;;;;;;*             *;;;;;;;;;;;;.            .;;;;;;;;;;;;;;;;;;;;;;;;=               ;;;;;;;;;;;;;          ",
    " .@@@@@@@@@#;;;;;;;;;;;;;;-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%;;;;;;;;;;;;;;=+@@@@@@@@@               .;;;;;;;;;;;;;;;;;;;;;;;;;&      +;;;;;;;;*            .;;;;;;;;;;;;;&            .;;;;;;;;;;;;;;;;;;;;;;;;;*             #;;;;;;;;;;;;;+         ",
    " +@@@@@@@@@&;;;;;;;;;;;;;;#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+*;;;;;;;;;;;;;;#@@@@@@@@@               *;;;;;;;;;;;;;;;;;;;;;;;;;;#     +;;;;;;;;*            $;;;;;;;;;;;;;;            .;;;;;;;;;;;;;;;;;;;;;;;;;;#            *;;;;;;;;;;;;;=         ",
    " @@@@@@@@@+-;;;;;;;;;;;;;*@@@@@@@@@@@@+#*;;;-&@@@@@@@@@@@@@@;;;;;;;;;;;;;;%@@@@@@@@@.             +;;;;;;;;;;-#   #-;;;;;;;;;;=     +;;;;;;;;*            =;;;;;;;;;;;;;;#           .;;;;;;;;-&&&&*-;;;;;;;;;;;;            ;;;;;;;;;;;;;;;.        ",
    " @@@@@@@@@+;;;;;;;;;;;;;;@@@@@@@@@@@+%-;;;;;;;;*+@@@@@@@@@@+&;;;;;;;;;;;;;*+@@@@@@@@+             &;;;;;;;;;%       %;;;;;;;;;;     +;;;;;;;;*           .;;;;;;;;;;;;;;;*           .;;;;;;;;=       #;;;;;;;;;;#          %;;;;;;;;;;;;;;;$        ",
    ".@@@@@@@@@%;;;;;;;;;;;;;=@@@@@@@@@@+&;;;;;;;;;;;;#@@@@@@@@@@#;;;;;;;;;;;;;;+@@@@@@@@@             =;;;;;;;;=         =;;;;;;;;;@    +;;;;;;;;*           &;;;;;;;%;;;;;;;;           .;;;;;;;;=         ;;;;;;;;;&          -;;;;;;;%;;;;;;;=        ",
    ".@@@@@@@@@=;;;;;;;;;;;;;$@@@@@@@@@+*;;;;;;;;;;;;;;#@@@@@@@@@@-;;;;;;;;;;;;;#@@@@@@@@@             ;;;;;;;;;@          -;;;;;;;;.    +;;;;;;;;*           -;;;;;;;+*;;;;;;;%          .;;;;;;;;=         %;;;;;;;;-          ;;;;;;;; ;;;;;;;;.       ",
    ".@@@@@@@@@-;;;;;;;;;;;;;+@@@@@@@@@%;;;;;;;;;;;;;;;;+@@@@@@@@@%;;;;;;;;;;;;;%@@@@@@@@@             ;;;;;;;;;                         +;;;;;;;;*          .;;;;;;;; #;;;;;;;=          .;;;;;;;;=          ;;;;;;;;;         &;;;;;;;& &;;;;;;;&       ",
    "+@@@@@@@@@;;;;;;;;;;;;;*+@@@@@@@@@;;;;;;;;;;;;;;;;;&@@@@@@@@@@;;;;;;;;;;;;;&@@@@@@@@@            .;;;;;;;;-                         +;;;;;;;;*          *;;;;;;;%  ;;;;;;;;          .;;;;;;;;=          -;;;;;;;;         ;;;;;;;;. @;;;;;;;-       ",
    "+@@@@@@@@@;;;;;;;;;;;;;&@@@@@@@@@%;;;;;;;;;;;;;;;;;-+@@@@@@@@+-;;;;;;;;;;;;*@@@@@@@@@.           .;;;;;;;;-                         +;;;;;;;;*          ;;;;;;;;.  *;;;;;;;&         .;;;;;;;;=          =;;;;;;;;.       .;;;;;;;;   ;;;;;;;;.      ",
    "+@@@@@@@@@;;;;;;;;;;;;;%@@@@@@@@+-;;;;;;;;;;;;;;;;;;$@@@@@@@@@-;;;;;;;;;;;;=@@@@@@@@@.           .;;;;;;;;-      .%%%%%%%%%%%%$     +;;;;;;;;*         +;;;;;;;-   .;;;;;;;;         .;;;;;;;;=          =;;;;;;;;.       &;;;;;;;*   %;;;;;;;*      ",
    "@@@@@@@@@@;;;;;;;;;;;;;$@@@@@@@@@;;;;;;;;;;;;;;;;;;;&@@@@@@@@@=;;;;;;;;;;;;=+@@@@@@@@.           +;;;;;;;;-      -;;;;;;;;;;;;;%    +;;;;;;;;*         *;;;;;;;&    ;;;;;;;;.        .;;;;;;;;=          *;;;;;;;;.       ;;;;;;;;.   .;;;;;;;;      ",
    "@@@@@@@@@@;;;;;;;;;;;;;$@@@@@@@@#;;;;;;;;;;;;;;;;;;;*@@@@@@@@@=;;;;;;;;;;;;=+@@@@@@@@.           +;;;;;;;;-      -;;;;;;;;;;;;;&    +;;;;;;;;*        .;;;;;;;;     *;;;;;;;&        .;;;;;;;;=          *;;;;;;;;+      #;;;;;;;-     ;;;;;;;;+     ",
    "@@@@@@@@@@;;;;;;;;;;;;;$@@@@@@@@#;;;;;;;;;;;;;;;;;;;*@@@@@@@@@#$$&*-;;;;;;;=+@@@@@@@@.           +;;;;;;;;-      -;;;;;;;;;;;;;&    +;;;;;;;;*        $;;;;;;;=     .;;;;;;;;        .;;;;;;;;=          *;;;;;;;;+      *;;;;;;;&     %;;;;;;;*     ",
    "@@@@@@@@@@;;;;;;;;;;;;;$@@@@@@@@@;;;;;;;;;;;;;;;;;;;&@@@@@@@@@@@@@@+@=;;;;;=@@@@@@@@@.           .;;;;;;;;-      -;;;;;;;;;;;;;&    +;;;;;;;;*        =;;;;;;;%      -;;;;;;;#       .;;;;;;;;=          *;;;;;;;;.      ;;;;;;;;+      ;;;;;;;;.    ",
    "+@@@@@@@@@;;;;;;;;;;;;;%@@@@@@@@+-;;;;;;;;;;;;;;;;;;$@@@@@@@@@@@@@@@@@#-;;;=@@@@@@@@@.           .;;;;;;;;-      -;;;;;;;;;;;;;&    +;;;;;;;;*       .;;;;;;;;.      &;;;;;;;*       .;;;;;;;;=          =;;;;;;;;.     %;;;;;;;-       =;;;;;;;#    ",
    "+@@@@@@@@@;;;;;;;;;;;;;&@@@@@@@@@%;;;;;;;;;;;;;;;;;;+@@@@@+++++++@@@@@@@&;;*@@@@@@@@@.           .;;;;;;;;-      @%%%%*;;;;;;;;&    +;;;;;;;;*       &;;;;;;;=.......#;;;;;;;;       .;;;;;;;;=          =;;;;;;;;.     -;;;;;;;%.......&;;;;;;;=    ",
    "+@@@@@@@@@;;;;;;;;;;;;;*+@@@@@@@@@;;;;;;;;;;;;;;;;;&@@@+#%*-;;-=&$@@@@@@@%;&@@@@@@@@@             ;;;;;;;;;           %;;;;;;;;%    +;;;;;;;;*       -;;;;;;;;;;;;;;;;;;;;;;;;%      .;;;;;;;;=          -;;;;;;;;      ;;;;;;;;;;;;;;;;;;;;;;;;;.   ",
    ".@@@@@@@@@-;;;;;;;;;;;;;+@@@@@@@@@%;;;;;;;;;;;;;;;;+@@@*;;;;;;;;;;;%@@@@@@&%@@@@@@@@@             ;;;;;;;;;           &;;;;;;;;%    +;;;;;;;;*       ;;;;;;;;;;;;;;;;;;;;;;;;;=      .;;;;;;;;=          ;;;;;;;;;     %;;;;;;;;;;;;;;;;;;;;;;;;;&   ",
    ".@@@@@@@@@=;;;;;;;;;;;;;$@@@@@@@@@+*;;;;;;;;;;;;;;#@+%;;;;;;;;;;;;;;-@@@@@@@@@@@@@@@@             -;;;;;;;;#          =;;;;;;;;@    +;;;;;;;;*      *;;;;;;;;;;;;;;;;;;;;;;;;;;      .;;;;;;;;=         $;;;;;;;;-     ;;;;;;;;;;;;;;;;;;;;;;;;;;-   ",
    ".@@@@@@@@@%;;;;;;;;;;;;;=@@@@@@@@@@+*;;;;;;;;;;;;#@+*;;;;;;;;;;;;;;;;;$+@@@@@@@@@@@@@             =;;;;;;;;=         @;;;;;;;;;     +;;;;;;;;*      ;;;;;;;;;;;;;;;;;;;;;;;;;;;&     .;;;;;;;;=         -;;;;;;;;&    .;;;;;;;;;;;;;;;;;;;;;;;;;;;.  ",
    " @@@@@@@@@+;;;;;;;;;;;;;;@@@@@@@@@@@+%-;;;;;;;;*@@+*;;;;;;;;;;;;;;;;;;;$@@@@@@@@@@@@+             &;;;;;;;;;%       +;;;;;;;;;=     +;;;;;;;;*     +;;;;;;;;;;;;;;;;;;;;;;;;;;;;     .;;;;;;;;=       +-;;;;;;;;;$    &;;;;;;;;;;;;;;;;;;;;;;;;;;;*  ",
    " @@@@@@@@@+-;;;;;;;;;;;;;*@@@@@@@@@@@@+$=;;;-&@@@@&;;;;;;;;;;;;;;;;;;;;;@@@@@@@@@@@@.             .;;;;;;;;;;-@   .*;;;;;;;;;;%     +;;;;;;;;*     *;;;;;;;;;;;;;;;;;;;;;;;;;;;;.    .;;;;;;;;-&&&&&*;;;;;;;;;;;;     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  ",
    " +@@@@@@@@@*;;;;;;;;;;;;;;#@@@@@@@@@@@@@@@@@+@@@@@;;;;;;;;;;;;;;;;;;;;;;-@@@@@@@@@@@               &;;;;;;;;;;;;;;;;;;;;;;;;;;      +;;;;;;;;*    .;;;;;;;;;;;;;;;;;;;;;;;;;;;;;&    .;;;;;;;;;;;;;;;;;;;;;;;;;;$    #;;;;;;;;;;;;;;;;;;;;;;;;;;;;;. ",
    " .@@@@@@@@@#;;;;;;;;;;;;;;-@@@@@@@@@@@@@@@@@@@@@@-;;;;;;;;;;;;;;;;;;;;;;;$@@@@@@@@@@               .;;;;;;;;;;;;;;;;;;;;;;;;;@      +;;;;;;;;*    $;;;;;;;;%            ;;;;;;;;;    .;;;;;;;;;;;;;;;;;;;;;;;;;-     *;;;;;;;;            .;;;;;;;;* ",
    "  @@@@@@@@@+-;;;;;;;;;;;;;;*+@@@@@@@@@@@@@@@@@@@#;;;;;;;;;;;;;;;;;;;;;;;;-+@@@@@@@@+                @;;;;;;;;;;;;;;;;;;;;;;;&       +;;;;;;;;*    *;;;;;;;;             &;;;;;;;;#   .;;;;;;;;;;;;;;;;;;;;;;;;;      ;;;;;;;;=             -;;;;;;;;.",
    "  +@@@@@@@@@%;;;;;;;;;;;;;;;&@@@@@@@@@@@@@@@@@@+%;;;;;;;;;;;;;;;;;;;;;;;;;#@@@@@@@@.                 #;;;;;;;;;;;;;;;;;;;;;%        +;;;;;;;;*    ;;;;;;;;*              ;;;;;;;;*   .;;;;;;;;;;;;;;;;;;;;;;;-      %;;;;;;;;%             %;;;;;;;;#",
    "  .@@@@@@@@@@;;;;;;;;;;;;;;;;&+@@@@@@@@@@@@@@@@+-;;;;;;;;;;;;;;;;;;;;;;;;;%@@@@@@@@                   .-;;;;;;;;;;;;;;;;;;+         +;;;;;;;;*   &;;;;;;;;$              =;;;;;;;;   .;;;;;;;;;;;;;;;;;;;;;;%       -;;;;;;;;               ;;;;;;;;*",
    "   @@@@@@@@@@%;;;;;;;;;;;;;;;;*@@@@@@@@@@@@@@@@+;;;;;;;;;;;;;;;;;;;;;;;;;;&+@@@@@@+                     $=;;;;;;;;;;;;;=$           .;;;;;;;;*   =;;;;;;;;               $;;;;;;;;#  .;;;;;;;;;;;;;;;;;;;=%.        ;;;;;;;;&               *;;;;;;;;",
    "   +@@@@@@@@@@-;;;;;;;;;;;;;;;;-#+@@@@@@@@@@@@@#;;;;;;;;;;;;;;;;;;;;;;;;;;*+@@@@@@.                       .%=---;---=%.              %&&&&&&&.   +&&&&&&&.                $&&&&&&%    #&&&&&&&&&&&&&&%$+            $&&&&&&%                 %&&&&&&#",
    "   .@@@@@@@@@@#;;;;;;;;;;;;;;;;;;*@@@@@@@@@@@@@#;;;;;;;;;;;;;;;;;;;;;;;;;;=+@@@@@@                                                                                                                                                                   ",
    "    +@@@@@@@@@@*;;;;;;;;;;;;;;;;;;;=%++@@@@@@@+@;;;;;;;;;;;;;;;;;;;;;;;;;;*+@@@@@.                                                                                                                                                                   ",
    "    .@@@@@@@@@@@-;;;;;;;;;;;;;;;;;;;;;=&%%$%%&*-;;;;;;;;;;;;;;;;;;;;;;;;;;&+@@@@@                                                                                                                                                                    ",
    "     +@@@@@@@@@@#;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;%@@@@@.                                                                                                                                                                    ",
    "      @@@@@@@@@@@$;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;#@@@@+                                                                                                                                                                     ",
    "      +@@@@@@@@@@@%;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-+@@@@                                                                                                                                                                      ",
    "       @@@@@@@@@@@+&;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;$@@@@.                                                                                                                                                                      ",
    "       .@@@@@@@@@@@+%;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-@@@@@                                                                                                                                                                       ",
    "        .@@@@@@@@@@@@$;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;@@@@@                                                                                                                                                                        ",
    "         +@@@@@@@@@@@@#-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;$@@@@.                                                                                                                                                                        ",
    "          @@@@@@@@@@@@@@*;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;%+@@@+                                                                                                                                                                         ",
    "           @@@@@@@@@@@@@+#-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-#@@@@+                                                                                                                                                                          ",
    "           .@@@@@@@@@@@@@@@%;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;%@@@@@@                                                                                                                                                                           ",
    "            .@@@@@@@@@@@@@@@@$-;;;;;;;;;;;;;;;;;;;;;;;;*$%*-;;;-*$@@@@@@@                                                                                                                                                                            ",
    "             .@@@@@@@@@@@@@@@@+#&-;;;;;;;;;;;;;;;;;;=%@+@@+++.+++@@@@@@+                                                                                                                                                                             ",
    "               @@@@@@@@@@@@@@@@@@++%*--;;;;;;;;--&#++@@@@@@@@@@@@@@@@@+                                                                                                                                                                              ",
    "                @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                               ",
    "                 .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                ",
    "                  .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+                                                                                                                                                                                  ",
    "                    +@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                   ",
    "                      @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                     ",
    "                       .+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                       ",
    "                         .+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                         ",
    "                            .+@@@@@@@@@@@@@@@@@@@@@@@@@@+.                                                                                                                                                                                           ",
    "                               .+@@@@@@@@@@@@@@@@@@@@.                                                                                                                                                                                               ",
    "                                   ...+++@@@@++...                                                                                                                                                                                                   "};

const char* loopRepeat_xpm[] = {
    "18 18 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #323331",
    "@	c #4D4F4C",
    "#	c #646663",
    "$	c #787A77",
    "%	c #919390",
    "&	c #BFC1BD",
    "..................",
    "..................",
    "..................",
    "...&%#......#%&...",
    "...&&&%+..+%&&&...",
    "...$%&&%..%&&%$...",
    ".....$&&##&&$.....",
    "......%&%%&%......",
    "......$&&&&$......",
    "......$&&&&$......",
    "......%&%%&%......",
    ".....$&&##&&$.....",
    "...$%&&%..%&&%$...",
    "...&&&%+..+%&&&...",
    "...&%#......#%&...",
    "..................",
    "..................",
    ".................."};

const char* loopBasic_xpm[] = {
    "18 18 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #313230",
    "@	c #4D4F4C",
    "#	c #666765",
    "$	c #787A77",
    "%	c #919390",
    "&	c #BEC0BD",
    "..................",
    "..................",
    "..................",
    "......#%&&%#......",
    "....+%&&&&&&%+....",
    "....%&&&%%&&&%....",
    "...#&&%+..+%&&#...",
    "...%&&+....+&&%...",
    "...&&%......%&&...",
    "...&&%......%&&...",
    "...%&&+....+&&%...",
    "...#&&%+..+%&&#...",
    "....%&&&%%&&&%....",
    "....+%&&&&&&%+....",
    "......#%&&%#......",
    "..................",
    "..................",
    ".................."};

const char* loopOnce_xpm[] = {
    "18 18 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #323331",
    "@	c #4D4F4C",
    "#	c #646663",
    "$	c #787A77",
    "%	c #919390",
    "&	c #BFC1BD",
    "..................",
    "..................",
    "..................",
    "......$%&&%#......",
    "....+&&&&&&&&+....",
    "...+&&&&$$&&&&+...",
    "...$&&$....$&&$...",
    "...%&&......%&%...",
    "..................",
    "..................",
    "...%&&+.....&&&...",
    "...#&&$....$&&#...",
    "....%&&&%$&&&%....",
    "....+%&&&&&&%+....",
    "......#%&&%#......",
    "..................",
    "..................",
    ".................."};

const char* loopOnceBar_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #393A38",
    "+	c #545553",
    "@	c #747673",
    "#	c #A3A5A2",
    "$	c #ADAFAC",
    "%	c #B5B7B4",
    "&	c #C7C9C6",
    "                  ",
    "                  ",
    "                  ",
    "      @$&%#@      ",
    "    .$&&&&&&$.    ",
    "    %&&#@@#&&$    ",
    "   @&&@    @&&@   ",
    "   %&# +%$+ #&$   ",
    "       %&&%       ",
    "       %&&%       ",
    "   $&# +%%+ #&$   ",
    "   @&&@    @&&@   ",
    "    $&&#@@#&&$    ",
    "    .$&&&&&&$.    ",
    "      @#&&#@      ",
    "                  ",
    "                  ",
    "                  "};

const char* oneshotBasic_xpm[] = {
    "18 18 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #313230",
    "@	c #4D4F4C",
    "#	c #666765",
    "$	c #787A77",
    "%	c #919390",
    "&	c #BEC0BD",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "...$$$$$$$$$$$$...",
    "...&&&&&&&&&&&&...",
    "...&&&&&&&&&&&&...",
    "..................",
    "..................",
    ".................."};

const char* oneshotBasicPause_xpm[] = {
    "18 18 5 1",
    " 	c #252525",
    ".	c #4E4E4E",
    "+	c #767676",
    "@	c #9F9F9F",
    "#	c #C8C8C8",
    "                  ",
    "                  ",
    "                  ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "            +##   ",
    "   +++++++++@##   ",
    "   ############   ",
    "   ############   ",
    "                  ",
    "                  ",
    "                  "};

const char* oneshotRetrig_xpm[] = {
    "18 18 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #313230",
    "@	c #4D4F4C",
    "#	c #666765",
    "$	c #787A77",
    "%	c #919390",
    "&	c #BEC0BD",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "...$$$$$$$#@......",
    "...&&&&&&&&&&@....",
    "...&&&&&&&&&&&+...",
    "..........+$&&%...",
    "............%&&...",
    "............%&&...",
    "...........+&&%...",
    "...$$$$$$$%&&&#...",
    "...&&&&&&&&&&%....",
    "...&&&&&&&&%#.....",
    "..................",
    "..................",
    ".................."};

const char* oneshotPress_xpm[] = {
    "18 18 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #313230",
    "@	c #4D4F4C",
    "#	c #666765",
    "$	c #787A77",
    "%	c #919390",
    "&	c #BEC0BD",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "...+%&%+..........",
    "...%&&&%..........",
    "...&&&&&..........",
    "...$&&&$..........",
    "...+$&$+..........",
    "..................",
    "...$$$$$$$$$$$$...",
    "...&&&&&&&&&&&&...",
    "...&&&&&&&&&&&&...",
    "..................",
    "..................",
    ".................."};

const char* oneshotEndless_xpm[] = {
    "18 18 6 1",
    " 	c #242523",
    ".	c #464745",
    "+	c #6D6F6C",
    "@	c #888A87",
    "#	c #ADAFAC",
    "$	c #C6C8C5",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "        .++.      ",
    "       @$$$$#.    ",
    "      @$$$$$$$.   ",
    "     .$$#. +$$@   ",
    "     +$$.   @$#   ",
    "     +$$    @$$   ",
    "     .$$+   #$#   ",
    "   @@@$$$@@#$$+   ",
    "   $$$$$$$$$$@    ",
    "   $$$$$$$$#+     ",
    "                  ",
    "                  ",
    "                  "};

const char* updirOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #332F2E",
    "+	c #54494A",
    "@	c #6B5A5C",
    "#	c #866C6B",
    "$	c #967B7A",
    "%	c #987D7C",
    "&	c #B18E8F",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "        @@        ",
    "       #&&#       ",
    "     .#&&&&#.     ",
    "    .$&&&&&&$.    ",
    "    +@%&&&&%@+    ",
    "      #&&&&#      ",
    "      #&&&&#      ",
    "      #&&&&#      ",
    "      #&&&&#      ",
    "      #&&&&#      ",
    "       ....       ",
    "                  ",
    "                  ",
    "                  "};

const char* updirOn_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #555150",
    "+	c #706465",
    "@	c #7D6B6E",
    "#	c #877373",
    "$	c #957978",
    "%	c #9F8382",
    "&	c #B18E8F",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "        ##        ",
    "       #&&#       ",
    "     .$&&&&$.     ",
    "    .%&&&&&&%.    ",
    "    +@%&&&&%@+    ",
    "      $&&&&$      ",
    "      $&&&&$      ",
    "      $&&&&$      ",
    "      $&&&&$      ",
    "      $&&&&$      ",
    "       ....       ",
    "                  ",
    "                  ",
    "                  "};

const char* pause_xpm[] = {
    "23 23 8 1",
    " 	c #4D4F4C",
    ".	c #514E53",
    "+	c #5C4F61",
    "@	c #6F507E",
    "#	c #855098",
    "$	c #9551AE",
    "%	c #A652C5",
    "&	c #AE52D1",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "       #+              ",
    "       &%#.            ",
    "       &&&%@           ",
    "       &&&&&$+         ",
    "       &&&&&&&#.       ",
    "       &&&&&&&&%@      ",
    "       &&&&&&&&&&#     ",
    "       &&&&&&&&%@.     ",
    "       &&&&&&&#.       ",
    "       &&&&&$+         ",
    "       &&&%@           ",
    "       &&#.            ",
    "       $+              ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* play_xpm[] = {
    "23 23 8 1",
    " 	c #242523",
    ".	c #393534",
    "+	c #574B4C",
    "@	c #6E5B5A",
    "#	c #7C6663",
    "$	c #8C7170",
    "%	c #A48384",
    "&	c #B18E8F",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "       $.              ",
    "       &&@             ",
    "       &&&%+           ",
    "       &&&&&$.         ",
    "       &&&&&&&@        ",
    "       &&&&&&&&%+      ",
    "       &&&&&&&&&&#     ",
    "       &&&&&&&&%+      ",
    "       &&&&&&&#.       ",
    "       &&&&&$.         ",
    "       &&&%+           ",
    "       &&@             ",
    "       $.              ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* rewindOff_xpm[] = {
    "23 23 8 1",
    " 	c #242523",
    ".	c #393534",
    "+	c #574B4C",
    "@	c #6E5B5A",
    "#	c #7C6663",
    "$	c #8C7170",
    "%	c #A48384",
    "&	c #B18E8F",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                .$     ",
    "               @&&     ",
    "             +%&&&     ",
    "           .$&&&&&     ",
    "          @&&&&&&&     ",
    "        +%&&&&&&&&     ",
    "       #&&&&&&&&&&     ",
    "        +%&&&&&&&&     ",
    "         .#&&&&&&&     ",
    "           .$&&&&&     ",
    "             +%&&&     ",
    "               @&&     ",
    "                .$     ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* rewindOn_xpm[] = {
    "23 23 8 1",
    " 	c #4D4F4C",
    ".	c #514E53",
    "+	c #5C4F61",
    "@	c #6F507E",
    "#	c #855098",
    "$	c #9551AE",
    "%	c #A652C5",
    "&	c #AE52D1",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                +#     ",
    "              .#%&     ",
    "             @%&&&     ",
    "           +$&&&&&     ",
    "         .#&&&&&&&     ",
    "        @%&&&&&&&&     ",
    "       #&&&&&&&&&&     ",
    "       .@%&&&&&&&&     ",
    "         .#&&&&&&&     ",
    "           +$&&&&&     ",
    "             @%&&&     ",
    "              .#&&     ",
    "                +$     ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* giada_icon[] = {
    "65 65 8 1",
    " 	c #444643",
    ".	c #565755",
    "+	c #6C6E6B",
    "@	c #898B88",
    "#	c #A3A5A2",
    "$	c #BEC0BD",
    "%	c #D7DAD6",
    "&	c #FCFEFB",
    "                                                                 ",
    " &&&&&&&&&&&&&&&&&&&&%$@                .@$%&&&&&&&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&&&&%$@.                     .#%&&&&&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&&&#+                          .@$&&&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&$+                              .@%&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&@                                  .#&&&&&&&&&&&&& ",
    " &&&&&&&&&&&%.                                     @&&&&&&&&&&&& ",
    " &&&&&&&&&&$              ...+@@#@@+..              +%&&&&&&&&&& ",
    " &&&&&&&&&#            .+#$&&&&&&&&&&%$@+.           .%&&&&&&&&& ",
    " &&&&&&&&#           +#%&&&&&&&&&&&&&&&&&$@.          .%&&&&&&&& ",
    " &&&&&&&#          .#%&&&&&&&&&&&&&&&&&&&&&%@          .%&&&&&&& ",
    " &&&&&&$          @%&&&&&&&&&&&&&&&&&&&&&&&&&%+         .&&&&&&& ",
    " &&&&&%          $&&&&&&&&&&&&&&&&&&&&&&&&&&&&&@         +&&&&&& ",
    " &&&&&.        .%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#         @&&&&& ",
    " &&&&@        +%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#         $&&&& ",
    " &&&$        .%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#        +&&&& ",
    " &&&+        %&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#        #&&& ",
    " &&#        $&&&&&&&&&&&&&&&&%$###$%&&&&&&&&&&&&&&&&@       +%&& ",
    " &%+       @&&&&&&&&&&&&&&%@..    ..+#&&&&&&&&&&&&&&%.       #&& ",
    " &$       .%&&&&&&&&&&&&%+             #&&&&&&&&&&&&&#       +&& ",
    " &@       $&&&&&&&&&&&&#                +%&&&&&&&&&&&%+       $& ",
    " %.      +%&&&&&&&&&&&@                  .$&&&&&&&&&&&#       @& ",
    " $       #&&&&&&&&&&&@                    .$&&&&&&&&&&&+       & ",
    " @      .%&&&&&&&&&&#                      .%&&&&&&&&&&@       $ ",
    " .      +&&&&&&&&&&%                        +&&&&&&&&&&%.      @ ",
    "        #&&&&&&&&&&+         @%&&%$+         #&&&&&&&&&&.      . ",
    "       .%&&&&&&&&&$        +%&&&&&&&#        .&&&&&&&&&&@        ",
    "       .&&&&&&&&&&+       +&&&&&&&&&&$        $&&&&&&&&&$        ",
    "       +&&&&&&&&&&       .%&&&&&&&&&&&#       @&&&&&&&&&%        ",
    "       @&&&&&&&&&$       @&&&&&&&&&&&&&.      +&&&&&&&&&&        ",
    "       @&&&&&&&&&#       %&&&&&&&&&&&&&#      .%&&&&&&&&&.       ",
    "       #&&&&&&&&&@      .&&&&&&&&&&&&&&$      .%&&&&&&&&&.       ",
    "       #&&&&&&&&&@      .&&&&&&&&&&&&&&%      .#$%&&&&&&&+       ",
    "       #&&&&&&&&&@      .&&&&&&&&&&&&&&$           @%&&&&.       ",
    "       @&&&&&&&&&#       %&&&&&&&&&&&&&#             @%&&.       ",
    "       @&&&&&&&&&$       #&&&&&&&&&&&&&.   +@@@@+.    .$&        ",
    "       +&&&&&&&&&&       .%&&&&&&&&&&&#  +$%&&&&&%#.   .$        ",
    "       .&&&&&&&&&&+       +&&&&&&&&&&$  $&&&&&&&&&&%@   .        ",
    "       .%&&&&&&&&&$        +%&&&&&&&#. %&&&&&&&&&&&&&#           ",
    "        #&&&&&&&&&&+         @%&&&$+  $&&&&&&&&&&&&&&&@        . ",
    " .      +&&&&&&&&&&%                 @&&&&&&&&&&&&&&&&%.       @ ",
    " @      .%&&&&&&&&&&#                %&&&&&&&&&&&&&&&&&@       $ ",
    " $       #&&&&&&&&&&&@              @&&&&&&&&&&&&&&&&&&%.      & ",
    " %.      +%&&&&&&&&&&&@             $&&&&&&&&&&&&&&&&&&&.     @& ",
    " &@       $&&&&&&&&&&&&#            %&&&&&&&&&&&&&&&&&&&+     $& ",
    " &$       .%&&&&&&&&&&&&%+          %&&&&&&&&&&&&&&&&&&&@    +&& ",
    " &%+       @&&&&&&&&&&&&&&%@..     .%&&&&&&&&&&&&&&&&&&&@    #&& ",
    " &&#        $&&&&&&&&&&&&&&&&%$###$%&&&&&&&&&&&&&&&&&&&&+   +%&& ",
    " &&&+       .%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&.   #&&& ",
    " &&&$        .%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#   +&&&& ",
    " &&&&@        +%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&+   $&&&& ",
    " &&&&&.        .%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&#   @&&&&& ",
    " &&&&&%         .$&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&%.  +&&&&&& ",
    " &&&&&&$          @%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&%.  .&&&&&&& ",
    " &&&&&&&#          .$%&&&&&&&&&&&&&&&&&&&&&&&&&&&&%#   .%&&&&&&& ",
    " &&&&&&&&#           +#%&&&&&&&&&&&&&&&&&$@#$%%$$@+   .%&&&&&&&& ",
    " &&&&&&&&&#            .+#%&&&&&&&&&&&$@+.  ....     .%&&&&&&&&& ",
    " &&&&&&&&&&$              ..+@@###@+...             +%&&&&&&&&&& ",
    " &&&&&&&&&&&%.                                     @&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&@                                  .#&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&$+                              .@%&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&&&#+                          .@$&&&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&&&&%$@.                     .#%&&&&&&&&&&&&&&&&&& ",
    " &&&&&&&&&&&&&&&&&&&&%$@                .@$%&&&&&&&&&&&&&&&&&&&& ",
    "                                                                 "};

const char* recOff_xpm[] = {
    "23 23 8 1",
    " 	c #242523",
    ".	c #342F2E",
    "+	c #3F3B3A",
    "@	c #594F4F",
    "#	c #7A6663",
    "$	c #8C7170",
    "%	c #A68384",
    "&	c #B18E8F",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "         @$%%$@        ",
    "       .$&&&&&&$.      ",
    "       $&&&&&&&&$      ",
    "      @&&&#++#&&&@     ",
    "      $&&#    #&&$     ",
    "      %&&+    +&&%     ",
    "      %&&+    +&&%     ",
    "      $&&#    #&&$     ",
    "      @&&&#++#&&&@     ",
    "       $&&&&&&&&$      ",
    "       .$&&&&&&$.      ",
    "         @$%%$@        ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* recOn_xpm[] = {
    "23 23 8 1",
    " 	c #4D4F4C",
    ".	c #5F4E50",
    "+	c #6E4F50",
    "@	c #8C5050",
    "#	c #AE5454",
    "$	c #BB5253",
    "%	c #C55352",
    "&	c #E85557",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "         @$&&$@        ",
    "       .%&&&&&&%.      ",
    "       %&&&&&&&&%      ",
    "      @&&&#++#&&&@     ",
    "      $&&#    #&&$     ",
    "      &&&+    +&&&     ",
    "      &&&+    +&&&     ",
    "      $&&#    #&&$     ",
    "      @&&&#++#&&&@     ",
    "       %&&&&&&&&%      ",
    "       .%&&&&&&%.      ",
    "         @$&&$@        ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* inputRecOn_xpm[] = {
    "23 23 8 1",
    " 	c #524D4C",
    ".	c #4D4F4C",
    "+	c #5D4F50",
    "@	c #8C5050",
    "#	c #BB5253",
    "$	c #C45251",
    "%	c #DD5256",
    "&	c #EA5657",
    ".......................",
    ".......................",
    ".......................",
    ".......................",
    ".......................",
    "........ @#%%#@ .......",
    ".......+$&&&&&&$+......",
    "...... $&&&&&&&&$ .....",
    "......@&&&&&&&&&&@.....",
    "......#&&&&&&&&&&#.....",
    "......%&&&&&&&&&&%.....",
    "......%&&&&&&&&&&%.....",
    "......#&&&&&&&&&&#.....",
    "......@&&&&&&&&&&@.....",
    ".......$&&&&&&&&$......",
    ".......+$&&&&&&$+......",
    "........ @#%%#@ .......",
    ".......................",
    ".......................",
    ".......................",
    ".......................",
    ".......................",
    "......................."};

const char* inputRecOff_xpm[] = {
    "23 23 8 1",
    " 	c #242523",
    ".	c #252724",
    "+	c #332F2E",
    "@	c #594E4F",
    "#	c #896E6D",
    "$	c #8D7271",
    "%	c #A68384",
    "&	c #B18E8F",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "        .@#%%#@.       ",
    "       +$&&&&&&$+      ",
    "      .$&&&&&&&&$.     ",
    "      @&&&&&&&&&&@     ",
    "      #&&&&&&&&&&#     ",
    "      %&&&&&&&&&&%     ",
    "      %&&&&&&&&&&%     ",
    "      #&&&&&&&&&&#     ",
    "      @&&&&&&&&&&@     ",
    "       $&&&&&&&&$      ",
    "       +$&&&&&&$+      ",
    "        .@#%%#@.       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       ",
    "                       "};

const char* freeInputRecOff_xpm[] = {
    "13 23 9 1",
    " 	c None",
    ".	c #232523",
    "+	c #353130",
    "@	c #483E3F",
    "#	c #4D4F4C",
    "$	c #574D4D",
    "%	c #705D5C",
    "&	c #8C7271",
    "*	c #AF8D8E",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    ".....+%%.....",
    ".....@*&.....",
    ".....@*&.....",
    ".....@*&.....",
    "....$@$@.....",
    "...+**&@.....",
    "....+%**&@...",
    "......+%*$...",
    ".....@&%+....",
    ".....@*&.....",
    ".....@*&.....",
    ".....@*&.....",
    ".....+@@.....",
    ".............",
    ".............",
    ".............",
    ".............",
    "............."};

const char* freeInputRecOn_xpm[] = {
    "13 23 9 1",
    " 	c None",
    ".	c #4D4F4C",
    "+	c #575352",
    "@	c #5D5857",
    "#	c #6A5F5F",
    "$	c #796A6B",
    "%	c #877472",
    "&	c #977C7C",
    "*	c #B08E8F",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    ".....@%$.....",
    ".....#*&.....",
    ".....#*&.....",
    ".....#*&.....",
    "....##$#.....",
    "...+**&@.....",
    "....@%**&@...",
    "......@%*$...",
    ".....@&%@....",
    ".....#*&.....",
    ".....#*&.....",
    ".....#*&.....",
    ".....+##.....",
    ".............",
    ".............",
    ".............",
    ".............",
    "............."};

const char* muteOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #2E2F2D",
    "+	c #3B3C3A",
    "@	c #525451",
    "#	c #6F716E",
    "$	c #878986",
    "%	c #ADAFAC",
    "&	c #C6C8C5",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     ++.  .++     ",
    "    +&&$  $&&+    ",
    "    +&&%  %&&+    ",
    "    +&%&++&%&+    ",
    "    +&$&##&$&+    ",
    "    +&#%$$%#&+    ",
    "    +&#$%%$#&+    ",
    "    +&#@&&@#&+    ",
    "    +&#+&&+#&+    ",
    "    .#@ ## @#.    ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* muteOn_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #585A57",
    "+	c #616260",
    "@	c #7A7C79",
    "#	c #888A87",
    "$	c #989A97",
    "%	c #B2B4B1",
    "&	c #C6C8C5",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     ..    ..     ",
    "    +&&$  $&&+    ",
    "    +&&%  %&&+    ",
    "    +&%&++&%&+    ",
    "    +&$&@@&$&+    ",
    "    +&#%$$%#&+    ",
    "    +&#$&&$#&+    ",
    "    +&#@&&@#&+    ",
    "    +&#.&&.#&+    ",
    "    .#+ ## +#.    ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* readActionOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #393B38",
    "+	c #555754",
    "@	c #6B6D6A",
    "#	c #7F807E",
    "$	c #9C9E9B",
    "%	c #B1B3B0",
    "&	c #C3C5C2",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     ....         ",
    "     %&&&&%+      ",
    "     %&@@@&&      ",
    "     %%   $&.     ",
    "     %&@@#&$      ",
    "     %&&&&@       ",
    "     %% +&$       ",
    "     %%  #&#      ",
    "     %%   %&+     ",
    "     @@   .#+     ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* readActionOn_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #696B68",
    "+	c #7A7C79",
    "@	c #888A87",
    "#	c #939592",
    "$	c #A7A9A6",
    "%	c #B7B9B6",
    "&	c #C4C6C3",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     %&&&&%.      ",
    "     %&++@&&      ",
    "     %%   $&      ",
    "     %&@@#&$      ",
    "     %&&&&@       ",
    "     %% +&$       ",
    "     %%  #&#      ",
    "     %%   %&.     ",
    "     +@   .@+     ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* readActionDisabled_xpm[] = {
    "18 18 7 1",
    " 	c None",
    ".	c #252525",
    "+	c #313131",
    "@	c #393939",
    "#	c #424242",
    "$	c #4A4A4A",
    "%	c #585858",
    "..................",
    "..................",
    "..................",
    "..................",
    ".....@@@@+........",
    ".....%%%%%%+......",
    ".....%%#+$%$......",
    ".....%%@.#%$......",
    ".....%%##%%@......",
    ".....%%%%%$.......",
    ".....%%@+%%#......",
    ".....%%@.@%%......",
    ".....%%@..%%#.....",
    ".....@@...+@@.....",
    "..................",
    "..................",
    "..................",
    ".................."};

const char* metronomeOff_xpm[] = {
    "13 23 3 1",
    " 	c None",
    ".	c #252525",
    "+	c #B18E8E",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    "............."};

const char* metronomeOn_xpm[] = {
    "13 23 3 1",
    " 	c None",
    ".	c #4E4E4E",
    "+	c #B18E8E",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    "....+...+....",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    ".............",
    "............."};

const char* recTriggerModeOff_xpm[] = {
    "13 23 8 1",
    " 	c #232523",
    ".	c #2A2625",
    "+	c #43393A",
    "@	c #514647",
    "#	c #6F5C59",
    "$	c #8B7170",
    "%	c #AA8889",
    "&	c #B08E8F",
    "             ",
    "             ",
    "             ",
    "             ",
    "             ",
    "     @$@     ",
    "     %&%     ",
    "     $&$     ",
    "     .+.     ",
    "             ",
    "     #%#     ",
    "     %&%     ",
    "     #%#     ",
    "             ",
    "     .+.     ",
    "     $&$     ",
    "     %&%     ",
    "     @$@     ",
    "             ",
    "             ",
    "             ",
    "             ",
    "             "};

const char* recTriggerModeOn_xpm[] = {
    "13 23 8 1",
    " 	c #4D4F4C",
    ".	c #534E4D",
    "+	c #605B5A",
    "@	c #6D6363",
    "#	c #817072",
    "$	c #967C7B",
    "%	c #AC8A8B",
    "&	c #B08E8F",
    "             ",
    "             ",
    "             ",
    "             ",
    "             ",
    "     @$@     ",
    "     %&%     ",
    "     $&$     ",
    "     .+.     ",
    "             ",
    "     #%#     ",
    "     %&%     ",
    "     #%#     ",
    "             ",
    "     .+.     ",
    "     $&$     ",
    "     %&%     ",
    "     @$@     ",
    "             ",
    "             ",
    "             ",
    "             ",
    "             "};

const char* zoomInOff_xpm[] = {
    "18 18 8 1",
    " 	c None",
    ".	c #252525",
    "+	c #262626",
    "@	c #535353",
    "#	c #ACACAC",
    "$	c #AEAEAE",
    "%	c #B1B1B1",
    "&	c #C4C4C4",
    "++++++++++++++++++",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+.......@@.......+",
    "+.......#$.......+",
    "+.......#$.......+",
    "+....@%%&&%%@....+",
    "+....@%%&&%%@....+",
    "+.......#$.......+",
    "+.......#$.......+",
    "+.......@@.......+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "++++++++++++++++++"};

const char* zoomInOn_xpm[] = {
    "18 18 8 1",
    " 	c None",
    ".	c #4E4E4E",
    "+	c #707070",
    "@	c #717171",
    "#	c #B3B3B3",
    "$	c #B5B5B5",
    "%	c #B7B7B7",
    "&	c #C5C5C5",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "........++........",
    "........#$........",
    "........#$........",
    ".....@%%&&%%@.....",
    ".....@%%&&%%@.....",
    "........#$........",
    "........#$........",
    "........++........",
    "..................",
    "..................",
    "..................",
    "..................",
    ".................."};

const char* zoomOutOff_xpm[] = {
    "18 18 5 1",
    " 	c None",
    ".	c #252525",
    "+	c #262626",
    "@	c #9C9C9C",
    "#	c #BBBBBB",
    "++++++++++++++++++",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+......@##@......+",
    "+......@##@......+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "+................+",
    "++++++++++++++++++"};

const char* zoomOutOn_xpm[] = {
    "18 18 4 1",
    " 	c None",
    ".	c #4E4E4E",
    "+	c #A7A7A7",
    "@	c #BEBEBE",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    ".......+@@+.......",
    ".......+@@+.......",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    ".................."};

const char* scrollRightOff_xpm[] = {
    "12 12 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #2E2F2D",
    "@	c #4D4F4C",
    "#	c #5D5F5C",
    "$	c #828481",
    "%	c #9B9D9A",
    "&	c #BCBEBB",
    "............",
    "............",
    "...+........",
    "...&$@......",
    "...$&&%@....",
    "....+#%&%...",
    "....+#%&%...",
    "...$&&%#....",
    "...&$@......",
    "...+........",
    "............",
    "............"};

const char* scrollLeftOff_xpm[] = {
    "12 12 8 1",
    " 	c #181917",
    ".	c #242523",
    "+	c #2E2F2D",
    "@	c #4D4F4C",
    "#	c #5D5F5C",
    "$	c #828481",
    "%	c #9B9D9A",
    "&	c #BCBEBB",
    "............",
    "............",
    "........+...",
    "......@$&...",
    "....@%&&$...",
    "...%&%#+....",
    "...%&%#+....",
    "....#%&&$...",
    "......@$&...",
    "........+...",
    "............",
    "............"};

const char* scrollLeftOn_xpm[] = {
    "12 12 8 1",
    " 	c #4D4F4C",
    ".	c #6B6D6A",
    "+	c #7B7D7A",
    "@	c #969895",
    "#	c #A6A8A5",
    "$	c #B4B6B3",
    "%	c #C0C2BF",
    "&	c #FEFFFC",
    "            ",
    "            ",
    "            ",
    "      .@$   ",
    "    +#%%@   ",
    "   $%#+     ",
    "   %%#+     ",
    "    +$%%@   ",
    "      .#$   ",
    "            ",
    "            ",
    "            "};

const char* scrollRightOn_xpm[] = {
    "12 12 8 1",
    " 	c #4D4F4C",
    ".	c #6B6D6A",
    "+	c #7B7D7A",
    "@	c #969895",
    "#	c #A6A8A5",
    "$	c #B4B6B3",
    "%	c #C0C2BF",
    "&	c #FEFFFC",
    "            ",
    "            ",
    "            ",
    "   %@.      ",
    "   @%%#.    ",
    "     +#%#   ",
    "     +#%#   ",
    "   @%%#+    ",
    "   %@.      ",
    "            ",
    "            ",
    "            "};

const char* soloOn_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #616360",
    "+	c #737572",
    "@	c #838582",
    "#	c #929491",
    "$	c #A5A7A4",
    "%	c #B1B3B0",
    "&	c #C6C8C5",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "       .@+.       ",
    "      #&&&&#      ",
    "     .&$  %&.     ",
    "      &%+ ..      ",
    "      #&&&$.      ",
    "       .@$&&.     ",
    "     .#.  @&@     ",
    "     .&$. #&+     ",
    "      #&&&&$      ",
    "       .+@+       ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* soloOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #3D3F3D",
    "+	c #525451",
    "@	c #666865",
    "#	c #80827F",
    "$	c #979996",
    "%	c #A7A9A6",
    "&	c #C6C8C5",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "       .@@.       ",
    "      #&&&&#      ",
    "     .&$  %&.     ",
    "      &%+ ..      ",
    "      #&&&$+      ",
    "       .@%&&.     ",
    "     +#.  @&@     ",
    "     .&$..#&+     ",
    "      #&&&&$      ",
    "       .@@+       ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

#ifdef WITH_VST

const char* fxOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #40423F",
    "+	c #4D4E4C",
    "@	c #686A67",
    "#	c #7B7D7A",
    "$	c #919390",
    "%	c #AEB0AD",
    "&	c #C1C3C0",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "   ..... .   .    ",
    "   $&&&$ $% @&.   ",
    "   $$    .&#&@    ",
    "   $%##.  @&$     ",
    "   $%##.  #&%     ",
    "   $$    .&@&#    ",
    "   $$    %$ @&.   ",
    "   ..    +   +.   ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* fxOn_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #565855",
    "+	c #636562",
    "@	c #80827F",
    "#	c #8E908D",
    "$	c #9FA19E",
    "%	c #B1B3B0",
    "&	c #C1C3C0",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "   .++++ +.  +.   ",
    "   $&&&$ $% @&.   ",
    "   $$    .&#&@    ",
    "   $%##+  @&$     ",
    "   $%##+  #&%     ",
    "   $$    +&@&#    ",
    "   $$    %$ @&+   ",
    "   ++   .+.  ++   ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* fxShiftUpOff_xpm[] = {
    "18 18 7 1",
    " 	c #242523",
    ".	c #4D4F4C",
    "+	c #A3A5A2",
    "@	c #868885",
    "#	c #C1C3C0",
    "$	c #313330",
    "%	c #626361",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "       .+@        ",
    "       @+#.       ",
    "      $#%+@       ",
    "      %# %#$      ",
    "      +@ $#%      ",
    "     $#.  @+      ",
    "     $.   $.      ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* fxShiftUpOn_xpm[] = {
    "18 18 5 1",
    " 	c #4D4F4C",
    ".	c #70726F",
    "+	c #A5A7A4",
    "@	c #C1C3BF",
    "#	c #8E908D",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "       .++        ",
    "       +@@.       ",
    "       @.+#       ",
    "      .@ .@       ",
    "      +#  @.      ",
    "     .@.  #+      ",
    "      .    .      ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* fxShiftDownOff_xpm[] = {
    "18 18 7 1",
    " 	c #242523",
    ".	c #4D4F4C",
    "+	c #A3A5A2",
    "@	c #313330",
    "#	c #626361",
    "$	c #868885",
    "%	c #C1C3C0",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     .+@  #$      ",
    "     @%#  +$      ",
    "      $+ .%@      ",
    "      .%@$+       ",
    "       +$%#       ",
    "       #%%@       ",
    "       @..        ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* fxShiftDownOn_xpm[] = {
    "18 18 5 1",
    " 	c #4D4F4C",
    ".	c #70726F",
    "+	c #A5A7A4",
    "@	c #C1C3BF",
    "#	c #8E908D",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     .+   .+      ",
    "      @.  +#      ",
    "      #+ .@.      ",
    "      .@.#+       ",
    "       +#@.       ",
    "       #@@        ",
    "        ..        ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* vstLogo_xpm[] = {
    "65 38 8 1",
    " 	c #161715",
    ".	c #2B2D2A",
    "+	c #474846",
    "@	c #6A6C69",
    "#	c #8C8E8B",
    "$	c #A8AAA7",
    "%	c #C7C9C6",
    "&	c #EEF0ED",
    " @#############################################################+ ",
    "@#.............................................................$+",
    "#.                                                             .#",
    "#.                                                             .#",
    "#.                             ......      ..                  .#",
    "#.                         .@$$$####$%$#@.+&$                  .#",
    "#.                       .#$$#+.     +#$%%%%$                  .#",
    "#.                      .$$#$          .#$$%$                  .#",
    "#. .............    ....$$$$$          ++$$%$+@@@@@@@@@@@@@@@  .#",
    "#. ##$$$$$$%%%%@    %%&&&&%%$@         %&@#$$@@$%%&&&%%%&&&&&  .#",
    "#.   +$$$$$%@         .&%####%$@       $&$.$#  #$%%%&    @&%&  .#",
    "#.    +$$$$$%         +&$###$%%&&$@.   $&.     #$%%%&.    .%&  .#",
    "#.     @$$$$%$        %##$##$%&&&&&&%#.%#      #$$%%&.     @&  .#",
    "#.      $$$$$%+      #&  #$$%%&&&&&&&%%$$@     #$$%%&.      +  .#",
    "#.      .$$$$$%     +&+   .#%&&&&&&&&%$$#$$#   #$$%%&.         .#",
    "#.       @$$$$%$    %$       @%&&&&&&%$$###$$  #$$%%&.         .#",
    "#.        #$$$%%@  #&  .        +$&&&%$####$%$ #$$%%&.         .#",
    "#.         $$$%%% .&@ +%#          .@$$$###$$% #$$$%&.         .#",
    "#.         +%$%%%$$%  +$$+             #$#$$$% @$$$%&.         .#",
    "#.          #%%%%%&.  +%$$              ##$$%$ @$$$%%.         .#",
    "#.           $$%%%@   +%$$$.            #$$$%. @$$$$%.         .#",
    "#.           +%%%$    +%$$#$@          +$$%$   @#$$$%+         .#",
    "#.            @%%.    +%%%$$$$#@++.++@#$$$@ @@##$$$%%%$$@      .#",
    "#.             #@     +&#  .@@###$$$###@.   @+++@@@@###$@      .#",
    "#.                                                             .#",
    "#.                                                             .#",
    "#.                                                             .#",
    "#.                                                             .#",
    "#.                                                             .#",
    "#.                   .@$$$$$$$$  .$%%%%%%#                     .#",
    "#.                  .......      .@@@@@@@@@.                   .#",
    "#.                 ........   @@@+@@@@@@@@@@+                  .#",
    "@#                .........  .####@@@@@@@@@@@+                 #@",
    " @$$$$$$$$$$$$$$$..........  .@@@@@@@@@@@@@@@@@$$$$$$$$$$$$$$$$@ ",
    "                  .........  .@@@@@@@@@@@@@@@.                   ",
    "                   ........       @@@@@@@@@@.                    ",
    "                    ...........  .@@@@@@@@@                      ",
    "                     ..........  .@@@@@@@@                       "};

const char* fxRemoveOff_xpm[] = {
    "18 18 9 1",
    " 	c None",
    ".	c #242623",
    "+	c #2F312E",
    "@	c #393A38",
    "#	c #484A47",
    "$	c #5D5F5C",
    "%	c #8E908D",
    "&	c #9B9D9A",
    "*	c #BDBFBC",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    ".....+#@..@#+.....",
    "......&*++*&......",
    "......@*%%*@......",
    ".......$**$.......",
    ".......#**#.......",
    "......+*&&*+......",
    "......%*@@*%......",
    "......@@..@@......",
    "..................",
    "..................",
    "..................",
    "..................",
    ".................."};

const char* fxRemoveOn_xpm[] = {
    "18 18 9 1",
    " 	c None",
    ".	c #4D4F4C",
    "+	c #575956",
    "@	c #5C5D5B",
    "#	c #666865",
    "$	c #787977",
    "%	c #9C9E9B",
    "&	c #A6A8A5",
    "*	c #BFC1BE",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "......#@..@#......",
    "......&*++*&......",
    "......@*%%*@......",
    ".......$**$.......",
    ".......#**#.......",
    "......+*&&*+......",
    "......%*@+*%......",
    "......@+..+@......",
    "..................",
    "..................",
    "..................",
    "..................",
    ".................."};
#endif // #ifdef WITH_VST

const char* divideOn_xpm[] = {
    "18 18 7 1",
    " 	c #5A5A5A",
    ".	c #696969",
    "+	c #757575",
    "@	c #8B8B8B",
    "#	c #AAAAAA",
    "$	c #BBBBBB",
    "%	c #BDBDBD",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "        @@        ",
    "        %$        ",
    "        ++        ",
    "    .########.    ",
    "    .########.    ",
    "        ++        ",
    "        %$        ",
    "        @@        ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* divideOff_xpm[] = {
    "18 18 8 1",
    " 	c #252525",
    ".	c #3B3B3B",
    "+	c #4D4D4D",
    "@	c #6D6D6D",
    "#	c #6E6E6E",
    "$	c #9C9C9C",
    "%	c #B5B5B5",
    "&	c #B7B7B7",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "        @#        ",
    "        &%        ",
    "        ++        ",
    "    .$$$$$$$$.    ",
    "    .$$$$$$$$.    ",
    "        ++        ",
    "        &%        ",
    "        @#        ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* multiplyOn_xpm[] = {
    "18 18 8 1",
    " 	c #595B58",
    ".	c #737572",
    "+	c #747673",
    "@	c #8B8D8A",
    "#	c #8D8F8C",
    "$	c #8E908D",
    "%	c #8F918E",
    "&	c #C7C9C6",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "      +    .      ",
    "     +&$  #&.     ",
    "      #&$#&#      ",
    "       @&&#       ",
    "       @&&%       ",
    "      @&#@&%      ",
    "     +&#  #&+     ",
    "      +    .      ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* multiplyOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #4A4C49",
    "+	c #4D4E4C",
    "@	c #6D6F6C",
    "#	c #717370",
    "$	c #737572",
    "%	c #757774",
    "&	c #C7C9C6",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "      +    .      ",
    "     +&$  #&.     ",
    "      #&$#&#      ",
    "       @&&#       ",
    "       @&&%       ",
    "      @&$@&%      ",
    "     +&#  #&+     ",
    "      +    .      ",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* channelStop_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #312D2C",
    "+	c #413A3A",
    "@	c #615253",
    "#	c #73605F",
    "$	c #7A6663",
    "%	c #9C7E7D",
    "&	c #B08D8E",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "     ##.          ",
    "     $&%@         ",
    "     $&&&%+       ",
    "     $&&&&&$.     ",
    "     $&&&&&&&@    ",
    "     $&&&&&&&@.   ",
    "     $&&&&&$.     ",
    "     $&&&%+       ",
    "     $&&@         ",
    "     $#.          ",
    "     .            ",
    "                  ",
    "                  ",
    "                  "};

const char* channelPlay_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #554E56",
    "+	c #5A4D59",
    "@	c #605068",
    "#	c #775086",
    "$	c #8A509C",
    "%	c #9E50B5",
    "&	c #AD52D0",
    "                  ",
    "                  ",
    "                  ",
    "     .            ",
    "     $$.          ",
    "     $&%#         ",
    "     $&&&%@       ",
    "     $&&&&&$.     ",
    "     $&&&&&&&#.   ",
    "     $&&&&&&&#.   ",
    "     $&&&&&$+     ",
    "     $&&&%@       ",
    "     $&&#         ",
    "     $$.          ",
    "     .            ",
    "                  ",
    "                  ",
    "                  "};

const char* armOff_xpm[] = {
    "18 18 8 1",
    " 	c #242523",
    ".	c #4F4445",
    "+	c #514647",
    "@	c #6D5C5E",
    "#	c #8E7372",
    "$	c #AA8889",
    "%	c #AC898A",
    "&	c #B18E8F",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "      +#%%#.      ",
    "     @&&&&&&@     ",
    "    +&&&&&&&&.    ",
    "    #&&&&&&&&#    ",
    "    %&&&&&&&&%    ",
    "    %&&&&&&&&%    ",
    "    #&&&&&&&&#    ",
    "    .&&&&&&&&.    ",
    "     @&&&&&&@     ",
    "      .#%%#.      ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* armOn_xpm[] = {
    "18 18 8 1",
    " 	c #4D4F4C",
    ".	c #6B5077",
    "+	c #805191",
    "@	c #9950AD",
    "#	c #9751B3",
    "$	c #9553AD",
    "%	c #AA52C9",
    "&	c #AE52D1",
    "                  ",
    "                  ",
    "                  ",
    "                  ",
    "      .#%%#.      ",
    "     +&&&&&&+     ",
    "    .&&&&&&&&.    ",
    "    #&&&&&&&&@    ",
    "    %&&&&&&&&%    ",
    "    %&&&&&&&&%    ",
    "    #&&&&&&&&$    ",
    "    .&&&&&&&&.    ",
    "     +&&&&&&+     ",
    "      .@%%$.      ",
    "                  ",
    "                  ",
    "                  ",
    "                  "};

const char* armDisabled_xpm[] = {
    "18 18 7 1",
    " 	c None",
    ".	c #232523",
    "+	c #303230",
    "@	c #393B38",
    "#	c #424441",
    "$	c #4B4D4A",
    "%	c #4D4F4C",
    "..................",
    "..................",
    "..................",
    "..................",
    "......+#$$#+......",
    ".....@%%%%%%@.....",
    "....+%%%%%%%%+....",
    "....#%%%%%%%%#....",
    "....$%%%%%%%%$....",
    "....$%%%%%%%%$....",
    "....#%%%%%%%%#....",
    "....+%%%%%%%%+....",
    ".....@%%%%%%@.....",
    "......+#$$#+......",
    "..................",
    "..................",
    "..................",
    ".................."};