/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "globus_error_hierarchy.h"
#include "globus_libc.h"


/* the following code all generated by running the script
 * ./globus_error_hierarchy.h.sh definitions < globus_error_hierarchy.idl
 */

const globus_object_type_t GLOBUS_ERROR_TYPE_NO_AUTHENTICATION_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BASE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NO_AUTHENTICATION   */
extern globus_object_t *
globus_error_construct_no_authentication (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NO_AUTHENTICATION);

  error = globus_error_initialize_no_authentication (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NO_AUTHENTICATION   */
extern globus_object_t *
globus_error_initialize_no_authentication (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_base (
    error,
    base_source,
    base_cause);
}


typedef struct globus_error_no_credentials_instance_s {
  globus_object_t *   no_credentials_file;
} globus_error_no_credentials_instance_t;

static globus_error_no_credentials_instance_t *
globus_l_error_no_credentials_instance_data (globus_object_t *error)
{
  globus_error_no_credentials_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_NO_CREDENTIALS);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_no_credentials_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_no_credentials_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->no_credentials_file = NULL;
    return instance_data;
  }
}

static void globus_l_error_no_credentials_copy (void *srcvp, void **dstvpp)
{
  globus_error_no_credentials_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_no_credentials_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_no_credentials_instance_t));
  dst = ((globus_error_no_credentials_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->no_credentials_file = globus_object_copy(src->no_credentials_file);
}

static void globus_l_error_no_credentials_destroy (void *datavp)
{
  globus_error_no_credentials_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_no_credentials_instance_t *) datavp);
  globus_object_free (data->no_credentials_file);
  data->no_credentials_file = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_NO_CREDENTIALS_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_NO_AUTHENTICATION_DEFINITION),
        globus_l_error_no_credentials_copy,
        globus_l_error_no_credentials_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NO_CREDENTIALS   */
extern globus_object_t *
globus_error_construct_no_credentials (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * no_credentials_file)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NO_CREDENTIALS);

  error = globus_error_initialize_no_credentials (
    newerror,
    base_source,
    base_cause,
    no_credentials_file);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NO_CREDENTIALS   */
extern globus_object_t *
globus_error_initialize_no_credentials (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * no_credentials_file)
{
  globus_error_no_credentials_set_no_credentials_file (error, no_credentials_file);

  return globus_error_initialize_no_authentication (
    error,
    base_source,
    base_cause);
}

/* return the no_credentials_file instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_CREDENTIALS   */
extern globus_object_t *
globus_error_no_credentials_get_no_credentials_file (globus_object_t * error)
{
  globus_error_no_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_no_credentials_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->no_credentials_file);
  }
  else return NULL;
}

/* set the no_credentials_file instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_CREDENTIALS   */
extern void
globus_error_no_credentials_set_no_credentials_file (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_no_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_no_credentials_instance_data (error);
  if (instance_data != NULL) {
    instance_data->no_credentials_file = value;
  }
}


typedef struct globus_error_no_trust_instance_s {
  globus_object_t *   no_trust_truster;
  globus_object_t *   no_trust_trustee;
} globus_error_no_trust_instance_t;

static globus_error_no_trust_instance_t *
globus_l_error_no_trust_instance_data (globus_object_t *error)
{
  globus_error_no_trust_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_NO_TRUST);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_no_trust_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_no_trust_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->no_trust_truster = NULL;
    instance_data->no_trust_trustee = NULL;
    return instance_data;
  }
}

static void globus_l_error_no_trust_copy (void *srcvp, void **dstvpp)
{
  globus_error_no_trust_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_no_trust_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_no_trust_instance_t));
  dst = ((globus_error_no_trust_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->no_trust_truster = globus_object_copy(src->no_trust_truster);
  dst->no_trust_trustee = globus_object_copy(src->no_trust_trustee);
}

static void globus_l_error_no_trust_destroy (void *datavp)
{
  globus_error_no_trust_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_no_trust_instance_t *) datavp);
  globus_object_free (data->no_trust_truster);
  data->no_trust_truster = NULL;
  globus_object_free (data->no_trust_trustee);
  data->no_trust_trustee = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_NO_TRUST_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_NO_AUTHENTICATION_DEFINITION),
        globus_l_error_no_trust_copy,
        globus_l_error_no_trust_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NO_TRUST   */
extern globus_object_t *
globus_error_construct_no_trust (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * no_trust_truster,
    globus_object_t * no_trust_trustee)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NO_TRUST);

  error = globus_error_initialize_no_trust (
    newerror,
    base_source,
    base_cause,
    no_trust_truster,
    no_trust_trustee);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NO_TRUST   */
extern globus_object_t *
globus_error_initialize_no_trust (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * no_trust_truster,
    globus_object_t * no_trust_trustee)
{
  globus_error_no_trust_set_no_trust_truster (error, no_trust_truster);
  globus_error_no_trust_set_no_trust_trustee (error, no_trust_trustee);

  return globus_error_initialize_no_authentication (
    error,
    base_source,
    base_cause);
}

/* return the no_trust_truster instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_TRUST   */
extern globus_object_t *
globus_error_no_trust_get_no_trust_truster (globus_object_t * error)
{
  globus_error_no_trust_instance_t * instance_data;
  instance_data
   = globus_l_error_no_trust_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->no_trust_truster);
  }
  else return NULL;
}

/* set the no_trust_truster instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_TRUST   */
extern void
globus_error_no_trust_set_no_trust_truster (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_no_trust_instance_t * instance_data;
  instance_data
   = globus_l_error_no_trust_instance_data (error);
  if (instance_data != NULL) {
    instance_data->no_trust_truster = value;
  }
}

/* return the no_trust_trustee instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_TRUST   */
extern globus_object_t *
globus_error_no_trust_get_no_trust_trustee (globus_object_t * error)
{
  globus_error_no_trust_instance_t * instance_data;
  instance_data
   = globus_l_error_no_trust_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->no_trust_trustee);
  }
  else return NULL;
}

/* set the no_trust_trustee instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_TRUST   */
extern void
globus_error_no_trust_set_no_trust_trustee (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_no_trust_instance_t * instance_data;
  instance_data
   = globus_l_error_no_trust_instance_data (error);
  if (instance_data != NULL) {
    instance_data->no_trust_trustee = value;
  }
}


typedef struct globus_error_invalid_credentials_instance_s {
  globus_object_t *   invalid_credentials_start_time;
  globus_object_t *   invalid_credentials_end_time;
  globus_object_t *   invalid_credentials_attempt_time;
} globus_error_invalid_credentials_instance_t;

static globus_error_invalid_credentials_instance_t *
globus_l_error_invalid_credentials_instance_data (globus_object_t *error)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_invalid_credentials_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_invalid_credentials_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->invalid_credentials_start_time = NULL;
    instance_data->invalid_credentials_end_time = NULL;
    instance_data->invalid_credentials_attempt_time = NULL;
    return instance_data;
  }
}

static void globus_l_error_invalid_credentials_copy (void *srcvp, void **dstvpp)
{
  globus_error_invalid_credentials_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_invalid_credentials_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_invalid_credentials_instance_t));
  dst = ((globus_error_invalid_credentials_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->invalid_credentials_start_time = globus_object_copy(src->invalid_credentials_start_time);
  dst->invalid_credentials_end_time = globus_object_copy(src->invalid_credentials_end_time);
  dst->invalid_credentials_attempt_time = globus_object_copy(src->invalid_credentials_attempt_time);
}

static void globus_l_error_invalid_credentials_destroy (void *datavp)
{
  globus_error_invalid_credentials_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_invalid_credentials_instance_t *) datavp);
  globus_object_free (data->invalid_credentials_start_time);
  data->invalid_credentials_start_time = NULL;
  globus_object_free (data->invalid_credentials_end_time);
  data->invalid_credentials_end_time = NULL;
  globus_object_free (data->invalid_credentials_attempt_time);
  data->invalid_credentials_attempt_time = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_NO_AUTHENTICATION_DEFINITION),
        globus_l_error_invalid_credentials_copy,
        globus_l_error_invalid_credentials_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_error_construct_invalid_credentials (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_credentials_start_time,
    globus_object_t * invalid_credentials_end_time,
    globus_object_t * invalid_credentials_attempt_time)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS);

  error = globus_error_initialize_invalid_credentials (
    newerror,
    base_source,
    base_cause,
    invalid_credentials_start_time,
    invalid_credentials_end_time,
    invalid_credentials_attempt_time);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_error_initialize_invalid_credentials (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_credentials_start_time,
    globus_object_t * invalid_credentials_end_time,
    globus_object_t * invalid_credentials_attempt_time)
{
  globus_error_invalid_credentials_set_invalid_credentials_start_time (error, invalid_credentials_start_time);
  globus_error_invalid_credentials_set_invalid_credentials_end_time (error, invalid_credentials_end_time);
  globus_error_invalid_credentials_set_invalid_credentials_attempt_time (error, invalid_credentials_attempt_time);

  return globus_error_initialize_no_authentication (
    error,
    base_source,
    base_cause);
}

/* return the invalid_credentials_start_time instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_error_invalid_credentials_get_invalid_credentials_start_time (globus_object_t * error)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_credentials_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->invalid_credentials_start_time);
  }
  else return NULL;
}

/* set the invalid_credentials_start_time instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern void
globus_error_invalid_credentials_set_invalid_credentials_start_time (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_credentials_instance_data (error);
  if (instance_data != NULL) {
    instance_data->invalid_credentials_start_time = value;
  }
}

/* return the invalid_credentials_end_time instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_error_invalid_credentials_get_invalid_credentials_end_time (globus_object_t * error)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_credentials_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->invalid_credentials_end_time);
  }
  else return NULL;
}

/* set the invalid_credentials_end_time instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern void
globus_error_invalid_credentials_set_invalid_credentials_end_time (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_credentials_instance_data (error);
  if (instance_data != NULL) {
    instance_data->invalid_credentials_end_time = value;
  }
}

/* return the invalid_credentials_attempt_time instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_error_invalid_credentials_get_invalid_credentials_attempt_time (globus_object_t * error)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_credentials_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->invalid_credentials_attempt_time);
  }
  else return NULL;
}

/* set the invalid_credentials_attempt_time instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_CREDENTIALS   */
extern void
globus_error_invalid_credentials_set_invalid_credentials_attempt_time (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_invalid_credentials_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_credentials_instance_data (error);
  if (instance_data != NULL) {
    instance_data->invalid_credentials_attempt_time = value;
  }
}


typedef struct globus_error_access_failed_instance_s {
  globus_object_t *   access_failed_resource;
  globus_object_t *   access_failed_operation;
} globus_error_access_failed_instance_t;

static globus_error_access_failed_instance_t *
globus_l_error_access_failed_instance_data (globus_object_t *error)
{
  globus_error_access_failed_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_ACCESS_FAILED);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_access_failed_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_access_failed_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->access_failed_resource = NULL;
    instance_data->access_failed_operation = NULL;
    return instance_data;
  }
}

static void globus_l_error_access_failed_copy (void *srcvp, void **dstvpp)
{
  globus_error_access_failed_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_access_failed_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_access_failed_instance_t));
  dst = ((globus_error_access_failed_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->access_failed_resource = globus_object_copy(src->access_failed_resource);
  dst->access_failed_operation = globus_object_copy(src->access_failed_operation);
}

static void globus_l_error_access_failed_destroy (void *datavp)
{
  globus_error_access_failed_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_access_failed_instance_t *) datavp);
  globus_object_free (data->access_failed_resource);
  data->access_failed_resource = NULL;
  globus_object_free (data->access_failed_operation);
  data->access_failed_operation = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_ACCESS_FAILED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BASE_DEFINITION),
        globus_l_error_access_failed_copy,
        globus_l_error_access_failed_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_ACCESS_FAILED   */
extern globus_object_t *
globus_error_construct_access_failed (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_ACCESS_FAILED);

  error = globus_error_initialize_access_failed (
    newerror,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_ACCESS_FAILED   */
extern globus_object_t *
globus_error_initialize_access_failed (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{
  globus_error_access_failed_set_access_failed_resource (error, access_failed_resource);
  globus_error_access_failed_set_access_failed_operation (error, access_failed_operation);

  return globus_error_initialize_base (
    error,
    base_source,
    base_cause);
}

/* return the access_failed_resource instance data of an error
 * derived from GLOBUS_ERROR_TYPE_ACCESS_FAILED   */
extern globus_object_t *
globus_error_access_failed_get_access_failed_resource (globus_object_t * error)
{
  globus_error_access_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_access_failed_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->access_failed_resource);
  }
  else return NULL;
}

/* set the access_failed_resource instance data of an error
 * derived from GLOBUS_ERROR_TYPE_ACCESS_FAILED   */
extern void
globus_error_access_failed_set_access_failed_resource (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_access_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_access_failed_instance_data (error);
  if (instance_data != NULL) {
    instance_data->access_failed_resource = value;
  }
}

/* return the access_failed_operation instance data of an error
 * derived from GLOBUS_ERROR_TYPE_ACCESS_FAILED   */
extern globus_object_t *
globus_error_access_failed_get_access_failed_operation (globus_object_t * error)
{
  globus_error_access_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_access_failed_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->access_failed_operation);
  }
  else return NULL;
}

/* set the access_failed_operation instance data of an error
 * derived from GLOBUS_ERROR_TYPE_ACCESS_FAILED   */
extern void
globus_error_access_failed_set_access_failed_operation (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_access_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_access_failed_instance_data (error);
  if (instance_data != NULL) {
    instance_data->access_failed_operation = value;
  }
}


typedef struct globus_error_no_authorization_instance_s {
  globus_object_t *   no_authorization_identity;
} globus_error_no_authorization_instance_t;

static globus_error_no_authorization_instance_t *
globus_l_error_no_authorization_instance_data (globus_object_t *error)
{
  globus_error_no_authorization_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_NO_AUTHORIZATION);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_no_authorization_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_no_authorization_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->no_authorization_identity = NULL;
    return instance_data;
  }
}

static void globus_l_error_no_authorization_copy (void *srcvp, void **dstvpp)
{
  globus_error_no_authorization_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_no_authorization_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_no_authorization_instance_t));
  dst = ((globus_error_no_authorization_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->no_authorization_identity = globus_object_copy(src->no_authorization_identity);
}

static void globus_l_error_no_authorization_destroy (void *datavp)
{
  globus_error_no_authorization_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_no_authorization_instance_t *) datavp);
  globus_object_free (data->no_authorization_identity);
  data->no_authorization_identity = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_NO_AUTHORIZATION_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ACCESS_FAILED_DEFINITION),
        globus_l_error_no_authorization_copy,
        globus_l_error_no_authorization_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NO_AUTHORIZATION   */
extern globus_object_t *
globus_error_construct_no_authorization (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation,
    globus_object_t * no_authorization_identity)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NO_AUTHORIZATION);

  error = globus_error_initialize_no_authorization (
    newerror,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation,
    no_authorization_identity);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NO_AUTHORIZATION   */
extern globus_object_t *
globus_error_initialize_no_authorization (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation,
    globus_object_t * no_authorization_identity)
{
  globus_error_no_authorization_set_no_authorization_identity (error, no_authorization_identity);

  return globus_error_initialize_access_failed (
    error,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);
}

/* return the no_authorization_identity instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_AUTHORIZATION   */
extern globus_object_t *
globus_error_no_authorization_get_no_authorization_identity (globus_object_t * error)
{
  globus_error_no_authorization_instance_t * instance_data;
  instance_data
   = globus_l_error_no_authorization_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->no_authorization_identity);
  }
  else return NULL;
}

/* set the no_authorization_identity instance data of an error
 * derived from GLOBUS_ERROR_TYPE_NO_AUTHORIZATION   */
extern void
globus_error_no_authorization_set_no_authorization_identity (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_no_authorization_instance_t * instance_data;
  instance_data
   = globus_l_error_no_authorization_instance_data (error);
  if (instance_data != NULL) {
    instance_data->no_authorization_identity = value;
  }
}


const globus_object_type_t GLOBUS_ERROR_TYPE_NOT_AVAILABLE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ACCESS_FAILED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NOT_AVAILABLE   */
extern globus_object_t *
globus_error_construct_not_available (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NOT_AVAILABLE);

  error = globus_error_initialize_not_available (
    newerror,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NOT_AVAILABLE   */
extern globus_object_t *
globus_error_initialize_not_available (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{

  return globus_error_initialize_access_failed (
    error,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_DEPLETED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_NOT_AVAILABLE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_DEPLETED   */
extern globus_object_t *
globus_error_construct_depleted (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_DEPLETED);

  error = globus_error_initialize_depleted (
    newerror,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_DEPLETED   */
extern globus_object_t *
globus_error_initialize_depleted (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{

  return globus_error_initialize_not_available (
    error,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_QUOTA_DEPLETED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_DEPLETED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_QUOTA_DEPLETED   */
extern globus_object_t *
globus_error_construct_quota_depleted (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_QUOTA_DEPLETED);

  error = globus_error_initialize_quota_depleted (
    newerror,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_QUOTA_DEPLETED   */
extern globus_object_t *
globus_error_initialize_quota_depleted (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{

  return globus_error_initialize_depleted (
    error,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_OFFLINE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_NOT_AVAILABLE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_OFFLINE   */
extern globus_object_t *
globus_error_construct_offline (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_OFFLINE);

  error = globus_error_initialize_offline (
    newerror,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_OFFLINE   */
extern globus_object_t *
globus_error_initialize_offline (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * access_failed_resource,
    globus_object_t * access_failed_operation)
{

  return globus_error_initialize_not_available (
    error,
    base_source,
    base_cause,
    access_failed_resource,
    access_failed_operation);
}


typedef struct globus_error_aborted_instance_s {
  globus_object_t *   aborted_operation;
} globus_error_aborted_instance_t;

static globus_error_aborted_instance_t *
globus_l_error_aborted_instance_data (globus_object_t *error)
{
  globus_error_aborted_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_ABORTED);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_aborted_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_aborted_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->aborted_operation = NULL;
    return instance_data;
  }
}

static void globus_l_error_aborted_copy (void *srcvp, void **dstvpp)
{
  globus_error_aborted_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_aborted_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_aborted_instance_t));
  dst = ((globus_error_aborted_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->aborted_operation = globus_object_copy(src->aborted_operation);
}

static void globus_l_error_aborted_destroy (void *datavp)
{
  globus_error_aborted_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_aborted_instance_t *) datavp);
  globus_object_free (data->aborted_operation);
  data->aborted_operation = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_ABORTED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BASE_DEFINITION),
        globus_l_error_aborted_copy,
        globus_l_error_aborted_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_ABORTED   */
extern globus_object_t *
globus_error_construct_aborted (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_ABORTED);

  error = globus_error_initialize_aborted (
    newerror,
    base_source,
    base_cause,
    aborted_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_ABORTED   */
extern globus_object_t *
globus_error_initialize_aborted (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{
  globus_error_aborted_set_aborted_operation (error, aborted_operation);

  return globus_error_initialize_base (
    error,
    base_source,
    base_cause);
}

/* return the aborted_operation instance data of an error
 * derived from GLOBUS_ERROR_TYPE_ABORTED   */
extern globus_object_t *
globus_error_aborted_get_aborted_operation (globus_object_t * error)
{
  globus_error_aborted_instance_t * instance_data;
  instance_data
   = globus_l_error_aborted_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->aborted_operation);
  }
  else return NULL;
}

/* set the aborted_operation instance data of an error
 * derived from GLOBUS_ERROR_TYPE_ABORTED   */
extern void
globus_error_aborted_set_aborted_operation (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_aborted_instance_t * instance_data;
  instance_data
   = globus_l_error_aborted_instance_data (error);
  if (instance_data != NULL) {
    instance_data->aborted_operation = value;
  }
}


const globus_object_type_t GLOBUS_ERROR_TYPE_USER_CANCELLED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ABORTED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_USER_CANCELLED   */
extern globus_object_t *
globus_error_construct_user_cancelled (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_USER_CANCELLED);

  error = globus_error_initialize_user_cancelled (
    newerror,
    base_source,
    base_cause,
    aborted_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_USER_CANCELLED   */
extern globus_object_t *
globus_error_initialize_user_cancelled (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{

  return globus_error_initialize_aborted (
    error,
    base_source,
    base_cause,
    aborted_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_INTERNAL_ERROR_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ABORTED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_INTERNAL_ERROR   */
extern globus_object_t *
globus_error_construct_internal_error (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_INTERNAL_ERROR);

  error = globus_error_initialize_internal_error (
    newerror,
    base_source,
    base_cause,
    aborted_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_INTERNAL_ERROR   */
extern globus_object_t *
globus_error_initialize_internal_error (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{

  return globus_error_initialize_aborted (
    error,
    base_source,
    base_cause,
    aborted_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_SYSTEM_ABORTED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ABORTED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_SYSTEM_ABORTED   */
extern globus_object_t *
globus_error_construct_system_aborted (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_SYSTEM_ABORTED);

  error = globus_error_initialize_system_aborted (
    newerror,
    base_source,
    base_cause,
    aborted_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_SYSTEM_ABORTED   */
extern globus_object_t *
globus_error_initialize_system_aborted (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * aborted_operation)
{

  return globus_error_initialize_aborted (
    error,
    base_source,
    base_cause,
    aborted_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_BAD_DATA_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BASE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_BAD_DATA   */
extern globus_object_t *
globus_error_construct_bad_data (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_BAD_DATA);

  error = globus_error_initialize_bad_data (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_BAD_DATA   */
extern globus_object_t *
globus_error_initialize_bad_data (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_base (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_NULL_REFERENCE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BAD_DATA_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NULL_REFERENCE   */
extern globus_object_t *
globus_error_construct_null_reference (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NULL_REFERENCE);

  error = globus_error_initialize_null_reference (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NULL_REFERENCE   */
extern globus_object_t *
globus_error_initialize_null_reference (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_bad_data (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_TYPE_MISMATCH_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BAD_DATA_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_TYPE_MISMATCH   */
extern globus_object_t *
globus_error_construct_type_mismatch (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_TYPE_MISMATCH);

  error = globus_error_initialize_type_mismatch (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_TYPE_MISMATCH   */
extern globus_object_t *
globus_error_initialize_type_mismatch (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_bad_data (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_BAD_FORMAT_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BAD_DATA_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_BAD_FORMAT   */
extern globus_object_t *
globus_error_construct_bad_format (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_BAD_FORMAT);

  error = globus_error_initialize_bad_format (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_BAD_FORMAT   */
extern globus_object_t *
globus_error_initialize_bad_format (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_bad_data (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_NAME_UNKNOWN_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BAD_DATA_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NAME_UNKNOWN   */
extern globus_object_t *
globus_error_construct_name_unknown (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NAME_UNKNOWN);

  error = globus_error_initialize_name_unknown (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NAME_UNKNOWN   */
extern globus_object_t *
globus_error_initialize_name_unknown (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_bad_data (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_OUT_OF_RANGE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BAD_DATA_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_OUT_OF_RANGE   */
extern globus_object_t *
globus_error_construct_out_of_range (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_OUT_OF_RANGE);

  error = globus_error_initialize_out_of_range (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_OUT_OF_RANGE   */
extern globus_object_t *
globus_error_initialize_out_of_range (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_bad_data (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_TOO_LARGE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_OUT_OF_RANGE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_TOO_LARGE   */
extern globus_object_t *
globus_error_construct_too_large (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_TOO_LARGE);

  error = globus_error_initialize_too_large (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_TOO_LARGE   */
extern globus_object_t *
globus_error_initialize_too_large (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_out_of_range (
    error,
    base_source,
    base_cause);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_TOO_SMALL_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_OUT_OF_RANGE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_TOO_SMALL   */
extern globus_object_t *
globus_error_construct_too_small (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_TOO_SMALL);

  error = globus_error_initialize_too_small (
    newerror,
    base_source,
    base_cause);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_TOO_SMALL   */
extern globus_object_t *
globus_error_initialize_too_small (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause)
{

  return globus_error_initialize_out_of_range (
    error,
    base_source,
    base_cause);
}


typedef struct globus_error_communication_failed_instance_s {
  globus_object_t *   communication_failed_local_resource;
  globus_object_t *   communication_failed_remote_resource;
} globus_error_communication_failed_instance_t;

static globus_error_communication_failed_instance_t *
globus_l_error_communication_failed_instance_data (globus_object_t *error)
{
  globus_error_communication_failed_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_communication_failed_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_communication_failed_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->communication_failed_local_resource = NULL;
    instance_data->communication_failed_remote_resource = NULL;
    return instance_data;
  }
}

static void globus_l_error_communication_failed_copy (void *srcvp, void **dstvpp)
{
  globus_error_communication_failed_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_communication_failed_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_communication_failed_instance_t));
  dst = ((globus_error_communication_failed_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->communication_failed_local_resource = globus_object_copy(src->communication_failed_local_resource);
  dst->communication_failed_remote_resource = globus_object_copy(src->communication_failed_remote_resource);
}

static void globus_l_error_communication_failed_destroy (void *datavp)
{
  globus_error_communication_failed_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_communication_failed_instance_t *) datavp);
  globus_object_free (data->communication_failed_local_resource);
  data->communication_failed_local_resource = NULL;
  globus_object_free (data->communication_failed_remote_resource);
  data->communication_failed_remote_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BASE_DEFINITION),
        globus_l_error_communication_failed_copy,
        globus_l_error_communication_failed_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED   */
extern globus_object_t *
globus_error_construct_communication_failed (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED);

  error = globus_error_initialize_communication_failed (
    newerror,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED   */
extern globus_object_t *
globus_error_initialize_communication_failed (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource)
{
  globus_error_communication_failed_set_communication_failed_local_resource (error, communication_failed_local_resource);
  globus_error_communication_failed_set_communication_failed_remote_resource (error, communication_failed_remote_resource);

  return globus_error_initialize_base (
    error,
    base_source,
    base_cause);
}

/* return the communication_failed_local_resource instance data of an error
 * derived from GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED   */
extern globus_object_t *
globus_error_communication_failed_get_communication_failed_local_resource (globus_object_t * error)
{
  globus_error_communication_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_communication_failed_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->communication_failed_local_resource);
  }
  else return NULL;
}

/* set the communication_failed_local_resource instance data of an error
 * derived from GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED   */
extern void
globus_error_communication_failed_set_communication_failed_local_resource (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_communication_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_communication_failed_instance_data (error);
  if (instance_data != NULL) {
    instance_data->communication_failed_local_resource = value;
  }
}

/* return the communication_failed_remote_resource instance data of an error
 * derived from GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED   */
extern globus_object_t *
globus_error_communication_failed_get_communication_failed_remote_resource (globus_object_t * error)
{
  globus_error_communication_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_communication_failed_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->communication_failed_remote_resource);
  }
  else return NULL;
}

/* set the communication_failed_remote_resource instance data of an error
 * derived from GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED   */
extern void
globus_error_communication_failed_set_communication_failed_remote_resource (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_communication_failed_instance_t * instance_data;
  instance_data
   = globus_l_error_communication_failed_instance_data (error);
  if (instance_data != NULL) {
    instance_data->communication_failed_remote_resource = value;
  }
}


const globus_object_type_t GLOBUS_ERROR_TYPE_UNREACHABLE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_UNREACHABLE   */
extern globus_object_t *
globus_error_construct_unreachable (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_UNREACHABLE);

  error = globus_error_initialize_unreachable (
    newerror,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_UNREACHABLE   */
extern globus_object_t *
globus_error_initialize_unreachable (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource)
{

  return globus_error_initialize_communication_failed (
    error,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_PROTOCOL_MISMATCH_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_PROTOCOL_MISMATCH   */
extern globus_object_t *
globus_error_construct_protocol_mismatch (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_PROTOCOL_MISMATCH);

  error = globus_error_initialize_protocol_mismatch (
    newerror,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_PROTOCOL_MISMATCH   */
extern globus_object_t *
globus_error_initialize_protocol_mismatch (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource)
{

  return globus_error_initialize_communication_failed (
    error,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource);
}


typedef struct globus_error_protocol_violated_instance_s {
  globus_object_t *   protocol_violated_version;
} globus_error_protocol_violated_instance_t;

static globus_error_protocol_violated_instance_t *
globus_l_error_protocol_violated_instance_data (globus_object_t *error)
{
  globus_error_protocol_violated_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_protocol_violated_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_protocol_violated_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->protocol_violated_version = NULL;
    return instance_data;
  }
}

static void globus_l_error_protocol_violated_copy (void *srcvp, void **dstvpp)
{
  globus_error_protocol_violated_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_protocol_violated_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_protocol_violated_instance_t));
  dst = ((globus_error_protocol_violated_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->protocol_violated_version = globus_object_copy(src->protocol_violated_version);
}

static void globus_l_error_protocol_violated_destroy (void *datavp)
{
  globus_error_protocol_violated_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_protocol_violated_instance_t *) datavp);
  globus_object_free (data->protocol_violated_version);
  data->protocol_violated_version = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_COMMUNICATION_FAILED_DEFINITION),
        globus_l_error_protocol_violated_copy,
        globus_l_error_protocol_violated_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED   */
extern globus_object_t *
globus_error_construct_protocol_violated (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource,
    globus_object_t * protocol_violated_version)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED);

  error = globus_error_initialize_protocol_violated (
    newerror,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource,
    protocol_violated_version);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED   */
extern globus_object_t *
globus_error_initialize_protocol_violated (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * communication_failed_local_resource,
    globus_object_t * communication_failed_remote_resource,
    globus_object_t * protocol_violated_version)
{
  globus_error_protocol_violated_set_protocol_violated_version (error, protocol_violated_version);

  return globus_error_initialize_communication_failed (
    error,
    base_source,
    base_cause,
    communication_failed_local_resource,
    communication_failed_remote_resource);
}

/* return the protocol_violated_version instance data of an error
 * derived from GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED   */
extern globus_object_t *
globus_error_protocol_violated_get_protocol_violated_version (globus_object_t * error)
{
  globus_error_protocol_violated_instance_t * instance_data;
  instance_data
   = globus_l_error_protocol_violated_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->protocol_violated_version);
  }
  else return NULL;
}

/* set the protocol_violated_version instance data of an error
 * derived from GLOBUS_ERROR_TYPE_PROTOCOL_VIOLATED   */
extern void
globus_error_protocol_violated_set_protocol_violated_version (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_protocol_violated_instance_t * instance_data;
  instance_data
   = globus_l_error_protocol_violated_instance_data (error);
  if (instance_data != NULL) {
    instance_data->protocol_violated_version = value;
  }
}


typedef struct globus_error_invalid_use_instance_s {
  globus_object_t *   invalid_use_operation;
} globus_error_invalid_use_instance_t;

static globus_error_invalid_use_instance_t *
globus_l_error_invalid_use_instance_data (globus_object_t *error)
{
  globus_error_invalid_use_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (error, GLOBUS_ERROR_TYPE_INVALID_USE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_error_invalid_use_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_error_invalid_use_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->invalid_use_operation = NULL;
    return instance_data;
  }
}

static void globus_l_error_invalid_use_copy (void *srcvp, void **dstvpp)
{
  globus_error_invalid_use_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_error_invalid_use_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_error_invalid_use_instance_t));
  dst = ((globus_error_invalid_use_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->invalid_use_operation = globus_object_copy(src->invalid_use_operation);
}

static void globus_l_error_invalid_use_destroy (void *datavp)
{
  globus_error_invalid_use_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_error_invalid_use_instance_t *) datavp);
  globus_object_free (data->invalid_use_operation);
  data->invalid_use_operation = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_ERROR_TYPE_INVALID_USE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_BASE_DEFINITION),
        globus_l_error_invalid_use_copy,
        globus_l_error_invalid_use_destroy,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_INVALID_USE   */
extern globus_object_t *
globus_error_construct_invalid_use (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_INVALID_USE);

  error = globus_error_initialize_invalid_use (
    newerror,
    base_source,
    base_cause,
    invalid_use_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_INVALID_USE   */
extern globus_object_t *
globus_error_initialize_invalid_use (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{
  globus_error_invalid_use_set_invalid_use_operation (error, invalid_use_operation);

  return globus_error_initialize_base (
    error,
    base_source,
    base_cause);
}

/* return the invalid_use_operation instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_USE   */
extern globus_object_t *
globus_error_invalid_use_get_invalid_use_operation (globus_object_t * error)
{
  globus_error_invalid_use_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_use_instance_data (error);
  if (instance_data != NULL) {
    return (instance_data->invalid_use_operation);
  }
  else return NULL;
}

/* set the invalid_use_operation instance data of an error
 * derived from GLOBUS_ERROR_TYPE_INVALID_USE   */
extern void
globus_error_invalid_use_set_invalid_use_operation (
    globus_object_t * error,
    globus_object_t * value)
{
  globus_error_invalid_use_instance_t * instance_data;
  instance_data
   = globus_l_error_invalid_use_instance_data (error);
  if (instance_data != NULL) {
    instance_data->invalid_use_operation = value;
  }
}


const globus_object_type_t GLOBUS_ERROR_TYPE_ALREADY_DONE_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_INVALID_USE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_ALREADY_DONE   */
extern globus_object_t *
globus_error_construct_already_done (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_ALREADY_DONE);

  error = globus_error_initialize_already_done (
    newerror,
    base_source,
    base_cause,
    invalid_use_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_ALREADY_DONE   */
extern globus_object_t *
globus_error_initialize_already_done (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{

  return globus_error_initialize_invalid_use (
    error,
    base_source,
    base_cause,
    invalid_use_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_ALREADY_REGISTERED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ALREADY_DONE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_ALREADY_REGISTERED   */
extern globus_object_t *
globus_error_construct_already_registered (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_ALREADY_REGISTERED);

  error = globus_error_initialize_already_registered (
    newerror,
    base_source,
    base_cause,
    invalid_use_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_ALREADY_REGISTERED   */
extern globus_object_t *
globus_error_initialize_already_registered (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{

  return globus_error_initialize_already_done (
    error,
    base_source,
    base_cause,
    invalid_use_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_ALREADY_CANCELLED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_ALREADY_DONE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_ALREADY_CANCELLED   */
extern globus_object_t *
globus_error_construct_already_cancelled (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_ALREADY_CANCELLED);

  error = globus_error_initialize_already_cancelled (
    newerror,
    base_source,
    base_cause,
    invalid_use_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_ALREADY_CANCELLED   */
extern globus_object_t *
globus_error_initialize_already_cancelled (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{

  return globus_error_initialize_already_done (
    error,
    base_source,
    base_cause,
    invalid_use_operation);
}


const globus_object_type_t GLOBUS_ERROR_TYPE_NOT_INITIALIZED_DEFINITION
= globus_error_type_static_initializer (
        (&GLOBUS_ERROR_TYPE_INVALID_USE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an error of type
 * GLOBUS_ERROR_TYPE_NOT_INITIALIZED   */
extern globus_object_t *
globus_error_construct_not_initialized (
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{
  globus_object_t * newerror, * error;
  newerror = globus_object_construct (GLOBUS_ERROR_TYPE_NOT_INITIALIZED);

  error = globus_error_initialize_not_initialized (
    newerror,
    base_source,
    base_cause,
    invalid_use_operation);

  if (error==NULL) globus_object_free (newerror);

  return error;
}

/* initialize and return an error of type
 * GLOBUS_ERROR_TYPE_NOT_INITIALIZED   */
extern globus_object_t *
globus_error_initialize_not_initialized (
    globus_object_t * error,
    globus_module_descriptor_t * base_source,
    globus_object_t * base_cause,
    globus_object_t * invalid_use_operation)
{

  return globus_error_initialize_invalid_use (
    error,
    base_source,
    base_cause,
    invalid_use_operation);
}




