#ifndef __GM_UI_H__
#define __GM_UI_H__

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <gtk/gtk.h>
#include "widgets/gm-app-view.h"
#include "widgets/gm-commands.h"
#include "gm-support.h"
#include "gm-pixbuf.h"

G_BEGIN_DECLS

static const GtkActionEntry gm_sensitive_menu_entries[] =
{
	/* Toplevel */
	{"World", NULL, N_("_World")},
	{"Edit", NULL, N_("_Edit")},
	{"View", NULL, N_("_View")},
	{"Help", NULL, N_("_Help")},

	/* World menu */
	{"WorldNew", GTK_STOCK_NEW, N_("New World..."), "<control>N",
			N_("Create a new world"), G_CALLBACK(on_action_world_new)},
	{"WorldOpen", GTK_STOCK_OPEN, N_("Open World..."), "<control>O",
			N_("Open an existing world"), 
			G_CALLBACK(on_action_world_open)},
	{"WorldQuit", GTK_STOCK_QUIT, NULL, NULL,
			N_("Quit the program"), G_CALLBACK(on_action_world_quit)},
	
	/* Edit menu */
	{"EditWorlds", NULL, N_("Worlds..."), NULL,
			N_("Edit worlds"), G_CALLBACK(on_action_edit_worlds)},
	{"EditPreferences", GTK_STOCK_PREFERENCES, NULL, NULL,
			N_("Configure the application"), 
			G_CALLBACK(on_action_edit_preferences)},
	{"EditScripts", NULL, N_("Scripts"), NULL,
			N_("Edit scripts"), G_CALLBACK(on_action_edit_scripts)},
 
	/* Help menu */
	{"HelpAbout", GTK_STOCK_ABOUT, NULL, NULL,
			N_("About this application"), G_CALLBACK(on_action_help_about)}
};

static const GtkToggleActionEntry gm_toggle_menu_entries[] = 
{
	/* View menu */
	{"ViewToolbar", NULL, N_("_Toolbar"), NULL,
			N_("Show or hide the toolbar"), G_CALLBACK(on_action_view_toolbar), TRUE},
	{"ViewUserlist", NULL, N_("_Userlist"), "F9",
			N_("Show or hide the world userlist"), G_CALLBACK(on_action_view_userlist), TRUE},
};

static const GtkActionEntry gm_editor_entries[] = 
{
	{"Editor", NULL, N_("E_ditor")},
	/* Editor toolbar */
	{"EditorSave", GTK_STOCK_SAVE, N_("Save"), "<control>S",
			N_("Save editor contents"),
			G_CALLBACK(on_action_editor_save)},
	{"EditorSaveClose", GM_STOCK_SAVE_CLOSE, N_("Save and close"), NULL,
			N_("Save editor contents and close editor"),
			G_CALLBACK(on_action_editor_save_close)},
#ifdef HAVE_PARSER
	{"EditorParse", GTK_STOCK_EXECUTE, N_("Check code"), "<control><shift>P",
			N_("Check code for warnings and errors"),
			G_CALLBACK(on_action_editor_parse)},
#endif
	{"EditorClose", GTK_STOCK_CLOSE, N_("Close"), NULL,
			N_("Close current editor"),
			G_CALLBACK(on_action_editor_close)}
};

static const GtkActionEntry gm_menu_entries[] =
{
	/* File menu */
	{"WorldConnect", GTK_STOCK_CONNECT, N_("Connect"), "<control><shift>C",
			N_("Connect the current world"), 
			G_CALLBACK(on_action_world_connect)},
	{"WorldClose", GTK_STOCK_CLOSE, NULL, NULL,
			N_("Close current world"), G_CALLBACK(on_action_world_close)},
	{"WorldPaste", GTK_STOCK_PASTE, N_("Paste"), "<control>P",
			N_("Paste text to the current world"),
			G_CALLBACK(on_action_world_paste)},
	{"WorldLogs", GTK_STOCK_JUSTIFY_LEFT, N_("Logs"), NULL,
			N_("View current world logs"), 
			G_CALLBACK(on_action_world_logs)},
	{"WorldInfo", GTK_STOCK_INFO, N_("In_fo"), NULL,
			N_("View current world info"), NULL},
	
	/* Edit menu */
	{"EditCut", GTK_STOCK_CUT, NULL, "<control>X",
			N_("Cut the selection"), G_CALLBACK(on_action_edit_cut)},
	{"EditCopy", GTK_STOCK_COPY, NULL, "<control>C",
			N_("Copy the selection"), G_CALLBACK(on_action_edit_copy)},
	{"EditPaste", GTK_STOCK_PASTE, NULL, "<control>V",
			N_("Paste the clipboard"), G_CALLBACK(on_action_edit_paste)},
	{"EditWorld", NULL, N_("Current world..."), NULL,
			N_("Edit the current world"), 
			G_CALLBACK(on_action_edit_world)},
	{"EditFind", GTK_STOCK_FIND, NULL, "<control>F",
			N_("Search for text"), G_CALLBACK(on_gm_app_view_edit_find)},
	{"EditFindNext", GTK_STOCK_FIND, N_("Find Ne_xt"), "<control>G",
			N_("Search forwards for the same text"), 
			G_CALLBACK(on_gm_app_view_edit_find_next)},
	{"EditReplace", GTK_STOCK_FIND_AND_REPLACE, N_("_Replace..."), "<control>R",
			N_("Search for and replace text"), 
			G_CALLBACK(on_gm_app_view_edit_replace)},
	
	/* Toolbar */
	{"WorldTriggers", GTK_STOCK_INDEX, N_("Triggers"), NULL,
			N_("Edit the current world triggers"),
			G_CALLBACK(on_action_edit_triggers)},
	{"WorldProperties", GTK_STOCK_PROPERTIES, N_("Properties"), NULL,
			N_("Edit the current world"),
			G_CALLBACK(on_action_edit_world)}
};

G_END_DECLS

#endif  /* __GEDIT_UI_H__  */
