#ifndef __GM_IUSERLIST_H__
#define __GM_IUSERLIST_H__

#include <gtk/gtk.h>
#include <glib.h>

#define GM_TYPE_IUSERLIST					(gm_iuserlist_get_type())
#define GM_IUSERLIST(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_IUSERLIST, GmIUserlist))
#define GM_IUSERLIST_CLASS(obj)				(G_TYPE_CHECK_CLASS_CAST((obj), \
		GM_TYPE_IUSERLIST, GmIUserlistInterface))
#define GM_IS_IUSERLIST(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_IUSERLIST))
#define GM_IUSERLIST_GET_INTERFACE(inst)	(G_TYPE_INSTANCE_GET_INTERFACE( \
		(inst), GM_TYPE_IUSERLIST, GmIUserlistInterface))

typedef struct _GmIUserlist GmIUserlist; /* dummy object */
typedef struct _GmIUserlistInterface GmIUserlistInterface;

struct _GmIUserlistInterface {
	GTypeInterface parent;

	GList *(* get_menu) (GmIUserlist *self, gint id);
	gchar *(* get_status) (GmIUserlist *self, gint id);
	
	gchar const *(* get_name) (GmIUserlist *self, gint id);
	gchar const *(* get_icon) (GmIUserlist *self, gint id, gboolean use_state);
	gint (* get_rank_priority) (GmIUserlist *self, gint id);
	gint (* get_state_priority) (GmIUserlist *self, gint id);

	/* Signals */
	void (* player_added) (GmIUserlist *obj, gint id);
	void (* player_removed) (GmIUserlist *obj, gint id);
	void (* name_changed) (GmIUserlist *obj, gint id);
	void (* state_changed) (GmIUserlist *obj, gint id);
	void (* rank_changed) (GmIUserlist *obj, gint id);
};

GType gm_iuserlist_get_type();

GList *gm_iuserlist_get_menu(GmIUserlist *self, gint id);
gboolean gm_iuserlist_supports_status(GmIUserlist *self);
gchar *gm_iuserlist_get_status(GmIUserlist *self, gint id);

gchar const *gm_iuserlist_get_name(GmIUserlist *self, gint id);
gchar const *gm_iuserlist_get_icon(GmIUserlist *self, gint id,
		gboolean use_state);
gint gm_iuserlist_get_rank_priority(GmIUserlist *self, gint id);
gint gm_iuserlist_get_state_priority(GmIUserlist *self, gint id);

#endif /* __GM_IUSERLIST_H__ */
