#ifndef __GM_MCP_SESSION_H__
#define __GM_MCP_SESSION_H__

#include <glib-object.h>
#include "gm-mcp-package.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_MCP_SESSION					(gm_mcp_session_get_type())
#define GM_MCP_SESSION(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_MCP_SESSION, GmMcpSession))
#define GM_MCP_SESSION_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj),\
		GM_TYPE_MCP_SESSION, GmMcpSession const))
#define GM_MCP_SESSION_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_MCP_SESSION, GmMcpSessionClass))
#define GM_IS_MCP_SESSION(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_MCP_SESSION))
#define GM_IS_MCP_SESSION_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_MCP_SESSION))
#define GM_MCP_SESSION_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_MCP_SESSION, GmMcpSessionClass))
#define GM_MCP_SESSION_WORLD(obj)			(GM_WORLD(gm_mcp_session_world(obj)))

typedef struct _McpMultilineInfo {
	gchar *key;
	gchar *data_tag;
	GList *data;
	GmMcpPackage *package;
} McpMultilineInfo;

typedef gboolean (* GmPackageClassFunc) (GmMcpPackageClass *klass, 
		gpointer user_data);

/* Private structure type */
typedef struct _GmMcpSessionPrivate GmMcpSessionPrivate;

/*
 * Main object structure
 */
typedef struct _GmMcpSession GmMcpSession;
 
struct _GmMcpSession {
	GObject parent;
	
	/*< private > */
	GmMcpSessionPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmMcpSessionClass 	GmMcpSessionClass;

struct _GmMcpSessionClass {
	GObjectClass parent_class;
	GList *available_packages;

	/* Signals */
	void (* package_created) (GmMcpSession *obj, GObject *package);
};

GType gm_mcp_session_get_type(void) G_GNUC_CONST;
GmMcpSession *gm_mcp_session_new(GObject *world);

GObject *gm_mcp_session_world(GmMcpSession *session);
GList const *gm_mcp_session_get_packages(GmMcpSession *session);
void gm_mcp_session_reset(GmMcpSession *session);
gboolean gm_mcp_session_initialized(GmMcpSession *session);

void gm_mcp_session_handle_oob(GmMcpSession *session, gchar *line);

GmMcpPackage *gm_mcp_session_has_package_of_class(GmMcpSession *session, 
		GmMcpPackageClass *klass);
GmMcpPackageClass *gm_mcp_session_find_package_class(gchar const *name);
GmMcpPackage *gm_mcp_session_find_package(GmMcpSession *session,
		gchar const *pname);
GmMcpPackageClass *gm_mcp_session_package_class_for_each(
		GmPackageClassFunc func, gpointer user_data);

GmMcpPackage *gm_mcp_session_create_package(GmMcpSession *session, 
		GmMcpPackageClass *klass, gdouble version);

void gm_mcp_session_send_simple(GmMcpSession *session, gchar const *pname,
		gchar const *first_key, ...);
void gm_mcp_session_send_multiline(GmMcpSession *session, gchar const *data_tag,
		gchar const *key, GList const *lines);

G_END_DECLS
#endif /* __GM_MCP_SESSION_H__ */
