/* ScannedItem.c generated by valac 0.16.1, the Vala compiler
 * generated from ScannedItem.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;
typedef struct _DVBScannedItemPrivate DVBScannedItemPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;

#define DVB_TYPE_SCANNED_SATTELITE_ITEM (dvb_scanned_sattelite_item_get_type ())
#define DVB_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItem))
#define DVB_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))
#define DVB_IS_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_IS_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_SCANNED_SATTELITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))

typedef struct _DVBScannedSatteliteItem DVBScannedSatteliteItem;
typedef struct _DVBScannedSatteliteItemClass DVBScannedSatteliteItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBScannedSatteliteItemPrivate DVBScannedSatteliteItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBScannedItem {
	GObject parent_instance;
	DVBScannedItemPrivate * priv;
};

struct _DVBScannedItemClass {
	GObjectClass parent_class;
};

struct _DVBScannedItemPrivate {
	guint _Frequency;
};

struct _DVBScannedSatteliteItem {
	DVBScannedItem parent_instance;
	DVBScannedSatteliteItemPrivate * priv;
};

struct _DVBScannedSatteliteItemClass {
	DVBScannedItemClass parent_class;
};

struct _DVBScannedSatteliteItemPrivate {
	gchar* _Polarization;
};


static gpointer dvb_scanned_item_parent_class = NULL;
static DVBLoggingLogger* dvb_scanned_item_log;
static DVBLoggingLogger* dvb_scanned_item_log = NULL;
static gpointer dvb_scanned_sattelite_item_parent_class = NULL;

GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
#define DVB_SCANNED_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_ITEM, DVBScannedItemPrivate))
enum  {
	DVB_SCANNED_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_ITEM_FREQUENCY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SCANNED_ITEM_PRIME 31
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
guint dvb_scanned_item_hash (DVBScannedItem* o);
GType dvb_scanned_sattelite_item_get_type (void) G_GNUC_CONST;
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
const gchar* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value);
static void dvb_scanned_item_finalize (GObject* obj);
static void _vala_dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemPrivate))
enum  {
	DVB_SCANNED_SATTELITE_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_SATTELITE_ITEM_POLARIZATION
};
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const gchar* polarization);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const gchar* polarization);
static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const gchar* value);
static void dvb_scanned_sattelite_item_finalize (GObject* obj);
static void _vala_dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency) {
	DVBScannedItem * self = NULL;
	guint _tmp0_;
	_tmp0_ = frequency;
	self = (DVBScannedItem*) g_object_new (object_type, "Frequency", _tmp0_, NULL);
	return self;
}


DVBScannedItem* dvb_scanned_item_new (guint frequency) {
	return dvb_scanned_item_construct (DVB_TYPE_SCANNED_ITEM, frequency);
}


guint dvb_scanned_item_hash (DVBScannedItem* o) {
	guint result = 0U;
	guint hashval = 0U;
	DVBScannedItem* _tmp0_;
	_tmp0_ = o;
	if (DVB_IS_SCANNED_SATTELITE_ITEM (_tmp0_)) {
		DVBScannedItem* _tmp1_;
		guint _tmp2_;
		DVBScannedItem* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp1_ = o;
		_tmp2_ = _tmp1_->priv->_Frequency;
		_tmp3_ = o;
		_tmp4_ = dvb_scanned_sattelite_item_get_Polarization (DVB_SCANNED_SATTELITE_ITEM (_tmp3_));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_str_hash (_tmp5_);
		hashval = ((2 * DVB_SCANNED_ITEM_PRIME) + (DVB_SCANNED_ITEM_PRIME * _tmp2_)) + _tmp6_;
	} else {
		DVBScannedItem* _tmp7_;
		_tmp7_ = o;
		if (DVB_IS_SCANNED_ITEM (_tmp7_)) {
			DVBScannedItem* _tmp8_;
			guint _tmp9_;
			_tmp8_ = o;
			_tmp9_ = _tmp8_->priv->_Frequency;
			hashval = _tmp9_;
		} else {
			hashval = (guint) 0;
		}
	}
	result = hashval;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DVBScannedItem* _tmp1_;
	gboolean _tmp3_;
	DVBScannedItem* _tmp4_;
	GType _tmp5_ = 0UL;
	const gchar* _tmp6_ = NULL;
	DVBScannedItem* _tmp7_;
	GType _tmp8_ = 0UL;
	const gchar* _tmp9_ = NULL;
	DVBScannedItem* _tmp10_;
	_tmp1_ = o1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		DVBScannedItem* _tmp2_;
		_tmp2_ = o2;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = o1;
	_tmp5_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp4_);
	_tmp6_ = g_type_name (_tmp5_);
	_tmp7_ = o2;
	_tmp8_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp7_);
	_tmp9_ = g_type_name (_tmp8_);
	if (g_strcmp0 (_tmp6_, _tmp9_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = o1;
	if (DVB_IS_SCANNED_SATTELITE_ITEM (_tmp10_)) {
		DVBScannedItem* _tmp11_;
		DVBScannedSatteliteItem* _tmp12_;
		DVBScannedSatteliteItem* item1;
		DVBScannedItem* _tmp13_;
		DVBScannedSatteliteItem* _tmp14_;
		DVBScannedSatteliteItem* item2;
		gboolean _tmp15_ = FALSE;
		DVBScannedSatteliteItem* _tmp16_;
		guint _tmp17_;
		DVBScannedSatteliteItem* _tmp18_;
		guint _tmp19_;
		gboolean _tmp26_;
		_tmp11_ = o1;
		_tmp12_ = _g_object_ref0 (DVB_SCANNED_SATTELITE_ITEM (_tmp11_));
		item1 = _tmp12_;
		_tmp13_ = o2;
		_tmp14_ = _g_object_ref0 (DVB_SCANNED_SATTELITE_ITEM (_tmp13_));
		item2 = _tmp14_;
		_tmp16_ = item1;
		_tmp17_ = DVB_SCANNED_ITEM (_tmp16_)->priv->_Frequency;
		_tmp18_ = item2;
		_tmp19_ = DVB_SCANNED_ITEM (_tmp18_)->priv->_Frequency;
		if (_tmp17_ == _tmp19_) {
			DVBScannedSatteliteItem* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			DVBScannedSatteliteItem* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp20_ = item1;
			_tmp21_ = dvb_scanned_sattelite_item_get_Polarization (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = item2;
			_tmp24_ = dvb_scanned_sattelite_item_get_Polarization (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp15_ = g_strcmp0 (_tmp22_, _tmp25_) == 0;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp26_ = _tmp15_;
		result = _tmp26_;
		_g_object_unref0 (item2);
		_g_object_unref0 (item1);
		return result;
	} else {
		DVBScannedItem* _tmp27_;
		_tmp27_ = o1;
		if (DVB_IS_SCANNED_ITEM (_tmp27_)) {
			DVBScannedItem* _tmp28_;
			DVBScannedItem* _tmp29_;
			DVBScannedItem* item1;
			DVBScannedItem* _tmp30_;
			DVBScannedItem* _tmp31_;
			DVBScannedItem* item2;
			DVBScannedItem* _tmp32_;
			guint _tmp33_;
			DVBScannedItem* _tmp34_;
			guint _tmp35_;
			_tmp28_ = o1;
			_tmp29_ = _g_object_ref0 (DVB_SCANNED_ITEM (_tmp28_));
			item1 = _tmp29_;
			_tmp30_ = o2;
			_tmp31_ = _g_object_ref0 (DVB_SCANNED_ITEM (_tmp30_));
			item2 = _tmp31_;
			_tmp32_ = item1;
			_tmp33_ = _tmp32_->priv->_Frequency;
			_tmp34_ = item2;
			_tmp35_ = _tmp34_->priv->_Frequency;
			result = _tmp33_ == _tmp35_;
			_g_object_unref0 (item2);
			_g_object_unref0 (item1);
			return result;
		} else {
			DVBLoggingLogger* _tmp36_;
			_tmp36_ = dvb_scanned_item_log;
			dvb_logging_logger_error (_tmp36_, "ScannedItem.vala:71: Don't comparing ScannedItem instances");
			result = FALSE;
			return result;
		}
	}
}


guint dvb_scanned_item_get_Frequency (DVBScannedItem* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Frequency;
	result = _tmp0_;
	return result;
}


static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Frequency = _tmp0_;
	g_object_notify ((GObject *) self, "Frequency");
}


static void dvb_scanned_item_class_init (DVBScannedItemClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_scanned_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanned_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanned_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_ITEM_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_scanned_item_log = _tmp1_;
}


static void dvb_scanned_item_instance_init (DVBScannedItem * self) {
	self->priv = DVB_SCANNED_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_item_finalize (GObject* obj) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (obj);
	G_OBJECT_CLASS (dvb_scanned_item_parent_class)->finalize (obj);
}


/**
     * This class represents a frequency and possibly other parameters
     * that are necessary to mark a frequency as scanned
     */
GType dvb_scanned_item_get_type (void) {
	static volatile gsize dvb_scanned_item_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanned_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedItem), 0, (GInstanceInitFunc) dvb_scanned_item_instance_init, NULL };
		GType dvb_scanned_item_type_id;
		dvb_scanned_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScannedItem", &g_define_type_info, 0);
		g_once_init_leave (&dvb_scanned_item_type_id__volatile, dvb_scanned_item_type_id);
	}
	return dvb_scanned_item_type_id__volatile;
}


static void _vala_dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		g_value_set_uint (value, dvb_scanned_item_get_Frequency (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		dvb_scanned_item_set_Frequency (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const gchar* polarization) {
	DVBScannedSatteliteItem * self = NULL;
	guint _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (polarization != NULL, NULL);
	_tmp0_ = frequency;
	_tmp1_ = polarization;
	self = (DVBScannedSatteliteItem*) g_object_new (object_type, "Frequency", _tmp0_, "Polarization", _tmp1_, NULL);
	return self;
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const gchar* polarization) {
	return dvb_scanned_sattelite_item_construct (DVB_TYPE_SCANNED_SATTELITE_ITEM, frequency, polarization);
}


const gchar* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Polarization;
	result = _tmp0_;
	return result;
}


static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_Polarization);
	self->priv->_Polarization = _tmp1_;
	g_object_notify ((GObject *) self, "Polarization");
}


static void dvb_scanned_sattelite_item_class_init (DVBScannedSatteliteItemClass * klass) {
	dvb_scanned_sattelite_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedSatteliteItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanned_sattelite_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanned_sattelite_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_sattelite_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_SATTELITE_ITEM_POLARIZATION, g_param_spec_string ("Polarization", "Polarization", "Polarization", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_scanned_sattelite_item_instance_init (DVBScannedSatteliteItem * self) {
	self->priv = DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_sattelite_item_finalize (GObject* obj) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (obj);
	_g_free0 (self->priv->_Polarization);
	G_OBJECT_CLASS (dvb_scanned_sattelite_item_parent_class)->finalize (obj);
}


GType dvb_scanned_sattelite_item_get_type (void) {
	static volatile gsize dvb_scanned_sattelite_item_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanned_sattelite_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedSatteliteItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_sattelite_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedSatteliteItem), 0, (GInstanceInitFunc) dvb_scanned_sattelite_item_instance_init, NULL };
		GType dvb_scanned_sattelite_item_type_id;
		dvb_scanned_sattelite_item_type_id = g_type_register_static (DVB_TYPE_SCANNED_ITEM, "DVBScannedSatteliteItem", &g_define_type_info, 0);
		g_once_init_leave (&dvb_scanned_sattelite_item_type_id__volatile, dvb_scanned_sattelite_item_type_id);
	}
	return dvb_scanned_sattelite_item_type_id__volatile;
}


static void _vala_dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		g_value_set_string (value, dvb_scanned_sattelite_item_get_Polarization (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		dvb_scanned_sattelite_item_set_Polarization (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



