// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/functions/v1beta2/functions.proto

package functions

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Describes the current stage of a deployment.
type CloudFunctionStatus int32

const (
	// Status not specified.
	CloudFunctionStatus_STATUS_UNSPECIFIED CloudFunctionStatus = 0
	// Successfully deployed.
	CloudFunctionStatus_READY CloudFunctionStatus = 1
	// Not deployed correctly - behavior is undefined. The item should be updated
	// or deleted to move it out of this state.
	CloudFunctionStatus_FAILED CloudFunctionStatus = 2
	// Creation or update in progress.
	CloudFunctionStatus_DEPLOYING CloudFunctionStatus = 3
	// Deletion in progress.
	CloudFunctionStatus_DELETING CloudFunctionStatus = 4
)

var CloudFunctionStatus_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "READY",
	2: "FAILED",
	3: "DEPLOYING",
	4: "DELETING",
}

var CloudFunctionStatus_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"READY":              1,
	"FAILED":             2,
	"DEPLOYING":          3,
	"DELETING":           4,
}

func (x CloudFunctionStatus) String() string {
	return proto.EnumName(CloudFunctionStatus_name, int32(x))
}

func (CloudFunctionStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{0}
}

// Describes a Cloud Function that contains user computation executed in
// response to an event. It encapsulate function and triggers configurations.
type CloudFunction struct {
	// A user-defined name of the function. Function names must be unique
	// globally and match pattern `projects/*/locations/*/functions/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The location of the function source code.
	//
	// Types that are valid to be assigned to SourceCode:
	//	*CloudFunction_SourceArchiveUrl
	//	*CloudFunction_SourceRepository
	//	*CloudFunction_SourceRepositoryUrl
	//	*CloudFunction_SourceUploadUrl
	SourceCode isCloudFunction_SourceCode `protobuf_oneof:"source_code"`
	// An event that triggers the function.
	//
	// Types that are valid to be assigned to Trigger:
	//	*CloudFunction_HttpsTrigger
	//	*CloudFunction_EventTrigger
	Trigger isCloudFunction_Trigger `protobuf_oneof:"trigger"`
	// Output only. Status of the function deployment.
	Status CloudFunctionStatus `protobuf:"varint,7,opt,name=status,proto3,enum=google.cloud.functions.v1beta2.CloudFunctionStatus" json:"status,omitempty"`
	// Output only. Name of the most recent operation modifying the function. If
	// the function status is `DEPLOYING` or `DELETING`, then it points to the
	// active operation.
	LatestOperation string `protobuf:"bytes,8,opt,name=latest_operation,json=latestOperation,proto3" json:"latest_operation,omitempty"`
	// The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix, if not specified. For
	// backward compatibility, if function with given name is not found, then the
	// system will try to use function named "function".
	// For Node.js this is name of a function exported by the module specified
	// in `source_location`.
	EntryPoint string `protobuf:"bytes,9,opt,name=entry_point,json=entryPoint,proto3" json:"entry_point,omitempty"`
	// The runtime in which to run the function. Required when deploying a new
	// function, optional when updating an existing function. For a complete
	// list of possible choices, see the
	// [`gcloud` command
	// reference](/sdk/gcloud/reference/functions/deploy#--runtime).
	Runtime string `protobuf:"bytes,23,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// The function execution timeout. Execution is considered failed and
	// can be terminated if the function is not completed at the end of the
	// timeout period. Defaults to 60 seconds.
	Timeout *duration.Duration `protobuf:"bytes,10,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The amount of memory in MB available for a function.
	// Defaults to 256MB.
	AvailableMemoryMb int32 `protobuf:"varint,11,opt,name=available_memory_mb,json=availableMemoryMb,proto3" json:"available_memory_mb,omitempty"`
	// The email of the function's service account. If empty, defaults to
	// `{project_id}@appspot.gserviceaccount.com`.
	ServiceAccount string `protobuf:"bytes,13,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. The last update timestamp of a Cloud Function.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,15,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The version identifier of the Cloud Function. Each deployment attempt
	// results in a new version of a function being created.
	VersionId int64 `protobuf:"varint,20,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Labels associated with this Cloud Function.
	Labels map[string]string `protobuf:"bytes,21,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Environment variables that shall be available during function execution.
	EnvironmentVariables map[string]string `protobuf:"bytes,22,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The limit on the maximum number of function instances that may coexist at a
	// given time.
	MaxInstances int32 `protobuf:"varint,24,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	// The VPC Network that this cloud function can connect to. It can be
	// either the fully-qualified URI, or the short name of the network resource.
	// If the short network name is used, the network must belong to the same
	// project. Otherwise, it must belong to a project within the same
	// organization. The format of this field is either
	// `projects/{project}/global/networks/{network}` or `{network}`, where
	// {project} is a project id where the network is defined, and {network} is
	// the short name of the network.
	//
	// This field is mutually exclusive with `vpc_connector` and will be replaced
	// by it.
	//
	// See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
	// more information on connecting Cloud projects.
	Network string `protobuf:"bytes,25,opt,name=network,proto3" json:"network,omitempty"`
	// The VPC Network Connector that this cloud function can connect to. It can
	// be either the fully-qualified URI, or the short name of the network
	// connector resource. The format of this field is
	// `projects/*/locations/*/connectors/*`
	//
	// This field is mutually exclusive with `network` field and will eventually
	// replace it.
	//
	// See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
	// more information on connecting Cloud projects.
	VpcConnector         string   `protobuf:"bytes,26,opt,name=vpc_connector,json=vpcConnector,proto3" json:"vpc_connector,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudFunction) Reset()         { *m = CloudFunction{} }
func (m *CloudFunction) String() string { return proto.CompactTextString(m) }
func (*CloudFunction) ProtoMessage()    {}
func (*CloudFunction) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{0}
}

func (m *CloudFunction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudFunction.Unmarshal(m, b)
}
func (m *CloudFunction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudFunction.Marshal(b, m, deterministic)
}
func (m *CloudFunction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudFunction.Merge(m, src)
}
func (m *CloudFunction) XXX_Size() int {
	return xxx_messageInfo_CloudFunction.Size(m)
}
func (m *CloudFunction) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudFunction.DiscardUnknown(m)
}

var xxx_messageInfo_CloudFunction proto.InternalMessageInfo

func (m *CloudFunction) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isCloudFunction_SourceCode interface {
	isCloudFunction_SourceCode()
}

type CloudFunction_SourceArchiveUrl struct {
	SourceArchiveUrl string `protobuf:"bytes,14,opt,name=source_archive_url,json=sourceArchiveUrl,proto3,oneof"`
}

type CloudFunction_SourceRepository struct {
	SourceRepository *SourceRepository `protobuf:"bytes,3,opt,name=source_repository,json=sourceRepository,proto3,oneof"`
}

type CloudFunction_SourceRepositoryUrl struct {
	SourceRepositoryUrl string `protobuf:"bytes,18,opt,name=source_repository_url,json=sourceRepositoryUrl,proto3,oneof"`
}

type CloudFunction_SourceUploadUrl struct {
	SourceUploadUrl string `protobuf:"bytes,16,opt,name=source_upload_url,json=sourceUploadUrl,proto3,oneof"`
}

func (*CloudFunction_SourceArchiveUrl) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceRepository) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceRepositoryUrl) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceUploadUrl) isCloudFunction_SourceCode() {}

func (m *CloudFunction) GetSourceCode() isCloudFunction_SourceCode {
	if m != nil {
		return m.SourceCode
	}
	return nil
}

func (m *CloudFunction) GetSourceArchiveUrl() string {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceArchiveUrl); ok {
		return x.SourceArchiveUrl
	}
	return ""
}

func (m *CloudFunction) GetSourceRepository() *SourceRepository {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceRepository); ok {
		return x.SourceRepository
	}
	return nil
}

func (m *CloudFunction) GetSourceRepositoryUrl() string {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceRepositoryUrl); ok {
		return x.SourceRepositoryUrl
	}
	return ""
}

func (m *CloudFunction) GetSourceUploadUrl() string {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceUploadUrl); ok {
		return x.SourceUploadUrl
	}
	return ""
}

type isCloudFunction_Trigger interface {
	isCloudFunction_Trigger()
}

type CloudFunction_HttpsTrigger struct {
	HttpsTrigger *HTTPSTrigger `protobuf:"bytes,6,opt,name=https_trigger,json=httpsTrigger,proto3,oneof"`
}

type CloudFunction_EventTrigger struct {
	EventTrigger *EventTrigger `protobuf:"bytes,12,opt,name=event_trigger,json=eventTrigger,proto3,oneof"`
}

func (*CloudFunction_HttpsTrigger) isCloudFunction_Trigger() {}

func (*CloudFunction_EventTrigger) isCloudFunction_Trigger() {}

func (m *CloudFunction) GetTrigger() isCloudFunction_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *CloudFunction) GetHttpsTrigger() *HTTPSTrigger {
	if x, ok := m.GetTrigger().(*CloudFunction_HttpsTrigger); ok {
		return x.HttpsTrigger
	}
	return nil
}

func (m *CloudFunction) GetEventTrigger() *EventTrigger {
	if x, ok := m.GetTrigger().(*CloudFunction_EventTrigger); ok {
		return x.EventTrigger
	}
	return nil
}

func (m *CloudFunction) GetStatus() CloudFunctionStatus {
	if m != nil {
		return m.Status
	}
	return CloudFunctionStatus_STATUS_UNSPECIFIED
}

func (m *CloudFunction) GetLatestOperation() string {
	if m != nil {
		return m.LatestOperation
	}
	return ""
}

func (m *CloudFunction) GetEntryPoint() string {
	if m != nil {
		return m.EntryPoint
	}
	return ""
}

func (m *CloudFunction) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *CloudFunction) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *CloudFunction) GetAvailableMemoryMb() int32 {
	if m != nil {
		return m.AvailableMemoryMb
	}
	return 0
}

func (m *CloudFunction) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *CloudFunction) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *CloudFunction) GetVersionId() int64 {
	if m != nil {
		return m.VersionId
	}
	return 0
}

func (m *CloudFunction) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CloudFunction) GetEnvironmentVariables() map[string]string {
	if m != nil {
		return m.EnvironmentVariables
	}
	return nil
}

func (m *CloudFunction) GetMaxInstances() int32 {
	if m != nil {
		return m.MaxInstances
	}
	return 0
}

func (m *CloudFunction) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *CloudFunction) GetVpcConnector() string {
	if m != nil {
		return m.VpcConnector
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CloudFunction) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CloudFunction_SourceArchiveUrl)(nil),
		(*CloudFunction_SourceRepository)(nil),
		(*CloudFunction_SourceRepositoryUrl)(nil),
		(*CloudFunction_SourceUploadUrl)(nil),
		(*CloudFunction_HttpsTrigger)(nil),
		(*CloudFunction_EventTrigger)(nil),
	}
}

// Describes HTTPSTrigger, could be used to connect web hooks to function.
type HTTPSTrigger struct {
	// Output only. The deployed url for the function.
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPSTrigger) Reset()         { *m = HTTPSTrigger{} }
func (m *HTTPSTrigger) String() string { return proto.CompactTextString(m) }
func (*HTTPSTrigger) ProtoMessage()    {}
func (*HTTPSTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{1}
}

func (m *HTTPSTrigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPSTrigger.Unmarshal(m, b)
}
func (m *HTTPSTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPSTrigger.Marshal(b, m, deterministic)
}
func (m *HTTPSTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPSTrigger.Merge(m, src)
}
func (m *HTTPSTrigger) XXX_Size() int {
	return xxx_messageInfo_HTTPSTrigger.Size(m)
}
func (m *HTTPSTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPSTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPSTrigger proto.InternalMessageInfo

func (m *HTTPSTrigger) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// Describes EventTrigger, used to request events be sent from another
// service.
type EventTrigger struct {
	// `event_type` names contain the service that is sending an event and the
	// kind of event that was fired. Must be of the form
	// `providers/*/eventTypes/*` e.g. Directly handle a Message published to
	// Google Cloud Pub/Sub `providers/cloud.pubsub/eventTypes/topic.publish`.
	//
	// Handle an object changing in Google Cloud Storage:
	// `providers/cloud.storage/eventTypes/object.change`
	//
	// Handle a write to the Firebase Realtime Database:
	// `providers/google.firebase.database/eventTypes/ref.write`
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Which instance of the source's service should send events. E.g. for Pub/Sub
	// this would be a Pub/Sub topic at `projects/*/topics/*`. For Google Cloud
	// Storage this would be a bucket at `projects/*/buckets/*`. For any source
	// that only supports one instance per-project, this should be the name of the
	// project (`projects/*`)
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// The hostname of the service that should be observed.
	//
	// If no string is provided, the default service implementing the API will
	// be used. For example, `storage.googleapis.com` is the default for all
	// event types in the `google.storage` namespace.
	Service string `protobuf:"bytes,6,opt,name=service,proto3" json:"service,omitempty"`
	// Specifies policy for failed executions.
	FailurePolicy        *FailurePolicy `protobuf:"bytes,5,opt,name=failure_policy,json=failurePolicy,proto3" json:"failure_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *EventTrigger) Reset()         { *m = EventTrigger{} }
func (m *EventTrigger) String() string { return proto.CompactTextString(m) }
func (*EventTrigger) ProtoMessage()    {}
func (*EventTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{2}
}

func (m *EventTrigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventTrigger.Unmarshal(m, b)
}
func (m *EventTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventTrigger.Marshal(b, m, deterministic)
}
func (m *EventTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventTrigger.Merge(m, src)
}
func (m *EventTrigger) XXX_Size() int {
	return xxx_messageInfo_EventTrigger.Size(m)
}
func (m *EventTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_EventTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_EventTrigger proto.InternalMessageInfo

func (m *EventTrigger) GetEventType() string {
	if m != nil {
		return m.EventType
	}
	return ""
}

func (m *EventTrigger) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *EventTrigger) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *EventTrigger) GetFailurePolicy() *FailurePolicy {
	if m != nil {
		return m.FailurePolicy
	}
	return nil
}

// Describes the location of the function source in a remote repository.
type SourceRepository struct {
	// URL to the hosted repository where the function is defined. Only paths in
	// https://source.developers.google.com domain are supported. The path should
	// contain the name of the repository.
	RepositoryUrl string `protobuf:"bytes,1,opt,name=repository_url,json=repositoryUrl,proto3" json:"repository_url,omitempty"`
	// The path within the repository where the function is defined. The path
	// should point to the directory where Cloud Functions files are located. Use
	// "/" if the function is defined directly in the root directory of a
	// repository.
	SourcePath string `protobuf:"bytes,2,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// The version of a function. Defaults to the latest version of the master
	// branch.
	//
	// Types that are valid to be assigned to Version:
	//	*SourceRepository_Branch
	//	*SourceRepository_Tag
	//	*SourceRepository_Revision
	Version isSourceRepository_Version `protobuf_oneof:"version"`
	// Output only. The id of the revision that was resolved at the moment of
	// function creation or update. For example when a user deployed from a
	// branch, it will be the revision id of the latest change on this branch at
	// that time. If user deployed from revision then this value will be always
	// equal to the revision specified by the user.
	DeployedRevision     string   `protobuf:"bytes,6,opt,name=deployed_revision,json=deployedRevision,proto3" json:"deployed_revision,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SourceRepository) Reset()         { *m = SourceRepository{} }
func (m *SourceRepository) String() string { return proto.CompactTextString(m) }
func (*SourceRepository) ProtoMessage()    {}
func (*SourceRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{3}
}

func (m *SourceRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceRepository.Unmarshal(m, b)
}
func (m *SourceRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceRepository.Marshal(b, m, deterministic)
}
func (m *SourceRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceRepository.Merge(m, src)
}
func (m *SourceRepository) XXX_Size() int {
	return xxx_messageInfo_SourceRepository.Size(m)
}
func (m *SourceRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceRepository.DiscardUnknown(m)
}

var xxx_messageInfo_SourceRepository proto.InternalMessageInfo

func (m *SourceRepository) GetRepositoryUrl() string {
	if m != nil {
		return m.RepositoryUrl
	}
	return ""
}

func (m *SourceRepository) GetSourcePath() string {
	if m != nil {
		return m.SourcePath
	}
	return ""
}

type isSourceRepository_Version interface {
	isSourceRepository_Version()
}

type SourceRepository_Branch struct {
	Branch string `protobuf:"bytes,3,opt,name=branch,proto3,oneof"`
}

type SourceRepository_Tag struct {
	Tag string `protobuf:"bytes,4,opt,name=tag,proto3,oneof"`
}

type SourceRepository_Revision struct {
	Revision string `protobuf:"bytes,5,opt,name=revision,proto3,oneof"`
}

func (*SourceRepository_Branch) isSourceRepository_Version() {}

func (*SourceRepository_Tag) isSourceRepository_Version() {}

func (*SourceRepository_Revision) isSourceRepository_Version() {}

func (m *SourceRepository) GetVersion() isSourceRepository_Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *SourceRepository) GetBranch() string {
	if x, ok := m.GetVersion().(*SourceRepository_Branch); ok {
		return x.Branch
	}
	return ""
}

func (m *SourceRepository) GetTag() string {
	if x, ok := m.GetVersion().(*SourceRepository_Tag); ok {
		return x.Tag
	}
	return ""
}

func (m *SourceRepository) GetRevision() string {
	if x, ok := m.GetVersion().(*SourceRepository_Revision); ok {
		return x.Revision
	}
	return ""
}

func (m *SourceRepository) GetDeployedRevision() string {
	if m != nil {
		return m.DeployedRevision
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SourceRepository) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SourceRepository_Branch)(nil),
		(*SourceRepository_Tag)(nil),
		(*SourceRepository_Revision)(nil),
	}
}

// Describes the policy in case of function's execution failure.
// If empty, then defaults to ignoring failures (i.e. not retrying them).
type FailurePolicy struct {
	// Defines the action taken in case of a function execution failure.
	//
	// Types that are valid to be assigned to Action:
	//	*FailurePolicy_Retry_
	Action               isFailurePolicy_Action `protobuf_oneof:"action"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *FailurePolicy) Reset()         { *m = FailurePolicy{} }
func (m *FailurePolicy) String() string { return proto.CompactTextString(m) }
func (*FailurePolicy) ProtoMessage()    {}
func (*FailurePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{4}
}

func (m *FailurePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailurePolicy.Unmarshal(m, b)
}
func (m *FailurePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailurePolicy.Marshal(b, m, deterministic)
}
func (m *FailurePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailurePolicy.Merge(m, src)
}
func (m *FailurePolicy) XXX_Size() int {
	return xxx_messageInfo_FailurePolicy.Size(m)
}
func (m *FailurePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_FailurePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_FailurePolicy proto.InternalMessageInfo

type isFailurePolicy_Action interface {
	isFailurePolicy_Action()
}

type FailurePolicy_Retry_ struct {
	Retry *FailurePolicy_Retry `protobuf:"bytes,1,opt,name=retry,proto3,oneof"`
}

func (*FailurePolicy_Retry_) isFailurePolicy_Action() {}

func (m *FailurePolicy) GetAction() isFailurePolicy_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *FailurePolicy) GetRetry() *FailurePolicy_Retry {
	if x, ok := m.GetAction().(*FailurePolicy_Retry_); ok {
		return x.Retry
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FailurePolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FailurePolicy_Retry_)(nil),
	}
}

// Describes the retry policy in case of function's execution failure.
// A function execution will be retried on any failure.
// A failed execution will be retried up to 7 days with an exponential backoff
// (capped at 10 seconds).
// Retried execution is charged as any other execution.
type FailurePolicy_Retry struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FailurePolicy_Retry) Reset()         { *m = FailurePolicy_Retry{} }
func (m *FailurePolicy_Retry) String() string { return proto.CompactTextString(m) }
func (*FailurePolicy_Retry) ProtoMessage()    {}
func (*FailurePolicy_Retry) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{4, 0}
}

func (m *FailurePolicy_Retry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailurePolicy_Retry.Unmarshal(m, b)
}
func (m *FailurePolicy_Retry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailurePolicy_Retry.Marshal(b, m, deterministic)
}
func (m *FailurePolicy_Retry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailurePolicy_Retry.Merge(m, src)
}
func (m *FailurePolicy_Retry) XXX_Size() int {
	return xxx_messageInfo_FailurePolicy_Retry.Size(m)
}
func (m *FailurePolicy_Retry) XXX_DiscardUnknown() {
	xxx_messageInfo_FailurePolicy_Retry.DiscardUnknown(m)
}

var xxx_messageInfo_FailurePolicy_Retry proto.InternalMessageInfo

// Request for the `CreateFunction` method.
type CreateFunctionRequest struct {
	// Required. The project and location in which the function should be created, specified
	// in the format `projects/*/locations/*`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. Function to be created.
	Function             *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CreateFunctionRequest) Reset()         { *m = CreateFunctionRequest{} }
func (m *CreateFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFunctionRequest) ProtoMessage()    {}
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{5}
}

func (m *CreateFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFunctionRequest.Unmarshal(m, b)
}
func (m *CreateFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFunctionRequest.Marshal(b, m, deterministic)
}
func (m *CreateFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFunctionRequest.Merge(m, src)
}
func (m *CreateFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFunctionRequest.Size(m)
}
func (m *CreateFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFunctionRequest proto.InternalMessageInfo

func (m *CreateFunctionRequest) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *CreateFunctionRequest) GetFunction() *CloudFunction {
	if m != nil {
		return m.Function
	}
	return nil
}

// Request for the `UpdateFunction` method.
type UpdateFunctionRequest struct {
	// Required. The name of the function to be updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New version of the function.
	Function             *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UpdateFunctionRequest) Reset()         { *m = UpdateFunctionRequest{} }
func (m *UpdateFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFunctionRequest) ProtoMessage()    {}
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{6}
}

func (m *UpdateFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFunctionRequest.Unmarshal(m, b)
}
func (m *UpdateFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFunctionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFunctionRequest.Merge(m, src)
}
func (m *UpdateFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFunctionRequest.Size(m)
}
func (m *UpdateFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFunctionRequest proto.InternalMessageInfo

func (m *UpdateFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateFunctionRequest) GetFunction() *CloudFunction {
	if m != nil {
		return m.Function
	}
	return nil
}

// Request for the `GetFunction` method.
type GetFunctionRequest struct {
	// Required. The name of the function which details should be obtained.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFunctionRequest) Reset()         { *m = GetFunctionRequest{} }
func (m *GetFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*GetFunctionRequest) ProtoMessage()    {}
func (*GetFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{7}
}

func (m *GetFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFunctionRequest.Unmarshal(m, b)
}
func (m *GetFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFunctionRequest.Marshal(b, m, deterministic)
}
func (m *GetFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFunctionRequest.Merge(m, src)
}
func (m *GetFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_GetFunctionRequest.Size(m)
}
func (m *GetFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFunctionRequest proto.InternalMessageInfo

func (m *GetFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `ListFunctions` method.
type ListFunctionsRequest struct {
	// Required. The project and location from which the function should be listed,
	// specified in the format `projects/*/locations/*`
	// If you want to list functions in all locations, use "-" in place of a
	// location. When listing functions in all locations, if one or more
	// location(s) are unreachable, the response will contain functions from all
	// reachable locations along with the names of any unreachable locations.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Maximum number of functions to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last
	// `ListFunctionsResponse`; indicates that
	// this is a continuation of a prior `ListFunctions` call, and that the
	// system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsRequest) Reset()         { *m = ListFunctionsRequest{} }
func (m *ListFunctionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsRequest) ProtoMessage()    {}
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{8}
}

func (m *ListFunctionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsRequest.Unmarshal(m, b)
}
func (m *ListFunctionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsRequest.Marshal(b, m, deterministic)
}
func (m *ListFunctionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsRequest.Merge(m, src)
}
func (m *ListFunctionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsRequest.Size(m)
}
func (m *ListFunctionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsRequest proto.InternalMessageInfo

func (m *ListFunctionsRequest) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *ListFunctionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFunctionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListFunctions` method.
type ListFunctionsResponse struct {
	// The functions that match the request.
	Functions []*CloudFunction `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty"`
	// If not empty, indicates that there may be more functions that match
	// the request; this value should be passed in a new
	// [google.cloud.functions.v1beta2.ListFunctionsRequest][google.cloud.functions.v1beta2.ListFunctionsRequest]
	// to get more functions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached. The response does not include any
	// functions from these locations.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsResponse) Reset()         { *m = ListFunctionsResponse{} }
func (m *ListFunctionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsResponse) ProtoMessage()    {}
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{9}
}

func (m *ListFunctionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsResponse.Unmarshal(m, b)
}
func (m *ListFunctionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsResponse.Marshal(b, m, deterministic)
}
func (m *ListFunctionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsResponse.Merge(m, src)
}
func (m *ListFunctionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsResponse.Size(m)
}
func (m *ListFunctionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsResponse proto.InternalMessageInfo

func (m *ListFunctionsResponse) GetFunctions() []*CloudFunction {
	if m != nil {
		return m.Functions
	}
	return nil
}

func (m *ListFunctionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListFunctionsResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for the `DeleteFunction` method.
type DeleteFunctionRequest struct {
	// Required. The name of the function which should be deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFunctionRequest) Reset()         { *m = DeleteFunctionRequest{} }
func (m *DeleteFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFunctionRequest) ProtoMessage()    {}
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{10}
}

func (m *DeleteFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFunctionRequest.Unmarshal(m, b)
}
func (m *DeleteFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFunctionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFunctionRequest.Merge(m, src)
}
func (m *DeleteFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFunctionRequest.Size(m)
}
func (m *DeleteFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFunctionRequest proto.InternalMessageInfo

func (m *DeleteFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `CallFunction` method.
type CallFunctionRequest struct {
	// Required. The name of the function to be called.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Input to be passed to the function.
	Data                 string   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CallFunctionRequest) Reset()         { *m = CallFunctionRequest{} }
func (m *CallFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*CallFunctionRequest) ProtoMessage()    {}
func (*CallFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{11}
}

func (m *CallFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallFunctionRequest.Unmarshal(m, b)
}
func (m *CallFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallFunctionRequest.Marshal(b, m, deterministic)
}
func (m *CallFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallFunctionRequest.Merge(m, src)
}
func (m *CallFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_CallFunctionRequest.Size(m)
}
func (m *CallFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CallFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CallFunctionRequest proto.InternalMessageInfo

func (m *CallFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CallFunctionRequest) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

// Response of `CallFunction` method.
type CallFunctionResponse struct {
	// Execution id of function invocation.
	ExecutionId string `protobuf:"bytes,1,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// Result populated for successful execution of synchronous function. Will
	// not be populated if function does not return a result through context.
	Result string `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// Either system or user-function generated error. Set if execution
	// was not successful.
	Error                string   `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CallFunctionResponse) Reset()         { *m = CallFunctionResponse{} }
func (m *CallFunctionResponse) String() string { return proto.CompactTextString(m) }
func (*CallFunctionResponse) ProtoMessage()    {}
func (*CallFunctionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{12}
}

func (m *CallFunctionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallFunctionResponse.Unmarshal(m, b)
}
func (m *CallFunctionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallFunctionResponse.Marshal(b, m, deterministic)
}
func (m *CallFunctionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallFunctionResponse.Merge(m, src)
}
func (m *CallFunctionResponse) XXX_Size() int {
	return xxx_messageInfo_CallFunctionResponse.Size(m)
}
func (m *CallFunctionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CallFunctionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CallFunctionResponse proto.InternalMessageInfo

func (m *CallFunctionResponse) GetExecutionId() string {
	if m != nil {
		return m.ExecutionId
	}
	return ""
}

func (m *CallFunctionResponse) GetResult() string {
	if m != nil {
		return m.Result
	}
	return ""
}

func (m *CallFunctionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Request of `GenerateUploadUrl` method.
type GenerateUploadUrlRequest struct {
	// The project and location in which the Google Cloud Storage signed URL
	// should be generated, specified in the format `projects/*/locations/*`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateUploadUrlRequest) Reset()         { *m = GenerateUploadUrlRequest{} }
func (m *GenerateUploadUrlRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateUploadUrlRequest) ProtoMessage()    {}
func (*GenerateUploadUrlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{13}
}

func (m *GenerateUploadUrlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateUploadUrlRequest.Unmarshal(m, b)
}
func (m *GenerateUploadUrlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateUploadUrlRequest.Marshal(b, m, deterministic)
}
func (m *GenerateUploadUrlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateUploadUrlRequest.Merge(m, src)
}
func (m *GenerateUploadUrlRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateUploadUrlRequest.Size(m)
}
func (m *GenerateUploadUrlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateUploadUrlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateUploadUrlRequest proto.InternalMessageInfo

func (m *GenerateUploadUrlRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// Response of `GenerateUploadUrl` method.
type GenerateUploadUrlResponse struct {
	// The generated Google Cloud Storage signed URL that should be used for a
	// function source code upload. The uploaded file should be a zip archive
	// which contains a function.
	UploadUrl            string   `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl,proto3" json:"upload_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateUploadUrlResponse) Reset()         { *m = GenerateUploadUrlResponse{} }
func (m *GenerateUploadUrlResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateUploadUrlResponse) ProtoMessage()    {}
func (*GenerateUploadUrlResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{14}
}

func (m *GenerateUploadUrlResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateUploadUrlResponse.Unmarshal(m, b)
}
func (m *GenerateUploadUrlResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateUploadUrlResponse.Marshal(b, m, deterministic)
}
func (m *GenerateUploadUrlResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateUploadUrlResponse.Merge(m, src)
}
func (m *GenerateUploadUrlResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateUploadUrlResponse.Size(m)
}
func (m *GenerateUploadUrlResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateUploadUrlResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateUploadUrlResponse proto.InternalMessageInfo

func (m *GenerateUploadUrlResponse) GetUploadUrl() string {
	if m != nil {
		return m.UploadUrl
	}
	return ""
}

// Request of `GenerateDownloadUrl` method.
type GenerateDownloadUrlRequest struct {
	// The name of function for which source code Google Cloud Storage signed
	// URL should be generated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The optional version of function.
	VersionId            uint64   `protobuf:"varint,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateDownloadUrlRequest) Reset()         { *m = GenerateDownloadUrlRequest{} }
func (m *GenerateDownloadUrlRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateDownloadUrlRequest) ProtoMessage()    {}
func (*GenerateDownloadUrlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{15}
}

func (m *GenerateDownloadUrlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateDownloadUrlRequest.Unmarshal(m, b)
}
func (m *GenerateDownloadUrlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateDownloadUrlRequest.Marshal(b, m, deterministic)
}
func (m *GenerateDownloadUrlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateDownloadUrlRequest.Merge(m, src)
}
func (m *GenerateDownloadUrlRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateDownloadUrlRequest.Size(m)
}
func (m *GenerateDownloadUrlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateDownloadUrlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateDownloadUrlRequest proto.InternalMessageInfo

func (m *GenerateDownloadUrlRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GenerateDownloadUrlRequest) GetVersionId() uint64 {
	if m != nil {
		return m.VersionId
	}
	return 0
}

// Response of `GenerateDownloadUrl` method.
type GenerateDownloadUrlResponse struct {
	// The generated Google Cloud Storage signed URL that should be used for
	// function source code download.
	DownloadUrl          string   `protobuf:"bytes,1,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateDownloadUrlResponse) Reset()         { *m = GenerateDownloadUrlResponse{} }
func (m *GenerateDownloadUrlResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateDownloadUrlResponse) ProtoMessage()    {}
func (*GenerateDownloadUrlResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{16}
}

func (m *GenerateDownloadUrlResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateDownloadUrlResponse.Unmarshal(m, b)
}
func (m *GenerateDownloadUrlResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateDownloadUrlResponse.Marshal(b, m, deterministic)
}
func (m *GenerateDownloadUrlResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateDownloadUrlResponse.Merge(m, src)
}
func (m *GenerateDownloadUrlResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateDownloadUrlResponse.Size(m)
}
func (m *GenerateDownloadUrlResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateDownloadUrlResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateDownloadUrlResponse proto.InternalMessageInfo

func (m *GenerateDownloadUrlResponse) GetDownloadUrl() string {
	if m != nil {
		return m.DownloadUrl
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.functions.v1beta2.CloudFunctionStatus", CloudFunctionStatus_name, CloudFunctionStatus_value)
	proto.RegisterType((*CloudFunction)(nil), "google.cloud.functions.v1beta2.CloudFunction")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.functions.v1beta2.CloudFunction.EnvironmentVariablesEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.functions.v1beta2.CloudFunction.LabelsEntry")
	proto.RegisterType((*HTTPSTrigger)(nil), "google.cloud.functions.v1beta2.HTTPSTrigger")
	proto.RegisterType((*EventTrigger)(nil), "google.cloud.functions.v1beta2.EventTrigger")
	proto.RegisterType((*SourceRepository)(nil), "google.cloud.functions.v1beta2.SourceRepository")
	proto.RegisterType((*FailurePolicy)(nil), "google.cloud.functions.v1beta2.FailurePolicy")
	proto.RegisterType((*FailurePolicy_Retry)(nil), "google.cloud.functions.v1beta2.FailurePolicy.Retry")
	proto.RegisterType((*CreateFunctionRequest)(nil), "google.cloud.functions.v1beta2.CreateFunctionRequest")
	proto.RegisterType((*UpdateFunctionRequest)(nil), "google.cloud.functions.v1beta2.UpdateFunctionRequest")
	proto.RegisterType((*GetFunctionRequest)(nil), "google.cloud.functions.v1beta2.GetFunctionRequest")
	proto.RegisterType((*ListFunctionsRequest)(nil), "google.cloud.functions.v1beta2.ListFunctionsRequest")
	proto.RegisterType((*ListFunctionsResponse)(nil), "google.cloud.functions.v1beta2.ListFunctionsResponse")
	proto.RegisterType((*DeleteFunctionRequest)(nil), "google.cloud.functions.v1beta2.DeleteFunctionRequest")
	proto.RegisterType((*CallFunctionRequest)(nil), "google.cloud.functions.v1beta2.CallFunctionRequest")
	proto.RegisterType((*CallFunctionResponse)(nil), "google.cloud.functions.v1beta2.CallFunctionResponse")
	proto.RegisterType((*GenerateUploadUrlRequest)(nil), "google.cloud.functions.v1beta2.GenerateUploadUrlRequest")
	proto.RegisterType((*GenerateUploadUrlResponse)(nil), "google.cloud.functions.v1beta2.GenerateUploadUrlResponse")
	proto.RegisterType((*GenerateDownloadUrlRequest)(nil), "google.cloud.functions.v1beta2.GenerateDownloadUrlRequest")
	proto.RegisterType((*GenerateDownloadUrlResponse)(nil), "google.cloud.functions.v1beta2.GenerateDownloadUrlResponse")
}

func init() {
	proto.RegisterFile("google/cloud/functions/v1beta2/functions.proto", fileDescriptor_61af63f3568f8edb)
}

var fileDescriptor_61af63f3568f8edb = []byte{
	// 1921 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x18, 0xdf, 0x6f, 0x1b, 0x49,
	0xf9, 0x36, 0x4e, 0x9c, 0xf8, 0x73, 0xec, 0x38, 0x93, 0xa4, 0xdd, 0xf8, 0x2e, 0x34, 0xb7, 0xd5,
	0x41, 0x2e, 0xb4, 0xf6, 0x35, 0x0d, 0x70, 0xcd, 0x1d, 0xa8, 0x9b, 0xc4, 0x49, 0xa3, 0xa6, 0xad,
	0xbb, 0x49, 0x4e, 0x3a, 0x24, 0x64, 0x26, 0xeb, 0x89, 0xb3, 0x74, 0xbd, 0xb3, 0xcc, 0xce, 0x3a,
	0xcd, 0x95, 0x4a, 0x08, 0x09, 0xfe, 0x01, 0x9e, 0x78, 0xe5, 0x0f, 0x40, 0x08, 0x24, 0x24, 0xfe,
	0x00, 0x1e, 0xe8, 0x23, 0x3c, 0x51, 0x09, 0xe9, 0x10, 0xbc, 0xc0, 0x0b, 0xef, 0x3c, 0xa1, 0x99,
	0x9d, 0x5d, 0xaf, 0x1d, 0xb7, 0xae, 0xa3, 0xeb, 0x93, 0xf7, 0xfb, 0x39, 0xdf, 0xaf, 0xf9, 0xbe,
	0x6f, 0x0c, 0x95, 0x16, 0xa5, 0x2d, 0x97, 0x54, 0x6d, 0x97, 0x86, 0xcd, 0xea, 0x49, 0xe8, 0xd9,
	0xdc, 0xa1, 0x5e, 0x50, 0xed, 0xdc, 0x3a, 0x26, 0x1c, 0xaf, 0x75, 0x31, 0x15, 0x9f, 0x51, 0x4e,
	0xd1, 0xd7, 0x22, 0xfe, 0x8a, 0xe4, 0xaf, 0x74, 0xa9, 0x8a, 0xbf, 0xfc, 0x9e, 0xd2, 0x87, 0x7d,
	0xa7, 0x8a, 0x3d, 0x8f, 0x72, 0x9c, 0x92, 0x2e, 0x5f, 0x4d, 0x51, 0x6d, 0xd7, 0x21, 0x1e, 0x57,
	0x84, 0x6b, 0x29, 0xc2, 0x89, 0x43, 0xdc, 0x66, 0xe3, 0x98, 0x9c, 0xe2, 0x8e, 0x43, 0x99, 0x62,
	0x58, 0x4c, 0x31, 0x30, 0x12, 0xd0, 0x90, 0xd9, 0x44, 0x91, 0xae, 0x2b, 0x92, 0x4b, 0xbd, 0x16,
	0x0b, 0x3d, 0xcf, 0xf1, 0x5a, 0x55, 0xea, 0x13, 0xd6, 0x73, 0xb2, 0xb2, 0xbb, 0x2a, 0xa1, 0xe3,
	0xf0, 0xa4, 0xda, 0x0c, 0x23, 0x86, 0x3e, 0x03, 0x12, 0x3a, 0x77, 0xda, 0x24, 0xe0, 0xb8, 0xed,
	0x47, 0x0c, 0xc6, 0x1f, 0xf2, 0x50, 0xd8, 0x12, 0x4e, 0xef, 0x28, 0x9f, 0x11, 0x82, 0x71, 0x0f,
	0xb7, 0x89, 0xae, 0x2d, 0x6b, 0x2b, 0x39, 0x4b, 0x7e, 0xa3, 0x0a, 0xa0, 0xc8, 0xb6, 0x06, 0x66,
	0xf6, 0xa9, 0xd3, 0x21, 0x8d, 0x90, 0xb9, 0x7a, 0x51, 0x70, 0xdc, 0x7b, 0xc7, 0x2a, 0x45, 0x34,
	0x33, 0x22, 0x1d, 0x31, 0x17, 0x35, 0x60, 0x56, 0xf1, 0x33, 0xe2, 0xd3, 0xc0, 0xe1, 0x94, 0x9d,
	0xeb, 0x99, 0x65, 0x6d, 0x25, 0xbf, 0xf6, 0x51, 0xe5, 0xf5, 0xa1, 0xae, 0x1c, 0x48, 0x41, 0x2b,
	0x91, 0xeb, 0x1e, 0xd0, 0xc5, 0xa1, 0x75, 0x58, 0xb8, 0x70, 0x80, 0xb4, 0x09, 0x29, 0x9b, 0xe6,
	0xfa, 0x45, 0x84, 0x59, 0x37, 0x12, 0xb3, 0x42, 0xdf, 0xa5, 0xb8, 0x29, 0x25, 0x4a, 0x4a, 0x62,
	0x26, 0x22, 0x1d, 0x49, 0x8a, 0xe0, 0x3e, 0x80, 0xc2, 0x29, 0xe7, 0x7e, 0xd0, 0xe0, 0xcc, 0x69,
	0xb5, 0x08, 0xd3, 0xb3, 0xd2, 0x81, 0x1b, 0xc3, 0x1c, 0xb8, 0x77, 0x78, 0x58, 0x3f, 0x38, 0x8c,
	0x64, 0xee, 0x69, 0xd6, 0xb4, 0x54, 0xa2, 0x60, 0xa1, 0x94, 0x74, 0x88, 0xc7, 0x13, 0xa5, 0xd3,
	0x6f, 0xa6, 0xb4, 0x26, 0x84, 0x52, 0x4a, 0x49, 0x0a, 0x46, 0x75, 0xc8, 0x06, 0x1c, 0xf3, 0x30,
	0xd0, 0x27, 0x97, 0xb5, 0x95, 0xe2, 0xda, 0xed, 0x61, 0xda, 0x7a, 0x32, 0x7e, 0x20, 0x45, 0x37,
	0x33, 0x5f, 0x9a, 0x19, 0x4b, 0xe9, 0x41, 0x15, 0x28, 0xb9, 0x98, 0x93, 0x80, 0x37, 0x92, 0x92,
	0xd3, 0xa7, 0x44, 0xa0, 0x22, 0xb6, 0x99, 0x88, 0xf8, 0x28, 0xa6, 0xa1, 0x6b, 0x90, 0x27, 0x1e,
	0x67, 0xe7, 0x0d, 0x9f, 0x3a, 0x1e, 0xd7, 0x73, 0xb2, 0x76, 0x40, 0xa2, 0xea, 0x02, 0x83, 0x74,
	0x98, 0x64, 0xa1, 0x27, 0xaa, 0x4f, 0xbf, 0x2a, 0x89, 0x31, 0x88, 0x6e, 0xc3, 0xa4, 0xf8, 0xa5,
	0x21, 0xd7, 0x41, 0xc6, 0x62, 0x31, 0xb6, 0x3e, 0x2e, 0xda, 0xca, 0xb6, 0x2a, 0x6a, 0x2b, 0xe6,
	0x44, 0x15, 0x98, 0xc3, 0x1d, 0xec, 0xb8, 0xf8, 0xd8, 0x25, 0x8d, 0x36, 0x69, 0x8b, 0xf4, 0xb7,
	0x8f, 0xf5, 0xfc, 0xb2, 0xb6, 0x32, 0x61, 0xcd, 0x26, 0xa4, 0x07, 0x92, 0xf2, 0xe0, 0x18, 0x7d,
	0x03, 0x66, 0x02, 0xc2, 0x3a, 0x8e, 0xa8, 0x60, 0xdb, 0xa6, 0xa1, 0xc7, 0xf5, 0x82, 0x34, 0xa3,
	0xa8, 0xd0, 0x66, 0x84, 0x45, 0x77, 0x21, 0x1f, 0xfa, 0x4d, 0xcc, 0x49, 0x43, 0xda, 0x3a, 0x23,
	0x2d, 0x2a, 0x5f, 0xb0, 0xe8, 0x30, 0xbe, 0x46, 0x51, 0x3c, 0x20, 0x92, 0x11, 0x58, 0x64, 0x00,
	0x74, 0x08, 0x0b, 0x1c, 0xea, 0x35, 0x9c, 0xa6, 0x3e, 0xbf, 0xac, 0xad, 0x64, 0x22, 0xa6, 0x9c,
	0x42, 0xef, 0x35, 0xd1, 0x63, 0xc8, 0xba, 0xf8, 0x98, 0xb8, 0x81, 0xbe, 0xb0, 0x9c, 0x59, 0xc9,
	0xaf, 0xdd, 0x19, 0x29, 0x61, 0x95, 0x7d, 0x29, 0x5b, 0x13, 0xd1, 0xb5, 0x94, 0x22, 0xf4, 0x13,
	0x58, 0x20, 0x5e, 0xc7, 0x61, 0xd4, 0x6b, 0x8b, 0xf2, 0xea, 0x60, 0xe6, 0x88, 0x08, 0x04, 0xfa,
	0x15, 0x79, 0xc2, 0xee, 0x68, 0x27, 0xd4, 0xba, 0xaa, 0x3e, 0x8b, 0x35, 0x45, 0xe7, 0xcd, 0x93,
	0x01, 0x24, 0x74, 0x1d, 0x0a, 0x6d, 0xfc, 0xb4, 0xe1, 0x78, 0x01, 0xc7, 0x9e, 0x4d, 0x02, 0x5d,
	0x97, 0x99, 0x98, 0x6e, 0xe3, 0xa7, 0x7b, 0x31, 0x4e, 0xd4, 0x80, 0x47, 0xf8, 0x19, 0x65, 0x4f,
	0xf4, 0xc5, 0xa8, 0x06, 0x14, 0x28, 0xc4, 0x3b, 0xbe, 0xdd, 0xb0, 0xa9, 0xe7, 0x11, 0x9b, 0x53,
	0xa6, 0x97, 0x25, 0x7d, 0xba, 0xe3, 0xdb, 0x5b, 0x31, 0xae, 0x7c, 0x07, 0xf2, 0x29, 0xc7, 0x51,
	0x09, 0x32, 0x4f, 0xc8, 0xb9, 0x6a, 0x53, 0xe2, 0x13, 0xcd, 0xc3, 0x44, 0x07, 0xbb, 0x21, 0xd1,
	0xc7, 0x24, 0x2e, 0x02, 0x36, 0xc6, 0x3e, 0xd6, 0xca, 0xbb, 0xb0, 0xf8, 0x4a, 0x8f, 0x46, 0x51,
	0xb4, 0xe1, 0xfd, 0xc7, 0x7c, 0x02, 0xdf, 0x94, 0x31, 0xec, 0x86, 0x30, 0x8a, 0x2c, 0xf6, 0x9d,
	0xa0, 0x62, 0xd3, 0x76, 0xb5, 0xb7, 0x9d, 0x7e, 0xea, 0x33, 0xfa, 0x23, 0x62, 0xf3, 0xa0, 0xfa,
	0x4c, 0x7d, 0x3d, 0xaf, 0xba, 0xd4, 0x8e, 0xba, 0x78, 0xf5, 0x59, 0xfc, 0xf9, 0x3c, 0x35, 0xa4,
	0x9e, 0xc5, 0x9f, 0xcf, 0x37, 0x0b, 0x90, 0x57, 0x1d, 0xcb, 0xa6, 0x4d, 0xb2, 0x99, 0x83, 0x49,
	0xd5, 0x37, 0x8c, 0x0f, 0x60, 0x3a, 0xdd, 0x68, 0xd0, 0x02, 0x64, 0x44, 0x37, 0xd3, 0xba, 0x97,
	0x54, 0xc0, 0xc6, 0x1f, 0x35, 0x98, 0x4e, 0xf7, 0x0e, 0xb4, 0x04, 0xa0, 0x1a, 0xd0, 0xb9, 0x1f,
	0x37, 0xf9, 0x5c, 0xd4, 0x4d, 0xce, 0x7d, 0x82, 0xca, 0x30, 0x15, 0xcf, 0x21, 0xe5, 0x7d, 0x02,
	0x8b, 0xfc, 0xa9, 0xdb, 0x22, 0x5b, 0x61, 0xce, 0x8a, 0x41, 0x74, 0x08, 0xc5, 0x13, 0xec, 0xb8,
	0x21, 0x23, 0x0d, 0x9f, 0xba, 0x8e, 0x7d, 0xae, 0x4f, 0xc8, 0x8b, 0x73, 0x73, 0x58, 0xd5, 0xed,
	0x44, 0x52, 0x75, 0x29, 0x64, 0x15, 0x4e, 0xd2, 0xa0, 0xf1, 0x4f, 0x0d, 0x4a, 0xfd, 0xd3, 0x00,
	0x7d, 0x00, 0xc5, 0xbe, 0x96, 0x1f, 0xf9, 0x50, 0x60, 0x3d, 0xad, 0xfe, 0x5a, 0x12, 0x38, 0x1f,
	0xf3, 0x53, 0xe5, 0x0a, 0x44, 0xa8, 0x3a, 0xe6, 0xa7, 0x48, 0x87, 0xec, 0x31, 0xc3, 0x9e, 0x7d,
	0x2a, 0xe7, 0x92, 0x18, 0x00, 0x0a, 0x46, 0x08, 0x32, 0x1c, 0xb7, 0xf4, 0x71, 0x85, 0x16, 0x00,
	0x7a, 0x4f, 0x84, 0xa5, 0xe3, 0x88, 0xeb, 0x2b, 0x5d, 0x13, 0x84, 0x04, 0x83, 0x3e, 0x82, 0xd9,
	0x26, 0xf1, 0x5d, 0x7a, 0x4e, 0x9a, 0x8d, 0x84, 0x2d, 0xdb, 0xcd, 0x44, 0x29, 0xa6, 0x5a, 0x8a,
	0x28, 0x12, 0xa9, 0xba, 0x81, 0x41, 0xa1, 0xd0, 0x13, 0x05, 0x74, 0x1f, 0x26, 0x18, 0xe1, 0x2c,
	0xaa, 0xc8, 0xfc, 0xf0, 0x66, 0xde, 0x23, 0x5d, 0xb1, 0x84, 0xe8, 0xbd, 0x77, 0xac, 0x48, 0x47,
	0x79, 0x12, 0x26, 0x24, 0x66, 0x73, 0x0a, 0xb2, 0x58, 0x0a, 0x1a, 0xbf, 0xd1, 0x60, 0x61, 0x8b,
	0x11, 0xcc, 0x49, 0x5c, 0xa4, 0x16, 0xf9, 0x71, 0x48, 0x02, 0x8e, 0x6a, 0x30, 0x15, 0xd7, 0xa3,
	0x2a, 0xa4, 0x0f, 0xbf, 0x34, 0xc7, 0xfe, 0x67, 0x5e, 0x87, 0xf7, 0x93, 0x92, 0xed, 0xaf, 0xf6,
	0x7d, 0x45, 0xb0, 0x12, 0x51, 0xf4, 0x10, 0xa6, 0x62, 0x2b, 0x65, 0xe0, 0xdf, 0xa0, 0x0e, 0x7a,
	0xee, 0x8c, 0x08, 0xda, 0x98, 0x95, 0xe8, 0x30, 0x7e, 0xab, 0xc1, 0xc2, 0x91, 0x6c, 0xb0, 0xfd,
	0x06, 0xef, 0xa6, 0x77, 0x95, 0xcd, 0xdb, 0xd2, 0xd8, 0x9b, 0x23, 0xdd, 0x4f, 0xb5, 0xe0, 0x7c,
	0xd5, 0x26, 0xff, 0x00, 0xd0, 0x2e, 0xe1, 0x6f, 0xcb, 0x5c, 0xe3, 0x57, 0x1a, 0xcc, 0xef, 0x3b,
	0x41, 0x72, 0x40, 0xf0, 0x15, 0x67, 0xf0, 0x5d, 0xc8, 0xf9, 0xb8, 0x45, 0x1a, 0x81, 0xf3, 0x45,
	0xd4, 0x06, 0x26, 0xac, 0x29, 0x81, 0x38, 0x70, 0xbe, 0x20, 0xa2, 0x83, 0x48, 0x22, 0xa7, 0x4f,
	0x88, 0x17, 0xdd, 0x1e, 0x4b, 0xb2, 0x1f, 0x0a, 0x84, 0x2c, 0xaf, 0x3e, 0xdb, 0x02, 0x9f, 0x7a,
	0x01, 0x41, 0xf7, 0x21, 0x97, 0x78, 0xa9, 0x6b, 0x72, 0x2c, 0x8d, 0x16, 0x65, 0xab, 0x2b, 0x8f,
	0xbe, 0x0e, 0x33, 0x1e, 0x79, 0xca, 0x1b, 0x29, 0x53, 0xa2, 0x4b, 0x5e, 0x10, 0xe8, 0x7a, 0x6c,
	0x0e, 0x5a, 0x86, 0x7c, 0xe8, 0x31, 0x82, 0xed, 0x53, 0xd1, 0xf2, 0xf5, 0xcc, 0x72, 0x66, 0x25,
	0x67, 0xa5, 0x51, 0xc6, 0x0f, 0x61, 0x61, 0x9b, 0xb8, 0xe4, 0xed, 0x55, 0x97, 0x71, 0x06, 0x73,
	0x5b, 0xd8, 0x75, 0xdf, 0x5a, 0xf5, 0x5e, 0x85, 0xf1, 0x26, 0xe6, 0x38, 0x0a, 0x40, 0x54, 0x8a,
	0x12, 0x61, 0xb4, 0x60, 0xbe, 0xf7, 0x60, 0x95, 0x89, 0xf7, 0x61, 0x9a, 0x3c, 0x25, 0x76, 0xc8,
	0xd5, 0x96, 0x12, 0xb5, 0xd0, 0x7c, 0x82, 0xdb, 0x6b, 0xa2, 0x2b, 0x90, 0x65, 0x24, 0x08, 0x5d,
	0xae, 0xc2, 0xaa, 0x20, 0x31, 0x1b, 0x09, 0x63, 0x94, 0xa9, 0xc4, 0x47, 0x80, 0xb1, 0x06, 0xfa,
	0x2e, 0xf1, 0xc4, 0x36, 0xd8, 0x5d, 0xa0, 0x63, 0x37, 0xaf, 0x40, 0xd6, 0xc7, 0x8c, 0x78, 0x5c,
	0x1d, 0xa3, 0x20, 0x63, 0x03, 0x16, 0x07, 0xc8, 0x28, 0x0b, 0x97, 0x00, 0x52, 0x3b, 0xba, 0x1a,
	0x53, 0x61, 0xcc, 0x66, 0x3c, 0x82, 0x72, 0x2c, 0xbb, 0x4d, 0xcf, 0xbc, 0xbe, 0x13, 0x07, 0x3d,
	0x61, 0x96, 0x7a, 0xd6, 0x32, 0xe1, 0xd3, 0x78, 0x6a, 0x23, 0x33, 0xee, 0xc2, 0xbb, 0x03, 0x15,
	0x76, 0x03, 0xd6, 0x54, 0xe8, 0x94, 0x41, 0xf9, 0x66, 0x97, 0x75, 0x15, 0xc3, 0xdc, 0x80, 0xb5,
	0x1a, 0x5d, 0x01, 0x74, 0x70, 0x68, 0x1e, 0x1e, 0x1d, 0x34, 0x8e, 0x1e, 0x1e, 0xd4, 0x6b, 0x5b,
	0x7b, 0x3b, 0x7b, 0xb5, 0xed, 0xd2, 0x3b, 0x28, 0x07, 0x13, 0x56, 0xcd, 0xdc, 0xfe, 0xbc, 0xa4,
	0x21, 0x80, 0xec, 0x8e, 0xb9, 0xb7, 0x5f, 0xdb, 0x2e, 0x8d, 0xa1, 0x02, 0xe4, 0xb6, 0x6b, 0xf5,
	0xfd, 0x47, 0x9f, 0xef, 0x3d, 0xdc, 0x2d, 0x65, 0xd0, 0x34, 0x4c, 0x6d, 0xd7, 0xf6, 0x6b, 0x87,
	0x02, 0x1a, 0x5f, 0xfb, 0x5d, 0x11, 0x16, 0x7a, 0xce, 0x08, 0x0e, 0xd4, 0x00, 0xfe, 0x93, 0x06,
	0x85, 0x9e, 0x4b, 0x87, 0xd6, 0x87, 0xdd, 0xac, 0x41, 0xfd, 0xa3, 0xfc, 0xad, 0x11, 0xa5, 0xa2,
	0xf0, 0x18, 0xbb, 0x2f, 0xcd, 0xa4, 0x79, 0xfc, 0xec, 0xaf, 0xff, 0xfa, 0xe5, 0xd8, 0xb7, 0xd1,
	0x7a, 0xf2, 0xd6, 0x4e, 0x76, 0x9c, 0xef, 0x26, 0xab, 0xd0, 0x6a, 0x6a, 0x05, 0x5a, 0x4d, 0xad,
	0x3e, 0xe8, 0xf7, 0x1a, 0xe4, 0x53, 0x8d, 0x13, 0xad, 0x0d, 0xb3, 0xe7, 0x62, 0x97, 0x2d, 0x8f,
	0xd6, 0x53, 0x0c, 0xf3, 0xa5, 0x29, 0x2b, 0x44, 0xda, 0xbd, 0x8e, 0xd6, 0xba, 0x76, 0x0b, 0xec,
	0x2b, 0x6c, 0x4e, 0x6d, 0x6b, 0xab, 0xcf, 0xd1, 0x7f, 0x35, 0x28, 0xf6, 0x4e, 0x54, 0x34, 0x34,
	0x90, 0x03, 0x27, 0x70, 0x79, 0x29, 0x16, 0x4b, 0xbd, 0xfa, 0x2b, 0xc9, 0x33, 0xcb, 0xf8, 0x85,
	0xf6, 0xc2, 0xfc, 0xb0, 0xff, 0xc1, 0xae, 0x27, 0xf4, 0x07, 0x84, 0x63, 0x71, 0xef, 0x3f, 0xbb,
	0xb5, 0x29, 0xce, 0x78, 0x69, 0xce, 0xc6, 0x26, 0xdf, 0x88, 0x0d, 0x90, 0x5e, 0xde, 0x35, 0x2e,
	0x95, 0x9d, 0x8d, 0x64, 0xbe, 0xa1, 0x7f, 0x6b, 0x50, 0xec, 0x1d, 0xc9, 0xc3, 0x3d, 0x1e, 0x38,
	0xc2, 0x87, 0x79, 0xfc, 0xd3, 0x11, 0x3d, 0x2e, 0x88, 0xa4, 0xf5, 0x7a, 0xfb, 0xbd, 0xf2, 0x25,
	0x72, 0x9a, 0xf2, 0xf5, 0xef, 0x1a, 0x14, 0x7b, 0x07, 0xc4, 0x70, 0x5f, 0x07, 0x0e, 0x94, 0x61,
	0xbe, 0x86, 0x2f, 0xcc, 0x5b, 0xb0, 0xd0, 0xff, 0xd4, 0xac, 0xb5, 0x7d, 0x7e, 0xfe, 0x3a, 0x97,
	0x53, 0xd5, 0xbb, 0x7a, 0x99, 0xea, 0xfd, 0xb3, 0x06, 0xd3, 0xe9, 0x29, 0x81, 0x86, 0xff, 0x7d,
	0x70, 0x71, 0x98, 0x95, 0xd7, 0x47, 0x13, 0x52, 0x8d, 0xe3, 0xe1, 0x4b, 0x33, 0x27, 0x33, 0x26,
	0x3c, 0x92, 0x3e, 0x7c, 0x6a, 0x7c, 0xe7, 0x12, 0xd9, 0xb2, 0xb1, 0xeb, 0x6e, 0x68, 0xab, 0xe8,
	0x6f, 0x1a, 0xcc, 0x5e, 0x18, 0x2a, 0xe8, 0xe3, 0xe1, 0x5d, 0x64, 0xf0, 0xec, 0x2a, 0xdf, 0xb9,
	0x84, 0xa4, 0x72, 0xed, 0x91, 0x74, 0x67, 0xcf, 0xd8, 0xee, 0xba, 0x13, 0x0d, 0xbe, 0x37, 0xb8,
	0x68, 0xad, 0x7e, 0xad, 0xc2, 0xb7, 0x7f, 0x68, 0x30, 0x37, 0x60, 0x46, 0xa1, 0x8d, 0x37, 0xb5,
	0xf1, 0xe2, 0xa4, 0x2c, 0x7f, 0x72, 0x29, 0x59, 0xe5, 0xe1, 0x63, 0xe9, 0xe1, 0x7d, 0x63, 0xe7,
	0x12, 0x09, 0x6b, 0x5d, 0xd4, 0xbb, 0xa1, 0xad, 0x96, 0x1f, 0xbf, 0x30, 0x97, 0x5e, 0xbb, 0xff,
	0xfc, 0xc5, 0xac, 0xc8, 0xff, 0xd3, 0x36, 0xaa, 0xd5, 0xb3, 0xb3, 0xb3, 0xfe, 0xe5, 0x08, 0x87,
	0xfc, 0x34, 0xfa, 0xcf, 0xf7, 0xa6, 0xef, 0x62, 0x7e, 0x42, 0x59, 0x7b, 0xf3, 0xe7, 0x1a, 0x18,
	0x36, 0x6d, 0x0f, 0x71, 0x74, 0xb3, 0x98, 0x4c, 0xb5, 0xba, 0xb8, 0x79, 0x75, 0xed, 0xfb, 0xbb,
	0x4a, 0xa2, 0x45, 0x5d, 0xec, 0xb5, 0x2a, 0x94, 0xb5, 0xaa, 0x2d, 0xe2, 0xc9, 0x7b, 0x59, 0xed,
	0x9e, 0xfb, 0xaa, 0xbf, 0x98, 0x3f, 0x49, 0x30, 0xbf, 0x1e, 0xcb, 0xec, 0x6e, 0xed, 0x1c, 0x67,
	0xa5, 0xe4, 0xed, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x14, 0x6c, 0x57, 0x85, 0x9b, 0x16, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudFunctionsServiceClient is the client API for CloudFunctionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudFunctionsServiceClient interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits refer to [API Calls](
	// https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	// * Source file type should be a zip file.
	// * Source file size should not exceed 100MB limit.
	// * No credentials should be attached - the signed URLs provide access to the
	//   target bucket using internal service identity; if credentials were
	//   attached, the identity from the credentials would be used, but that
	//   identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error)
}

type cloudFunctionsServiceClient struct {
	cc *grpc.ClientConn
}

func NewCloudFunctionsServiceClient(cc *grpc.ClientConn) CloudFunctionsServiceClient {
	return &cloudFunctionsServiceClient{cc}
}

func (c *cloudFunctionsServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error) {
	out := new(CloudFunction)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error) {
	out := new(CallFunctionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error) {
	out := new(GenerateUploadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateUploadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error) {
	out := new(GenerateDownloadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateDownloadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFunctionsServiceServer is the server API for CloudFunctionsService service.
type CloudFunctionsServiceServer interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunning.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits refer to [API Calls](
	// https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	// * Source file type should be a zip file.
	// * Source file size should not exceed 100MB limit.
	// * No credentials should be attached - the signed URLs provide access to the
	//   target bucket using internal service identity; if credentials were
	//   attached, the identity from the credentials would be used, but that
	//   identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error)
}

// UnimplementedCloudFunctionsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCloudFunctionsServiceServer struct {
}

func (*UnimplementedCloudFunctionsServiceServer) ListFunctions(ctx context.Context, req *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFunctions not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GetFunction(ctx context.Context, req *GetFunctionRequest) (*CloudFunction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) CreateFunction(ctx context.Context, req *CreateFunctionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) UpdateFunction(ctx context.Context, req *UpdateFunctionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) DeleteFunction(ctx context.Context, req *DeleteFunctionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) CallFunction(ctx context.Context, req *CallFunctionRequest) (*CallFunctionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GenerateUploadUrl(ctx context.Context, req *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadUrl not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GenerateDownloadUrl(ctx context.Context, req *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateDownloadUrl not implemented")
}

func RegisterCloudFunctionsServiceServer(s *grpc.Server, srv CloudFunctionsServiceServer) {
	s.RegisterService(&_CloudFunctionsService_serviceDesc, srv)
}

func _CloudFunctionsService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, req.(*CallFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateUploadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateUploadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateUploadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, req.(*GenerateUploadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateDownloadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, req.(*GenerateDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudFunctionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v1beta2.CloudFunctionsService",
	HandlerType: (*CloudFunctionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFunctions",
			Handler:    _CloudFunctionsService_ListFunctions_Handler,
		},
		{
			MethodName: "GetFunction",
			Handler:    _CloudFunctionsService_GetFunction_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _CloudFunctionsService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _CloudFunctionsService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _CloudFunctionsService_DeleteFunction_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _CloudFunctionsService_CallFunction_Handler,
		},
		{
			MethodName: "GenerateUploadUrl",
			Handler:    _CloudFunctionsService_GenerateUploadUrl_Handler,
		},
		{
			MethodName: "GenerateDownloadUrl",
			Handler:    _CloudFunctionsService_GenerateDownloadUrl_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/functions/v1beta2/functions.proto",
}
