// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/type/quaternion.proto

package quaternion

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A quaternion is defined as the quotient of two directed lines in a
// three-dimensional space or equivalently as the quotient of two Euclidean
// vectors (https://en.wikipedia.org/wiki/Quaternion).
//
// Quaternions are often used in calculations involving three-dimensional
// rotations (https://en.wikipedia.org/wiki/Quaternions_and_spatial_rotation),
// as they provide greater mathematical robustness by avoiding the gimbal lock
// problems that can be encountered when using Euler angles
// (https://en.wikipedia.org/wiki/Gimbal_lock).
//
// Quaternions are generally represented in this form:
//
//     w + xi + yj + zk
//
// where x, y, z, and w are real numbers, and i, j, and k are three imaginary
// numbers.
//
// Our naming choice `(x, y, z, w)` comes from the desire to avoid confusion for
// those interested in the geometric properties of the quaternion in the 3D
// Cartesian space. Other texts often use alternative names or subscripts, such
// as `(a, b, c, d)`, `(1, i, j, k)`, or `(0, 1, 2, 3)`, which are perhaps
// better suited for mathematical interpretations.
//
// To avoid any confusion, as well as to maintain compatibility with a large
// number of software libraries, the quaternions represented using the protocol
// buffer below *must* follow the Hamilton convention, which defines `ij = k`
// (i.e. a right-handed algebra), and therefore:
//
//     i^2 = j^2 = k^2 = ijk = −1
//     ij = −ji = k
//     jk = −kj = i
//     ki = −ik = j
//
// Please DO NOT use this to represent quaternions that follow the JPL
// convention, or any of the other quaternion flavors out there.
//
// Definitions:
//
//   - Quaternion norm (or magnitude): `sqrt(x^2 + y^2 + z^2 + w^2)`.
//   - Unit (or normalized) quaternion: a quaternion whose norm is 1.
//   - Pure quaternion: a quaternion whose scalar component (`w`) is 0.
//   - Rotation quaternion: a unit quaternion used to represent rotation.
//   - Orientation quaternion: a unit quaternion used to represent orientation.
//
// A quaternion can be normalized by dividing it by its norm. The resulting
// quaternion maintains the same direction, but has a norm of 1, i.e. it moves
// on the unit sphere. This is generally necessary for rotation and orientation
// quaternions, to avoid rounding errors:
// https://en.wikipedia.org/wiki/Rotation_formalisms_in_three_dimensions
//
// Note that `(x, y, z, w)` and `(-x, -y, -z, -w)` represent the same rotation,
// but normalization would be even more useful, e.g. for comparison purposes, if
// it would produce a unique representation. It is thus recommended that `w` be
// kept positive, which can be achieved by changing all the signs when `w` is
// negative.
//
type Quaternion struct {
	// The x component.
	X float64 `protobuf:"fixed64,1,opt,name=x,proto3" json:"x,omitempty"`
	// The y component.
	Y float64 `protobuf:"fixed64,2,opt,name=y,proto3" json:"y,omitempty"`
	// The z component.
	Z float64 `protobuf:"fixed64,3,opt,name=z,proto3" json:"z,omitempty"`
	// The scalar component.
	W                    float64  `protobuf:"fixed64,4,opt,name=w,proto3" json:"w,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Quaternion) Reset()         { *m = Quaternion{} }
func (m *Quaternion) String() string { return proto.CompactTextString(m) }
func (*Quaternion) ProtoMessage()    {}
func (*Quaternion) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b847e1bdd83ff5e, []int{0}
}

func (m *Quaternion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Quaternion.Unmarshal(m, b)
}
func (m *Quaternion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Quaternion.Marshal(b, m, deterministic)
}
func (m *Quaternion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quaternion.Merge(m, src)
}
func (m *Quaternion) XXX_Size() int {
	return xxx_messageInfo_Quaternion.Size(m)
}
func (m *Quaternion) XXX_DiscardUnknown() {
	xxx_messageInfo_Quaternion.DiscardUnknown(m)
}

var xxx_messageInfo_Quaternion proto.InternalMessageInfo

func (m *Quaternion) GetX() float64 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *Quaternion) GetY() float64 {
	if m != nil {
		return m.Y
	}
	return 0
}

func (m *Quaternion) GetZ() float64 {
	if m != nil {
		return m.Z
	}
	return 0
}

func (m *Quaternion) GetW() float64 {
	if m != nil {
		return m.W
	}
	return 0
}

func init() {
	proto.RegisterType((*Quaternion)(nil), "google.type.Quaternion")
}

func init() { proto.RegisterFile("google/type/quaternion.proto", fileDescriptor_6b847e1bdd83ff5e) }

var fileDescriptor_6b847e1bdd83ff5e = []byte{
	// 170 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x92, 0x49, 0xcf, 0xcf, 0x4f,
	0xcf, 0x49, 0xd5, 0x2f, 0xa9, 0x2c, 0x48, 0xd5, 0x2f, 0x2c, 0x4d, 0x2c, 0x49, 0x2d, 0xca, 0xcb,
	0xcc, 0xcf, 0xd3, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0xe2, 0x86, 0xc8, 0xea, 0x81, 0x64, 0x95,
	0x5c, 0xb8, 0xb8, 0x02, 0xe1, 0x0a, 0x84, 0x78, 0xb8, 0x18, 0x2b, 0x24, 0x18, 0x15, 0x18, 0x35,
	0x18, 0x83, 0x18, 0x2b, 0x40, 0xbc, 0x4a, 0x09, 0x26, 0x08, 0xaf, 0x12, 0xc4, 0xab, 0x92, 0x60,
	0x86, 0xf0, 0xaa, 0x40, 0xbc, 0x72, 0x09, 0x16, 0x08, 0xaf, 0xdc, 0x29, 0x9f, 0x8b, 0x3f, 0x39,
	0x3f, 0x57, 0x0f, 0xc9, 0x60, 0x27, 0x7e, 0x84, 0xb1, 0x01, 0x20, 0x6b, 0x03, 0x18, 0xa3, 0x1c,
	0xa0, 0xf2, 0xe9, 0xf9, 0x39, 0x89, 0x79, 0xe9, 0x7a, 0xf9, 0x45, 0xe9, 0xfa, 0xe9, 0xa9, 0x79,
	0x60, 0x47, 0xe9, 0x43, 0xa4, 0x12, 0x0b, 0x32, 0x8b, 0xd1, 0x5d, 0x6d, 0x8d, 0x60, 0xfe, 0x60,
	0x64, 0x5c, 0xc4, 0xc4, 0xec, 0x1e, 0x12, 0x90, 0xc4, 0x06, 0xd6, 0x65, 0x0c, 0x08, 0x00, 0x00,
	0xff, 0xff, 0xc0, 0x0f, 0xce, 0x99, 0xea, 0x00, 0x00, 0x00,
}
