The Gradle team is pleased to announce Gradle 4.4.

First and foremost, this release of Gradle features some exciting improvements for IDE users:

 * [Visual Studio 2017 is now supported](#visual-studio-2017-support). Please read details about `vswhere` and [VS toolchain discovery changes](#changes-to-visual-studio-toolchain-discovery) if you plan to use Gradle with VS 2017.
 * The `eclipse` plugin now provides separate output folders. This allows Eclipse plugins to provide more sophisticated classpath management. [Buildship 2.2](https://projects.eclipse.org/projects/tools.buildship/reviews/2.2.0-release-review) will take advantage of this feature to avoid one large global classpath when running Java applications or executing tests in Eclipse IDE.

![Editing a Gradle Build for a C++ Library in Visual Studio 2017](data:image/png;base64,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)

No discussion about IDE support for Gradle would be complete without mentioning improvements to the Kotlin DSL. Version 0.13 is included in Gradle 4.4 and provides support for writing `settings.gradle.kts` files, Kotlin standard library extensions to the Java 7 and Java 8 APIs for use in build scripts, improvements to the `plugins {}` DSL, and more! See the [Kotlin DSL 0.13 release notes](https://github.com/gradle/kotlin-dsl/releases/tag/v0.13.1) for more details.

This version of Gradle supports version ranges in parent elements of a POM. You can see an [example below](#support-version-ranges-in-parent-elements).

C and C++ developers will enjoy better [incremental builds and build cache support for C/C++](#c/c++-incremental-build-improvements) because this version of Gradle takes compiler version and system headers into account for up-to-date checks. 

This version of Gradle fully supports the combination of Play 2.6 and Scala 2.12, with improvements and fixes to `runPlayBinary`, the distributed Play start script, and [other improvements](#improved-play-2.6-support).

Previous versions of Gradle required that all transitive dependencies of a given plugin were present in the same repository as the plugin. Gradle 4.4 takes all plugin repositories into account and can resolve transitive plugin dependencies across them. Learn about this and other plugin repository handling improvements [in the details](#plugin-repositories-enhancements). 

Last but not least, [several 3rd party dependencies](#upgrade-of-third-party-dependencies) including Ant were updated to their latest versions containing security and other bug fixes.

## New and noteworthy

Here are the new features introduced in this Gradle release.

### Eclipse plugin separates output folders

The `eclipse` plugin now defines separate output directories for each source folder. This ensures that main and test classes are compiled to different directories. 

The plugin also records which Eclipse classpath entries are needed for running classes from each source folder through the new `gradle_scope` and `gradle_used_by_scope` attributes. Future [Buildship](http://eclipse.org/buildship) versions will use this information to provide a more accurate classpath when launching applications and tests.

### Visual Studio 2017 support

It is now possible to compile native applications with the Visual C++ toolchain packaged with all versions of Visual Studio 2017.
  Note that discovery of a Visual Studio 2017 installation requires the [vswhere utility](https://github.com/Microsoft/vswhere).  Visual Studio 2017 versions earlier than update 2 do not install `vswhere` automatically, and so to use one of these earlier versions of Visual Studio 2017 when `vswhere` is not installed, you'll need to set [the installation directory on the VisualCpp toolchain](userguide/native_software.html#sec:defining_tool_chains).
  
### Parametrized tooling model builders

The Tooling API now allows model builders to accept parameters from the tooling client. This is useful when there are multiple possible mappings from the Gradle project to the tooling model and the decision depends on some user-provided value.

Android Studio, for instance, will use this API to request just the dependencies for the variant that the user currently selected in the UI. This will greatly reduce synchronization times.

For more information see the [documentation](javadoc/org/gradle/tooling/provider/model/ParameterizedToolingModelBuilder.html) of the new API.

### Support version ranges in parent elements

When resolving an external dependency from Maven repository, Gradle now supports version ranges in a `parent` element of a POM, which was introduced by Maven 3.2.2. The following is now permissible:

    <project>
      <modelVersion>4.0.0</modelVersion>
      <parent>
        <groupId>org.apache</groupId>
        <artifactId>apache</artifactId>
        <version>[3.0,4.0)</version>
      </parent>
      <groupId>org.apache.maven.its.mng2199</groupId>
      <artifactId>valid</artifactId>
      <version>1</version>
      <packaging>pom</packaging>
    </project>
  
### C/C++ incremental build improvements

C/C++ compilation now takes system headers, and the compiler vendor and version into account, making it safer to use those tasks with incremental build and [experimental native caching](userguide/build_cache.html#sec:task_output_caching_native_tasks).

Before Gradle 4.4 changing the compiler did not make the compilation task out of date, even though different compilers may produce different outputs.
Changing system headers were not detected either, so updating a system library would not have caused recompilation.

### Improved Play 2.6 support

This version of Gradle improves the `runPlayBinary` task to work with Play 2.6.

* The combination of Play 2.6 and Scala 2.12 should now have full support
* Play plugin's `dist` task fixes the generated start script

You can read more in the improved [Play plugin user guide chapter](userguide/play_plugin.html). Special thanks to [Marcos Pereira](https://github.com/marcospereira) for extraordinary contributions here.

### Plugin repositories enhancements

#### Plugin repositories declared in a settings script can now have custom names

    // settings.gradle
    pluginManagement {
        repositories {
            maven {
                name = "My Custom Plugin Repository"
                url = "https://..."
            }
        }
    }

#### Explicit notation for common repositories can now be used in settings scripts:

    // settings.gradle
    pluginManagement {
        repositories {
            gradlePluginPortal()
            jcenter()
            google()
            mavenCentral()
        }
    }

#### Gradle Plugin resolution changes

Plugin resolution now takes all plugin repositories into account and can resolve transitive plugin dependencies across them. Previous versions of Gradle required that all transitive dependencies of a given plugin were present in the same repository as the plugin.

#### Build scripts can declare Gradle Plugin Portal

Finally, the Gradle Plugin Portal repository can now be added to build scripts. This is particularly useful for `buildSrc` or binary plugin builds:

    // build.gradle
    repositories {
        gradlePluginPortal()
    }

### Use of canonical URL for `mavenCentral()` repository URL

In previous versions of Gradle the URL referred to by `RepositoryHandler.mavenCentral()` was pointing to `https://repo1.maven.org/maven2/`. Sonatype recommends using the canonical URL `https://repo.maven.apache.org/maven2/` instead. This version of Gradle makes the switch to `repo.maven.apache.org` when using the `mavenCentral()` API to avoid SSL errors due to [MVNCENTRAL-2870](https://issues.sonatype.org/browse/MVNCENTRAL-2870).

### Provider API documentation

In this release, the Gradle team added a new chapter in the user guide documenting the [Provider API](userguide/lazy_configuration.html).

### Task validation disallows input/output annotations on private getters

Annotating private task properties will not be allowed in Gradle 5.0.
To prepare for this, Gradle 4.4 will warn about annotations on private properties.
The warning is visible when building the task with the [`java-gradle-plugin`](userguide/javaGradle_plugin.html) applied:

    Task property validation finished with warnings:
    - Warning: Task type 'MyTask': property 'inputFile' is private and annotated with an input or output annotation

<!--
IMPORTANT: if this is a patch release, ensure that a prominent link is included in the foreword to all releases of the same minor stream.
Add-->

## Promoted features

Promoted features are features that were incubating in previous versions of Gradle but are now supported and subject to backwards compatibility.
See the User guide section on the “[Feature Lifecycle](userguide/feature_lifecycle.html)” for more information.

The following are the features that have been promoted in this Gradle release.

<!--
### Example promoted
-->

## Fixed issues

## Deprecations

Features that have become superseded or irrelevant due to the natural evolution of Gradle become *deprecated*, and scheduled to be removed
in the next major Gradle version (Gradle 5.0). See the User guide section on the “[Feature Lifecycle](userguide/feature_lifecycle.html)” for more information.

The following are the newly deprecated items in this Gradle release. If you have concerns about a deprecation, please raise it via the [Gradle Forums](https://discuss.gradle.org).

### Deprecation of no-rebuild command line options 

The command line options for avoiding a full rebuild of dependent projects in a multi-project builds (`-a`/`--no-rebuild`) were introduced in a very early version of Gradle. 
Since then Gradle optimized its up-to-date checking for project dependencies which renders the option obsolete. It has been deprecated and will be removed in Gradle 5.0.

<!--
### Example deprecation
-->

## Potential breaking changes

### Change to the `Test` task structure

Common test framework functionality in the `Test` task moved to `AbstractTestTask`. Be aware that `AbstractTestTask` is the new base class for the `Test` task. The `AbstractTestTask` will be used by test frameworks outside of the JVM ecosystem. Plugins configuring an `AbstractTestTask` will find tasks for test frameworks (e.g., XCTest, Google Test, etc.).

### Changes in the `eclipse` plugin

The default output location in [EclipseClasspath](dsl/org.gradle.plugins.ide.eclipse.model.EclipseClasspath.html#org.gradle.plugins.ide.eclipse.model.EclipseClasspath:defaultOutputDir) changed from `${project.projectDir}/bin` to `${project.projectDir}/bin/default`.

### Removal of `@Incubating` methods

- `org.gradle.nativeplatform.tasks.InstallExecutable.setDestinationDir(Provider<? extends Directory>)` was removed. Use `org.gradle.nativeplatform.tasks.InstallExecutable.getInstallDirectory()` instead.
- `org.gradle.nativeplatform.tasks.InstallExecutable.setExecutable(Provider<? extends RegularFile>)` was removed. Use `org.gradle.nativeplatform.tasks.InstallExecutable.getSourceFile()` instead.

### Changes to Visual Studio toolchain discovery

In previous versions, Gradle would prefer a version of Visual Studio found on the path over versions discovered through any other 
means.  It will now consider a version found on the path only if a version is not found in the registry or through executing 
the [vswhere](https://github.com/Microsoft/vswhere) utility (i.e. it will consider the path only as a last resort).  In order to 
force a particular version of Visual Studio to be used, configure the [installation directory](dsl/org.gradle.nativeplatform.toolchain.VisualCpp.html#org.gradle.nativeplatform.toolchain.VisualCpp:installDir) on the Visual Studio toolchain.

### Upgrade of third-party dependencies

This version includes several upgrades of third-party dependencies:

- `jackson`: `2.6.6` -> `2.8.9` 
- `plexus-utils`: `2.0.6` -> `2.1` 
- `xercesImpl`: `2.9.1` -> `2.11.0` 
- `bsh`: `2.0b4` -> `2.0b6` 
- `bouncycastle`: `1.57` -> `1.58`

to fix the following security issues:

- [CVE-2017-7525](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-7525) (critical)
- SONATYPE-2017-0359 (critical)
- SONATYPE-2017-0355 (critical)
- SONATYPE-2017-0398 (critical)
- [CVE-2013-4002](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2013-4002) (critical)
- [CVE-2016-2510](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2016-2510) (severe)
- SONATYPE-2016-0397 (severe)
- [CVE-2009-2625](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-2625) (severe)
- SONATYPE-2017-0348 (severe)

Gradle does not expose public APIs for these 3rd-party dependencies, but those who customize Gradle will want to be aware.

### Ant version upgraded to Ant 1.9.9

Gradle has been upgraded to embed Ant 1.9.9 over Ant 1.9.6.

### Avoid checking other repositories when dependency resolution in one repository fails with HTTP status code in the 500 range

The HTTP status codes 5xx can be considered unrecoverable server states. Gradle will explicitly rethrow exceptions which occur in dependency resolution instead of quietly continue to the next repository similar to timeout issues introduced in Gradle 4.3.

### The type of `pluginManagement.repositories` changed

Before Gradle 4.4 it was a `PluginRepositoriesSpec`. This type has been removed and `pluginManagement.repositories` is now a regular `RepositoryHandler`.

## External contributions

We would like to thank the following community members for making contributions to this release of Gradle.

<!--
 - [Some person](https://github.com/some-person) - fixed some issue (gradle/gradle#1234)
-->

- [Marcos Pereira](https://github.com/marcospereira) — Several improvements to Play 2.6 and Scala 2.12 support (gradle/gradle#3018, gradle/gradle#3314 and gradle/gradle#3315)
- [Lucas Smaira](https://github.com/lsmaira) - Support parametrized Tooling model builders (gradle/gradle#2729)
- [Kyle Moore](https://github.com/DPUkyle) - Updated Gosu plugin to fix API breakage (gradle/gradle#3115)
- [Kyle Moore](https://github.com/DPUkyle) - Filter non-file URLs when getting classpath from `ClassLoader` (gradle/gradle#3224)
- [Jaci Brunning](https://github.com/JacisNonsense) - Support for overriding target platforms on Gcc toolchains (gradle/gradle#3124)
- [Joel Vasallo](https://github.com/jvasallo) - Use canonical URL for Maven Central repository shortcut method (gradle/gradle#3464)
- [Chris Dore](https://github.com/oesolutions) - Fix typo in lazy configuration section of user guide (gradle/gradle#3602)

We love getting contributions from the Gradle community. For information on contributing, please see [gradle.org/contribute](https://gradle.org/contribute).

## Known issues

Known issues are problems that were discovered post release that are directly related to changes made in this release.
