{- This module was generated from data in the Kate syntax
   highlighting file actionscript.xml, version 1.0, by Aaron Miller (armantic101@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Actionscript
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Javadoc
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "ActionScript 2.0"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.as"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("ActionScript 2.0","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("ActionScript 2.0","Normal") -> return ()
      ("ActionScript 2.0","String") -> (popContext) >> pEndLine
      ("ActionScript 2.0","Member") -> (popContext) >> pEndLine
      ("ActionScript 2.0","StaticImports") -> (popContext) >> pEndLine
      ("ActionScript 2.0","Imports") -> (popContext) >> pEndLine
      ("ActionScript 2.0","Commentar 1") -> (popContext) >> pEndLine
      ("ActionScript 2.0","Commentar 2") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_properties = Set.fromList $ words $ "_accProps _focusrect _global _highquality _level _parent _quality _root _soundbuftime maxscroll scroll this"
list_global'5ffunctions = Set.fromList $ words $ "asfunction call chr clearInterval duplicateMovieClip escape eval fscommand getProperty getTimer getURL getVersion gotoAndPlay gotoAndStop ifFrameLoaded int isFinite isNaN length loadMovie loadMovieNum loadVariables loadVariablesNum mbchr mblength mbord mbsubstring nextFrame nextScene on onClipEvent ord parseFloat parseInt play prevFrame prevScene print printAsBitmap printAsBitmapNum printNum random removeMovieClip setInterval setProperty showRedrawRegions startDrag stop stopAllSounds stopDrag substring targetPath tellTarget toggleHighQuality trace typeof unescape unloadMovie unloadMovieNum updateAfterEvent"
list_classes = Set.fromList $ words $ "Accessibility Accordion Alert Binding Button Camera CellRenderer CheckBox Collection Color ComboBox ComponentMixins ContextMenu ContextMenuItem CustomActions CustomFormatter CustomValidator DataGrid DataHolder DataProvider DataSet DataType Date DateChooser DateField Delta DeltaItem DeltaPacket DepthManager EndPoint Error FaultEvent FocusManager Form Function Iterator Key Label List LoadVars Loader LocalConnection Log Math Media Menu MenuBar Microphone Mouse MovieClip MovieClipLoader NetConnection NetStream Number NumericStepper PendingCall PopUpManager PrintJob ProgressBar RDBMSResolver RadioButton RelayResponder SOAPCall Screen ScrollPane Selection SharedObject Slide Sound Stage StyleManager System TextArea TextField TextFormat TextInput TextSnapshot TransferObject Tree TreeDataProvider TypedValue UIComponent UIEventDispatcher UIObject Video WebService WebServiceConnector Window XML XMLConnector XUpdateResolver"
list_keywords = Set.fromList $ words $ "add and break case catch class continue default delete do dynamic else eq extends finally for function ge get gt if implements import in instanceof interface intrinsic le lt ne new not or private public return set static switch throw try var void while with"
list_const = Set.fromList $ words $ "false Infinity -Infinity NaN newline null true undefined"
list_types = Set.fromList $ words $ "Array Boolean Number Object String Void"

regex_'2f'2f'5cs'2aBEGIN'2e'2a'24 = compileRegex "//\\s*BEGIN.*$"
regex_'2f'2f'5cs'2aEND'2e'2a'24 = compileRegex "//\\s*END.*$"
regex_'5c'2e'7b3'2c3'7d'5cs'2b = compileRegex "\\.{3,3}\\s+"
regex_'5cb'28import'5cs'2bstatic'29'5cb = compileRegex "\\b(import\\s+static)\\b"
regex_'5cb'28package'7cimport'29'5cb = compileRegex "\\b(package|import)\\b"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'28'2f'5c'2a'5cs'2a'5cd'2b'5cs'2a'5c'2a'2f'5cs'2a'29'3f'5b'28'5d'29 = compileRegex "\\b[_\\w][_\\w\\d]*(?=[\\s]*(/\\*\\s*\\d+\\s*\\*/\\s*)?[(])"
regex_'5b'2e'5d'7b1'2c1'7d = compileRegex "[.]{1,1}"
regex_'5cb'5b'5fa'2dzA'2dZ'5d'5cw'2a'28'3f'3d'5b'5cs'5d'2a'29 = compileRegex "\\b[_a-zA-Z]\\w*(?=[\\s]*)"
regex_'5cs'2a'2e'2a'24 = compileRegex "\\s*.*$"

parseRules ("ActionScript 2.0","Normal") =
  (((Text.Highlighting.Kate.Syntax.Javadoc.parseExpression (Just ("Javadoc",""))))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_properties >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_global'5ffunctions >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_classes >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_const >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'2f'2f'5cs'2aBEGIN'2e'2a'24 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'2f'2f'5cs'2aEND'2e'2a'24 >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("ActionScript 2.0","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("ActionScript 2.0","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("ActionScript 2.0","Commentar 2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'2e'7b3'2c3'7d'5cs'2b >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28import'5cs'2bstatic'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("ActionScript 2.0","StaticImports"))
   <|>
   ((pRegExpr regex_'5cb'28package'7cimport'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("ActionScript 2.0","Imports"))
   <|>
   ((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'28'2f'5c'2a'5cs'2a'5cd'2b'5cs'2a'5c'2a'2f'5cs'2a'29'3f'5b'28'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5b'2e'5d'7b1'2c1'7d >>= withAttribute NormalTok) >>~ pushContext ("ActionScript 2.0","Member"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ActionScript 2.0","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ActionScript 2.0","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ActionScript 2.0","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("ActionScript 2.0","Member") =
  (((pRegExpr regex_'5cb'5b'5fa'2dzA'2dZ'5d'5cw'2a'28'3f'3d'5b'5cs'5d'2a'29 >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("ActionScript 2.0","StaticImports") =
  (((pRegExpr regex_'5cs'2a'2e'2a'24 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ActionScript 2.0","StaticImports")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ActionScript 2.0","Imports") =
  (((pRegExpr regex_'5cs'2a'2e'2a'24 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ActionScript 2.0","Imports")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ActionScript 2.0","Commentar 1") =
  (currentContext >>= \x -> guard (x == ("ActionScript 2.0","Commentar 1")) >> pDefault >>= withAttribute CommentTok)

parseRules ("ActionScript 2.0","Commentar 2") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ActionScript 2.0","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Javadoc", _) = Text.Highlighting.Kate.Syntax.Javadoc.parseExpression Nothing

parseRules x = parseRules ("ActionScript 2.0","Normal") <|> fail ("Unknown context" ++ show x)
