/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.service;

import javax.ejb.Local;
import javax.ejb.Remote;
import org.jboss.annotation.ejb.Depends;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.Service;

/**
 * @author <a href="mailto:kabir.khan@jboss.org">Kabir Khan</a>
 * @version $Revision: 60233 $
 */
@Service
@RemoteBinding(jndiBinding = "serviceTwo/remote")
@LocalBinding (jndiBinding = "serviceTwo/local")
@Depends ("jboss.j2ee:jar=service-test.jar,name=ServiceOne,service=EJB3,type=ManagementInterface")
@Remote(ServiceTwoRemote.class)
@Local(ServiceTwoLocal.class)
public class ServiceTwo implements ServiceTwoLocal, ServiceTwoRemote
{
   boolean called;

   public boolean getCalled()
   {
      return called;
   }

   public void setCalled(boolean called)
   {
      this.called = called;
   }

   public void localMethod()
   {
      called = true;
   }

   public void remoteMethod()
   {
      called = true;
   }
}
