/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.ConfigurableComponent;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanContextFactory;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.BeforeAfterMethodInterceptor;
import net.sourceforge.stripes.controller.DefaultActionBeanContextFactory;
import net.sourceforge.stripes.controller.DefaultActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.HttpCacheInterceptor;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.NameBasedActionResolver;
import net.sourceforge.stripes.controller.multipart.DefaultMultipartWrapperFactory;
import net.sourceforge.stripes.controller.multipart.MultipartWrapperFactory;
import net.sourceforge.stripes.exception.DefaultExceptionHandler;
import net.sourceforge.stripes.exception.ExceptionHandler;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.DefaultFormatterFactory;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.localization.DefaultLocalePicker;
import net.sourceforge.stripes.localization.DefaultLocalizationBundleFactory;
import net.sourceforge.stripes.localization.LocalePicker;
import net.sourceforge.stripes.localization.LocalizationBundleFactory;
import net.sourceforge.stripes.tag.DefaultPopulationStrategy;
import net.sourceforge.stripes.tag.DefaultTagErrorRendererFactory;
import net.sourceforge.stripes.tag.PopulationStrategy;
import net.sourceforge.stripes.tag.TagErrorRendererFactory;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.DefaultTypeConverterFactory;
import net.sourceforge.stripes.validation.DefaultValidationMetadataProvider;
import net.sourceforge.stripes.validation.TypeConverterFactory;
import net.sourceforge.stripes.validation.ValidationMetadataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
implements Configuration {
    private static final Log log = Log.getInstance(DefaultConfiguration.class);
    private boolean debugMode;
    private BootstrapPropertyResolver resolver;
    private ActionResolver actionResolver;
    private ActionBeanPropertyBinder actionBeanPropertyBinder;
    private ActionBeanContextFactory actionBeanContextFactory;
    private TypeConverterFactory typeConverterFactory;
    private LocalizationBundleFactory localizationBundleFactory;
    private LocalePicker localePicker;
    private FormatterFactory formatterFactory;
    private TagErrorRendererFactory tagErrorRendererFactory;
    private PopulationStrategy populationStrategy;
    private Map<LifecycleStage, Collection<Interceptor>> interceptors;
    private ExceptionHandler exceptionHandler;
    private MultipartWrapperFactory multipartWrapperFactory;
    private ValidationMetadataProvider validationMetadataProvider;

    @Override
    public void setBootstrapPropertyResolver(BootstrapPropertyResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void init() {
        try {
            Boolean debugMode = this.initDebugMode();
            this.debugMode = debugMode != null ? debugMode : false;
            this.actionResolver = this.initActionResolver();
            if (this.actionResolver == null) {
                this.actionResolver = new NameBasedActionResolver();
                this.actionResolver.init(this);
            }
            this.actionBeanPropertyBinder = this.initActionBeanPropertyBinder();
            if (this.actionBeanPropertyBinder == null) {
                this.actionBeanPropertyBinder = new DefaultActionBeanPropertyBinder();
                this.actionBeanPropertyBinder.init(this);
            }
            this.actionBeanContextFactory = this.initActionBeanContextFactory();
            if (this.actionBeanContextFactory == null) {
                this.actionBeanContextFactory = new DefaultActionBeanContextFactory();
                this.actionBeanContextFactory.init(this);
            }
            this.typeConverterFactory = this.initTypeConverterFactory();
            if (this.typeConverterFactory == null) {
                this.typeConverterFactory = new DefaultTypeConverterFactory();
                this.typeConverterFactory.init(this);
            }
            this.localizationBundleFactory = this.initLocalizationBundleFactory();
            if (this.localizationBundleFactory == null) {
                this.localizationBundleFactory = new DefaultLocalizationBundleFactory();
                this.localizationBundleFactory.init(this);
            }
            this.localePicker = this.initLocalePicker();
            if (this.localePicker == null) {
                this.localePicker = new DefaultLocalePicker();
                this.localePicker.init(this);
            }
            this.formatterFactory = this.initFormatterFactory();
            if (this.formatterFactory == null) {
                this.formatterFactory = new DefaultFormatterFactory();
                this.formatterFactory.init(this);
            }
            this.tagErrorRendererFactory = this.initTagErrorRendererFactory();
            if (this.tagErrorRendererFactory == null) {
                this.tagErrorRendererFactory = new DefaultTagErrorRendererFactory();
                this.tagErrorRendererFactory.init(this);
            }
            this.populationStrategy = this.initPopulationStrategy();
            if (this.populationStrategy == null) {
                this.populationStrategy = new DefaultPopulationStrategy();
                this.populationStrategy.init(this);
            }
            this.exceptionHandler = this.initExceptionHandler();
            if (this.exceptionHandler == null) {
                this.exceptionHandler = new DefaultExceptionHandler();
                this.exceptionHandler.init(this);
            }
            this.multipartWrapperFactory = this.initMultipartWrapperFactory();
            if (this.multipartWrapperFactory == null) {
                this.multipartWrapperFactory = new DefaultMultipartWrapperFactory();
                this.multipartWrapperFactory.init(this);
            }
            this.validationMetadataProvider = this.initValidationMetadataProvider();
            if (this.validationMetadataProvider == null) {
                this.validationMetadataProvider = new DefaultValidationMetadataProvider();
                this.validationMetadataProvider.init(this);
            }
            this.interceptors = new HashMap<LifecycleStage, Collection<Interceptor>>();
            Map<LifecycleStage, Collection<Interceptor>> map = this.initCoreInterceptors();
            if (map != null) {
                this.mergeInterceptorMaps(this.interceptors, map);
            }
            if ((map = this.initInterceptors()) != null) {
                this.mergeInterceptorMaps(this.interceptors, map);
            }
            for (Map.Entry<LifecycleStage, Collection<Interceptor>> entry : this.interceptors.entrySet()) {
                HashSet classes = new HashSet();
                Collection<Interceptor> interceptors = entry.getValue();
                if (interceptors == null) continue;
                for (Interceptor interceptor : interceptors) {
                    Class<?> clazz = interceptor.getClass();
                    if (classes.contains(clazz)) {
                        log.warn(new Object[]{"Interceptor ", clazz, " is configured to run more than once for ", entry.getKey()});
                        continue;
                    }
                    classes.add(clazz);
                }
            }
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Problem instantiating default configuration objects.", e);
        }
    }

    @Override
    public BootstrapPropertyResolver getBootstrapPropertyResolver() {
        return this.resolver;
    }

    @Override
    public ServletContext getServletContext() {
        return this.getBootstrapPropertyResolver().getFilterConfig().getServletContext();
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    protected Boolean initDebugMode() {
        return null;
    }

    @Override
    public ActionResolver getActionResolver() {
        return this.actionResolver;
    }

    protected ActionResolver initActionResolver() {
        return null;
    }

    @Override
    public ActionBeanPropertyBinder getActionBeanPropertyBinder() {
        return this.actionBeanPropertyBinder;
    }

    protected ActionBeanPropertyBinder initActionBeanPropertyBinder() {
        return null;
    }

    @Override
    public ActionBeanContextFactory getActionBeanContextFactory() {
        return this.actionBeanContextFactory;
    }

    protected ActionBeanContextFactory initActionBeanContextFactory() {
        return null;
    }

    @Override
    public TypeConverterFactory getTypeConverterFactory() {
        return this.typeConverterFactory;
    }

    protected TypeConverterFactory initTypeConverterFactory() {
        return null;
    }

    @Override
    public LocalizationBundleFactory getLocalizationBundleFactory() {
        return this.localizationBundleFactory;
    }

    protected LocalizationBundleFactory initLocalizationBundleFactory() {
        return null;
    }

    @Override
    public LocalePicker getLocalePicker() {
        return this.localePicker;
    }

    protected LocalePicker initLocalePicker() {
        return null;
    }

    @Override
    public FormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    protected FormatterFactory initFormatterFactory() {
        return null;
    }

    @Override
    public TagErrorRendererFactory getTagErrorRendererFactory() {
        return this.tagErrorRendererFactory;
    }

    protected TagErrorRendererFactory initTagErrorRendererFactory() {
        return null;
    }

    @Override
    public PopulationStrategy getPopulationStrategy() {
        return this.populationStrategy;
    }

    protected PopulationStrategy initPopulationStrategy() {
        return null;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected ExceptionHandler initExceptionHandler() {
        return null;
    }

    @Override
    public MultipartWrapperFactory getMultipartWrapperFactory() {
        return this.multipartWrapperFactory;
    }

    protected MultipartWrapperFactory initMultipartWrapperFactory() {
        return null;
    }

    @Override
    public ValidationMetadataProvider getValidationMetadataProvider() {
        return this.validationMetadataProvider;
    }

    protected ValidationMetadataProvider initValidationMetadataProvider() {
        return null;
    }

    @Override
    public Collection<Interceptor> getInterceptors(LifecycleStage stage) {
        Collection<Interceptor> interceptors = this.interceptors.get((Object)stage);
        if (interceptors == null) {
            interceptors = Collections.emptyList();
        }
        return interceptors;
    }

    protected void mergeInterceptorMaps(Map<LifecycleStage, Collection<Interceptor>> dst, Map<LifecycleStage, Collection<Interceptor>> src) {
        for (Map.Entry<LifecycleStage, Collection<Interceptor>> entry : src.entrySet()) {
            Collection<Interceptor> collection = dst.get((Object)entry.getKey());
            if (collection == null) {
                collection = new LinkedList<Interceptor>();
                dst.put(entry.getKey(), collection);
            }
            collection.addAll(entry.getValue());
        }
    }

    protected void addInterceptor(Map<LifecycleStage, Collection<Interceptor>> map, Interceptor interceptor) {
        Class<?> type = interceptor.getClass();
        Intercepts intercepts = type.getAnnotation(Intercepts.class);
        if (intercepts == null) {
            log.error("An interceptor of type ", type.getName(), " was configured ", "but was not marked with an @Intercepts annotation. As a ", "result it is not possible to determine at which ", "lifecycle stages the interceptor should be applied. This ", "interceptor will be ignored.");
            return;
        }
        log.debug(new Object[]{"Configuring interceptor '", type.getSimpleName(), "', for lifecycle stages: ", intercepts.value()});
        if (interceptor instanceof ConfigurableComponent) {
            try {
                ((ConfigurableComponent)((Object)interceptor)).init(this);
            }
            catch (Exception e) {
                log.error("Error initializing interceptor of type " + type.getName(), e);
            }
        }
        for (LifecycleStage stage : intercepts.value()) {
            Collection<Interceptor> stack = map.get((Object)stage);
            if (stack == null) {
                stack = new LinkedList<Interceptor>();
                map.put(stage, stack);
            }
            stack.add(interceptor);
        }
    }

    protected Map<LifecycleStage, Collection<Interceptor>> initCoreInterceptors() {
        HashMap<LifecycleStage, Collection<Interceptor>> interceptors = new HashMap<LifecycleStage, Collection<Interceptor>>();
        this.addInterceptor(interceptors, new BeforeAfterMethodInterceptor());
        this.addInterceptor(interceptors, new HttpCacheInterceptor());
        return interceptors;
    }

    protected Map<LifecycleStage, Collection<Interceptor>> initInterceptors() {
        return null;
    }
}

