# support for the nasm assembler

SET(ASM_DIALECT "-NASM")

SET(CMAKE_ASM${ASM_DIALECT}_SOURCE_FILE_EXTENSIONS asm)

if(WIN32)
  if(CMAKE_C_SIZEOF_DATA_PTR EQUAL 8)
    SET(CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT win64)
  else()
    SET(CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT win32)
  endif()
elseif(APPLE)
  if(CMAKE_C_SIZEOF_DATA_PTR EQUAL 8)
    SET(CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT macho64)
  else()
    SET(CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT macho)
  endif()
else()
  if(CMAKE_C_SIZEOF_DATA_PTR EQUAL 8)
    SET(CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT elf64)
  else()
    SET(CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT elf)
  endif()
endif()

SET(CMAKE_ASM${ASM_DIALECT}_COMPILE_OBJECT "<CMAKE_ASM${ASM_DIALECT}_COMPILER> <FLAGS> -f ${CMAKE_ASM${ASM_DIALECT}_OBJECT_FORMAT} -o <OBJECT> <SOURCE>")

INCLUDE(CMakeASMInformation)
SET(ASM_DIALECT)
