<?php

/*
# Copyright 2006, CRIM., Martin Rioux
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/* This is the login object when htacces is use instead of ldap or any authorization module
 *
 * Author: Martin Rioux
 * Last modification:
 * 		7 Mar 2006 Martin Rioux <martin.rioux@crim.ca>
 *		- Creation
 */
require_once 'dbFunctions.php';
require_once 'Permission.php';
class Permissions {
	var $listPermissions; // array of permissions
	var $attributesList; //all attributes with one permission

	function Permissions($nodeId) {
		$this->setPermissions($this->getPermissionsFromDB($nodeId),$nodeId);
	}

	/** This function clean up permissionList in order to respect the following rules :
	 *
	 * 1- If they are permissions set at different level of hierarchy,
	 * the closest permission will be apply
	 * 2- If a user obtain two permissions on the same node from two different groups,
	 * the most privilegious permission will be selected.
	 *
	 */
	function setPermissions($permissions,$nodeId){
		$this->attributeList=array();
		$previousId;
		$previousAttribute;
		$ignoreNextSameId = false;
		//remember all attributes
		$newIndex=0;
		for ($index = 0; $index < sizeof($permissions); $index++) {
			//default-> it's a new attribute...
			if(empty($this->attributesList) || !in_array($permissions[$index]->getAttribute(),$this->attributesList)){
				$previousId = $permissions[$index]->getNodeId();
				$previousAttribute = $permissions[$index]->getAttribute();
				$permissions[$index]->setNodeId($nodeId);
				$this->listPermissions[$newIndex] = $permissions[$index];
				$this->attributesList[$newIndex] = $permissions[$index]->getAttribute();
				$newIndex++;
				$ignoreNextSameId = false;
				continue;
			}
			//If the permission attribute is already define for another node continue... (rule #1)
			if(in_array($permissions[$index]->getAttribute(),$this->attributesList) && $previousId != $permissions[$index]->getNodeId()){
				$previousId = $permissions[$index]->getNodeId();
				$previousAttribute = $permissions[$index]->getAttribute();
				$ignoreNextSameId = true;
				continue;
			}
			//If it's the same attribute and the same node the most privilegious permission will be selected. rule #2
			if(!$ignoreNextSameId && in_array($permissions[$index]->getAttribute(),$this->attributesList) && $previousId == $permissions[$index]->getNodeId()){
				$previousId = $permissions[$index]->getNodeId();
				$previousAttribute = $permissions[$index]->getAttribute();
				//update previous permission with this one
				$this->listPermissions[$newIndex-1] = $this->mergePermissions($this->listPermissions[$newIndex-1],$permissions[$index]);
				$ignoreNextSameId = false;
				continue;
			}
		}
	}
	/**
	 * This function get all permission for a specific node
	 */
	function getPermissionsFromDB($nodeId){
		$sessionData  = $_SESSION['groups'];
		//Superadmin  role bypass all permissions

		if($_SESSION['userRole'] == "Superadmin"){
			$listPerms[] = new Permission(0,'*',1,1,1,1,1);
			$listPerms[] = new Permission(0,"",1,1,1,1,1);
			return $listPerms;
		}
		//Generate IN condition
		$groups = $sessionData->getGroups();
		$inCondition="";
		for ($index = 0; $index < sizeof($groups); $index++) {
			$inCondition = $inCondition."'".$groups[$index]."'";
			if($index <(sizeof($groups))-1){
				$inCondition = $inCondition.",";
			}
		}
		$request = "SELECT id, attributes, scope, canadd, candelete, canread, canwrite ".
				   "FROM nodes,permissions ".
				   "WHERE leftval<=(select leftval from nodes where id=".$nodeId.") ".
				   "AND rightval >=(select rightval from nodes where id=".$nodeId.") ".
				   "AND id = nodes_id ".
				   "AND (scope = 1 OR nodes_id = ".$nodeId.") ".
				   "AND (".
				   "       (granteekey IN (".$inCondition.") AND granteetype =2)".
				   "       OR".
				   "       (granteekey ='".$sessionData->getUsername()."' AND granteetype =1)".
				   "      ) ".
				   "ORDER BY rightval, attributes";
		$perms = select($request);
		if (!is_array($perms) && !is_null($perms)) {
			$this->lastError = getMessage('db_error') . $perms;
			return NULL;
		}
		if (is_null($perms)) {
			$this->lastError = "";
			return NULL;
		}
		for ($index = 0; $index < sizeof($perms); $index++) {
			$permission = new Permission($perms[$index]["id"],$perms[$index]["attributes"],$perms[$index]["scope"],$perms[$index]["canadd"],$perms[$index]["candelete"],$perms[$index]["canread"],$perms[$index]["canwrite"]);
			$listPerms[$index] = $permission;
		}
		return $listPerms;
	}
	/**
	 * This function applied rule 2 - If a user obtain two permissions on the same node from
	 * two different groups, the most privilegious permission will be selected.
	 */
	function mergePermissions($perm1, $perm2){
		if(!$perm1->getScope())$perm1->setScope($perm2->getScope());
		if(!$perm1->getCanadd())$perm1->setCanadd($perm2->getCanadd());
		if(!$perm1->getCandelete())$perm1->setCandelete($perm2->getCandelete());
		if(!$perm1->getCanread())$perm1->setCanread($perm2->getCanread());
		if(!$perm1->getCanwrite())$perm1->setCanwrite($perm2->getCanwrite());
		return $perm1;
	}
	/**
	 * Get index permission for nodes...
	 */
	function getNodeIndex(){
	    $returnValue = -1;
	    for ($index = 0; $index < sizeof($this->listPermissions); $index++) {
	    	//if attribute is empty it is the node permission
			if($this->listPermissions[$index]->getAttribute() == ""){
				$returnValue=$index;
				break;
			}
		}
		return $returnValue;
	}
	/**
	 * This function return the permission to use (index of listPermissions) for the attribute
	 * 1. if attribute name is in $attributesList
	 * 2. if attribute name begin with an attriubte in $attributesList contain XXXX* (ex. SCREEN_* match SCREEN_01)
	 * 3. if $attributeClass.$name isi defined.
	 * 4. if permission on all attribute is defined... (ex. *)
	 *
	 */
	 function getIndexPermission($name, $attributeClass){
		// 1.if attribute name is in $attributesList
		$returnValue = -1; //index value return if no permission is -1
		for ($index = 0; $index < sizeof($this->listPermissions); $index++) {
			if($this->listPermissions[$index]->getAttribute() == $name){
				$returnValue = $index;
				break;
			}
		}
		// 2. if attribute name begin with an attriubte in $attributesList contain XXXX*
		if($returnValue == -1){
			for ($index = 0; $index < sizeof($this->listPermissions); $index++) {
				//MUST CONTAINT * at last position
				$stringToCompare = $this->listPermissions[$index]->getAttribute();
				if(strlen($stringToCompare)>1 && $stringToCompare{strlen($stringToCompare)-1}=='*' ){
					$stringToCompare = substr($stringToCompare,0,strlen($stringToCompare)-1);
					if(strpos($name,$stringToCompare)!==false){
						$returnValue = $index;
						break;
					}
				}
			}
		}
		//3. if $attributeClass.$name is defined.
		if($returnValue == -1){
			for ($index = 0; $index < sizeof($this->listPermissions); $index++) {
				if($this->listPermissions[$index]->getAttribute() == $attributeClass.'.*'){
					$returnValue = $index;
					break;
				}
			}
		}
		//4. if permission on all attribute is defined... (ex. *)
		if($returnValue == -1){
			for ($index = 0; $index < sizeof($this->listPermissions); $index++) {
				if($this->listPermissions[$index]->getAttribute() == '*'){
					$returnValue = $index;
					break;
				}
			}
		}
		return $returnValue;
	 }

	 /**
	  * This function validate attribute delete rights
	  */
	  function canDeleteAttribute($name, $attributeClass){
	    $index = $this->getIndexPermission($name, $attributeClass);
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue = $this->listPermissions[$index]->getCandelete();
	    }
	    return $returnValue;
	  }
	 /**
	  * This function validate attribute add rights
	  *
	  */
	  function canAddAttribute($name, $attributeClass){
	    $index = $this->getIndexPermission($name, $attributeClass);
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue=$this->listPermissions[$index]->getCanadd();
	    }
	    return $returnValue;
	  }
	 /**
	  * This function validate attribute read rights
	  *
	  */
	  function canReadAttribute($name, $attributeClass){
	    $index = $this->getIndexPermission($name, $attributeClass);
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue=$this->listPermissions[$index]->getCanread();
	    }
	    return $returnValue;
	  }
	 /**
	  * This function validate attribute modify rights
	  *
	  */
	  function canWriteAttribute($name, $attributeClass){
	    $index = $this->getIndexPermission($name, $attributeClass);
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue=$this->listPermissions[$index]->getCanwrite();
	    }
	    return $returnValue;
	  }
	 /**
	  * This function validate attribute modify rights
	  *
	  */
	  function canReadNode(){
	    $index = $this->getNodeIndex();
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue=$this->listPermissions[$index]->getCanread();
	    }
	    return $returnValue;
	  }
	 /**
	  * This function validate attribute modify rights
	  *
	  */
	  function canWriteNode(){
	    $index = $this->getNodeIndex();
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue=$this->listPermissions[$index]->getCanwrite();
	    }
	    return $returnValue;
	  }
	 /**
	  * This function validate attribute modify rights
	  *
	  */
	  function canAddNode(){
	    $index = $this->getNodeIndex();
	    $returnValue = 0;//Default no permission
	    if($index != -1){
	    	$returnValue=$this->listPermissions[$index]->getCanadd();
	    }
	    return $returnValue;
	  }
}
?>
