//
//  Lynkeos 
//  $Id: MyDocumentData.h,v 1.8 2005/01/27 23:03:05 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Thu Jul 29 2004.
//  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/*!
 * @header
 * @abstract Document contents wrapper classes
 * @discussion The load and save use these classes as a root object to feed the
 *    archiver or extract from the unarchiver.
 *
 *    The V0 document format is handled by a compatibility class
 */
#ifndef __MYDOCUMENTDATA_H
#define __MYDOCUMENTDATA_H

#include "MyObjectImageList.h"

/*!
 * @class MyDocumentDataV1
 * @abstract Wrapper class for version 1 document content
 * @discussion The document attributes to be saved are copied in an instance of
 *    this class which feed the archiver
 * @ingroup Models
 */
@interface MyDocumentDataV1 : NSObject <NSCoding>
{
@public
   MyObjectImageList*	_imageList;
   MyImageList*		_darkFrameList;
   MyImageList*		_flatFieldList;
   BOOL                 _monochromeFlat;
   int                  _analysisMethod;  // Enum converted
   NSString*            _windowFrame;
}
@end

/*!
 * @class MyImageListData
 * @abstract Compatibility wrapper class for version 0 document format
 * @discussion It contains the attributes of the image list and is send to 
 *    MyObjectImageList for initalization when the unarchiver creates an 
 *    instance of this class.
 * @ingroup Models
 */
@interface MyImageListData : NSObject <NSCoding>
{
   @public
   NSArray*	     _imageList;
   MyImageListItem*  _referenceItem;
   NSPoint	     _searchSquareOrigin;
   double	     _searchSquareSide;
   NSPoint	     _analyzeSquareOrigin;
   double	     _analyzeSquareSide;
   double	     _selectThreshold;
   NSRect	     _cropRectangle;
   BOOL		     _doubleSize;
   NSData*	     _rawStack;
   double	     _uRadius, _uGain;
   double	     _dRadius, _dThreshold;
   double	     _blackLevel, _whiteLevel;
}
@end

#endif
