/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private OutputStream out;
    private OutputStream err;
    private InputStream input;

    public PumpStreamHandler(OutputStream out, OutputStream err, InputStream input) {
        this.out = out;
        this.err = err;
        this.input = input;
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, null);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public void setProcessOutputStream(InputStream is) {
        this.createProcessOutputPump(is, this.out);
    }

    public void setProcessErrorStream(InputStream is) {
        if (this.err != null) {
            this.createProcessErrorPump(is, this.err);
        }
    }

    public void setProcessInputStream(OutputStream os) {
        if (this.input != null) {
            this.inputThread = this.createPump(this.input, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException e) {}
        }
    }

    public void start() {
        this.outputThread.start();
        this.errorThread.start();
        if (this.inputThread != null) {
            this.inputThread.start();
        }
    }

    public void stop() {
        try {
            this.outputThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.errorThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.inputThread != null) {
            try {
                this.inputThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.err.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {}
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, false);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        Thread result = new Thread(new StreamPumper(is, os, closeWhenExhausted));
        result.setDaemon(true);
        return result;
    }
}

