/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * AvailableProvidersPanel.java
 *
 * Created on 10.4.2009, 12:12:45
 */

package org.netbeans.modules.server.ui.wizard;

import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;

/**
 *
 * @author Jaroslav Tulach <jtulach@netbeans.org>
 */
final class AvailableProvidersPanel extends javax.swing.JPanel {

    /** Creates new form AvailableProvidersPanel */
    public AvailableProvidersPanel(JRadioButton[] arr) {
        initComponents();

        radioPanel.removeAll();
        for (JRadioButton b : arr) {
            radioGroup.add(b);
            radioPanel.add(b);
        }
        arr[0].setSelected(true);
    }

    public JRadioButton getSelected() {
        Enumeration<AbstractButton> en = radioGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton b = en.nextElement();
            if (b.isSelected()) {
                return (JRadioButton)b;
            }
        }
        throw new IllegalStateException();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        radioGroup = new javax.swing.ButtonGroup();
        radioPanel = new javax.swing.JPanel();
        jRadioButton2 = new javax.swing.JRadioButton();
        jRadioButton3 = new javax.swing.JRadioButton();
        msgPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        radioPanel.setLayout(new java.awt.GridLayout(0, 1));

        radioGroup.add(jRadioButton2);
        jRadioButton2.setText(org.openide.util.NbBundle.getBundle(AvailableProvidersPanel.class).getString("AvailableProvidersPanel.jRadioButton2.text")); // NOI18N
        radioPanel.add(jRadioButton2);

        radioGroup.add(jRadioButton3);
        jRadioButton3.setText(org.openide.util.NbBundle.getBundle(AvailableProvidersPanel.class).getString("AvailableProvidersPanel.jRadioButton3.text")); // NOI18N
        radioPanel.add(jRadioButton3);

        jLabel1.setText(org.openide.util.NbBundle.getBundle(AvailableProvidersPanel.class).getString("MSG_AvailableProviders")); // NOI18N

        javax.swing.GroupLayout msgPanelLayout = new javax.swing.GroupLayout(msgPanel);
        msgPanel.setLayout(msgPanelLayout);
        msgPanelLayout.setHorizontalGroup(
            msgPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(msgPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 402, Short.MAX_VALUE)
                .addContainerGap())
        );
        msgPanelLayout.setVerticalGroup(
            msgPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 99, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(msgPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addComponent(radioPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 402, Short.MAX_VALUE)
                .addGap(12, 12, 12))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(msgPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(radioPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JPanel msgPanel;
    private javax.swing.ButtonGroup radioGroup;
    private javax.swing.JPanel radioPanel;
    // End of variables declaration//GEN-END:variables

}
