/* ----- decode/953xint32, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_953xint32_checksums[] = {
  "dec92f9468ece28ae286a8fa5b70bd260b013e54adb1884e6cd1b8cd4126c0c5",
  "d816216b0110cf74ad08705d85d438f5897a52e214ecac53b0c97fd668b37e62",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_953xint32_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_953xint32_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_953xint32_ITEMBYTES

static void *storage_decode_953xint32_x;
static unsigned char *test_decode_953xint32_x;
static void *storage_decode_953xint32_s;
static unsigned char *test_decode_953xint32_s;
static void *storage_decode_953xint32_x2;
static unsigned char *test_decode_953xint32_x2;
static void *storage_decode_953xint32_s2;
static unsigned char *test_decode_953xint32_s2;

#define precomputed_decode_953xint32_NUM 4

static const uint32_t precomputed_decode_953xint32_x[precomputed_decode_953xint32_NUM][crypto_decode_ITEMS] = {
  {1456995461,1340972072,3919255183,3785298700,1523377295,3749121381,1921130231,1117791448,296662880,2965803740,1471364253,935319319,1176704741,3889096077,797035748,2126449180,2197492254,4113203826,2935347782,3022566797,1431877299,2596923591,4231922237,139395702,1887136997,4035564249,912087476,3466595441,1216200984,3615216623,1924949365,1296445665,1927089532,3089851467,2445005725,1370736804,3196462247,2203499950,2779771071,2299271783,1146734855,1403388466,3715622659,3913706804,1825292364,3298489980,907935097,4009156823,2019319066,4221493814,4219758555,3037231093,1732558237,3791965186,3314074832,495394136,1359694697,3107332455,2383459170,139093707,3463061511,102784113,125860403,3090821822,2487066104,249423520,2028135322,2909320922,2715528605,633156926,2888322626,4231250382,604615499,3811320478,1304292638,1780106483,2329224615,1943822388,3893965396,3614683523,824038250,3335940803,2720530750,735876340,1079056484,3627323472,3665266322,1632621891,1256691872,2365724866,3522703630,4053266713,3340646831,1028860728,2222108106,1926732565,622873266,3000600123,3648097405,2453347274,1630572469,1598210275,1295976066,666899537,3181380977,1449530893,2468340089,1587093068,3601789025,2028234181,1877572073,1677805033,3183059819,170358309,3637203303,2536602623,882517155,856339761,4008777349,2026511396,3738707655,3380586939,155363756,535276530,2959633612,1482875033,1585880003,2700581824,344891405,1757777226,3819860400,38358882,3831038059,2093024247,3803896739,491673212,314601537,749770020,2635269620,2971665871,601395373,2848016093,1779281478,2712505423,2183229253,181773293,970902312,873808429,1413196837,3192190030,3633388038,544055124,989570544,340278975,4141389309,3581458711,1405677724,396716023,3200199736,1983471109,1919898038,1959880827,2445752085,4193818025,1655547665,2777455144,3964279689,115834436,1608394456,3926167030,709599503,1143123848,3587665490,3332624444,3550167109,3258385793,3272531896,958124353,1394863038,4267347157,3157082715,2219640077,1655870989,1274993502,357918104,1792298613,3042069443,1386962292,441147455,3808673946,1561258419,1087869065,1094464035,762848897,1256343857,3950296961,4188513193,891898738,1685191190,3456042443,2064728251,270840520,331222365,2819872309,311218347,2743926166,4231955730,3906483950,475232982,1826921191,1193560407,2213591718,1706941211,209221845,2250269133,1284715479,2424746096,138760979,568921523,2862771617,4060402329,3056704259,3363209664,312845276,808547384,4196059743,1494671916,2091409973,1055823688,958076855,2934050447,866907761,783187935,2601333091,1127785862,2732701234,2654513065,1025304759,187851711,2035896844,3548573793,2934661011,1192712552,423140172,3017310290,3544594847,2362910575,2266150099,1009397250,1211509246,765106675,480677495,2891244881,522319344,711149673,242473884,91650981,370802777,3519457733,845486438,3690147192,2925255427,2375664709,1723230281,320924667,3913266665,1559557161,290078546,3199060115,1006564302,1538792614,668788050,2239616012,271486643,2449623977,1247251515,2475888231,3815185679,1026288903,933110432,2062246567,3534966975,2256814957,3742767605,398829861,3380751930,3189552997,564491807,3009006836,782745589,4291660355,164031380,1090602857,1825087422,1843326433,2895892149,3569586930,3433823978,380575794,1678683606,4224266426,1068905869,535151662,3539211175,889397878,2976543349,2688446354,3229114061,502070530,1184378208,3967306178,3730858226,3644135575,2073181689,1573209791,467814184,4199012543,3220432568,2945334142,2591092954,273569569,1870206185,4153287158,4002244982,3369905886,3070007312,2286004977,4175864923,1841420875,3720859202,3095036922,1522727848,2924702566,782719679,3595466923,1110337587,3685671246,1398841181,2366331715,1564859249,422900852,2488656836,2835074294,871879764,3762512732,586697582,2437400933,2969094008,3413058152,3032270980,3154953291,878949497,2751175265,2061592164,1126168474,2938522567,3120765835,4239881052,3004893577,984344437,2274233682,3570202607,3665040005,597705528,3321550014,2550083218,65352227,1809128084,286567191,3892377622,3420048790,2787679041,2072842689,2077746442,1119403315,3197925954,4186054979,2355601772,3141290258,394448489,2745425519,2455495256,2425625756,3715078385,4079137347,3523020134,2338514831,3264298208,798182772,770566103,3435131533,2245188958,2606676619,2836925048,974289339,3329349698,2992917858,3232554408,2434340698,2578729982,3842196287,1525693435,4193737187,610217182,1608067866,2459772164,1322037518,1786330467,3099382099,2811979739,2339235299,4044342948,4168402090,4103792601,4118572756,1960055566,2506975078,278529626,862981162,2673207084,237649890,986060868,1574630303,3973729995,1066736714,3971214758,3369816756,2533421499,358226740,1262673124,1018159599,54660313,958461467,283188146,706662637,3655623332,3489374703,4005530629,84035291,877081903,1095408018,608892426,645534091,3901835702,3043935557,950247532,3413198066,2576093297,2673023723,1993300112,1193689208,1362636651,1157582210,959159460,1209146443,1631202130,1913590671,1048954674,3080461070,1745172113,784017855,4065596821,2214977679,3557225882,3392544293,4010503591,2142348940,2260047569,563609982,1346072818,3814129935,3019811432,3263210416,3415271337,956188496,1879280737,19427223,3114269686,2855413085,340083541,3820287809,507773065,2495614304,2779441666,3476321475,3118724303,2413657659,772216033,1825287450,1948766268,3896369332,2565684548,2130462971,4076059366,439408303,602330997,440494865,3329184755,3998271867,75533758,456614815,140986607,2985600029,249762928,2031391133,1887334819,1734069340,1465435257,3542572433,725661075,742256820,2985616031,468011095,3585860694,1129008312,3153934081,387652466,1114013997,2593760657,166174628,697884369,1002354621,2636024751,817885483,1982400856,20432449,745917947,360334288,2451713889,1761331027,1010974387,1970987709,1557958423,3405627614,114262536,1989330192,3341778472,283728159,1928586616,1547977286,4051523656,3237596723,103996114,2456082446,585783054,3266833250,1703759001,2361630906,1708081296,3150673008,741202789,3326783096,1421492223,2606569589,191647487,1037755532,1294832426,163519293,2811842416,2745740838,4257819515,1372733809,2961687927,2982566339,1108741754,814866674,1004496872,1936224979,2695490407,2224207245,626878865,3655626343,724647948,1639178056,1595562078,1561538184,2105110966,885881184,3651220904,218049896,105423901,551017649,1551437028,266770949,783995941,3472310734,3085427609,1969199533,1077648810,3311817071,4061404455,3232732861,3838737175,2350110699,2399095976,2174810326,2885466501,275779466,4089085604,2565553602,1140860300,1888773509,2129162863,1331494846,614434436,3917941114,4173262293,284513249,4216497903,4198055866,1001531642,2655396017,603874089,1357404209,2318232030,1832079344,3223787567,2911267667,4265115400,4254878291,3110504042,4220954867,1652078988,415581449,3651188211,702884966,1697242942,651626497,2114911775,83273752,747350143,3981125610,3298298359,89966995,300627556,2851315842,936517421,336090077,3882699650,622442378,3191100206,3090558576,4019475139,133767243,2498340609,1310204029,2881503654,2679299163,1469130438,94976361,821468126,1520695530,566694797,254375743,4021120093,1569253993,846809148,1401680859,417035938,658645791,3757589532,1347945731,150675668,3685169889,2796838564,1917073841,1751406953,3099368720,1371941609,1511022985,1762591978,1732695055,4094324059,3904253003,3150671696,1261708011,909648865,4115880787,728078415,3396079124,3243904120,1166485097,1894667900,273044624,3180560979,879402651,4282727089,1683271184,3457180030,2665137395,909833139,2104873010,2800097681,316766834,3909608474,2294255547,1698816304,3533438409,4261975609,3649607445,1310980838,2968124639,257007309,4109660322,429351024,593852953,2885171629,688664788,3444999118,3385374997,2977958185,3567849830,1424695274,2103278964,1422872979,3240386365,2820665431,1339640296,2939845546,3828751405,616183912,945792166,227147754,2782884263,3280299670,565150334,4226745823,4151126965,2035008625,2984732437,3366416448,3978489785,3329484651,3257512331,2179238584,2740014596,2077115319,2126351157,3454530908,1059297620,47464803,1038011414,1473898067,3820710617,3755518719,2092270271,2507251505,396549802,3436574691,3042628196,1488070764,2913917352,3548255740,1446085509,2912356456,2236642920,452543343,2551169498,3948317984,1885259820,749196700,3317537753,3793742422,2881529100,1487366770,3132378714,412992700,3981130915,390884413,3075161464,2600652995,980197953,1882579272,1856253287,2829410164,3128434236,2962122622,838787973,954756688,2696529475,1499804583,3904557277,1814489418,1938086509,676537446,3530486085,717043919,1976849843,2599862413,3588813461,122337642,1836686232,1672681348,4067005455,4205317792,3923923732,3216683848,3927157876,3388430806,2006943675,3304645219,1821433388,2581701314,3649150914,3130572268,2851914442,3946675332,319173908,1550698314,903853487,1140485423,2735132479,840259157,1361588974,436652830,839980417,277839597,1117921693,706045882,574064985,1075830811,144806556,330255536,3004428089,70141066,2027995012,131813635,202183326,4147136118,3680958,2390182351,3190288359,3250600625,979792428,1861591326,2220690834,3283216600,3829097804,3599332117,669585205,3077794646,415721446,888082342,1274452597,2828278079,407476393,1517418333,3232372483,2144698693,2185966862,1122114610,2700220128,2476530138,2418503872,1679382167,3761023257,3237668356,252273991,2465025873,3292459089,3058771784,1260750079,434824923,874739549,664727311,1479849954,2664799827,2222574002,3915248967,471384673,2797261366,3710338423,3365269369,1247791560,4115011500,1166356960,729517613,3070832621,1102653474,3875106935,137133132,3319304022,3570737791,371257911,3235121223,84293999,1395366583,1938165170,230859248,893052048,1961425657,2375315328,1694231758,2036319714,940573020,1495317177,2010517248,1819080569,4243421719,397349029,658999064,1262903860,3422358908,3132580550,720371820,3194092862,406126615,3529007381,3250748212,719119912,3300206663,282323142,559195183,218676954,1761687226,107319750,4087344618,2855313785,1286265197,2597221200,1837262935,3125640186,3441877665,1933911117,2828009616,3146372720,2282126925,227505126,3497043954,494477148,1930801369,2550363858,1485029234,194214971,614140368,1998250267,1021863650,1876474952,2004508154,225514809,2126396518,3979417307,4051488652,1263675152,3948968512,3945677579,618036380,2451968370,4123737507,2175931922,1093385107,2122425899,1213440311},
  {3800765481,2104822292,1972711164,3311991195,477665423,3834514814,628310476,2210088553,3470077894,1691713343,3841465728,525428011,856443446,429417027,2048349472,3657841551,2494392483,2705311109,2366683455,3164774403,1404031127,3285302148,33845462,1708311519,1941948362,157203248,430984777,3088471993,3598677699,1272768470,1982103778,2464890065,1699262411,3372495066,337221420,1183310731,2420255997,2589758853,2213254972,1464328327,3158012203,817713460,1077953504,746519166,2331211383,2535353591,428375466,2172575465,3654483017,964200375,907374929,1155661049,1120914766,680708204,2027985281,1267963745,3749714545,2736614816,1395891136,3534979883,1216194244,107939042,3763455937,2998712398,3296125697,141973476,3103197931,674718478,478945712,4091553485,970906306,1350432430,3573619525,3110252574,2919747117,80584867,1988780609,4112839439,1373741017,260107567,3871877998,2179199125,4209246666,3323423106,1970731711,3718446827,2385765693,2416225655,3439015541,863489843,645511915,3544846042,1271529908,792230083,3896073686,1194372547,4284208688,768773272,3940959469,1611644154,3767567643,2946409848,3507005533,4732409,2238731681,1179071099,2013761145,4174185948,1049539505,1229995050,583874700,1861466370,2496133103,655585633,4076644104,2559131436,1934018655,1427523837,986029638,850656530,3630395051,4293906957,1250897058,795963740,994779959,726176299,3713897245,3036660507,2582498002,3873587639,1587204665,4289011848,1754551116,2840443302,424122037,3196516501,827053651,3767725715,2862725391,1534703138,1475753352,1341722340,2662297946,3872870493,2574206018,3825835884,3890502061,1568241824,1191884197,1892206555,3315931036,2933965585,3315826722,879677358,3537403970,2349769900,465701152,762190953,2263626943,2915076891,4106281231,2096113342,1848211274,1229989082,2308282192,2644406572,94110882,1843932526,1313813981,1533640860,3158393861,3820401123,2220804832,1960339385,2006615828,3152765363,1414737076,1665132874,163713574,1967487240,2594117886,1735708526,3108050700,2931291586,1342571822,3326581718,2250559626,2923672790,2199831426,2416691483,3698769260,1925200553,3911735869,3779009456,108687208,3368456398,4132269456,1212495336,217223177,3956505934,2464447408,494383527,2398993400,1304717617,2493852901,376042366,3100069525,1676869706,2606534480,3088315159,2349754607,2429216790,2498372891,2981944103,2073960348,172851474,2585268245,2575508978,2012420454,1067322218,3465579083,671507052,4092315641,965225513,4200154357,3898390895,4034937703,2168921843,2238490068,240354050,3908090033,281370477,1036845439,3780600075,4227719331,2380814374,2844615593,114583484,2895607329,3135319448,1703004427,1049498245,1895852621,3058403450,664907808,2857865678,3295196349,1103595278,2673952450,4004718790,2243850032,2541506500,3536529370,401604220,2358876588,3124888074,4146817992,1589347684,3810211529,2237093748,333256224,996678178,265570256,1675905124,3899975418,3598696931,3376500338,2960037598,3051363436,4059141532,2540157939,3387378465,3879063818,1340284509,3177440236,2283255282,2366739751,1605537078,4110060624,3882053982,3203754374,3211384404,2639050723,838313104,2914772797,3781342469,3875948157,4188227423,3231797596,3778424639,2767228566,2288098215,4094808156,1464054785,3136851976,3314497831,2236679226,3528588336,536081669,841622251,4147668961,1474339463,3933564581,4065566717,2819948231,1398629899,3862463096,4228584233,2833422854,1857704545,409686080,221868677,924283749,1121803536,1650376078,2641553043,632673491,2054328700,830010485,2647985218,825504792,2838457969,3262212887,3317820488,4002849930,3259642403,3757093572,1383650494,4082220412,1740115275,35481935,31358480,1182841859,4007747132,2653826681,2143245548,1684308990,3167591685,3848993829,2350286875,3702723819,610323232,36509038,2372091334,2848348531,2502779808,23293977,4082203215,3050956482,3932465774,3326878925,4126863284,169955916,3667172691,3689314315,1368979788,1872399121,522501103,1873596477,1599822759,706030222,2855692999,1986787568,4103863205,646986742,3383122294,2279354247,1845849854,2252585055,1687106408,802954541,1118013551,2727299993,1232886387,865955161,2224326058,2716244867,1007681479,708392410,3538804766,2322057079,3449840426,2832513032,618909176,2174812975,3705874673,4250689000,1640840503,982983038,1265608181,931234288,1304510577,2654698237,706923303,3283393739,3502889317,3034898412,2472806308,423647686,1715211342,3630199999,3491457060,2001964616,1851791302,3679575346,4271836501,849556059,3824839141,2294539525,3863453366,1314383071,2059398556,573682535,3801341431,3872576347,3911128960,627449608,1820930090,318052449,1756084463,4115125408,168154633,1393006666,493222483,3539669382,3833924353,1366748266,3672186918,2370998257,627825867,3944800511,756722478,1147821165,727689870,1521052032,2067003499,2323436903,2723153107,3479043648,4180885590,518008393,3751446133,3199312796,4041157323,2848819507,2954979414,3906150224,4244407928,3783369368,3675406736,3841515506,2739653781,552717235,1025661443,3854533741,1718378195,2562391229,1314860797,1749048766,134038196,2417871462,2706972877,819410676,2969012927,135613170,615789949,677949863,1687885071,178963761,2278273219,1887934300,1373813175,3923363316,2624544083,147125187,1933389856,2634935833,2604496147,4024436931,90608338,549877160,252700778,732075404,3938759442,4153188258,4120935318,374469956,3834070697,1578495831,3302254896,3781344380,352985775,3992266252,1965051338,2127358253,2640179744,3674655355,650481755,189157712,1822852962,3417805636,3074301547,3946953825,1987625952,3652032217,3784721789,236510888,1490254058,1210034970,510334099,1704267296,1862543292,3328844503,3987195338,3520029620,3370847469,1849982920,1703900569,3909985290,3575941585,1661312771,3058262451,1374242521,2957882992,1050911533,3476425593,3069769603,3223468560,4055236975,1185635372,3917033392,1074797183,3524909866,2503802039,2109912382,1168715681,1641290365,272275743,1472178944,1150800096,925689170,618411492,1494853835,2010222281,2909690266,3360312155,3005306734,3012289871,2099664941,2469373568,94780646,3678513162,3818981944,2042178902,2837533512,3728298455,3029176076,3038795330,773257670,804414385,1939440934,1810653300,2537850179,4123084918,1706378020,2468526015,1279911364,284546991,3847492854,374925431,3906151118,3848104475,3362881321,2833484079,153760497,2339549979,2307351637,3989731094,770656725,2811196434,384246054,3437165992,983216688,50413154,795644448,1022997861,3966237466,2858953161,1820916472,269422489,1913077174,1210770939,1407528813,841068448,3692902510,1914528763,2567325231,3590551061,3632105290,1878553608,727709393,3867563853,3733765200,4267079006,2105456043,97889853,171320949,909452689,3084718370,1071047848,3532920810,1318779730,1120904214,1572629275,2576835721,3303505890,1967332331,890023788,3038369639,3685441891,3745205445,1379298681,132183564,2022475396,4076255064,1535562159,2503210500,3194208216,3288956475,607042679,3086112905,2214951652,767092568,1471820569,3023283857,3890488734,2268951532,4087144200,1398958858,3897407019,3448978503,3728111699,2985627330,3569586337,3890025133,1607726788,2160525708,3567579743,4275417866,1094865885,1867301891,3782971279,1026036278,2403566154,637766282,1747146316,3942782303,242595144,2926201981,215075541,312832114,2667051066,3192918928,2739653818,2075781169,2344549947,236411534,2393178933,1115752390,3070170831,2439231241,244530012,3535666182,2334115236,1108097601,2203164620,4179099785,998989632,4283290210,293156462,4289286117,2300826059,2992133840,100444731,1214865846,2851413859,546562559,894492084,1719729608,2705872214,1769576179,2414457986,2080307436,2940878670,4098196356,4110458373,3414540605,937995486,1337646799,3926163919,127256278,4270484339,3596950935,3279145628,1057937038,335088146,3559723896,3177529052,2074895957,506370683,4176055830,2918128942,3507450388,692921026,2340633962,4193377215,948543997,1234566496,4124471530,2798639562,3264276361,198863268,50052965,2145420785,3692494714,1422993981,181725020,146875927,4090739187,1173885148,1379221761,2600302336,3930470046,99815774,2014234458,1455403422,2180528331,1337370856,444754775,4147791294,2860564546,3395740815,69363122,2412390228,3913079236,514696275,510655907,3184193707,4168296207,4234029687,3192039267,2813204328,4143705350,64840924,2407079672,3567682728,2342431862,3663329097,2052169690,2144320187,1540212895,3876102311,355924222,3151757740,2746822164,4009194902,3695322390,894361035,317240763,396679551,207293992,1862215920,3069979873,228925238,4030010479,2436155135,3691006105,244233629,444833534,3036175099,983976111,2152001847,763668854,1022493864,2591826558,918364387,1028202286,3296444974,3427425170,2377583764,2193247481,4277255026,2949883433,1658047065,2026796522,2395593106,614267625,1225126901,2340813063,3322801491,1453207582,904738429,525190745,2589421071,939308137,2326376907,3432066168,3433598105,3569539567,1159700554,1211286557,3604849986,936668460,900298140,3223583398,3323605639,642465702,63693000,2729901801,1226082967,1562604322,832631157,3400563231,1842619007,2717919287,1777857622,2829473444,2915783265,2006599285,709657415,681295683,791553360,1672742404,1405737573,269917763,3227934437,1136581548,1588480856,287869402,2710579234,533433792,1929942528,1904967478,2722182989,687321423,816897102,841730493,3330444070,4101377532,3179423648,1597253088,2031902020,2280812460,3292484407,2451459712,578913229,565675053,854975012,84895465,1741529472,239833709,1755454087,1388819376,3702442712,2533172419,3837153581,2050825739,2120304916,2599653769,1312985988,2454269473,1833353545,3656841829,721827660,2322962207,3935254687,3706219629,2130481124,2570592131,4164950822,1922075960,2662172529,418506033,4253375422,3762012439,265669556,4177505994,2313330621,1961902735,3296404393,3654745962,3181659391,1764074848,1757621707,36700082,3808280901,2061868693,3183822821,4005555697,1264841562,251499354,4107700063,2617202980,481572066,735223389,12051983,3316362152,1830218096,1365201863,3896216485,2956054317,3952117866,842383544,2929067619,2225570867,1844437183,3808271348,2529500379,1733097047,3955412363,678326762,1459982333,1013746563,3094025727,405437309,1304921924,3330822863,3096187382,1149387853,1453807918,2418552447,3511775018,1239017403,1971395742,3202298702,3632227370,2517605400,3133370195,2431004554,2974771162,1155313128,695928556,3325785879,2998308593,554282239,116589782,3293603457,1781953195,3950961850,1618268603,1043868684,3781664271,2212314716},
  {3998721891,261473506,1001189902,612414262,3065327604,3432793928,2865008640,1904786775,1053039954,1687731060,3874993442,3566799938,789291664,3195014159,3762220865,1475306327,1403103952,2273486707,1581262144,3927954773,1662017534,1288286356,107723506,882740674,2297398372,2844597932,2913801433,2627994388,2909835930,2164353591,372561881,1775508236,3010969514,3184555297,1879955791,1611819724,973609019,1497195810,2722856984,3779203167,1402972516,2414786618,3066507463,2384838605,2105242580,2777262616,1038443577,52219654,734139765,1024285707,3566394191,851758368,1314960668,4011739725,3981771672,1997640514,2172072172,1616377324,2257789276,2931938396,1140443614,435600657,3708701548,1320910583,4103630132,2589321493,1751837766,2532573992,36843703,1418199030,128771586,731498950,1912071534,4108929291,2436378070,2694158011,1705611583,1092152189,3701949792,3225094672,2091708471,2354074841,3802659120,2950433377,1317666928,413733852,1842067465,14432302,2302290419,3567893022,3888513805,508410589,2977975755,495075877,2978682599,91838980,3014624794,1822305812,1304445235,1869127893,1881278552,2818628833,1289168434,2240051118,4095037401,1794551462,1523495381,3918777876,3051173718,1855166204,981490105,2700481643,4018604594,4002684045,3897704667,931649397,2453705793,2036994091,3093263966,3224911792,1437976946,2550531202,1017798539,3386148933,3212250505,1340495406,799496601,2015981939,3593554126,3655133727,3276965868,160209147,1365180706,3571811534,1510759137,3009942340,191090166,1039651386,717020910,3661800789,1237071895,1359909207,1847332609,983856903,2873903134,2506848468,2045243943,3721431184,1970880301,2255248775,2101418225,2015930536,3285581015,3294279103,3947751815,3937260610,1818438228,1663039196,3232585137,2658059633,3389841344,3831396875,3082357613,377374961,3204028191,4203781799,1813279063,1788962676,1701620764,3008158081,885427870,2704602867,2057087301,2324089788,1073152630,510252955,1901411791,960022525,1557221096,216184822,2682246622,1481850702,4136912733,11675056,1467401190,2386203462,2526628535,954631595,334104771,2881480091,3008040176,3929799941,544968,1391373034,2258570458,2370481086,1844927168,4224928174,632668826,2719026190,2206551127,3784031094,514909466,4209184626,856078606,3574495284,2663078403,2383281668,3607225588,2950237171,3195234206,1585939913,1117996569,983850875,2143584425,3241657542,1105311154,2314770198,2676501006,1191726452,3010510917,1005665942,1931843267,4282165883,4262644260,1137800014,2023298271,4244063622,253283177,323086113,288793250,553069682,1028014588,2304536269,3591409355,67921120,2023856058,3476579437,1210817738,991295602,2191553894,4253370406,4261568187,1709666055,2892346277,61611239,3230697759,2201076595,1358679039,935153889,1922395215,562468123,3950821954,3321562505,1478904171,827737617,1862573179,2427578178,2889831197,289413512,1410339112,4066787317,2991500219,3314752519,573521328,4204193415,3322077317,458051370,1416197481,1184740653,2352022902,4232732547,1738912428,500561716,787765407,486395946,3402069589,4256602218,2753492410,2022810859,2924640064,1086402323,3952633971,3195433266,3253535989,3842748768,4260440814,3666196989,1823461691,1682803841,989066528,1966216960,3277624703,513216107,1655927832,3689291037,1313755788,92371392,3858407463,796783209,1036111329,3111021572,696089295,3689465542,1813011310,3405684317,2466197057,3562216411,806056804,2366947631,4028423184,4233028606,3297170056,958597297,406747750,2871357295,3037578646,3598162395,3131090540,618379439,620486113,2209652916,82066623,623825156,571736178,3293628090,1784654194,564604110,205473044,2681839526,360030068,3507659456,386706351,4019823307,1984825239,4186778293,1144335441,306288032,1867159791,1111042231,1543070587,3857729525,3934317972,3306016589,1604161444,3484029332,3070920684,1272975469,2374737042,1305809786,3737736002,569462245,3398209561,1166956578,1234982896,3031105415,3227568961,882141467,2055670589,2918611679,2093511417,896961966,3928740220,1757648,4026610457,2254901540,1165898504,1352290179,187362866,4156106,383759465,4208757866,1336124464,1266477011,2434060977,2251137723,255672652,3678988145,4180410658,356889732,3448287316,301733322,1407343065,899718948,3639376248,686562414,1963659686,2379059536,762879604,2030173389,4163320711,3962478957,564133905,103778337,2253378620,4167756519,1932080197,3584940676,2468743176,2439210256,2737666461,1542134096,2564295925,495114325,1534747697,2961001322,2557592262,995313554,3038207118,1437944058,758460244,3873559663,3164497855,2231550547,3655336085,3462175205,3114447943,2000260999,3567233741,412201809,3903146340,1333223098,679099502,2813014470,3377845820,3011802848,86723318,1038326912,2620658664,2334233384,2261049756,2652770820,2036152788,3513085937,2475769400,1248279031,3942899135,2683258492,1923545044,3703809391,1089832280,1900048085,3343292760,2253337339,332187252,3747719357,4123331584,4280214974,2042938431,780868709,2591364184,4226049534,809916953,2999530517,1112955919,979447334,3712068843,2138179440,3988257795,4165462896,213567247,3088514430,601393107,2905530590,4084813134,3100448965,3910869530,1314090900,2346654015,2304751538,80524326,865178694,2620360696,972245573,2313610025,276062805,3220473631,2173872993,3879640026,2783116093,2903907021,3675588174,2883472155,933157256,3593713369,903620619,3720621913,4046345309,422034234,3695910972,3747465122,2852027210,1562251528,1144722163,3290056692,2376937298,2606588340,2880858076,1765712693,15454611,4024662007,2324736698,3975408478,1792360341,1371222129,748791198,1809609083,2001550106,4235669240,290371492,363008220,4179786095,3025347537,410153445,852586944,3817290070,4136941682,3547043839,1470863673,4059443263,4041579201,104386640,1834531563,3673006180,4220529780,4263921412,1889914158,601984417,1372362517,3930671872,2450030924,1401291538,2823498285,3414205253,3908802482,2282022617,3848669451,717811342,2353189157,233135465,103867468,2352988595,2909349749,1962951227,1107169637,1432173207,620232167,3818385115,940918328,1644609695,2430116585,3582894470,1923378421,2391908645,124123938,714970549,4255392606,3051426327,390274722,2438923266,3164139577,2242347696,3028675305,3298590446,3906342732,1448937640,4252771076,2537862398,2809238200,4240535036,3531256977,896920339,4176923534,987099947,4287976002,518725387,3232158075,1850040166,4291609578,1078672830,1162051740,2989439890,2630105268,1260158713,3902937877,2504144362,1946817116,3089038191,328356866,617352829,2059305020,1443417557,3484573984,4101941829,4197324997,2869610313,2252330510,907633133,3183140359,1391642824,733803175,1922790177,695033213,2605915264,789505763,2627998272,3533749320,660053712,3666349303,1949663823,2170538352,656961950,3988040529,4197820636,1673880873,3097120031,2528721884,20390284,3518793778,3742704986,1236629938,1789054203,2094644000,1935407990,575913557,1204993065,569726227,672699856,1267718785,4053259461,3155099844,3054328832,127239037,3767838472,1474984686,3979670143,4218717572,2499033997,3973218358,2176748634,3617419990,1039910373,3749774621,3178443967,3321324851,1034620525,424071054,2964075200,4251596951,1849156037,790811820,2885583760,1191332820,2801051704,4246037889,744006283,2139783184,2126670643,3508597835,702828779,3438601553,3043284123,3690252143,25188825,493009190,3335718864,2266910155,2061328125,3071519311,2638044642,3892913595,2614064401,296283348,4172231588,3318244120,2463098934,905505717,3268068543,2381178307,1483176789,2012266910,1538384035,1387942136,567560669,2737269189,1888202422,553951201,2154735170,3092440758,3254209489,2600615516,3968596066,4087365199,3899339322,1440527359,3270343896,3082767079,4119047580,36589537,1699015509,4178621454,845781863,315168812,527292793,3639765674,898496036,1314745493,2581297186,2464456631,3109358064,93015905,1773177953,2733108095,3535249986,1148269927,2196229456,125725439,2423372839,1624927027,1823038900,2334434843,24468490,2628413434,2013344554,692904275,956568501,3519218229,3061959736,4237480579,2522237808,1912305322,1039313952,748268179,1532194364,2269143268,210871162,2476468129,2464589069,3698153005,1308762311,3985756221,1850518335,3616336376,2179820358,3360212252,3997341338,1354904181,899166516,3165675382,782044827,2273506362,2102221386,3917530953,359214577,60836023,3700330817,4188128948,3783161646,3262566030,2874860193,17134999,412690228,4229073489,3402728698,1283437732,1537209646,1146657717,1009986372,2891654148,2319372533,1477799193,2414911425,1997357918,4057707501,3335053305,230545354,2272084451,508800835,4206726634,1758423158,565995664,2988103096,2939909047,4246183927,3813578359,3694647685,623196665,676366217,306209255,3746468829,999963767,1283059178,1374407146,1110399974,1411518690,145174818,257999192,1349719189,3805810622,765427992,3278929117,1567419925,2942151521,1866043527,3723214032,2395661970,3846688207,878556338,2905511805,2981769274,3973022295,663040588,959468082,4131867574,2697396096,1159571956,1660618954,4029354614,212424098,3339358536,1619635168,3922142335,4138647720,2864342036,1112279242,217576109,1607127019,4206940958,2990049423,3893262889,372442069,581764553,1643953641,2962146201,4253529262,1936562532,984338095,130166038,763178493,3130982482,3508313813,1566033375,2272810879,3698699643,460496014,472823634,3411822711,538912170,3179390445,13761627,3817139234,3772845490,193420095,3227831050,2576458837,3795809480,444605404,2076357681,2395098522,683595870,4062140569,2734264429,2378760145,4123198582,4266448493,3618770539,837774345,887153916,976099684,1678067132,2260399460,3404368918,424687018,1718589146,3892246565,3787034123,3065349973,2888948252,3463208025,2581114678,4104485161,4023395690,3018664126,3305501777,2518501818,181281961,2932615099,2621024890,376811993,4144537202,894462377,2597146541,2778528874,2129009501,1354075684,2509946417,2874157383,2289220214,725675704,2433343540,4097832362,1771366788,784982230,173637733,2477640123,4156762611,2194544176,2937524071,704795476,417440611,437554445,88646822,2745700912,771840702,1317003949,1029078315,515897759,176525710,3987782391,3632243703,1855826382,4276295381,7874842,2841778207,3640668114,2558711014,3593784321,2829404276,1489805387,3135623329,4154177261,3221666753,1882387625,3438844507,141858140,2133643826,57787512,3336116117,4186331000,3662401780,7383330,1035598836,3962393821,3138824918,4067360196,3050120625,2273923570,2123292175,1678567123,499053224,283665434,3610750193,1424196139},
  {2006720584,3275864680,2943273920,681842044,2396696574,1583711613,1632044851,94161397,269856992,2996498300,2032987490,1766621356,633105450,2219212403,1270462032,3136656509,702239130,3749274641,1872865811,913094155,3277200679,2052539884,3076478393,40377753,784645552,1904132170,1936332969,2064035904,3244558649,2857117627,3181006975,1628477959,2095203085,2961995509,3118349149,1570432661,2664238682,1239849990,4162314545,3958964517,188719664,48424876,613545554,1360286251,1367919479,688726707,3046597537,3670877999,1151056329,23596881,2759500394,368272310,684795353,2246919924,430256505,3926035324,1372068296,1936672805,3420957575,3035998730,4252816115,2095210892,527053288,902041106,3099062373,3748587518,3132813458,4117838508,886294277,441073748,3089213071,1158939902,3814883967,1058908486,2667462661,514535663,2375563771,2790485992,1829010763,31682784,2637964520,2693394765,63944809,1405669382,646212606,2828544308,1472197160,480984325,2218089182,3032956646,3216794298,1987292648,2711789547,680107441,2292656633,1685347816,3387401042,4115210575,4240029432,1890517388,4230921898,2003667238,327488245,2801759016,3815068250,376155944,2939962025,243871762,2547473676,2384282529,3808982767,4124124324,3929728486,2335090424,2567264782,1578171801,847600910,2362937599,1199062114,2798111406,2677235312,1985607360,1279277202,2386221220,2073326308,2851339178,335489952,2362726302,2765585442,3922772350,144189007,1154981494,3587319461,98059100,406948092,3466474629,1278035776,774792122,1360779519,209832785,310114636,1914179472,840802851,3517472873,4244699973,226454260,2320324746,2351224998,3555395070,3135269387,4011874447,3005884499,1845389038,1666602080,3233315596,554982760,4032666543,1825004446,3838212426,1620118583,3839772883,641859682,1544162802,2073931654,945018313,263345324,826588412,644965550,4245142393,1863748949,1616223632,1395010602,2647268606,3241522360,4001822398,4109121234,3045485335,3288314011,1613804261,1861861882,2410050702,156146051,1080177640,3576670048,3527254803,1830879750,1322994156,2549572036,3274541093,2848113058,3991941730,688272192,347881356,287228287,1784459748,4129508806,2665238533,1773340177,452673343,2480787439,273269429,1733954553,359371320,3627644758,2411231301,544663154,78969533,2434022253,782817896,1629577313,3825329257,378659812,397932853,2112931677,2893799842,2035169743,1522440549,4240049380,3078336242,43741877,3830844256,4133801598,3512106737,4050031171,1012504323,3406497545,3732852091,2859885225,3214018966,3995317168,1809240122,2398741187,1694742605,1400333973,2789625942,1256831003,2403844582,4125018864,3261528404,183758335,1715067394,3518861690,521316523,3273111691,540730442,2480019304,1508444278,4126506141,1135318119,1737996736,1041920598,1261364450,2369977278,1259764846,2037100731,1727739930,2358213477,93640863,3484157505,1560775394,2767675682,1640408817,99923676,2263467697,2102610102,733533479,2566288178,133210248,3636798502,3981585742,2835558417,395522043,2641587621,1719753159,2120086460,2256797533,1355046459,397394513,455573819,4145608702,2128219438,3021203389,3120108285,2244731798,1813309709,2801478304,2813290680,1122428760,1022919270,3264465493,4007355670,3348469835,1841009271,3982044909,1071413443,298529992,2643833091,1649111725,2431090083,926474051,2921426987,2234064461,1882761060,1557091641,250523233,1350719840,2583227821,941567052,1852896248,2189983713,759783335,2635666323,2486855431,1074652093,2156352860,3764463666,446283773,1237363560,1963889400,3230360769,310138212,3484967119,4137761831,1041979975,631973349,1085734891,3415590388,1746620725,2270861546,1366225915,3209003159,76873785,3006663638,3003434520,798544495,3944192429,3682233390,439070284,1105387584,2561059041,3211622241,3492007457,335116254,1821192566,197499370,2461878156,263070546,884457713,1526771377,200321892,2270877561,662170810,1607721771,2104652696,1772955408,1876210382,2819478849,2073909708,1701480161,3508642155,2471804218,3928130306,1425798356,405322937,304575757,1405785866,1305507546,3167949844,1093164875,1734031669,1097415174,3220655285,3191337917,2584862190,3889579785,2913214300,1121192499,2744850823,3846091693,595494013,1322523016,2535715598,2119631414,455580807,2674307330,1528805792,3371733750,5633310,3455333260,2034277444,1342125283,1423347513,652879082,3697232965,4215407803,138694056,4003656789,1389467478,1892649665,172464590,3360654270,3982765523,1181994740,2144621627,1890356717,243084933,2422859263,3174132769,1564239755,1711508584,1335710886,3911854915,1266893972,4020395946,3710628856,1663292358,3927467634,1440383395,2593379504,3954512257,2999120471,2720061363,4209831403,3402247689,3048562576,3120689388,4173415937,178455803,3746764911,1690354790,790924706,2952048395,2124425827,2198673971,278711430,2685618863,139008393,1202591245,3821064689,3922221290,2444129646,2123419764,543430138,1826709396,2026218326,3463204852,4120573083,10222413,112655964,3581100701,3774814987,3884383074,1863919587,1769689549,3236010848,2701889200,2014503034,2331455068,2017959624,2811128622,3761463015,242609073,3701070724,4069749337,2100371922,3964768890,2090351073,3687464941,382913096,2276332349,3358174456,894929774,3589489472,869759303,3487066733,438919667,3788804159,3707462390,1723532059,3172645452,2377290357,3264101792,808983695,4117024054,4132385694,1959714632,2265883377,3204615594,2013653728,4227996604,572083046,3744870425,3267216298,1738114226,1216392526,1053524973,3604919943,3340149648,3417768939,3721629502,424336859,2478748993,887784685,1672192617,832977291,3710927483,982587665,1191220689,659543524,669300414,3811192075,4154726246,2671131729,1961233605,1820370275,1531818538,1715339014,932422391,4171925754,3008000953,4285287277,226567095,1157932467,1439824783,3740105776,2820030045,1906711855,253858865,2618325181,1454585025,2477416149,3991831636,3850787568,220882703,3009918122,4239819347,3591717240,1493402350,1482075112,2782396904,2887038551,137109270,1923495203,3882749720,561256637,1243879831,3493756684,1310081471,2028199097,3509094385,3860736612,985847568,3542399630,385271151,3781018514,1536000626,122014706,1766539405,2289542165,1591075388,3886773332,799521394,2650277,362704044,3086014059,1031448255,2571581875,3414978468,4084971900,2048633684,2106431847,2217336510,2661254975,2764018658,427175087,105352352,193826873,1867426078,267032182,671824341,698114104,1097354581,762342888,534400243,101891434,1683344659,911593815,4013658379,1871555641,3740033419,269647663,369811181,2414612916,776791219,2118011963,1772246194,2160244686,4101097934,1124488701,4125147606,3597383113,3866782920,2767121017,2224757888,2743716947,2658858862,2799031380,1887815329,776845965,3789872128,928712402,228701352,1211688741,621159604,2153616377,3717605558,3836899899,1495157062,3873729591,1594175901,3338685545,3309809788,781156213,1336126928,1866518586,3110996058,1155198550,3416484677,97287125,4023883495,12113086,81637234,2311199879,3842161753,1120945825,976358302,397605844,1410707452,2265347573,3567293687,1205584765,1037933729,1872398824,892744664,2014617224,2438456152,3455781729,2487873313,1754332588,1663593016,1597648832,2104871679,1063020296,1920564293,3542504056,1240921289,1744867492,3462337334,2313268390,3986400624,4280029581,368096917,2167158692,3422108463,1405089024,219114238,1869201593,1619595595,3196209893,2609215758,1603733881,1798459256,1473835126,2621667508,1182907355,3503251412,4011994009,2782841097,1165531681,1771912853,1350625913,1666280316,177299816,1044107306,438022487,3009404743,55279866,1745215105,597834134,690054454,4102321181,2968185387,1601627646,727602310,2101197765,3864430615,2641610802,1145292275,3508810427,1237722549,1691314579,1495228504,3078810324,1686697944,1767446032,2990625496,1753196667,2247215482,1700746662,1185453962,2984983598,3655058312,1422578057,2339534273,1978194280,3183197001,1166946292,1041406975,417598422,1768121061,606722228,3584293089,3544080316,3183142659,1826454411,3196623397,1704265734,133284363,3580317910,960641132,1693093531,193871131,3316934036,691254467,1734046289,3149346696,2606969439,212698927,1290637750,1410534512,3003168519,13748356,856866216,2570774131,989423725,3219046313,3412732359,1926664174,3844940772,957718829,3627877683,3106867648,2936797534,3046820966,1863322183,473737609,4285998448,738840064,2967289028,616477974,3950359850,1721993608,2366094350,4293128307,3927913509,3235130971,275599099,2192421886,1436561669,250365971,2175176224,2412396521,3291222015,2906810930,768492929,51148427,1595753094,109850442,1507665155,4130945353,1659317245,4264031449,3629441437,3676035936,2303086791,2001792800,3385560090,4276658243,3828243122,3119894267,3686495659,404131502,2944437561,2764730047,2585888871,1401252583,4189273516,1192973104,3513185643,2628957428,2513301877,4008950039,3139670770,3083340392,2338453760,2753895521,4081351765,661807713,3261515114,1096131703,3863554421,3783797551,4240539469,3309467958,3452717580,4262390516,1282519311,3065613687,4001353756,744775697,2019967497,1552720598,963529300,934018063,1757231394,1222294743,2750042335,218147545,1678033941,2407362700,1801700268,2279805328,2568436442,2942914734,1078059857,3901521770,888423141,699867687,831448810,2204166662,3722179548,16291258,3391097693,2238889055,1406403915,3829894237,2166003334,1126602772,2177460833,1808845887,3785626059,537024756,1176360985,3216813700,849290953,3844443905,2703962327,2898211828,1317064801,3894648570,3399136019,3329462722,1137345738,4220332432,2005880396,902361600,2108431297,1518479234,681441429,1431056345,1594271152,40874356,742589635,3343621921,2290986259,3578334019,3322022464,4101903631,2436176288,185946666,2374720358,3921314410,2726157418,4184585745,4000423895,3546339190,2308192088,3149600414,3464402834,1419050373,360456161,1196347548,3846509121,3052579735,3126592140,29438943,2859409587,4138480607,563255186,3956632549,3835938018,2829365723,2553449492,2121105586,291913834,3200588783,3502747252,3777424423,894406310,2513415545,473282970,260457270,3368237318,6192649,2982835529,2127026540,2993716328,1221715622,2089624162,593260063,1751443295,737729971,1692343000,2446899318,1630744629,3504839623,494263462,2481798059,2925721502,874593085,1030394755,4210150343,3530569558,2840168223,581103657,3024175208,1108441929,3787825481,3265324281,2626366360,1857535788,2070328543,3522410732,2194933756,4275286427,4145609378,3942083235,4151897303,2061629071,3865265683,2449024803,1985723306,2607949325},
} ;

static const unsigned char precomputed_decode_953xint32_s[precomputed_decode_953xint32_NUM][crypto_decode_STRBYTES] = {
  {133,252,215,86,40,156,237,79,143,22,155,233,12,19,159,225,143,228,204,90,101,13,119,223,247,30,130,114,216,36,160,66,96,183,174,17,220,146,198,176,157,60,179,87,23,215,191,55,229,22,35,70,141,229,206,231,228,204,129,47,28,10,191,126,30,18,251,130,114,130,42,245,70,218,245,174,141,181,40,180,179,182,88,85,199,232,201,154,61,2,62,252,118,2,79,8,229,108,123,112,217,210,137,240,180,89,93,54,113,12,160,206,24,193,125,72,239,211,123,215,117,101,188,114,225,48,70,77,124,13,221,114,75,100,43,184,157,211,187,145,164,200,179,81,167,36,134,190,174,189,86,131,191,240,175,165,103,26,12,137,7,201,89,68,50,2,166,83,3,231,119,221,52,109,70,233,76,192,203,108,124,246,154,196,121,253,29,54,215,224,246,238,26,93,92,120,54,226,158,251,219,103,132,251,245,119,8,181,157,189,68,103,2,204,4,226,208,196,136,197,88,29,135,29,105,75,11,81,103,33,54,185,98,179,16,142,203,102,74,8,7,32,106,206,113,92,32,6,51,122,128,7,190,50,58,184,248,157,61,148,160,230,221,14,154,227,226,120,218,182,104,173,157,173,219,161,62,53,189,37,66,78,40,172,206,193,51,252,75,179,9,36,158,34,44,227,30,237,189,77,243,68,26,106,167,37,213,138,52,96,220,115,84,50,25,232,131,177,115,215,106,211,29,49,195,106,214,198,62,1,40,162,244,148,220,43,100,24,81,64,80,144,52,216,146,134,119,218,67,213,79,97,160,152,231,74,194,24,2,141,14,49,248,209,25,241,151,241,175,57,30,199,56,43,83,61,202,173,114,132,21,155,215,114,178,74,32,37,59,134,217,178,125,140,113,217,202,27,59,146,181,143,48,97,227,192,66,95,130,6,63,77,81,20,192,39,113,5,160,189,13,22,102,86,121,225,31,147,76,30,153,94,97,240,174,214,197,101,228,120,233,121,233,111,233,69,1,100,107,163,185,189,37,118,39,10,103,81,203,216,255,123,49,151,163,36,154,52,49,181,10,51,133,22,241,238,36,28,202,120,199,38,216,222,187,169,127,201,172,169,66,9,242,171,231,31,204,108,104,176,153,224,98,88,195,155,134,94,192,155,247,160,13,160,142,20,74,141,197,104,176,113,174,227,98,79,73,2,107,0,89,228,247,3,193,124,163,219,186,226,124,86,78,29,65,112,192,18,36,149,176,44,244,5,19,157,207,5,32,177,173,144,216,35,221,70,193,169,70,174,13,106,79,140,173,161,69,111,33,130,237,163,213,10,40,203,222,57,45,66,21,52,37,172,59,84,78,244,68,190,6,26,145,216,84,159,109,32,240,165,251,58,191,62,72,20,253,149,216,246,23,185,120,213,156,240,200,83,247,103,165,23,56,44,191,190,5,94,57,118,182,81,111,114,123,104,209,116,21,55,199,145,169,149,248,249,17,167,173,98,40,154,140,165,137,27,74,236,68,126,231,6,216,38,222,95,246,141,4,234,15,161,75,42,136,175,34,68,82,110,215,213,60,208,163,198,69,64,155,211,129,5,55,194,184,223,14,195,65,209,27,57,190,235,35,83,213,140,90,254,91,66,45,188,13,5,77,132,13,150,178,98,94,219,254,75,152,101,85,21,117,78,212,106,195,75,82,181,116,93,171,82,63,96,75,26,154,192,3,227,179,233,14,93,137,144,215,64,35,50,60,65,129,38,120,45,49,73,226,74,129,191,116,235,169,163,167,249,114,75,41,53,22,250,113,100,203,5,255,205,187,64,17,123,200,178,36,16,93,13,190,19,53,214,19,168,171,208,140,18,150,253,140,163,18,133,62,252,238,54,216,232,214,122,83,28,231,154,228,108,87,73,36,71,166,186,240,131,27,219,189,101,213,120,120,12,205,97,32,134,215,51,147,76,112,176,134,144,19,83,69,8,179,13,233,33,161,109,162,170,153,210,4,242,3,155,49,182,192,129,118,200,220,163,165,18,56,116,49,48,95,202,26,250,44,226,22,89,53,98,168,124,72,151,238,62,183,23,27,57,143,14,226,174,113,246,171,51,223,127,174,46,99,49,13,155,134,165,56,67,50,182,225,162,169,167,56,158,183,232,28,61,191,99,50,11,12,82,89,121,97,240,130,211,147,95,235,174,104,89,23,71,76,155,56,25,82,128,216,179,159,57,70,211,111,39,215,140,211,180,18,135,2,46,42,60,254,41,54,72,243,153,154,45,119,142,166,28,81,229,84,172,240,245,33,31,105,72,99,42,156,219,115,14,165,123,118,5,89,0,26,22,197,169,198,209,102,25,101,50,120,45,243,219,3,219,91,174,69,196,153,141,73,104,182,102,251,235,32,19,233,181,63,233,41,244,244,92,82,63,74,17,147,200,173,190,206,243,254,59,166,28,184,91,82,229,220,39,12,212,125,133,179,142,46,16,169,75,2,146,59,140,87,74,103,14,147,147,15,29,103,227,7,237,43,61,160,34,158,55,167,98,235,122,191,80,179,210,109,67,132,134,245,25,22,223,37,169,197,23,58,46,130,201,101,183,28,190,31,118,165,33,244,204,89,179,245,191,167,46,67,138,205,255,148,235,198,9,105,71,1,65,190,159,200,108,225,237,222,109,181,206,155,172,242,146,195,212,234,254,171,204,50,32,175,22,214,173,14,100,186,48,201,251,141,53,182,63,46,196,229,31,167,19,244,210,118,34,3,53,117,114,106,177,146,111,62,160,205,94,120,192,2,253,236,29,96,45,152,70,194,73,120,236,242,96,96,222,151,24,53,217,249,61,146,123,191,70,197,93,40,71,226,27,191,216,71,250,184,230,243,191,126,59,142,175,218,240,112,154,33,87,78,16,233,20,121,111,246,33,142,247,118,105,141,238,222,174,220,200,16,152,252,182,241,170,65,136,91,164,230,248,75,218,193,109,66,206,199,221,250,131,122,184,168,251,194,90,102,107,83,174,191,90,167,46,171,120,78,214,51,104,46,66,78,225,174,219,93,159,96,83,67,91,11,141,113,219,69,93,116,244,52,25,196,227,85,148,246,204,251,168,84,212,247,51,92,99,67,224,110,75,248,34,101,201,71,145,120,199,248,176,104,34,111,203,132,200,188,180,75,196,12,188,121,180,99,52,97,154,251,163,100,102,225,122,154,247,31,67,199,75,38,175,139,27,3,186,92,115,183,252,137,9,27,179,117,231,171,58,82,13,142,135,239,247,204,212,133,18,116,218,56,67,160,35,190,212,250,197,146,46,255,151,35,50,229,3,148,26,213,107,23,171,20,17,22,248,0,232,150,205,217,203,65,155,40,166,193,17,141,123,10,229,215,123,51,189,184,66,66,122,156,190,67,33,130,249,108,161,103,140,18,73,60,187,105,206,130,23,111,222,163,163,88,226,91,146,156,28,148,144,241,152,111,221,67,178,34,243,102,5,253,209,143,231,98,139,224,60,145,194,116,77,147,47,215,231,237,45,141,242,191,204,94,221,210,133,139,186,94,155,120,10,24,169,187,121,18,58,66,216,113,198,98,77,100,178,168,221,172,192,90,23,25,145,254,75,180,153,63,67,3,229,251,59,240,90,227,89,247,249,222,44,95,36,26,43,217,95,4,37,157,146,14,177,204,78,99,61,121,106,83,209,188,184,219,103,155,167,227,229,109,139,164,198,15,241,170,196,116,248,217,231,154,244,212,110,124,245,14,19,212,116,102,103,109,149,90,6,154,16,42,12,112,51,44,231,85,159,226,63,42,14,68,24,198,58,159,243,218,93,203,78,218,236,74,28,149,63,166,237,179,236,180,82,219,200,187,241,0,151,52,27,90,21,228,220,66,75,239,225,175,60,217,12,66,3,27,246,32,57,178,27,225,16,237,208,30,42,164,98,228,217,239,161,251,207,5,140,191,238,219,70,2,5,47,53,71,52,146,153,74,65,10,246,74,36,139,17,122,38,182,73,145,232,69,197,110,181,108,160,163,56,242,68,113,203,113,16,140,153,235,26,83,159,144,88,207,118,120,64,38,71,107,47,56,81,130,77,255,68,164,156,43,57,75,28,18,72,82,43,58,97,143,19,15,114,50,199,133,62,14,27,156,183,145,54,5,104,191,41,187,46,149,21,84,242,143,224,5,132,154,245,6,212,37,30,54,202,167,109,11,239,140,166,177,127,209,150,181,134,126,1,152,33,242,112,59,80,15,1,87,227,104,170,254,179,176,163,128,194,169,231,144,203,80,71,254,56,97,140,3,112,151,111,40,1,246,251,159,185,93,37,50,170,85,67,69,20,65,247,180,227,137,0,68,30,96,13,192,148,2,234,170,165,195,116,52,207,207,244,227,185,59,126,221,143,225,20,7,46,26,173,203,108,60,208,39,116,180,224,61,232,68,61,237,152,251,72,252,126,230,186,243,242,175,214,48,26,117,215,230,35,17,107,65,26,243,83,111,198,123,201,80,238,190,141,128,4,159,99,55,27,239,72,103,8,29,164,244,177,112,20,227,14,157,145,20,121,163,113,126,112,92,204,91,103,121,196,88,87,145,93,39,211,147,181,64,43,180,240,61,44,159,226,244,177,87,72,229,27,86,228,187,213,184,76,75,67,1,55,253,187,114,27,27,23,45,129,102,66,145,165,153,154,164,159,231,9,209,222,152,41,189,183,190,59,175,139,30,157,43,241,191,48,88,9,41,118,65,198,55,1,251,205,117,44,208,67,122,21,97,47,34,146,83,199,251,104,179,62,66,60,189,226,122,117,23,143,220,92,222,192,253,202,8,130,207,6,16,197,146,118,40,126,47,199,31,89,233,16,120,229,243,114,70,66,68,92,72,88,125,241,51,206,249,192,210,218,50,6,14,216,100,146,14,87,234,34,98,235,183,194,153,76,141,101,186,160,195,140,144,64,207,101,112,116,203,187,101,219,45,44,120,174,74,198,255,63,186,84,117,24,93,155,255,78,108,11,140,228,218,61,42,147,45,77,61,27,191,9,112,79,153,167,38,174,168,163,123,43,201,253,113,65,210,81,119,197,135,176,195,89,198,177,122,14,22,66,242,224,145,48,232,103,223,59,211,114,104,115,103,235,169,160,141,181,146,132,145,105,93,37,103,110,228,217,12,64,49,43,72,223,179,97,94,88,26,95,136,46,19,93,182,113,121,125,96,121,205,52,168,53,161,217,104,45,255,12,29,164,72,6,177,220,215,32,228,12,121,92,5,154,230,15,37,212,186,46,206,65,247,206,153,227,231,183,173,153,95,117,170,157,59,64,111,81,102,197,39,29,20,242,189,150,175,192,23,123,206,228,235,215,19,140,168,76,255,142,214,248,160,129,133,185,252,171,138,15,112,16,164,126,186,243,194,61,235,152,140,37,0,68,133,101,148,112,111,114,232,126,190,255,92,79,132,134,159,36,122,9,135,233,213,237,190,248,225,83,245,16,239,166,82,251,186,63,57,250,250,40,178,59,177,32,70,158,41,99,254,35,49,88,232,80,222,105,45,138,240,79,51,109,47,24,39,192,83,107,134,173,8,127,56,254,83,74,156,253,106,134,102,185,243,168,150,251,140,185,120,98,9,69,197,24,243,181,160,217,102,44,229,41,62,223,41,101,1,8,215,38,31,254,14,126,24,168,246,4,127,168,139,44,234,39,75,237,247,9,152,196,147,201,92,5,100,54,235,17,130,160,243,169,45,31,210,55,221,83,8,20,130,75,109,231,138,183,25,37,46,83,52,190,112,46,54,184,195,82,148,239,75,32,249,7,1,167,233,148,125,32,24,78,166,65,192,171,91,220,178,159,198,38,145,87,105,57,169,5,222,155,246,48,234,248,163,90,141,19,199,33,63,119,41,15,93,108,173,239,105,234,136,93,60,72,121,50,219,243,139,83,162,118,219,24,31,35,66,39,28,68,248,223,3,5,88,80,212,32,251,8,225,58,167,219,164,94,180,166,177,57,68,114,105,89,100,104,16,157,188,184,233,42,198,81,137,97,16,90,234,4,15,105,15,212,70,103,91,109,10,244,75,44,182,232,80,111,203,187,235,34,52,75,225,35,56,54,83,91,83,245,79,152,101,43,20,14,108,202,120,12,90,193,105,38,135,69,124,86,238,112,144,84,70,16,83,130,147,189,155,158,106,52,177,58,69,255,16,174,84,100,126,97,16,206,243,196,218,158,179,243,58,54,50,208,117,125,145,25,230,166,114,122,225,18,26,228,7,233,187,143,191,136,48,225,65,101,201,253,155,210,57,150,8,254,21,151,136,217,230,250,35,78,223,252,233,176,205,158,81,15,162,112,244,244,112,96,151,25,25,122,101,35,173,57,248,171,212,48,12,41,206,131,86,205,21,185,200,201,41,9,128,177,102,17,169,212,234,31,235,84,116,125,93,125,147,81,207,84,61,95,36,193,87,240,31,168,232,73,217,79,170,123,58,175,45,28,54,228,104,56,186,36,166,164,95,56,234,255,137,13,167,113,223,165,150,102,133,195,126,130,175,33,223,5,239,251,181,43,109,247,113,196,75,121,21,103,231,177,64,112,167,200,185,239,34,237,107,231,115,198,139,177,41,194,184,138,228,129,4,78,81,163,183,67,206,123,53,139,189,126,92,245,231,205,84,153,35,63,99,65,212,2,22,204,222,61,83,230,217,87,217,106,187,227,255,170,216,223,191,130,181,124,49,159,113,149,170,222,162,23,227,247,213,204,100,210,90,181,108,40,178,88,168,217,174,173,252,21,126,211,133,131,49,86,104,8,151,173,104,118,80,133,111,67,249,26,218,193,15,152,32,141,86,235,44,200,94,112,156,213,167,44,217,155,189,197,86,234,31,226,12,165,192,171,114,106,167,88,90,78,180,186,188,196,157,24,163,60,75,237,61,108,76,23,120,61,75,183,195,208,2,155,65,162,108,58,72,225,53,112,103,45,164,110,116,95,165,168,60,30,120,186,126,103,142,176,133,227,254,49,80,110,232,56,67,198,185,160,167,51,101,89,221,208,186,232,74,233,38,108,109,218,132,115,102,36,83,40,69,241,110,210,207,56,189,42,179,85,212,117,141,192,246,154,149,242,232,213,106,185,74,7,152,155,121,109,132,23,179,99,15,148,105,242,160,14,168,250,20,83,226,233,72,179,186,191,116,172,19,234,214,89,247,201,187,135,159,119,99,226,248,196,44,222,144,108,194,162,225,153,194,159,129,217,236,189,152,186,202,194,252,169,132,124,61,235,20,53,6,19,74,199,109,92,175,181,223,53,47,109,250,67,63,207,6,163,85,86,21,50,238,50,40,81,30,203,6,26,129,21,17,50,237,126,143,16,157,33,162,66,186,103,21,42,89,137,55,34,27,224,31,64,156,146,161,8,176,76,175,19,57,239,19,179,138,68,46,4,132,191,224,120,3,81,219,7,158,18,13,12,118,70,48,247,190,42,56,0,207,73,119,142,231,239,39,190,177,58,192,193,44,114,102,58,30,161,245,110,146,13,93,132,216,232,177,195,76,101,59,228,21,115,137,214,53,15,233,39,86,107,115,183,230,103,199,24,166,15,239,52,117,154,246,75,63,25,148,168,169,152,73,24,93,247,113,90,3,23,170,192,69,129,213,127,14,53,75,130,50,28,226,66,224,22,242,160,218,217,156,147,192,112,39,144,151,86,25,100,25,169,44,224,4,230,250,192,71,101,9,15,81,79,237,146,81,240,62,196,72,39,81,182,255,132,37,75,219,230,234,25,93,119,35,52,15,239,158,39,226,183,52,88,83,158,213,158,178,201,121,132,71,245,93,233,97,194,24,28,54,210,186,166,119,69,39,221,121,239,149,200,200,201,95,74,172,23,70,245,224,49,133,69,45,142,123,43,237,47,9,183,34,40,185,65,119,112,249,230,76,124,44,8,86,143,216,197,127,34,213,212,55,242,32,22,71,8,212,192,111,57,6,5,183,154,43,83,178,13,134,115,240,161,194,13,144,228,58,53,249,250,232,116,128,111,148,141,206,236,251,100,226,197,95,121,92,1,16,56,185,186,32,89,0,15,214,119,121,247,108,108,23,122,237,252,165,16,175,23,24,135,71,39,52,98,70,75,124,13,253,203,198,98,183,186,108,0,240,42,62,253,97,190,23,0,53,24,21,97,88,210,52,123,194,193,40,230,220,42,71,40,181,196,198,232,211,16,47,164,84,33,218,190,8,13,186,54,1,105,198,145,101,6,234,237,159,243,121,161,48,170,109,217,170,76,80,115,206,154,87,104,130,109,250,123,77,186,161,226,38,205,77,36,69,115,144,0,144,168,112,214,137,187,77,126,6,136,230,115,143,13,242,167,112,208,92,31,121,29,217,176,21,115,210,118,3,152,114,191,131,88,59,124,147,11,208,9,155,36,27,225,26,119,226,102,232,60,72,188,216,111,250,93,122,119,57,21,113,13,102,60,190,126,219,22,49,237,140,207,124,241,16,39,82,75,64,122,96,235,11,67,46,235,156,124,214,36,114,17,38,146,163,61,203,245,18,22,178,129,147,187,43,65,43,166,129,126,55,161,83,72},
  {41,20,139,226,20,10,117,125,252,46,149,117,155,249,104,197,143,152,120,28,126,13,142,228,204,65,115,37,105,70,187,131,198,47,213,206,63,127,213,100,128,29,248,228,43,101,81,31,54,74,12,51,67,98,152,25,32,85,23,122,143,59,6,218,163,104,173,148,133,197,63,161,63,185,16,141,3,160,162,188,151,208,175,83,132,187,209,195,214,112,4,2,223,195,210,101,202,199,191,115,48,187,94,9,73,78,176,25,185,87,22,184,195,118,127,214,214,231,220,75,226,128,36,118,209,60,235,146,203,175,72,101,218,48,4,201,44,151,25,20,139,227,135,70,253,44,66,144,133,149,92,154,60,151,235,131,135,224,71,87,43,113,59,188,52,81,189,48,224,67,64,64,126,250,126,44,119,118,243,138,247,108,30,151,170,125,136,25,233,222,126,129,73,252,210,217,183,135,120,57,81,113,21,54,249,252,225,68,78,205,207,66,108,200,146,40,129,153,224,120,97,151,147,75,113,26,128,223,160,109,29,163,192,155,51,83,43,131,179,210,196,166,125,72,226,4,111,6,193,199,81,224,78,184,188,178,1,227,118,196,228,87,118,8,235,10,247,184,14,99,55,40,176,33,140,28,205,38,224,243,194,218,222,57,174,246,125,80,69,27,1,213,30,176,98,185,45,206,7,174,163,160,205,4,65,98,138,118,15,243,36,245,217,159,225,81,47,237,128,15,110,43,200,230,149,240,227,129,202,1,228,250,130,105,23,198,191,250,118,117,235,254,162,221,61,229,51,142,119,173,4,144,117,54,251,204,51,207,119,51,235,186,121,38,218,14,74,211,180,1,202,75,195,120,56,47,214,93,57,232,195,173,48,71,48,214,91,255,152,140,210,45,237,68,230,234,250,188,15,96,27,133,144,224,120,165,158,175,93,168,8,209,249,53,72,0,161,85,112,133,123,50,71,70,121,142,7,120,220,5,205,248,177,179,142,62,42,60,80,73,140,56,205,34,2,185,243,110,239,247,199,148,97,113,19,39,8,167,252,242,44,63,137,152,95,200,70,115,253,72,22,85,70,158,197,58,18,253,179,50,171,110,99,216,13,210,239,255,162,44,143,74,92,113,113,47,55,35,75,59,43,146,72,43,29,147,93,221,27,195,255,180,210,202,237,153,183,65,226,230,57,210,154,94,136,32,165,255,76,83,148,104,166,185,77,169,181,150,71,25,149,248,134,190,83,214,75,49,147,238,146,224,15,185,161,170,34,182,121,91,136,53,246,87,228,14,249,79,90,113,175,158,93,80,215,230,66,68,111,153,108,159,9,228,173,89,228,231,160,120,121,93,165,181,10,71,219,199,200,112,156,23,165,197,17,195,224,174,34,128,163,197,174,207,110,52,66,128,216,210,172,164,14,140,32,9,194,27,105,28,110,45,191,52,236,134,27,139,192,173,15,225,192,244,190,38,240,124,74,119,41,110,218,36,80,73,80,151,149,137,44,113,158,157,162,4,156,5,110,45,232,109,221,53,79,78,156,128,105,91,5,68,65,188,227,177,182,227,224,202,94,132,185,103,216,116,20,135,154,119,179,97,235,187,180,44,83,84,74,233,63,99,38,18,194,9,8,121,69,117,254,24,159,154,110,207,116,103,12,23,65,185,194,245,183,174,46,5,6,80,214,155,71,198,138,208,36,134,214,180,67,174,130,195,30,131,27,201,11,144,108,189,118,220,169,58,192,114,61,90,40,233,176,27,63,225,104,111,122,6,206,144,198,200,144,109,77,246,232,53,69,72,9,144,242,12,78,125,211,235,176,123,228,146,167,177,119,29,248,187,253,142,49,105,196,77,229,44,165,148,126,243,105,22,149,78,199,184,74,0,243,99,80,143,92,155,23,243,19,184,239,104,14,140,22,232,202,144,27,37,234,148,39,219,188,177,156,31,158,123,18,129,77,10,21,16,24,154,242,37,131,153,102,25,243,119,106,11,158,63,75,138,144,206,108,98,6,40,249,199,235,243,41,44,136,57,245,68,89,250,111,185,92,232,103,67,128,240,243,30,71,129,212,165,108,133,2,131,83,14,177,184,240,232,109,95,197,16,127,1,205,61,11,97,87,225,163,224,253,251,38,88,232,141,169,99,141,169,188,103,212,6,33,118,151,172,152,45,225,186,11,201,129,101,133,18,142,62,77,106,0,113,122,136,75,182,32,176,161,39,206,145,87,170,189,180,104,196,14,135,199,65,194,70,97,159,198,40,179,238,48,111,190,133,196,79,124,151,218,39,203,210,124,254,239,23,172,153,153,140,10,2,66,186,200,107,43,247,100,133,187,94,201,54,27,227,116,87,87,133,32,22,221,19,34,26,104,59,208,71,212,15,100,72,228,99,250,230,116,232,227,193,127,214,114,78,65,201,222,150,110,176,108,28,224,181,156,149,241,241,243,187,103,151,33,75,231,201,10,209,53,231,93,30,227,79,236,227,99,189,242,181,23,136,39,149,17,141,54,141,178,95,80,140,250,244,94,113,99,231,134,105,245,190,84,214,105,191,227,183,76,157,144,164,247,49,61,231,187,173,5,181,98,225,125,70,6,231,95,71,163,249,92,81,161,192,63,47,54,225,150,142,240,164,167,155,97,136,92,208,17,244,1,180,67,87,8,144,248,186,39,57,143,197,58,4,81,133,48,252,81,210,5,245,243,31,235,34,42,50,225,103,56,247,135,162,224,87,165,110,117,234,253,159,83,242,199,254,20,168,11,102,93,83,120,130,56,230,41,19,11,252,6,154,226,168,97,82,186,110,64,80,107,24,133,114,57,13,101,115,23,55,16,93,221,66,142,189,94,98,147,230,114,157,211,212,181,37,124,145,114,122,117,244,120,49,66,12,213,157,24,52,52,49,113,110,47,169,23,107,113,194,72,236,193,197,138,164,150,238,35,50,74,194,196,178,240,223,190,212,120,82,124,189,81,243,75,13,184,103,79,105,29,2,16,126,222,1,3,188,128,70,60,94,225,238,121,46,46,158,236,84,191,127,254,131,100,100,5,157,205,188,37,252,106,229,27,136,22,140,235,20,179,220,32,203,96,36,110,21,45,2,198,61,99,141,115,89,198,169,160,99,45,149,25,112,99,1,79,122,81,243,194,230,217,181,110,170,100,234,205,36,76,198,180,239,250,245,76,82,33,10,83,157,148,218,11,120,230,219,76,249,152,81,17,139,154,111,239,187,36,31,61,208,172,111,167,91,91,95,142,42,21,42,199,106,54,170,240,248,107,118,165,251,155,244,246,59,144,38,118,89,166,201,135,47,220,135,254,110,5,110,95,184,67,134,104,51,143,100,45,29,220,47,111,136,163,66,153,75,143,162,115,90,124,73,89,109,157,51,170,133,148,132,131,155,230,161,199,255,15,60,218,53,57,42,30,224,237,210,119,199,103,138,42,99,160,205,8,184,212,168,248,205,227,36,47,3,161,129,241,40,227,220,232,93,92,253,55,61,205,97,126,33,151,58,245,165,111,75,240,129,129,55,113,64,193,77,253,122,59,158,39,203,34,42,203,156,180,195,101,217,201,208,236,223,228,180,164,7,100,147,198,89,64,25,78,12,60,102,191,116,96,216,36,104,27,208,72,142,83,119,198,23,96,110,50,221,81,219,85,13,159,254,91,50,163,50,229,105,250,227,5,229,195,136,182,158,71,230,223,228,87,78,156,237,191,122,103,179,49,34,247,221,147,226,91,211,210,230,128,23,31,233,8,31,102,37,42,48,137,108,97,24,245,18,239,184,171,104,160,212,71,245,9,214,5,10,74,152,7,83,83,250,101,29,134,17,251,210,1,11,133,228,106,236,118,81,38,32,225,218,241,143,82,141,203,220,107,37,255,224,32,235,46,171,26,45,109,92,106,68,142,170,95,43,128,105,169,90,107,248,51,123,103,213,124,138,211,4,80,162,64,254,93,207,86,64,51,249,73,46,224,30,117,134,154,223,156,163,177,190,203,42,223,240,51,137,205,169,86,104,33,176,80,31,211,232,120,134,252,252,152,162,129,225,144,65,18,219,242,223,248,228,149,204,75,163,179,203,241,32,3,90,34,61,109,132,191,229,211,94,108,102,189,252,186,152,253,46,95,78,190,93,64,104,180,66,253,7,102,202,29,144,205,32,89,161,244,54,215,48,191,138,247,176,242,74,21,8,125,53,180,36,167,177,104,40,15,21,155,100,49,197,170,10,195,176,203,135,92,151,135,112,183,185,226,81,244,197,217,233,83,93,111,156,195,243,196,8,32,48,61,115,25,238,13,157,19,117,61,155,195,8,224,239,210,146,102,5,168,117,198,32,106,232,15,15,140,149,162,43,18,179,196,234,162,159,140,247,150,123,160,245,68,245,81,22,169,70,135,228,87,239,21,94,48,105,212,196,124,188,98,225,175,34,10,21,12,38,245,237,202,77,32,117,45,233,204,126,32,242,93,157,123,202,6,219,91,144,197,38,80,81,70,11,98,135,166,108,68,147,183,203,107,30,62,183,97,188,65,235,224,195,120,118,217,150,173,217,125,69,150,225,168,222,24,14,234,120,211,88,26,171,31,72,147,20,107,30,32,14,149,101,188,39,4,111,215,34,106,198,202,197,167,237,180,99,207,209,237,12,235,200,200,127,68,110,153,117,143,101,10,164,13,233,209,137,36,213,3,159,5,99,179,97,73,182,217,70,233,81,112,182,77,176,45,163,163,62,121,11,54,207,131,247,248,182,16,58,34,192,111,1,182,241,44,92,171,70,176,47,121,233,127,26,16,64,42,219,25,210,183,252,60,149,62,181,194,125,161,47,169,69,125,26,212,97,31,153,58,16,0,171,191,87,224,208,151,68,82,229,44,55,228,53,220,36,203,168,25,89,201,142,209,119,154,89,110,173,91,75,74,200,110,87,33,179,79,229,139,179,45,88,38,125,128,166,47,147,230,60,166,5,10,168,65,219,56,10,161,227,86,45,185,121,72,83,33,169,215,81,57,222,12,143,141,180,66,86,32,181,198,249,22,46,177,99,242,47,38,133,153,115,116,96,236,107,67,133,68,151,118,72,193,245,36,67,181,101,191,183,34,147,196,229,73,76,175,215,245,16,246,20,84,229,119,232,88,22,206,34,211,232,27,106,93,229,41,127,113,200,47,137,227,168,241,50,42,9,27,179,114,139,85,100,135,137,22,119,206,237,213,73,239,45,18,116,143,167,38,33,231,22,168,253,222,204,48,178,154,58,98,62,1,3,32,146,108,47,101,181,249,60,26,251,103,236,201,41,104,170,248,250,136,108,153,15,15,16,182,61,7,114,251,229,42,72,109,47,229,83,160,175,33,50,110,56,29,220,251,99,29,114,47,70,6,153,21,118,3,214,74,135,125,216,8,116,248,111,209,246,95,43,77,87,134,230,80,188,140,222,94,117,86,254,171,181,126,125,61,174,213,5,117,38,54,10,145,37,53,54,34,17,221,183,168,228,214,63,234,23,148,210,82,251,154,78,22,164,207,66,27,107,188,93,137,100,151,153,226,127,231,196,235,27,67,117,108,175,12,53,103,215,25,181,99,97,171,219,197,76,59,223,121,109,54,82,12,246,224,7,132,134,140,120,88,183,246,242,175,209,134,91,4,246,51,149,216,191,99,190,59,126,9,196,119,188,46,36,137,88,242,183,228,122,5,132,88,231,184,45,25,51,186,87,145,166,51,180,158,37,228,231,236,115,61,135,8,223,156,243,10,107,98,83,43,182,77,232,71,60,147,205,83,120,54,222,194,14,245,177,161,144,195,212,173,18,221,231,196,246,211,95,140,1,199,128,95,242,164,212,10,179,213,254,221,83,66,65,3,196,76,111,143,143,123,225,54,18,40,61,74,130,67,143,138,138,3,38,76,86,35,104,95,21,2,235,72,181,117,14,125,76,106,174,213,202,209,12,114,112,165,18,58,248,247,158,144,19,80,190,186,204,75,163,49,232,185,123,59,254,190,139,142,90,23,14,53,3,165,142,198,7,129,66,207,22,255,182,9,183,99,145,92,59,147,14,6,252,189,210,164,197,31,139,65,58,12,66,204,159,81,131,137,0,24,249,64,95,139,59,98,210,77,255,110,54,121,17,229,79,169,255,203,209,35,137,208,86,88,178,59,170,252,5,182,97,105,72,99,31,245,169,255,225,147,32,180,221,80,53,200,253,128,102,86,85,72,161,243,150,121,105,130,180,233,143,236,248,254,123,78,63,74,175,132,131,69,244,5,158,0,245,61,193,133,203,222,172,232,55,207,222,186,79,207,129,4,234,214,198,149,7,115,107,138,254,151,29,101,214,156,202,115,195,142,214,14,63,18,10,249,19,120,19,45,212,220,62,101,189,85,102,172,123,123,154,46,30,22,142,233,248,46,29,239,173,20,114,15,209,194,34,77,41,106,61,131,139,191,219,241,249,253,161,137,56,96,253,149,73,234,112,214,245,202,217,207,166,137,231,144,194,164,105,218,11,101,191,251,2,241,133,224,127,122,255,22,220,61,42,209,84,92,231,212,10,23,38,193,8,243,185,211,243,220,16,248,69,1,65,53,82,0,119,253,154,158,54,70,234,94,17,243,5,90,199,14,120,158,177,191,86,203,56,248,129,232,168,182,79,87,107,130,26,190,69,58,247,66,192,128,170,143,228,102,202,178,101,34,4,84,39,202,143,196,217,60,233,83,164,173,30,163,253,111,30,171,240,202,189,15,39,115,248,119,42,94,252,99,167,66,190,104,23,174,167,6,237,251,246,220,100,221,3,248,30,121,143,168,132,166,212,118,172,158,139,73,247,89,218,218,159,81,122,187,186,207,127,159,200,205,91,167,160,8,231,254,248,54,21,172,1,220,187,20,46,185,163,150,117,247,238,22,37,66,220,203,221,78,53,187,181,232,18,127,217,164,23,40,14,91,12,240,40,255,110,225,44,252,182,54,31,165,13,111,20,53,240,255,198,52,145,153,72,0,220,157,181,142,14,254,158,131,26,251,90,248,180,175,72,166,58,55,241,68,128,118,169,132,45,168,4,242,60,126,34,124,154,227,32,189,54,46,31,73,61,46,194,123,196,146,91,74,204,148,12,183,141,249,76,186,130,114,187,241,254,41,166,211,175,89,202,211,98,234,117,206,120,146,217,201,142,233,250,156,36,245,243,5,73,7,249,133,139,83,237,13,198,30,48,158,86,125,54,237,53,89,198,77,31,15,110,87,154,105,180,252,55,203,177,169,138,120,44,145,204,153,140,168,204,239,217,194,212,74,160,31,69,29,196,50,72,66,165,221,214,44,109,212,55,156,117,169,53,166,250,35,192,135,50,26,198,166,63,75,38,200,224,203,3,233,254,182,162,151,138,20,73,34,115,35,93,117,241,160,49,31,122,176,202,127,34,212,109,55,40,0,162,86,244,247,105,164,86,166,168,97,82,203,173,117,70,154,119,71,131,76,42,67,191,155,40,80,37,46,47,4,6,180,99,101,218,201,83,67,158,22,16,229,94,102,192,172,219,190,67,88,75,174,94,218,137,40,17,34,40,144,161,192,141,203,31,0,150,8,115,54,127,139,113,77,55,65,162,79,177,247,40,78,220,176,48,189,201,43,50,38,139,130,198,252,13,118,244,160,39,130,189,224,37,52,95,68,93,28,121,172,111,242,135,55,83,63,196,128,78,30,146,205,131,129,34,45,132,183,33,36,226,245,50,233,102,15,5,128,161,205,103,109,146,75,14,135,26,162,104,176,179,199,82,216,202,174,220,195,36,253,150,45,81,182,228,11,30,61,122,20,73,97,126,137,145,243,154,132,147,66,78,33,46,73,146,73,193,70,109,101,250,246,217,76,55,6,43,31,151,117,138,159,56,143,234,109,108,232,220,228,143,252,126,131,31,56,153,38,27,64,248,56,141,144,114,113,135,173,158,49,229,241,24,190,91,133,253,23,193,59,224,180,203,213,15,202,174,255,248,189,159,226,137,143,66,240,116,169,35,123,196,106,255,214,217,255,68,164,189,96,165,37,105,203,45,195,104,178,255,47,2,69,193,253,226,149,158,229,122,229,71,197,189,241,237,191,238,90,243,99,75,90,147,253,14,95,135,214,244,36,89,255,155,226,52,180,28,93,158,210,43,15,230,183,0,168,171,171,197,112,233,22,109,199,83,95,81,165,139,59,232,45,207,49,176,106,136,144,235,184,192,53,50,99,6,150,174,51,132,167,132,191,224,239,109,244,155,253,226,219,28,197,150,87,246,76,103,139,205,194,235,234,113,110,40,253,143,5,87,131,139,108,60,255,21,107,184,125,123,42,24,68,135,199,77,207,82,136,198,246,17,140,184,77,68,130,68,46,89,167,86,127,46,40,144,42,111,81,209,187,231,217,73,158,28,129,117,78,51,223,190,42,100,127,216,24,156,15,150,83,111,195,186,138,47,230,144,218,103,79,177,232,173,220,68,236,6,123,41,23,119,59,198,241,142,182,178,255,172,9,33,214,4,243,6,129,102,80,196,171,114,54,106,186,228,126,235,187,209,116,96,12,44,56,62,15,158,103,225,92,62,221,131},
  {99,167,87,238,226,196,149,15,14,242,172,59,54,179,128,36,244,47,181,182,72,71,156,204,0,144,196,170,87,189,136,113,82,29,196,62,116,187,152,100,34,181,247,230,66,12,153,212,144,162,11,47,15,12,112,190,65,239,62,224,87,99,239,87,208,170,161,83,115,167,130,135,64,37,64,94,85,213,31,234,254,95,16,99,148,176,201,76,242,186,107,6,194,141,157,52,100,132,239,136,172,30,141,169,217,20,173,173,20,3,164,156,154,146,112,173,55,106,1,129,217,215,52,22,12,27,212,105,170,191,119,179,33,117,208,189,79,217,13,112,204,106,18,96,59,24,8,58,34,101,61,89,24,128,75,162,95,16,66,225,100,169,159,83,58,184,238,143,199,48,199,182,205,191,37,142,212,115,123,125,24,170,137,165,57,100,229,61,6,207,28,3,117,21,194,43,11,92,13,61,79,219,146,212,32,205,196,50,28,181,96,78,77,74,30,239,152,3,85,237,66,147,17,119,236,48,119,129,236,245,87,96,92,33,147,134,92,212,193,174,222,201,249,67,17,189,246,25,108,75,14,221,247,126,187,78,52,109,152,244,21,233,85,154,70,236,106,104,40,3,244,150,183,48,50,2,246,255,135,84,2,230,172,7,198,201,153,43,110,229,247,113,11,73,233,244,214,45,56,145,187,150,149,160,63,145,169,101,125,235,24,65,96,69,167,220,16,10,59,192,55,240,172,124,217,84,80,140,48,249,167,226,97,10,220,175,112,0,138,78,220,19,169,24,9,184,203,109,46,56,220,0,243,41,58,137,30,186,169,212,13,3,198,231,221,186,77,30,203,77,128,177,37,66,130,29,231,22,139,177,4,90,121,5,26,134,175,179,20,46,158,108,51,65,192,77,213,160,104,111,88,8,34,112,225,220,0,168,50,38,215,76,174,119,132,133,217,79,21,244,166,174,246,106,213,177,206,90,20,206,147,233,86,55,221,181,252,150,147,110,185,89,128,58,107,20,246,160,50,10,135,239,141,28,148,238,219,64,82,232,117,215,135,55,65,148,64,146,43,16,106,121,94,118,95,184,176,63,56,192,114,201,181,85,130,4,6,152,139,95,170,60,69,136,212,201,137,13,119,191,46,86,230,79,153,89,167,47,115,113,41,120,206,72,49,214,31,234,220,217,236,135,82,195,251,152,140,9,34,1,95,81,206,132,229,212,225,90,12,90,68,19,104,179,246,205,99,11,58,210,247,61,238,222,188,42,85,165,66,218,23,56,188,73,87,145,14,81,1,15,28,110,7,119,164,58,30,72,76,171,212,120,107,149,39,242,231,121,144,136,208,221,45,63,121,117,135,93,108,134,241,24,65,125,168,168,40,120,215,252,213,195,191,181,90,196,135,233,77,235,66,212,173,234,84,42,99,108,220,246,31,99,177,85,173,192,113,197,110,158,192,223,12,202,11,122,94,228,109,11,185,183,241,72,126,22,31,151,249,190,167,158,144,250,87,113,20,108,116,103,161,106,28,172,108,101,129,217,76,179,158,142,198,52,243,246,52,161,69,169,156,122,188,203,134,138,118,2,247,63,155,215,105,30,207,61,85,113,253,199,56,57,232,78,209,92,246,183,226,12,222,213,223,159,78,63,83,88,93,71,148,246,176,37,178,0,230,195,118,87,70,147,58,142,183,74,153,150,171,133,230,56,195,8,234,19,155,229,191,171,240,12,75,179,5,253,59,234,200,80,8,0,234,170,238,82,218,12,159,134,190,171,74,141,192,90,247,109,174,73,211,251,154,194,181,37,14,12,17,162,87,76,133,131,118,187,139,225,26,229,176,30,114,15,227,250,14,185,6,51,52,120,14,213,3,90,187,158,4,254,13,142,244,228,1,215,243,11,217,175,158,103,115,190,201,133,135,94,25,70,163,66,123,95,164,58,169,128,196,127,198,196,55,193,178,181,225,65,22,151,248,137,14,42,136,159,116,77,8,71,69,192,112,179,150,62,241,59,195,150,37,115,123,170,60,255,36,202,18,254,78,115,209,67,223,20,153,120,134,69,247,252,105,203,24,15,33,231,65,19,162,162,54,17,114,44,247,32,252,65,70,61,205,110,92,137,203,142,16,214,224,100,12,4,186,151,161,120,109,100,56,207,202,156,43,72,114,248,21,59,102,117,160,130,38,72,133,253,187,94,2,254,7,111,231,101,165,179,101,172,231,28,172,3,31,137,144,192,115,195,49,131,255,203,251,80,225,80,189,55,79,108,149,114,27,149,134,33,66,194,124,235,137,5,251,197,107,73,38,88,17,70,86,49,123,156,4,111,66,231,177,144,29,83,63,172,136,25,64,17,40,17,16,84,245,63,102,242,187,171,78,178,7,28,147,197,176,61,47,34,135,230,150,250,133,224,2,198,42,79,77,27,105,117,105,84,45,181,157,70,118,5,49,140,131,95,74,252,172,178,165,103,52,247,213,29,159,88,244,46,42,208,253,28,85,118,199,202,106,152,182,253,186,245,30,164,235,164,145,120,64,119,82,174,19,47,193,64,115,104,152,235,50,113,118,190,245,4,237,193,96,177,11,229,238,42,241,253,253,185,133,218,59,209,175,108,129,140,77,100,32,245,243,58,0,23,50,117,127,149,92,195,107,14,151,30,24,116,179,98,29,29,230,219,140,82,78,78,192,121,129,5,39,160,250,229,105,242,125,47,225,205,193,61,4,108,110,185,207,122,125,41,198,198,232,219,110,91,16,108,93,158,254,202,65,46,255,146,219,27,83,212,100,115,11,48,47,193,20,141,16,220,28,240,254,227,78,252,136,210,134,196,177,8,35,57,102,122,62,24,111,111,37,171,150,197,13,181,219,153,119,214,108,166,160,186,175,184,219,36,225,221,251,36,180,160,180,131,191,60,228,4,4,209,46,37,114,0,20,34,186,198,80,196,114,169,95,106,206,44,167,33,20,69,63,12,166,159,217,159,116,159,117,21,192,162,18,209,175,171,12,23,203,162,153,239,151,7,78,118,181,42,141,249,81,44,53,68,160,149,65,18,239,152,74,111,183,40,57,66,123,99,249,91,245,71,240,229,148,237,128,234,77,207,13,197,164,143,157,95,148,17,170,207,236,135,10,183,109,16,224,75,146,156,139,141,122,19,213,77,66,83,201,222,229,77,241,33,25,144,140,202,34,88,142,69,240,87,156,73,135,255,170,180,65,203,96,192,27,105,148,52,61,11,135,122,223,122,246,173,249,114,200,124,174,141,118,53,124,209,43,234,208,209,26,0,25,51,1,240,36,17,103,134,8,51,126,69,131,79,154,80,50,238,42,11,202,106,63,0,105,180,223,22,106,140,220,250,48,164,163,79,211,231,124,75,177,210,20,145,187,162,45,134,76,65,61,15,113,231,72,219,34,1,44,249,132,180,69,21,84,176,136,205,202,21,252,17,217,89,226,83,36,159,160,53,120,121,236,216,110,28,236,40,166,17,11,117,80,145,205,141,116,158,120,45,205,252,1,121,135,59,39,248,109,161,46,236,17,0,160,33,33,136,47,6,60,212,79,134,231,234,106,248,69,52,41,115,132,218,173,213,8,8,38,147,16,101,99,145,157,121,45,163,80,25,235,91,245,12,216,152,85,216,130,29,49,100,122,91,106,75,125,176,198,194,113,152,146,71,83,59,142,92,23,181,250,72,181,85,84,47,53,45,111,212,225,230,191,103,158,188,83,194,2,133,149,0,224,217,229,153,92,206,71,180,162,185,135,143,57,119,205,170,159,212,81,179,145,24,100,73,165,232,186,94,119,79,110,60,122,40,198,49,171,167,60,214,85,201,224,118,132,179,246,74,43,5,128,156,227,61,232,19,52,156,40,147,33,139,156,225,196,134,4,18,30,158,212,57,93,121,241,111,101,209,56,62,145,147,247,57,103,74,191,221,3,235,124,70,239,159,212,247,166,114,111,165,195,220,88,133,245,64,213,110,64,113,88,153,70,199,251,50,79,134,116,198,204,19,189,168,97,223,0,12,197,245,190,229,30,255,63,196,196,121,101,28,139,46,88,20,117,154,254,101,228,251,25,90,70,48,21,52,201,178,15,92,86,66,38,46,97,58,235,172,65,221,112,7,114,127,3,252,183,237,112,235,71,248,15,199,186,12,126,253,22,184,211,135,216,35,222,224,46,173,78,77,121,243,197,24,205,184,26,34,27,233,148,111,83,78,63,25,223,139,178,183,95,137,38,180,204,4,70,148,145,51,248,135,47,156,69,74,243,57,41,227,230,137,85,98,116,16,31,135,244,191,97,171,146,129,218,155,62,231,61,251,226,165,205,26,22,173,78,6,21,219,27,75,222,171,136,217,158,55,217,182,51,214,11,40,220,53,89,47,196,221,93,84,46,241,58,187,39,25,60,32,75,220,162,199,93,223,74,123,254,169,8,17,30,93,243,18,59,68,244,71,26,196,82,47,173,141,180,97,93,155,220,103,182,171,53,163,62,105,147,209,235,0,247,119,227,239,186,170,144,138,94,235,243,236,149,63,213,106,113,48,187,81,158,165,161,44,123,113,220,107,26,59,77,119,248,46,119,252,164,183,78,17,220,16,163,21,111,121,34,249,209,35,83,180,229,113,114,24,192,113,209,50,86,57,135,227,114,184,148,246,255,151,107,211,57,153,171,87,63,48,246,241,193,154,229,240,80,208,56,6,235,186,88,109,100,160,237,218,116,44,144,251,4,71,38,254,46,205,165,112,161,141,225,35,21,151,204,81,0,75,73,234,76,129,8,146,18,3,134,83,45,42,75,168,69,163,128,203,178,151,251,232,217,230,4,136,11,9,102,229,142,238,200,42,37,209,66,140,105,93,229,13,76,228,48,6,179,193,63,140,117,39,105,173,59,66,0,117,101,17,254,65,151,58,93,85,231,253,247,36,219,238,151,227,56,70,21,56,159,192,6,98,233,162,216,144,134,161,142,213,245,108,164,114,37,161,145,142,34,251,101,7,181,149,157,42,94,35,164,253,23,18,225,181,162,30,67,23,2,4,95,145,57,240,152,188,176,130,167,133,233,234,133,180,238,126,156,196,76,15,214,232,168,8,93,86,4,35,124,253,254,180,68,151,184,146,113,167,252,109,193,252,145,180,122,210,19,235,117,53,142,203,246,248,43,243,213,58,66,82,149,255,11,31,235,30,123,209,166,192,102,95,69,110,234,195,204,255,190,61,75,64,156,128,67,69,146,59,47,178,180,56,196,156,249,126,28,75,21,27,162,232,234,53,66,149,92,18,10,116,111,251,30,184,2,84,146,19,125,14,204,36,60,128,190,122,213,205,8,86,32,97,178,207,69,170,126,244,197,24,46,250,73,199,10,171,14,214,63,134,237,97,25,54,7,222,186,189,200,200,242,82,167,242,188,43,33,115,155,114,125,93,109,41,128,28,83,155,227,230,14,47,64,18,164,156,72,188,160,210,208,158,87,39,247,12,136,218,79,130,53,116,112,201,95,129,158,113,40,39,81,171,180,237,220,168,53,250,41,101,197,99,31,77,154,184,220,59,185,150,140,33,55,1,50,136,188,209,90,37,21,223,178,121,181,73,251,204,162,106,32,187,217,124,118,251,91,115,85,190,83,34,41,188,210,71,19,85,245,33,208,149,24,40,129,218,143,75,197,212,151,241,196,0,15,188,0,92,13,182,125,131,149,7,8,167,148,224,238,122,234,87,127,242,52,237,132,133,116,251,141,59,244,148,54,128,210,236,90,140,190,129,214,114,157,215,229,197,251,61,29,5,129,223,191,52,115,189,51,101,247,197,109,14,171,61,142,207,70,25,192,50,172,176,151,56,106,253,197,225,55,110,172,212,34,47,144,131,254,171,212,75,2,71,56,168,244,166,129,101,21,253,139,162,88,44,16,128,138,127,51,107,194,126,75,244,32,209,235,80,228,41,81,229,244,204,155,212,100,181,111,199,244,219,217,89,128,1,38,185,98,29,208,7,211,198,203,77,30,135,253,94,221,122,79,170,19,183,226,93,61,157,187,37,9,232,17,117,207,155,212,236,168,17,164,51,175,248,24,99,200,197,54,232,207,146,181,235,248,53,191,196,202,194,195,229,237,141,85,123,103,88,158,193,240,119,163,224,177,91,248,80,186,82,221,73,212,33,197,105,39,163,182,174,139,112,225,159,4,33,66,166,110,128,182,230,82,184,209,75,247,193,92,62,2,155,98,248,139,236,79,62,160,243,58,50,107,232,255,179,220,85,216,124,237,194,231,74,191,183,156,173,131,245,225,79,46,2,85,235,68,101,14,180,16,249,103,155,105,50,44,24,201,18,121,217,109,31,170,106,242,216,36,246,141,53,149,108,93,78,34,120,219,153,183,159,228,146,240,9,85,185,97,79,139,5,97,140,176,105,127,235,231,162,66,162,183,210,103,53,113,68,80,205,231,130,255,106,126,7,39,188,113,144,51,107,218,96,180,93,169,108,27,166,36,139,10,92,117,1,250,103,170,156,42,51,1,120,83,225,76,41,181,19,4,57,53,2,195,209,56,204,129,182,131,210,146,252,112,75,86,150,170,118,251,113,32,172,242,61,147,170,153,44,60,110,83,91,228,96,64,135,122,163,145,12,161,231,155,147,13,165,230,146,45,86,109,220,199,32,2,78,61,208,145,237,63,171,76,110,248,233,140,215,70,107,237,129,28,197,72,200,154,150,66,238,117,50,194,80,52,49,152,53,118,95,176,188,155,14,157,46,58,244,130,135,74,90,77,125,73,199,128,233,241,45,105,21,183,72,160,3,65,145,142,220,180,198,161,249,46,119,126,225,142,206,118,194,161,226,90,171,151,117,5,1,52,39,153,24,81,138,18,252,250,132,209,202,164,180,127,76,46,245,159,91,181,155,88,68,68,43,51,60,4,36,91,172,245,208,62,138,25,109,21,88,193,159,240,143,94,67,13,119,237,179,219,241,249,223,200,198,202,215,189,13,227,65,109,135,67,175,83,30,234,141,189,250,118,104,207,104,144,104,188,33,184,213,26,178,183,115,59,175,247,159,23,253,119,150,78,227,133,217,55,220,249,57,37,37,137,135,80,40,231,97,64,18,221,147,78,223,119,60,154,59,234,237,121,76,234,201,235,81,230,91,47,66,226,16,34,84,34,49,167,8,88,193,96,15,149,20,115,80,190,15,216,226,24,129,159,45,221,124,112,195,21,238,108,93,97,171,93,175,135,144,57,111,208,188,235,221,146,230,202,142,207,205,71,229,178,180,93,52,125,151,46,173,58,48,186,177,87,130,207,236,76,50,133,39,50,82,48,57,182,75,71,246,128,255,198,160,244,169,29,69,202,8,251,98,118,18,43,240,162,85,169,12,72,145,10,199,224,171,137,96,127,36,199,233,168,192,174,246,20,100,186,170,202,8,76,66,173,242,247,12,235,207,202,95,30,211,192,250,143,136,56,178,41,122,14,232,213,3,51,22,201,5,173,34,233,189,252,97,153,195,142,176,174,180,135,253,100,153,109,115,175,206,171,58,22,45,194,7,253,45,125,45,82,0,159,186,213,158,28,209,223,197,87,93,127,87,120,135,123,173,117,220,142,156,114,27,82,183,46,28,119,72,92,203,170,37,31,32,237,165,129,189,91,252,209,0,34,236,132,227,178,13,225,224,63,91,135,11,10,203,100,192,85,164,145,153,200,116,63,226,220,35,128,26,49,180,194,123,154,77,194,142,94,216,190,40,153,88,31,242,109,144,249,162,209,255,200,141,118,4,195,245,109,214,76,254,107,14,178,215,9,108,239,49,252,228,224,52,100,25,46,58,188,69,5,100,100,245,186,134,22,140,234,202,170,53,80,25,218,150,111,102,37,248,254,231,11,142,185,225,85,135,181,182,28,218,49,172,89,92,108,206,54,175,216,153,41,121,165,244,106,37,208,239,190,40,237,179,81,244,5,197,186,73,29,150,169,36,206,10,187,39,204,174,122,170,57,156,217,177,117,22,114,158,8,247,169,105,80,53,173,79,205,154,106,252,156,165,93,27,230,126,36,142,181,80,49,190,154,149,71,41,80,171,118,186,114,136,184,238,64,43,52,224,9,145,170,245,63,244,132,233,148,105,214,224,201,46,101,128,89,10,187,201,173,147,243,41,195,247,48,22,206,130,103,15,23,175,84,83,2,42,99,163,225,24,13,141,20,26,166,164,72,5,48,18,168,163,190,90,1,46,173,226,127,78,43,125,86,61,159,249,191,30,142,145,133,10,247,186,176,237,247,163,127,216,206,169,157,110,213,22,227,254,26,41,120,0,31,24,98,169,210,47,0,217,230,212,130,152,1,204,52,214,116,72,165,168,75,160,204,88,161,208,229,186,237,182,155,247,193,187,6,192,169,244,50,112,91,154,248,204,92,149,116,8,50,210,44,127,120,196,113,3,149,23,217,198,120,87,134,249,244,208,75,218,34,169,112,0,244,251,185,61,221,84,45,236,214,170,22,187,196,253,110,242,177,37,205,181,242,81,137,135,15,222,142,126,211,230,12,100,168,242,190,29,26,100,232,16,241,172,55,215,43,130,227,84},
  {72,32,156,119,104,186,65,195,192,203,110,175,124,21,164,40,254,175,218,142,125,133,101,94,51,7,71,97,245,201,156,5,224,176,21,16,124,239,154,178,98,237,44,121,172,128,76,105,42,108,188,37,115,126,70,132,80,182,185,75,125,148,245,186,154,81,219,41,17,100,121,223,19,170,161,111,11,182,108,54,39,29,86,195,236,69,87,122,185,85,95,183,153,29,104,2,176,189,196,46,74,192,126,113,169,24,106,115,64,176,6,123,57,9,100,193,187,39,76,170,127,80,154,189,7,154,16,97,13,67,226,124,245,118,140,176,93,59,222,185,149,230,154,93,90,14,205,158,6,156,230,73,49,225,23,248,37,1,249,235,48,162,63,11,172,231,226,2,82,246,145,36,43,82,20,81,119,203,136,81,179,34,13,41,161,99,151,181,47,39,205,218,201,185,155,68,81,15,104,1,106,162,122,164,182,99,243,21,217,37,209,40,244,70,237,133,121,49,165,25,124,139,2,234,200,25,200,81,37,72,111,115,135,171,231,203,10,170,245,180,243,210,124,253,140,97,226,124,232,49,106,31,18,14,196,53,101,240,183,184,254,231,110,223,146,240,186,186,172,58,113,245,5,199,211,52,84,64,74,26,143,166,33,184,254,4,20,69,127,130,98,227,70,169,29,63,5,64,254,158,239,48,171,30,251,57,152,141,232,111,83,166,75,125,4,109,224,112,227,1,232,36,60,157,77,241,137,160,105,184,207,3,6,208,200,83,254,107,132,38,52,41,152,168,40,242,191,87,5,61,171,28,222,90,53,132,230,62,199,180,186,98,188,191,232,173,115,118,235,159,162,161,177,157,137,40,249,41,167,136,232,93,116,100,82,163,231,201,79,33,73,245,248,182,185,252,140,1,175,112,170,190,46,252,38,137,109,119,245,18,133,19,40,115,255,166,90,82,101,227,40,175,107,22,169,66,60,175,18,48,137,14,12,93,215,151,161,67,29,142,239,118,8,227,164,36,209,245,230,229,58,234,248,166,46,139,14,90,5,153,153,253,16,94,14,93,133,50,255,144,215,140,98,60,120,71,174,202,199,166,112,94,147,159,192,246,89,118,146,56,64,76,164,216,58,142,228,114,148,123,170,251,243,169,160,43,255,19,158,87,212,140,34,124,215,164,126,193,208,233,79,38,152,8,118,158,215,68,165,38,210,213,92,67,216,5,252,136,65,24,133,52,158,206,64,71,45,76,186,99,46,46,255,216,27,81,81,203,129,12,76,249,123,18,144,15,24,114,35,162,29,50,105,96,168,209,69,251,0,253,244,106,127,13,138,88,77,138,166,216,36,140,254,5,235,211,11,106,224,186,143,88,32,239,83,40,42,179,238,102,254,109,96,84,86,99,12,123,184,192,104,93,20,33,175,155,93,240,158,91,199,108,74,121,198,228,55,12,145,96,211,72,222,228,98,0,66,38,242,13,10,92,134,175,157,123,201,213,83,56,172,84,178,15,252,188,68,49,174,100,113,38,121,187,7,253,85,141,22,111,144,157,85,96,42,44,38,83,254,28,202,157,184,180,53,193,190,246,134,238,210,54,236,244,23,107,134,181,155,176,255,195,229,178,48,96,250,193,249,110,142,116,166,143,131,153,78,9,232,51,98,64,96,167,47,213,19,163,61,210,6,2,33,109,236,73,219,78,196,97,247,151,37,136,45,195,162,193,194,169,98,50,240,237,64,51,6,41,140,63,188,20,127,193,30,17,228,177,92,106,198,77,35,246,5,80,220,158,17,6,179,105,63,63,251,26,239,207,221,147,181,194,73,16,249,11,90,103,56,146,107,21,86,119,57,216,69,120,184,143,114,230,118,32,189,250,180,4,109,59,20,145,104,218,168,46,97,96,33,97,105,228,1,228,228,227,145,22,53,249,183,23,93,199,240,125,162,225,123,172,207,57,78,121,101,153,190,90,228,4,186,252,242,174,123,183,181,114,155,2,96,11,86,228,126,206,100,246,241,126,86,209,67,146,102,241,3,151,89,60,9,7,11,203,123,205,126,222,169,98,118,170,150,9,146,191,176,179,35,238,58,208,214,107,195,226,249,142,77,184,3,101,149,102,119,83,86,80,70,166,27,184,233,74,230,193,71,143,240,202,222,245,84,249,102,194,255,237,243,10,2,218,57,102,122,145,189,209,171,168,18,31,139,184,23,195,74,228,58,32,104,23,210,147,118,8,233,89,157,124,245,245,103,148,171,67,192,185,151,103,86,114,26,62,226,228,46,75,190,251,66,141,110,124,22,75,187,176,107,121,26,56,251,102,101,123,143,140,159,216,148,5,65,6,172,207,226,138,7,93,34,97,247,164,241,166,198,97,220,182,244,5,177,198,233,134,182,72,83,125,39,213,184,43,50,115,246,152,136,160,240,7,38,36,197,216,78,45,82,237,17,48,3,169,251,47,147,23,165,109,115,157,199,89,129,102,188,243,93,126,93,255,131,134,59,94,196,80,81,194,175,23,59,129,39,27,254,247,24,247,46,13,218,126,189,231,19,180,253,18,249,185,150,227,203,133,13,233,20,108,160,42,251,166,184,104,175,167,88,231,230,66,102,130,248,60,85,202,147,194,22,101,219,238,75,152,149,199,119,146,187,109,237,46,89,237,195,120,220,63,200,52,203,17,3,177,149,157,173,114,75,98,163,125,231,144,67,223,56,55,43,112,33,174,77,30,41,133,100,167,56,112,57,85,207,92,97,174,238,14,96,89,130,80,173,237,248,153,76,44,31,56,248,243,112,110,225,127,136,130,167,95,73,45,147,19,25,157,7,103,58,148,189,227,13,64,92,85,135,128,50,40,97,224,253,191,153,26,104,171,192,73,248,146,14,117,193,100,139,192,100,85,124,18,207,96,184,207,39,60,161,246,71,90,27,62,229,37,171,37,235,255,182,64,244,197,149,203,53,81,27,104,234,152,90,135,251,243,110,81,151,128,69,191,57,0,149,4,214,11,54,179,24,198,4,179,111,210,152,47,173,153,23,235,46,108,122,219,76,174,43,26,64,224,226,65,225,168,166,152,97,119,109,191,33,206,35,208,222,119,249,19,118,49,141,108,234,153,197,11,140,71,189,146,82,35,174,15,241,192,183,52,177,174,0,91,100,171,240,11,121,215,90,135,186,236,119,39,43,227,211,95,152,115,114,125,16,39,173,105,206,178,212,111,65,213,13,168,204,89,157,123,225,134,106,101,107,161,33,209,58,189,84,147,2,131,34,234,212,244,251,84,185,188,40,24,13,117,39,18,10,151,202,83,218,118,208,77,20,20,211,188,75,95,40,65,53,57,91,103,6,58,105,65,181,76,247,191,189,243,55,190,238,221,17,154,9,71,214,231,92,31,164,173,51,10,212,66,135,25,155,163,173,179,62,229,125,132,126,35,136,25,212,78,14,243,35,151,54,2,87,126,135,156,39,27,2,177,102,159,160,185,31,91,246,146,248,200,30,245,85,0,140,51,244,205,68,156,64,121,227,52,255,79,57,143,214,84,234,36,234,38,69,76,95,220,187,4,66,251,168,77,68,8,85,244,162,238,86,151,209,82,193,138,207,112,206,153,71,10,190,131,79,200,211,45,100,237,244,206,115,70,59,84,212,127,237,141,172,112,133,46,125,14,255,229,105,144,33,108,49,189,139,103,60,93,104,140,3,102,166,84,157,79,67,43,42,233,148,68,131,75,170,95,162,239,248,179,43,221,198,211,35,99,114,102,24,234,163,129,218,85,176,212,147,154,129,17,181,235,87,242,194,178,179,215,32,162,235,237,236,250,9,46,202,202,144,95,181,181,236,240,1,186,1,70,193,248,251,4,163,10,111,24,83,223,102,196,192,100,162,141,36,47,11,175,244,175,99,42,160,126,51,26,13,131,134,204,156,16,175,74,19,160,137,25,73,8,13,22,174,71,241,209,192,227,234,88,200,233,110,117,174,145,116,208,144,126,250,21,100,32,148,95,225,108,86,163,197,120,244,79,108,206,155,244,154,245,77,251,155,0,92,254,182,6,157,66,115,213,11,27,255,224,98,251,134,231,227,39,25,111,205,81,123,105,96,155,225,192,176,142,11,161,122,224,18,120,92,46,247,138,200,158,71,120,46,107,142,167,231,94,51,224,177,235,117,14,132,219,153,220,89,114,147,242,210,33,49,125,122,146,81,236,225,57,152,124,237,63,202,219,72,202,210,22,61,19,174,135,248,172,41,200,110,139,87,53,64,67,243,213,71,121,215,51,109,106,216,207,243,97,41,26,63,144,212,225,246,98,251,220,27,3,187,102,76,186,26,189,117,146,178,141,160,61,142,194,143,28,56,48,54,205,100,245,158,51,79,246,72,223,206,116,241,162,14,135,170,141,2,191,224,234,5,120,188,27,2,252,102,75,25,34,25,48,54,223,170,195,189,194,178,132,153,103,78,173,128,72,237,131,203,62,135,182,222,214,144,163,22,199,235,3,183,203,62,143,211,221,219,221,74,25,65,181,190,147,237,132,234,52,105,162,171,99,139,57,166,49,123,66,48,221,17,25,145,58,209,149,0,71,228,213,79,39,190,182,228,39,11,45,42,227,102,23,164,247,81,60,54,159,197,12,230,116,99,165,128,108,42,178,77,91,6,255,61,102,247,162,147,55,250,136,170,248,185,115,74,179,109,75,108,255,183,35,129,13,179,165,4,69,143,251,209,85,48,124,237,222,93,62,22,168,47,29,166,113,49,148,33,15,189,120,16,156,193,52,179,86,213,94,170,147,84,132,238,237,240,90,134,229,15,103,42,13,170,180,103,179,83,130,182,252,120,65,21,214,238,130,3,89,232,171,86,88,232,1,216,165,87,182,20,172,22,31,44,8,35,53,166,114,24,15,110,231,189,24,116,33,151,25,36,74,12,127,62,208,191,65,22,78,185,220,227,120,241,135,40,209,100,42,30,230,16,215,194,58,142,186,36,211,111,197,246,22,146,195,93,225,114,130,141,91,242,203,69,7,141,64,75,105,21,164,119,136,60,226,213,94,84,116,171,231,114,186,167,47,165,112,40,0,172,108,158,21,107,214,240,183,191,166,122,61,179,57,71,153,164,111,140,203,124,185,123,243,84,171,27,122,103,153,141,125,190,222,41,132,63,135,159,158,226,147,191,164,175,44,118,25,160,140,71,6,57,144,141,11,30,169,78,111,118,150,234,15,213,57,11,40,56,96,156,41,85,77,104,65,232,109,112,45,243,76,218,31,106,189,18,6,19,205,85,100,87,209,85,54,11,145,59,239,57,172,141,111,139,97,236,222,47,127,18,16,237,222,10,22,180,17,236,143,179,228,76,46,59,76,62,126,178,84,162,105,206,183,194,128,206,201,113,244,253,85,6,67,214,193,224,245,201,181,107,214,200,108,122,230,121,234,238,164,128,28,155,132,83,204,137,163,110,247,122,158,84,212,213,166,161,198,133,112,141,186,77,46,0,220,228,225,210,6,91,55,168,180,161,13,37,231,56,72,180,36,6,37,249,147,93,128,182,40,150,221,59,114,178,228,70,73,30,89,55,108,228,230,157,49,5,95,105,76,0,199,124,176,71,197,117,127,143,46,208,173,163,79,58,208,64,111,90,8,110,185,86,238,218,68,69,107,163,203,213,123,204,5,231,150,215,239,190,212,184,0,114,175,221,4,135,28,194,137,89,188,2,229,161,70,208,66,158,11,50,58,212,251,178,23,252,175,21,84,245,117,6,135,247,148,160,212,125,195,219,71,161,156,221,61,232,137,154,111,216,51,54,53,136,158,20,120,88,227,87,145,97,11,251,205,33,239,73,148,172,253,144,104,56,106,40,99,192,47,58,95,255,202,117,125,8,103,92,63,69,124,121,114,120,82,38,211,201,244,246,73,164,144,0,104,54,19,95,206,166,172,225,137,112,165,155,237,141,17,28,255,149,182,240,21,164,55,44,129,47,59,249,203,0,245,191,83,254,106,15,13,185,192,105,111,75,17,137,96,229,74,130,190,14,121,133,155,121,9,151,95,120,79,50,107,118,240,216,87,180,120,67,156,219,187,129,70,212,95,207,208,153,43,34,239,9,201,222,165,33,154,120,69,149,62,157,105,121,234,128,80,124,107,81,99,104,97,145,10,42,208,59,62,87,177,27,26,71,223,95,179,250,128,75,3,129,222,5,104,150,57,162,35,54,101,33,41,29,116,132,244,43,234,234,176,254,229,118,95,134,84,94,43,197,187,61,125,23,136,86,230,50,200,115,157,243,197,67,68,187,50,36,209,181,37,198,73,147,105,207,100,88,96,31,89,212,234,130,183,216,247,136,100,16,22,89,105,216,82,65,178,123,168,127,104,122,201,241,133,166,85,95,101,138,151,168,70,46,60,235,177,136,195,219,217,137,209,202,84,193,117,114,139,104,217,232,117,73,187,187,189,244,47,142,69,255,155,18,62,214,11,228,24,229,98,99,105,180,216,41,36,225,248,163,213,188,95,62,211,3,231,186,189,139,123,221,108,37,154,136,190,6,8,149,101,11,194,241,7,214,80,103,213,108,56,66,57,155,142,234,100,27,61,142,11,148,101,180,197,195,180,51,41,81,114,91,103,136,55,183,187,95,50,99,155,47,135,173,12,182,145,237,76,112,12,19,84,7,183,0,179,132,200,209,0,168,189,18,51,115,230,58,153,109,104,249,58,169,191,222,191,199,41,106,203,238,143,214,114,228,35,45,229,45,161,21,57,51,5,61,216,192,9,47,185,94,249,11,175,102,204,154,181,71,10,16,111,137,169,60,28,112,37,119,255,0,206,9,44,196,60,221,176,22,181,190,36,42,181,117,235,136,137,163,102,14,188,7,141,115,240,227,255,37,52,31,234,91,46,212,192,251,78,109,16,254,179,173,130,5,49,160,85,19,72,236,14,32,142,166,129,233,63,202,143,255,15,44,196,50,106,66,173,129,69,206,45,139,118,12,3,134,66,29,95,74,47,140,6,3,37,221,89,73,57,57,246,253,43,231,98,217,244,39,254,157,225,84,216,96,219,27,219,199,80,70,137,32,239,80,119,26,140,203,201,67,160,232,254,178,90,46,228,251,206,245,185,171,117,187,219,174,142,22,24,57,141,128,175,191,110,202,164,103,136,33,154,231,106,133,83,172,61,179,249,48,83,27,71,107,245,102,209,244,180,178,156,117,241,205,149,23,185,243,238,242,146,35,187,104,10,200,183,0,249,97,139,97,28,37,164,85,124,68,243,97,98,114,39,106,197,102,194,119,164,85,65,117,41,73,230,47,43,136,225,77,127,193,252,54,121,66,197,12,74,204,205,244,234,14,254,15,177,113,76,119,141,185,182,28,208,127,238,17,96,100,44,9,66,102,120,214,162,140,92,84,74,110,57,15,252,171,55,34,57,189,104,215,188,218,72,223,80,234,163,217,170,0,13,21,196,4,100,140,112,125,143,172,195,99,107,144,17,227,135,218,58,23,153,174,80,105,175,81,227,65,64,106,127,140,232,229,66,244,52,39,34,183,41,234,230,142,49,6,234,96,131,220,243,219,221,186,149,248,0,93,11,32,202,95,188,114,133,75,5,212,83,93,140,71,228,134,150,26,129,20,152,38,67,97,106,201,129,63,204,208,107,203,17,164,225,244,88,2,32,25,216,29,70,132,174,188,191,201,38,159,50,1,143,37,229,215,48,43,161,244,51,191,172,97,208,128,78,250,158,35,232,19,179,154,202,194,145,115,198,202,132,202,67,144,41,141,251,76,78,143,119,0,242,200,53,193,27,172,125,130,39,130,90,149,248,157,40,217,47,76,85,176,165,6,95,116,177,111,2,195,4,67,44,33,159,75,199,19,173,141,136,67,11,73,213,64,10,2,198,15,21,126,244,160,25,53,145,42,82,21,11,102,91,139,141,106,130,186,233,106,220,125,162,17,182,107,249,215,159,113,238,118,215,96,211,88,55,148,137,158,22,187,187,146,151,126,206,133,253,148,84,225,31,124,21,156,208,78,71,65,18,69,229,151,171,242,181,140,2,92,186,223,51,193,1,179,32,111,170,223,51,172,246,146,151,146,33,229,107,213,235,226,196,163,228,219,177,164,168,20,140,50,152,178,128,109,126,106,64,102,17,239,27,197,190,116,174,199,208,39,236,38,225,166,142,79,53,121,173,207,149,154,185,53,28,54,67,134,15,6,57,195,200,9,126,94,0,73,117,202,177,108,217,199,126,104,124,112,178,166,230,209,72,98,34,141,124,31,110,92,35,95,231,100,104,179,221,248,43,216,26,223,100,118,184,216,145,53,48,51,97,199,155,231,208,166,220,117,29,171,59,237,147,158,247,98,174,61,59,33,52,131,147,106,61,199,203,241,250,86,55,112,210,31,135,73,169,41,240,162,34,104,64,65,180,73,123,17,66,73,161,197,225,249,228,160,194,152,43,139,156,44,191,183,110,223,180,102,123,236,184,243,209,252,7,212,130,155,177,211,254,162,250,24,247,163,106,247,234,215,236,120,247,143,246,225,122,19,70,99,230,35,39,249,145,170,187,91,118,13,38,114,155},
} ;

static void test_decode_953xint32_impl(long long impl)
{
  unsigned char *x = test_decode_953xint32_x;
  unsigned char *s = test_decode_953xint32_s;
  unsigned char *x2 = test_decode_953xint32_x2;
  unsigned char *s2 = test_decode_953xint32_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_953xint32_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_953xint32(impl);
    printf("decode_953xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953xint32_implementation(impl),ntruprime_dispatch_decode_953xint32_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_953xint32;
    printf("decode_953xint32 selected implementation %s compiler %s\n",ntruprime_decode_953xint32_implementation(),ntruprime_decode_953xint32_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_953xint32_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_953xint32_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_953xint32_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_953xint32_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_953xint32_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_953xint32_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_953xint32(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953xint32")) return;
  storage_decode_953xint32_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_953xint32_x = aligned(storage_decode_953xint32_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_953xint32_s = callocplus(crypto_decode_STRBYTES);
  test_decode_953xint32_s = aligned(storage_decode_953xint32_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_953xint32_x2 = callocplus(maxalloc);
  test_decode_953xint32_x2 = aligned(storage_decode_953xint32_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_953xint32_s2 = callocplus(maxalloc);
  test_decode_953xint32_s2 = aligned(storage_decode_953xint32_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_953xint32 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_953xint32();++impl)
      forked(test_decode_953xint32_impl,impl);
    ++test_decode_953xint32_x;
    ++test_decode_953xint32_s;
    ++test_decode_953xint32_x2;
    ++test_decode_953xint32_s2;
  }
  free(storage_decode_953xint32_s2);
  free(storage_decode_953xint32_x2);
  free(storage_decode_953xint32_s);
  free(storage_decode_953xint32_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

