/* ----- encode/1013x3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1013x3_checksums[] = {
  "d7024fe86d0285887eec1af699b0498d32ab1eaee799c12f44ef5cab26cfdc96",
  "3dca23aa721c2d4907b07cdbde42968e69e8689794aae6478e2b5e04da0d1579",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1013x3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1013x3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1013x3_ITEMBYTES

static void *storage_encode_1013x3_s;
static unsigned char *test_encode_1013x3_s;
static void *storage_encode_1013x3_x;
static unsigned char *test_encode_1013x3_x;
static void *storage_encode_1013x3_s2;
static unsigned char *test_encode_1013x3_s2;
static void *storage_encode_1013x3_x2;
static unsigned char *test_encode_1013x3_x2;

#define precomputed_encode_1013x3_NUM 4

static const unsigned char precomputed_encode_1013x3_s[precomputed_encode_1013x3_NUM][crypto_encode_STRBYTES] = {
  {7,159,20,15,191,109,154,167,249,62,187,96,62,58,25,49,163,244,84,16,7,101,192,156,55,94,231,45,9,36,79,43,20,230,243,76,206,137,116,225,107,64,86,233,143,84,25,141,252,192,8,171,197,227,66,147,188,51,236,146,62,163,102,143,161,56,127,101,78,94,45,125,251,122,102,22,68,100,195,35,125,83,106,57,105,13,25,207,184,113,52,166,182,204,103,196,94,225,85,255,31,129,78,64,186,143,130,27,167,136,254,252,88,44,76,20,117,119,178,56,197,91,20,83,191,4,123,142,56,140,62,15,166,33,136,117,238,250,169,145,14,55,210,20,143,66,140,76,125,174,110,237,234,171,67,123,17,230,120,85,51,69,176,67,89,161,181,4,163,111,184,157,16,108,174,224,252,225,16,98,113,99,246,148,244,85,40,4,191,72,193,166,216,52,119,173,30,226,171,44,211,123,3,24,241,150,118,37,181,75,181,113,22,166,204,8,170,247,8,33,85,192,94,35,48,138,27,101,41,66,35,48,207,69,235,140,192,171,255,83,12,14,238,178,8,207,175,170,249,13,130,194,204,242},
  {31,93,111,72,42,213,67,156,206,72,16,160,233,171,252,5,173,239,24,90,149,144,94,39,102,149,36,48,102,74,223,82,44,7,39,44,211,144,128,59,213,5,101,136,116,191,204,92,75,31,18,109,235,24,85,104,166,221,40,139,188,245,250,247,53,179,51,27,83,15,42,39,234,87,24,93,181,60,5,61,198,62,154,227,123,24,167,226,199,95,16,185,127,153,7,217,51,134,118,214,133,13,149,73,149,153,10,61,110,104,12,83,20,117,233,108,49,72,127,118,64,4,188,149,211,250,192,183,87,14,146,13,88,102,103,126,83,16,237,181,73,76,147,68,191,109,85,160,147,116,27,233,172,113,6,71,238,104,90,157,223,152,170,209,30,35,95,98,216,237,220,230,39,67,176,231,91,159,102,202,247,64,202,184,132,146,67,32,254,188,238,41,146,8,113,236,82,240,53,206,251,235,121,185,150,229,90,24,174,56,136,191,9,206,89,204,57,224,35,251,171,179,181,52,136,172,207,129,5,226,251,118,45,150,102,3,1,117,19,233,154,54,58,191,176,147,122,58,178,117,90,167,101,154},
  {10,157,129,215,110,192,122,110,179,45,215,184,108,71,60,40,124,1,119,190,38,127,61,227,237,167,54,22,183,81,191,27,19,17,66,138,65,66,100,231,249,169,248,46,43,22,111,14,153,219,23,157,20,94,216,129,238,129,72,177,5,176,118,77,216,62,171,165,179,174,155,192,140,215,16,41,42,242,217,5,233,221,60,26,50,173,250,255,200,206,234,236,18,76,187,68,117,220,1,169,123,161,231,236,120,47,177,170,186,71,58,199,188,146,99,233,183,229,128,211,220,58,235,8,151,244,175,109,117,153,58,146,182,66,177,199,136,47,127,79,2,26,214,2,213,47,0,231,109,170,141,87,25,23,59,138,76,148,207,56,178,65,37,81,4,48,206,56,218,223,223,120,13,68,231,236,31,216,122,69,158,42,110,108,100,3,122,20,22,159,85,187,171,26,36,187,92,244,3,133,246,161,24,17,1,2,95,130,173,89,76,1,65,41,196,8,54,54,77,112,1,105,238,175,203,223,225,165,207,142,30,42,199,71,56,121,37,109,142,155,1,238,107,4,202,62,149,88,249,239,2,110,137,229},
  {172,103,178,133,62,190,132,132,25,196,175,5,184,87,93,30,111,199,123,44,37,17,65,53,249,13,22,129,114,187,123,216,16,175,71,101,123,53,219,61,117,108,48,104,178,53,169,89,214,231,44,138,69,245,248,136,135,239,238,83,125,47,93,125,193,181,12,7,92,8,189,195,198,61,27,92,75,104,23,60,97,90,173,252,116,15,162,146,140,231,11,237,202,1,215,14,92,216,115,233,251,11,220,204,227,26,217,72,75,143,190,77,92,120,229,159,110,86,119,136,17,118,191,136,72,93,87,192,228,78,49,2,242,240,85,235,25,144,3,167,231,230,165,29,242,152,31,195,184,236,94,142,184,55,1,195,0,142,179,70,124,233,56,119,170,94,138,201,128,88,131,208,111,248,60,186,145,194,197,3,70,79,136,36,110,89,153,196,114,75,149,182,5,1,72,83,247,86,35,117,162,183,57,178,98,14,245,113,63,49,89,97,126,120,16,39,55,159,22,29,90,142,96,89,98,4,22,184,22,117,244,37,105,47,17,48,46,55,83,254,53,18,227,13,15,198,218,47,241,223,83,213,45,93},
} ;

static const unsigned char precomputed_encode_1013x3_x[precomputed_encode_1013x3_NUM][crypto_encode_ITEMS] = {
  {82,32,178,139,234,244,97,158,31,188,223,115,58,36,39,30,222,91,114,148,32,178,107,126,41,199,92,53,102,203,36,62,196,24,92,155,21,169,43,226,10,243,233,220,111,175,82,95,185,188,24,223,1,165,189,130,40,111,2,143,136,101,148,74,170,185,100,246,155,101,67,141,67,243,7,98,47,91,26,182,226,216,59,195,212,75,197,103,159,211,32,198,67,177,172,118,10,218,11,163,109,91,211,72,18,208,24,7,12,19,164,37,100,128,61,190,191,188,234,130,14,43,112,253,138,15,213,47,139,97,59,120,73,46,133,197,254,88,32,181,223,54,88,35,245,125,41,132,124,162,215,231,35,131,231,230,196,210,56,0,26,39,146,49,107,168,170,49,249,78,217,149,4,184,103,249,94,175,26,234,99,55,64,247,88,179,18,234,136,240,147,251,167,236,141,94,139,212,29,167,99,100,8,53,18,153,194,83,232,214,191,13,30,156,176,100,29,200,75,48,122,121,118,174,39,16,176,96,46,220,8,87,223,122,77,244,25,69,233,30,201,40,220,247,234,165,121,153,249,230,152,52,170,144,245,192,176,95,50,176,79,213,156,10,174,47,224,183,100,115,142,64,45,223,13,218,133,81,236,78,192,10,23,118,144,2,101,41,234,191,140,244,149,184,3,66,97,200,141,231,157,245,65,237,223,68,204,149,79,96,224,129,54,230,82,174,190,100,120,172,40,240,188,122,190,48,28,215,225,209,203,25,128,33,106,213,56,159,178,189,88,188,23,16,152,127,27,250,6,133,82,49,115,172,128,249,92,28,73,151,147,231,99,62,89,198,90,189,241,200,97,129,199,216,193,85,14,73,74,73,75,209,106,69,45,79,238,231,232,89,100,240,52,167,131,220,186,28,200,92,90,60,168,136,80,43,127,5,173,7,139,106,59,84,18,57,201,27,131,236,42,120,251,242,169,129,20,153,250,55,139,169,82,44,189,166,11,90,32,215,41,152,226,204,123,251,0,1,71,79,200,164,167,60,28,14,195,105,97,130,91,69,57,211,136,30,18,12,138,94,142,201,157,112,204,117,231,107,205,190,56,218,117,154,250,111,97,73,107,149,244,231,30,208,34,194,58,32,135,105,31,196,68,97,146,33,105,66,89,216,52,205,139,202,111,85,35,85,36,86,45,203,233,0,230,209,177,154,1,36,220,96,72,145,204,70,59,250,237,65,104,74,121,44,177,134,77,228,149,148,92,248,52,32,178,254,212,2,110,182,109,219,18,219,206,169,187,247,137,177,27,186,83,99,250,249,58,40,194,245,49,223,108,138,95,10,91,112,59,251,173,252,92,115,124,149,25,236,17,70,65,238,130,120,32,58,221,151,201,119,95,144,118,24,84,129,190,120,225,173,238,226,207,203,36,70,32,38,45,13,211,248,155,106,54,102,44,97,233,195,254,228,81,81,116,7,126,210,163,214,22,156,90,173,194,203,192,181,151,156,40,249,12,62,44,229,2,214,11,241,182,114,146,91,189,114,146,70,111,34,199,199,192,102,200,228,35,59,151,109,11,103,123,147,89,83,169,200,61,163,219,36,122,202,223,214,115,13,68,26,86,254,179,242,148,228,105,253,143,155,196,246,232,112,142,124,173,247,77,149,128,180,163,127,2,110,255,136,216,220,236,49,213,128,55,199,176,242,203,45,91,2,14,195,133,140,143,101,97,187,68,10,244,243,53,155,139,220,235,38,188,229,179,159,75,148,22,83,16,111,8,24,131,167,101,241,22,77,181,102,88,95,174,246,241,75,31,82,35,149,30,212,13,225,170,23,170,82,118,110,40,204,151,67,186,10,116,150,245,22,49,220,90,164,65,144,10,148,112,180,93,223,76,9,103,210,194,201,121,90,136,74,227,194,48,219,124,119,173,145,209,31,217,66,39,0,239,70,155,19,227,36,36,180,37,16,27,193,222,205,9,180,83,136,60,198,244,54,220,33,56,46,241,232,179,246,18,171,177,18,53,247,206,156,109,239,67,122,147,178,53,92,181,97,90,27,156,145,156,233,153,189,240,169,12,62,113,191,136,108,130,183,55,144,231,57,133,251,38,237,50,182,236,53,219,178,242,81,186,83,87,116,73,202,235,40,146,7,194,85,84,248,22,201,71,76,50,59,102,138,163,205,222,120,69,21,142,45,221,251,169,157,149,246,27,9,223,161,129,33,94,211,205,116,138,128,9,85,37,252,132,100,48,105,213,58,196,221,68,29,29,200,95,232,61,172,140,39,63,158,220,208,241},
  {14,43,61,237,132,13,173,6,134,73,179,89,87,103,100,15,1,41,11,146,52,35,144,43,254,8,189,212,15,230,2,122,177,118,151,90,35,116,144,252,191,143,148,126,119,153,219,155,220,198,202,148,70,188,6,179,207,54,144,200,64,32,139,233,84,137,10,57,186,28,7,220,167,103,92,131,81,209,143,242,116,35,164,116,203,80,31,197,253,51,144,141,86,27,213,87,197,155,34,163,36,139,19,255,199,114,88,127,55,113,26,85,69,135,195,50,181,48,140,191,122,248,23,207,45,60,90,93,147,245,91,163,134,51,206,154,82,156,145,4,231,76,32,87,58,229,11,64,79,131,154,81,19,10,139,125,162,233,30,195,52,107,90,32,216,254,118,22,16,232,90,171,167,95,249,14,99,67,71,5,62,199,249,202,135,20,2,138,107,251,183,93,102,4,64,34,30,71,9,196,157,144,242,23,196,173,250,204,130,105,127,14,103,163,193,127,96,160,62,33,3,100,12,135,117,135,232,221,156,87,189,235,183,99,109,167,38,248,247,143,211,213,212,212,72,78,130,156,77,154,63,60,202,234,247,195,120,102,169,173,70,42,239,62,30,120,198,58,106,3,69,220,22,126,211,55,190,23,22,189,249,47,174,129,174,17,202,141,61,158,54,126,126,37,239,52,175,197,132,247,216,228,206,39,36,175,40,24,99,13,205,78,40,66,124,123,156,19,16,196,33,148,120,230,89,172,230,214,177,197,84,69,254,196,240,58,242,117,34,17,187,118,43,54,50,180,205,38,85,126,140,230,158,109,122,26,46,167,220,166,207,79,183,189,44,102,34,190,110,191,232,173,0,97,60,132,26,6,172,39,96,193,74,162,174,212,30,68,113,244,51,207,225,196,63,245,97,44,167,196,56,26,161,86,192,230,182,148,52,195,116,147,176,189,149,120,28,9,120,106,232,55,68,221,53,136,218,79,180,201,157,49,129,6,180,93,255,209,101,166,19,205,175,66,138,73,149,196,123,209,108,113,144,176,65,51,32,133,38,224,203,95,189,20,20,6,235,112,171,2,8,183,206,99,141,144,105,2,3,126,11,68,173,96,11,5,9,20,27,147,192,172,16,56,69,240,86,242,202,175,89,7,183,71,47,123,153,27,30,133,67,88,46,253,198,178,65,70,130,201,69,242,195,92,140,231,161,206,235,170,235,11,209,72,186,46,254,209,217,101,45,247,30,129,90,33,158,245,135,117,14,102,12,55,119,29,188,73,92,235,236,162,36,141,247,240,228,236,198,226,167,78,195,215,61,60,38,173,201,200,88,0,228,94,208,184,65,165,199,41,190,160,162,131,173,255,71,54,112,252,18,221,244,4,60,246,148,125,151,152,122,235,152,137,90,51,189,5,154,13,186,190,28,42,109,211,230,234,91,250,101,46,1,229,191,166,56,136,47,32,198,13,121,108,183,211,160,121,165,212,166,52,40,177,245,169,189,139,106,93,242,239,70,155,22,149,146,146,109,236,191,236,143,41,73,111,216,200,38,217,115,241,57,167,169,6,57,45,62,81,161,61,18,135,112,99,239,59,232,228,30,181,50,90,66,57,218,217,54,5,216,94,233,146,142,120,41,135,51,224,206,153,251,111,59,208,211,161,149,60,147,139,3,240,142,75,191,236,64,47,53,254,9,2,238,4,139,57,159,99,54,101,145,26,23,249,255,202,128,61,173,231,61,102,160,93,48,15,121,173,241,80,19,180,45,44,112,191,3,190,227,157,124,2,133,34,183,110,119,149,29,168,100,243,231,229,13,3,122,67,174,54,42,250,174,6,121,153,24,159,101,245,84,124,2,252,49,84,24,29,124,45,6,76,253,214,207,11,131,228,103,201,25,208,28,233,27,170,38,171,127,29,120,175,214,101,128,132,184,155,81,126,165,145,153,0,204,74,193,188,39,164,140,220,8,191,210,203,195,218,106,95,118,110,70,177,86,108,78,135,90,171,193,93,106,141,160,75,68,243,105,147,195,99,17,218,107,238,17,188,23,56,102,156,134,253,164,227,108,140,109,215,136,70,141,65,113,195,181,75,154,139,250,69,137,126,130,122,136,152,123,61,117,75,30,175,33,56,21,203,114,11,181,95,220,180,104,14,12,101,56,148,154,169,40,24,36,168,229,122,165,76,127,30,101,83,219,26,225,37,211,181,234,144,252,250,39,81,195,87,178,119,115,26,197,96,14,196,213,36,88,172,117,158,131,17,228,11,165,175,21,76,128,15,158,161,179,200,92,197,218,124,153},
  {25,155,115,24,100,121,252,65,88,153,23,36,178,92,78,194,157,219,181,179,127,67,186,133,193,205,35,188,173,35,178,219,182,182,137,85,52,205,99,109,250,14,181,208,231,239,212,54,215,100,151,185,142,25,120,166,43,251,149,6,195,64,173,121,3,149,237,24,60,192,163,201,6,159,94,83,9,176,18,114,253,49,9,46,110,27,113,121,248,32,87,88,46,216,240,192,200,68,196,230,174,161,114,152,209,112,193,77,41,134,116,101,14,241,117,157,60,200,150,5,226,42,26,41,198,236,253,42,202,113,87,131,84,6,57,127,105,141,209,21,85,128,86,218,40,9,154,20,241,147,99,190,251,33,53,93,38,7,117,116,12,214,204,130,232,123,212,161,99,156,141,212,157,255,128,217,86,44,17,75,109,85,108,201,170,36,66,155,165,189,38,207,184,163,140,1,86,144,243,143,34,228,205,13,80,174,36,152,239,0,41,173,1,82,52,206,175,181,164,243,24,173,58,91,41,28,12,181,8,209,58,45,215,27,127,239,72,41,63,42,128,100,78,163,19,166,83,202,245,227,110,83,204,27,152,97,75,106,153,116,93,191,145,114,190,46,230,94,16,44,177,194,122,173,231,219,189,255,90,24,10,55,86,180,123,72,73,141,227,53,52,81,70,183,234,203,19,118,17,215,40,131,254,107,77,86,111,45,153,213,67,250,216,219,136,71,76,57,52,185,104,127,195,80,136,40,66,21,159,186,238,130,193,225,52,1,193,127,90,154,84,85,47,39,197,40,20,40,114,54,162,181,31,53,196,65,21,253,167,144,221,26,45,38,99,105,133,185,13,176,183,18,19,13,39,157,210,97,85,175,187,165,246,5,68,19,121,56,251,63,153,228,192,99,10,167,164,172,72,22,110,170,33,192,8,77,173,229,38,135,153,163,23,156,153,114,27,242,252,22,150,189,29,134,12,4,68,76,113,57,92,193,101,40,206,18,190,145,187,125,229,92,141,175,22,187,43,191,199,144,190,242,181,130,128,70,42,193,6,26,200,55,143,0,230,79,12,58,236,229,13,121,103,13,185,156,194,219,149,36,123,115,212,120,237,122,181,31,66,205,182,59,15,225,18,44,6,115,3,93,67,27,239,176,254,75,99,204,160,178,159,203,80,244,4,183,60,2,12,225,137,195,113,5,65,243,219,14,201,158,174,93,133,158,63,48,68,82,133,82,198,171,28,49,147,228,217,22,86,193,184,84,198,121,124,171,46,203,110,83,97,63,61,150,33,161,166,147,181,247,159,28,253,152,177,125,248,30,53,239,74,96,189,189,47,203,33,121,62,149,40,38,104,220,112,149,81,21,159,131,172,211,100,252,50,88,79,186,184,55,203,10,18,136,213,149,158,174,157,203,77,126,235,1,215,68,221,121,83,231,105,79,246,177,88,185,151,83,24,122,37,10,217,234,180,122,93,30,144,144,216,34,92,168,116,15,151,10,67,7,59,240,102,26,9,248,1,154,227,20,243,186,161,181,105,122,158,11,168,97,242,98,1,80,103,87,146,173,140,115,58,203,71,66,250,4,154,62,20,3,59,71,228,232,66,74,98,133,3,44,237,180,189,10,116,148,104,86,255,225,53,129,125,65,209,217,178,214,237,195,238,169,111,162,94,221,251,233,79,26,2,111,71,226,57,11,144,143,43,241,113,115,13,89,169,75,170,156,23,91,212,223,179,30,98,141,41,221,66,129,25,222,101,60,231,132,39,30,219,150,62,174,151,200,171,115,49,210,235,197,6,197,106,117,99,129,40,78,113,215,113,204,12,121,76,156,77,131,51,176,109,120,148,230,109,127,88,249,211,61,69,162,102,182,242,22,104,177,209,123,183,44,228,225,219,57,248,59,62,201,183,148,123,113,96,103,63,107,204,228,185,148,144,137,74,122,187,133,162,186,123,158,244,178,165,7,118,163,65,160,194,132,68,21,166,176,215,25,122,13,104,153,110,160,88,27,245,164,113,82,226,247,194,202,135,132,190,86,226,249,150,101,182,132,180,126,254,244,92,189,96,8,138,224,203,67,13,87,1,139,121,176,33,82,141,190,77,246,62,49,67,161,22,171,215,175,199,131,33,208,196,216,136,210,252,185,55,74,32,122,89,250,153,112,74,181,226,73,164,108,68,118,185,24,137,16,209,119,118,132,189,163,175,236,117,244,105,79,157,108,97,242,196,174,20,59,224,77,39,231,132,20,96,153,14,44,30,211,119,19,253,16,71,164,209,106,42,88,60,234,29,250,228},
  {163,253,244,154,214,79,16,252,237,16,171,78,204,205,119,171,177,82,31,104,137,140,31,183,127,36,178,160,231,138,174,57,112,197,20,24,167,198,23,245,50,2,18,112,124,201,73,118,127,53,121,126,54,35,20,184,120,8,247,8,101,5,181,104,194,18,33,100,38,255,241,193,6,24,208,131,151,156,125,56,164,103,125,143,176,235,214,24,68,106,0,48,236,85,130,182,84,20,40,10,216,24,48,186,213,27,188,183,112,103,86,103,141,244,28,168,210,57,239,171,222,222,89,29,75,254,80,213,39,45,10,125,26,252,189,98,158,97,89,57,32,72,205,220,238,130,199,11,108,125,132,209,10,111,104,173,48,26,145,229,60,13,143,51,255,46,242,237,239,51,218,62,227,236,216,220,169,101,106,102,148,215,195,7,52,80,226,55,164,168,56,69,169,26,223,150,138,6,195,83,95,2,107,179,181,0,24,192,164,223,81,79,8,150,28,234,195,244,113,108,67,128,231,166,238,113,176,154,142,115,84,100,237,151,125,54,250,77,241,139,104,104,222,149,18,86,159,102,64,190,65,167,108,131,95,187,192,143,51,217,160,224,68,172,119,176,64,78,110,121,34,121,175,66,125,238,83,68,133,112,96,66,100,159,210,183,148,158,141,13,219,164,52,117,70,174,90,227,18,211,147,93,144,216,62,154,89,95,39,183,165,35,186,122,150,87,159,90,78,232,28,248,9,174,97,113,146,147,228,41,81,211,139,115,33,85,163,51,23,13,222,11,211,206,217,41,89,1,117,54,63,168,27,111,142,22,154,146,15,11,182,160,152,160,136,32,41,128,129,241,75,242,100,222,109,64,90,154,152,225,41,48,33,143,247,60,90,230,171,114,153,26,30,224,176,238,252,46,194,107,210,209,201,76,66,29,228,115,155,95,147,213,123,231,250,75,106,149,33,239,249,99,252,2,24,143,43,54,211,192,98,224,238,10,58,229,102,105,199,11,157,11,70,33,8,208,251,220,123,223,129,184,71,247,156,161,64,148,56,154,170,72,168,112,41,152,177,142,121,38,71,206,182,3,66,205,235,218,90,53,136,21,106,149,245,47,139,143,150,181,48,68,223,185,167,132,219,166,236,151,40,156,31,198,10,90,173,147,235,92,81,232,163,195,86,42,33,134,228,178,152,101,23,197,9,181,213,14,229,18,203,71,19,50,20,30,244,59,142,93,2,173,174,84,80,157,236,133,227,186,95,22,2,87,209,201,14,225,56,13,178,136,228,222,81,88,226,75,112,8,160,171,192,118,103,231,129,91,3,118,143,61,152,149,58,108,114,171,10,101,253,28,207,217,27,202,167,248,181,31,165,237,151,145,133,173,16,0,99,84,131,206,122,214,117,255,244,246,102,214,210,15,226,45,207,211,157,95,117,237,145,144,210,79,53,164,129,248,153,92,99,45,41,34,164,240,227,144,139,170,143,55,102,255,88,65,217,115,199,133,61,7,87,153,177,61,125,207,152,55,40,70,191,119,21,249,67,80,32,246,146,79,62,246,47,143,97,64,78,67,48,255,91,22,39,26,99,197,163,221,169,23,10,111,44,160,185,216,29,116,136,24,140,105,124,134,194,203,16,175,77,153,128,253,210,198,209,116,167,151,119,43,83,59,73,32,85,105,30,45,176,185,175,134,140,138,237,163,59,185,29,182,121,61,255,155,98,161,5,63,72,118,246,111,141,201,139,220,112,132,151,215,152,137,67,43,211,72,140,209,54,170,138,242,190,85,185,0,77,41,137,22,142,184,186,59,64,76,151,141,53,54,120,131,194,32,66,208,112,129,35,141,81,215,151,233,217,57,177,77,13,203,44,163,184,110,235,10,28,84,95,83,194,138,136,58,52,78,111,162,176,73,251,6,104,1,190,215,233,244,187,51,171,170,157,164,183,9,158,12,70,71,95,54,26,58,166,34,70,65,140,69,129,108,165,181,128,158,153,225,21,116,202,202,41,52,228,228,247,237,162,73,196,36,155,80,93,96,199,31,139,233,128,86,33,204,19,81,15,57,23,104,213,51,90,34,124,41,72,114,111,172,128,126,36,219,144,113,64,133,148,18,14,187,58,149,64,119,222,223,183,209,18,19,233,208,207,235,178,128,155,70,94,96,82,4,137,4,69,211,68,255,214,61,149,30,63,99,62,4,184,63,104,36,248,153,210,2,26,245,189,125,140,188,197,12,37,57,102,69,122,135,168,197,94,208,38,137,60,198,106,169,219,225,120,70,143,104,216,36,87,172,92},
} ;

static void test_encode_1013x3_impl(long long impl)
{
  unsigned char *s = test_encode_1013x3_s;
  unsigned char *x = test_encode_1013x3_x;
  unsigned char *s2 = test_encode_1013x3_s2;
  unsigned char *x2 = test_encode_1013x3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1013x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1013x3(impl);
    printf("encode_1013x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x3_implementation(impl),ntruprime_dispatch_encode_1013x3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1013x3;
    printf("encode_1013x3 selected implementation %s compiler %s\n",ntruprime_encode_1013x3_implementation(),ntruprime_encode_1013x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1013x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1013x3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1013x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1013x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1013x3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1013x3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1013x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x3")) return;
  storage_encode_1013x3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1013x3_s = aligned(storage_encode_1013x3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1013x3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1013x3_x = aligned(storage_encode_1013x3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1013x3_s2 = callocplus(maxalloc);
  test_encode_1013x3_s2 = aligned(storage_encode_1013x3_s2,crypto_encode_STRBYTES);
  storage_encode_1013x3_x2 = callocplus(maxalloc);
  test_encode_1013x3_x2 = aligned(storage_encode_1013x3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1013x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x3();++impl)
      forked(test_encode_1013x3_impl,impl);
    ++test_encode_1013x3_s;
    ++test_encode_1013x3_x;
    ++test_encode_1013x3_s2;
    ++test_encode_1013x3_x2;
  }
  free(storage_encode_1013x3_x2);
  free(storage_encode_1013x3_s2);
  free(storage_encode_1013x3_x);
  free(storage_encode_1013x3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

