# -----------------------------------------------------------------------------
# File name         : doxyfile-config-c.txt
# Description       : Doxygen config for C libSBML API manual 
# Original author(s): Michael Hucka <mhucka@caltech.edu>
# Organization      : California Institute of Technology
# -----------------------------------------------------------------------------

# Include libSBML's common Doxygen settings:

@INCLUDE               = doxygen-config-common.txt

# -----------------------------------------------------------------------------
# Beginning of C++ specific configuration settings
# -----------------------------------------------------------------------------

# The PROJECT_NAME tag is a single word (or a sequence of words surrounded 
# by quotes) that should identify the project.

PROJECT_NAME           = "@PACKAGE_NAME@ C API"

# The PROJECT_NUMBER tag can be used to enter a project or revision number. 
# This could be handy for archiving the generated documentation or 
# if some version control system is used.

PROJECT_NUMBER         = "@PACKAGE_NAME@ @PACKAGE_VERSION@ C API"

# The HTML_OUTPUT tag is used to specify where the HTML docs will be put. 
# If a relative path is entered the value of OUTPUT_DIRECTORY will be 
# put in front of it. If left blank `html' will be used as the default path.

HTML_OUTPUT            = ../formatted/c-api

# Set the OPTIMIZE_OUTPUT_FOR_C tag to YES if your project consists of C sources 
# only. Doxygen will then generate output that is more tailored for C. 
# For instance, some of the names that are used will be different. The list 
# of all members will be omitted, etc.

OPTIMIZE_OUTPUT_FOR_C  = YES

# The ENABLED_SECTIONS tag can be used to enable conditional 
# documentation sections, marked by \if sectionname ... \endif.
#
# In libSBML, we use the following section names for the languages:
#
#   java:     only Java
#   python:   only Python
#   perl:     only Perl
#   cpp:      only C++
#   csharp:   only C#
#   conly:    only C
#   clike:    C, C++

ENABLED_SECTIONS       = clike conly doxygenCOnly doxygenCLikeOnly

# When TYPEDEF_HIDES_STRUCT is enabled, a typedef of a struct, union, or enum
# is documented as struct, union, or enum with the name of the typedef. So
# typedef struct TypeS {} TypeT, will appear in the documentation as a struct
# with name TypeT. When disabled the typedef will appear as a member of a
# file, namespace, or class. And the struct will be named TypeS. This can
# typically be useful for C code in case the coding convention dictates that
# all compound types are typedef'ed and only the typedef is referenced, never
# the tag name.

TYPEDEF_HIDES_STRUCT   = YES

# If you use STL classes (i.e. std::string, std::vector, etc.) but do not
# want to include (a tag file for) the STL sources as input, then you should
# set this tag to YES in order to let doxygen match functions declarations
# and definitions whose arguments contain STL classes
# (e.g. func(std::string); v.s. func(std::string) {}). This also make the
# inheritance and collaboration diagrams that involve STL classes more
# complete and accurate.

BUILTIN_STL_SUPPORT    = NO

# The PREDEFINED tag can be used to specify one or more macro names that 
# are defined before the preprocessor is started (similar to the -D option of 
# gcc). The argument of the tag is a list of macros of the form: name 
# or name=definition (no spaces). If the definition and the = are 
# omitted =1 is assumed.

PREDEFINED             = LIBSBML_EXTERN:="" \
			 BEGIN_C_DECLS:="" \
			 END_C_DECLS:="" \
			 LIBSBML_CPP_NAMESPACE_BEGIN:="" \
			 LIBSBML_CPP_NAMESPACE_END:="" 

EXAMPLE_PATH           = common-text . ../.. ../../examples/c \
                         ../../examples/c/comp

INPUT =                                    \
  libsbml-accessing.txt                    \
  libsbml-changes.txt                      \
  libsbml-coding.txt                       \
  libsbml-communications.txt               \
  libsbml-core-versus-packages.txt         \
  libsbml-example-c.txt                    \
  libsbml-example-files-c.txt              \
  libsbml-extending.txt                    \
  libsbml-extension-support-classes.txt    \
  libsbml-features.txt                     \
  libsbml-groups.txt                       \
  libsbml-howto-implement-extension.txt    \
  libsbml-installation.txt                 \
  libsbml-issues.txt                       \
  libsbml-license.txt                      \
  libsbml-mainpage.txt                     \
  libsbml-math.txt                         \
  libsbml-news.txt                         \
  libsbml-old-news.txt                     \
  libsbml-other.txt                        \
  libsbml-release-info.txt                 \
  libsbml-programming.txt                  \
  libsbml-reading-files.txt                \
  ../../src/sbml/annotation                \
  ../../src/sbml/common                    \
  ../../src/sbml/conversion                \
  ../../src/sbml/extension                 \
  ../../src/sbml/math                      \
  ../../src/sbml/util                      \
  ../../src/sbml/validator                 \
  ../../src/sbml                           \
  ../../src/sbml/xml                       \
  ../../src/sbml/packages/comp/common      \
  ../../src/sbml/packages/comp/extension   \
  ../../src/sbml/packages/comp/sbml        \
  ../../src/sbml/packages/comp/util        \ 
  ../../src/sbml/packages/comp/validator   \
  ../../src/sbml/packages/fbc/common       \
  ../../src/sbml/packages/fbc/extension    \
  ../../src/sbml/packages/fbc/sbml         \
  ../../src/sbml/packages/fbc/util         \ 
  ../../src/sbml/packages/fbc/validator    \
  ../../src/sbml/packages/layout/common    \
  ../../src/sbml/packages/layout/extension \
  ../../src/sbml/packages/layout/sbml      \
  ../../src/sbml/packages/layout/util      \ 
  ../../src/sbml/packages/layout/validator \
  ../../src/sbml/packages/qual/common      \
  ../../src/sbml/packages/qual/extension   \
  ../../src/sbml/packages/qual/sbml        \
  ../../src/sbml/packages/qual/validator

EXCLUDE += ../../src/sbml/common/sbmlfwd.h \
           ../../src/sbml/packages/comp/common/compfwd.h

# The INPUT_FILTER tag can be used to specify a program that doxygen should 
# invoke to filter for each input file. Doxygen will invoke the filter program 
# by executing (via popen()) the command <filter> <input-file>, where <filter> 
# is the value of the INPUT_FILTER tag, and <input-file> is the name of an 
# input file. Doxygen will then use the output that the filter program writes 
# to standard output.

INPUT_FILTER = ./filters/doc-filter-c.py

# If the FILTER_SOURCE_FILES tag is set to YES, the input filter (if set using
# INPUT_FILTER ) will also be used to filter the input files that are used for
# producing the source files to browse (i.e. when SOURCE_BROWSER is set to
# YES).

FILTER_SOURCE_FILES = YES

LAYOUT_FILE = doxygen-layout-c.xml

COLLABORATION_GRAPH = NO

GROUP_GRAPHS = YES

INLINE_SIMPLE_STRUCTS = YES
