.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_stat_init.mdoc -- init zip_stat structure
.\" Copyright (C) 2006-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_STAT_INIT" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_stat_init\fR
\- initialize zip_stat structure
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIvoid\fR
.br
.PD 0
.HP 4n
\fBzip_stat_init\fR(\fIzip_stat_t\ *sb\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_stat_init\fR()
function initializes the members of a struct zip_stat.
The current members are described in
zip_stat(3),
but this function should be used to initialize it to
make sure none are missed.
The structure pointed to by
\fIsb\fR
must be allocated before calling
\fBzip_stat_init\fR().
.PP
This function should be used by functions provided to
zip_source_function(3)
when returning
\fRZIP_SOURCE_STAT\fR
information to make sure all fields are initialized.
.SH "RETURN VALUES"
If
\fIsb\fR
is valid, the function is always successful.
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "HISTORY"
\fBzip_stat_init\fR()
was added in libzip 0.8.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
