//
//  Extension.h
//  
//
//  Created by Pierre Peterlongo on 22/10/2012
//

#include <stdio.h>
#include <stdlib.h>
#include "../minia/Kmer.h"
#include "../minia/Hash16.h"
#include "../minia/Set.h"
#include "../minia/Pool.h"
#include "../minia/Bloom.h"
#include "../minia/Debloom.h"
#include "../minia/Utils.h"
#include "../minia/SortingCount.h"
#include "../minia/Terminator.h"

#include "IterativeExtensions.h"

#ifndef EXTENSION_
#define EXTENSION_
class Extension{
 public:
  //kmer_type starting_kmer;
  string starting_kmer; // stores the starting k mer that is going to be extended.
  string direction;
  int node_id; // id of node of the starting_kmer
  // The extension types could be
  // 1/ a strict sequence: any branching stops the extension
  // 2/ a consensus sequence: uses minia contiging approach
  // 3/ a strict graph: any branching is conserved in the graph
  // 4/ a consensus graph: "small" polymorphism is merged, but "large" structures are represented.
  
  Extension(const char * starting_kmer, const char * direction);
  ~Extension(){};
  void perform_extension(const string prefix, int limit, const char extension_type);
};
#endif// EXTENSION_
