/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.


   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MZ_LAB_INPUT_OLIGOMER_TABLE_VIEW_HPP
#define MZ_LAB_INPUT_OLIGOMER_TABLE_VIEW_HPP
// #pragma message("including MZ_LAB_INPUT_OLIGOMER_TABLE_VIEW_HPP")


/////////////////////// Qt includes
#include <QTableView>


/////////////////////// Local includes
#include "oligomerList.hpp"

namespace massXpert
{

  class MzLabWnd;
  class MzLabInputOligomerTableViewModel;
  class MzLabInputOligomerTableViewDlg;


  class MzLabInputOligomerTableView : public QTableView
  {
    Q_OBJECT

    private:
    MzLabInputOligomerTableViewDlg *mp_parentDlg;
    MzLabWnd *mp_mzLabWnd;

    MzLabInputOligomerTableViewModel *mp_sourceModel;

    // We do not own that oligomer list.
    OligomerList *mp_oligomerList;

    int testCleaveOligomerDataDropped(QDropEvent *, OligomerList *);
    int testFragmentOligomerDataDropped(QDropEvent *, OligomerList *);
    int testMassSearchOligomerDataDropped(QDropEvent *, OligomerList *);
    int testSimpleTextDataDropped(QDropEvent *, OligomerList *);
    int testSimpleTextDataDroppedOrPasted(QString &, OligomerList *);
    
  protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dragMoveEvent(QDragMoveEvent *event);
    void dropEvent(QDropEvent *event);
    MassType pasteOrDropMassTypeCheck();
    
  public:
    MzLabInputOligomerTableView(QWidget *parent = 0);
    ~MzLabInputOligomerTableView();

    void setSourceModel(MzLabInputOligomerTableViewModel *);
    MzLabInputOligomerTableViewModel *sourceModel();

    void setOligomerList(OligomerList *);
    const OligomerList *oligomerList();

    void setParentDlg(MzLabInputOligomerTableViewDlg *);
    MzLabInputOligomerTableViewDlg *parentDlg();

    void setMzLabWnd(MzLabWnd *);
    MzLabWnd *mzLabWnd();

    void mousePressEvent(QMouseEvent *);
    void pasteEvent();

    QString * selectedDataAsPlainText();

    Oligomer *parseOnlyMassLine(QStringList &);
    Oligomer *parseMassAndChargeLine(QStringList &);
    Oligomer *parseFullLine(QStringList &);

  public slots:
    void itemActivated(const QModelIndex &);
  };

} // namespace massXpert


#endif // MZ_LAB_INPUT_OLIGOMER_TABLE_VIEW_HPP
// #pragma message("done...including MZ_LAB_INPUT_OLIGOMER_TABLE_VIEW_HPP")
